/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event;

import java.util.HashMap;
import java.util.List;
import org.eclipse.linuxtools.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;

public class EventDefinition
implements IDefinitionScope {
    public final EventDeclaration declaration;
    public long timestamp;
    public StructDefinition context;
    public StructDefinition fields;
    public final StreamInputReader streamInputReader;

    public EventDefinition(EventDeclaration declaration, StreamInputReader streamInputReader) {
        this.declaration = declaration;
        this.streamInputReader = streamInputReader;
    }

    @Override
    public String getPath() {
        return "event";
    }

    public EventDeclaration getDeclaration() {
        return this.declaration;
    }

    public StructDefinition getFields() {
        return this.fields;
    }

    public StructDefinition getContext() {
        return this.context;
    }

    public StreamInputReader getStreamInputReader() {
        return this.streamInputReader;
    }

    public StructDefinition getPacketContext() {
        return this.streamInputReader.getCurrentPacketContext();
    }

    public int getCPU() {
        return this.streamInputReader.getCPU();
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals("context")) {
            return this.context;
        }
        if (lookupPath.equals("fields")) {
            return this.fields;
        }
        return null;
    }

    public String toString() {
        List<String> list;
        HashMap<String, Definition> f;
        StringBuilder b = new StringBuilder();
        b.append("Event type: " + this.declaration.getName() + "\n");
        b.append("Timestamp: " + Long.toString(this.timestamp) + "\n");
        if (this.context != null) {
            f = this.context.getDefinitions();
            list = this.context.getDeclaration().getFieldsList();
            for (String field : list) {
                b.append(String.valueOf(field) + " : " + f.get(field).toString() + "\n");
            }
        }
        if (this.fields != null) {
            f = this.fields.getDefinitions();
            list = this.fields.getDeclaration().getFieldsList();
            for (String field : list) {
                b.append(String.valueOf(field) + " : " + f.get(field).toString() + "\n");
            }
        }
        return b.toString();
    }
}

