/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.nio.ByteOrder;
import java.util.ListIterator;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketReader;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInputReader {
    private final StreamInput streamInput;
    private final StreamInputPacketReader packetReader;
    private ListIterator<StreamInputPacketIndexEntry> packetIndexIt;
    private EventDefinition currentEvent = null;
    private int name;

    public StreamInputReader(StreamInput streamInput) {
        this.streamInput = streamInput;
        this.packetReader = new StreamInputPacketReader(this);
        this.packetIndexIt = streamInput.getIndex().listIterator();
        this.goToNextPacket();
    }

    public EventDefinition getCurrentEvent() {
        return this.currentEvent;
    }

    public StructDefinition getCurrentPacketContext() {
        return this.packetReader.getStreamPacketContextDef();
    }

    public ByteOrder getByteOrder() {
        return this.streamInput.getStream().getTrace().getByteOrder();
    }

    public int getName() {
        return this.name;
    }

    public void setName(int name) {
        this.name = name;
    }

    public int getCPU() {
        return this.packetReader.getCPU();
    }

    public String getFilename() {
        return this.streamInput.getFilename();
    }

    StreamInput getStreamInput() {
        return this.streamInput;
    }

    public boolean readNextEvent() {
        if (!this.packetReader.hasMoreEvents()) {
            this.goToNextPacket();
        }
        if (this.packetReader.hasMoreEvents()) {
            try {
                this.setCurrentEvent(this.packetReader.readNextEvent());
            }
            catch (CTFReaderException cTFReaderException) {
                return false;
            }
            return true;
        }
        this.setCurrentEvent(null);
        return false;
    }

    private void goToNextPacket() {
        if (this.getPacketIndexIt().hasNext()) {
            StreamInputPacketIndexEntry nextPacket = this.getPacketIndexIt().next();
            this.packetReader.setCurrentPacket(nextPacket);
        } else {
            this.packetReader.setCurrentPacket(null);
        }
    }

    public long seek(long timestamp) {
        long offset = 0L;
        this.packetIndexIt = this.streamInput.getIndex().search(timestamp);
        this.goToNextPacket();
        this.readNextEvent();
        boolean done = this.getCurrentEvent() == null;
        while (!done && this.getCurrentEvent().timestamp < timestamp) {
            this.readNextEvent();
            done = this.getCurrentEvent() == null;
            ++offset;
        }
        return offset;
    }

    public long seekIndex(long index) throws CTFReaderException {
        StreamInputPacketIndexEntry sipie = null;
        this.packetIndexIt = this.streamInput.getIndex().searchIndex(index);
        this.goToNextPacket();
        sipie = this.packetReader.getCurrentPacket();
        this.readNextEvent();
        if (this.packetReader.getCurrentPacket() == null) {
            if (sipie.getIndexBegin() != 0L || sipie.getIndexEnd() != Long.MAX_VALUE) {
                throw new CTFReaderException("Current packet null in index seek, did you index your trace yet?");
            }
            return 0L;
        }
        return this.packetReader.getCurrentPacket().getIndexBegin();
    }

    public void goToLastEvent() throws CTFReaderException {
        int len = this.streamInput.getIndex().getEntries().size();
        int back = 0;
        long desired_timestamp = -1L;
        do {
            StreamInputPacketIndexEntry entry = this.streamInput.getIndex().getEntries().get(len - ++back);
            desired_timestamp = entry.getTimestampBegin() + 1L;
            this.seek(desired_timestamp);
        } while (!this.packetReader.hasMoreEvents());
        int packet_size = 0;
        while (this.packetReader.hasMoreEvents()) {
            this.packetReader.readNextEvent();
            ++packet_size;
        }
        this.seek(desired_timestamp);
        int i = 0;
        while (i < packet_size - 1) {
            this.packetReader.readNextEvent();
            ++i;
        }
    }

    public void setCurrentEvent(EventDefinition currentEvent) {
        this.currentEvent = currentEvent;
    }

    private ListIterator<StreamInputPacketIndexEntry> getPacketIndexIt() {
        return this.packetIndexIt;
    }

    public StreamInputPacketReader getPacketReader() {
        return this.packetReader;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name;
        result = 31 * result + (this.streamInput == null ? 0 : this.streamInput.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInputReader)) {
            return false;
        }
        StreamInputReader other = (StreamInputReader)obj;
        if (this.name != other.name) {
            return false;
        }
        return !(this.streamInput == null ? other.streamInput != null : !this.streamInput.equals(other.streamInput));
    }
}

