/*******************************************************************************
 * Copyright (c) 2012 Ericsson
 * Copyright (c) 2010, 2011 École Polytechnique de Montréal
 * Copyright (c) 2010, 2011 Alexandre Montplaisir <alexandre.montplaisir@gmail.com>
 * 
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 *******************************************************************************/

package org.eclipse.linuxtools.tmf.core.statevalue;

/**
 * A state value containing a simple integer.
 * 
 * @author alexmont
 *
 */
final class IntegerStateValue extends TmfStateValue {

    private final int valueInt;

    public IntegerStateValue(int valueAsInt) {
        this.valueInt = valueAsInt;
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public Integer getValue() {
        return valueInt;
    }

    @Override
    public byte[] toByteArray() {
        return null;
    }

    @Override
    public String toString() {
        return String.format("%3d", valueInt); //$NON-NLS-1$
    }
}
