/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.state;

import java.util.Map;
import org.eclipse.linuxtools.internal.lttng.core.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.state.AbsStateUpdate;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LTTngCPUState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngBdevState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngExecutionState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngIRQState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngProcessState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngSoftIRQState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTrapState;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;

class StateUpdateHandlers {
    StateUpdateHandlers() {
    }

    final ILttngEventProcessor getSyscallEntryHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                LttngProcessState process = traceSt.getRunning_process().get(cpu);
                if (process != null && process.getPid() != null && process.getPid() == 0L) {
                    return true;
                }
                Long syscall = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_SYSCALL_ID);
                String submode = null;
                int submodeId = 0;
                if (syscall == null) {
                    TraceDebug.debug("Syscall Field not found, traceVent time: " + trcEvent.getTimestamp());
                } else {
                    submode = traceSt.getSyscall_names().get(syscall);
                    submodeId = syscall.intValue() | 0x40000000;
                }
                if (submode == null) {
                    submode = StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.getInName();
                    submodeId = StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.ordinal() | 0x10000000;
                }
                this.push_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_SYSCALL, submode, submodeId, trcEvent.getTimestamp(), traceSt);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getsySyscallExitHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                LttngProcessState process = traceSt.getRunning_process().get(cpu);
                if (process != null && process.getPid() != null && process.getPid() == 0L) {
                    return true;
                }
                this.pop_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_SYSCALL, traceSt, trcEvent.getTimestamp());
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getTrapEntryHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                Long trap = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_TRAP_ID);
                if (trap == null) {
                    TraceDebug.debug("Trap field could not be found, event time: " + trcEvent.getTimestamp());
                    return true;
                }
                String submode = traceSt.getTrap_names().get(trap);
                int submodeId = trap.intValue() | 0x50000000;
                if (submode == null) {
                    submode = StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.getInName();
                    submodeId = StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.ordinal() | 0x10000000;
                }
                this.push_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_TRAP, submode, submodeId, trcEvent.getTimestamp(), traceSt);
                LTTngCPUState cpust = traceSt.getCpu_states().get(cpu);
                this.cpu_push_mode(cpust, StateStrings.CpuMode.LTTV_CPU_TRAP);
                cpust.pushToTrapStack(trap);
                LttngTrapState trap_state = null;
                trap_state = traceSt.getTrap_states().get(trap);
                if (trap_state == null) {
                    trap_state = new LttngTrapState();
                    trap_state.incrementRunning();
                    traceSt.getTrap_states().put(trap, trap_state);
                } else {
                    trap_state.incrementRunning();
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getTrapExitHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                LTTngCPUState cpust = traceSt.getCpu_states().get(cpu);
                Long trap = cpust.popFromTrapStack();
                this.pop_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_TRAP, traceSt, trcEvent.getTimestamp());
                this.cpu_pop_mode(cpust);
                if (trap != -1L) {
                    traceSt.getTrap_states().get(trap).decrementRunning();
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getIrqEntryHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                Long irq = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_IRQ_ID);
                if (irq == null || traceSt.getIrq_states().get(irq) == null) {
                    if (irq != null) {
                        TraceDebug.debug("Invalid irq (" + irq + "), ts = " + trcEvent.getTimestamp());
                    }
                    return true;
                }
                String submode = traceSt.getIrq_names().get(irq);
                int submodeId = irq.intValue() | 0x20000000;
                if (submode == null) {
                    submode = StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.getInName();
                    submodeId = StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.ordinal() | 0x10000000;
                }
                this.push_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_IRQ, submode, submodeId, trcEvent.getTimestamp(), traceSt);
                LTTngCPUState cpust = traceSt.getCpu_states().get(cpu);
                this.cpu_push_mode(cpust, StateStrings.CpuMode.LTTV_CPU_IRQ);
                cpust.pushToIrqStack(irq);
                this.irq_push_mode(traceSt.getIrq_states().get(irq), StateStrings.IRQMode.LTTV_IRQ_BUSY);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getSoftIrqExitHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngSoftIRQState softIrqstate;
                Long cpu = trcEvent.getCpuId();
                LTTngCPUState cpust = traceSt.getCpu_states().get(cpu);
                Long softirq = cpust.popFromSoftIrqStack();
                this.pop_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_SOFT_IRQ, traceSt, trcEvent.getTimestamp());
                if (softirq != -1L && (softIrqstate = traceSt.getSoft_irq_states().get(softirq)) != null) {
                    softIrqstate.decrementRunning();
                }
                this.cpu_pop_mode(cpust);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getIrqExitHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                this.pop_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_IRQ, traceSt, trcEvent.getTimestamp());
                LTTngCPUState cpust = traceSt.getCpu_states().get(cpu);
                this.cpu_pop_mode(cpust);
                Long last_irq = cpust.popFromIrqStack();
                if (last_irq != -1L) {
                    LttngIRQState irq_state = traceSt.getIrq_states().get(last_irq);
                    this.irq_pop_mode(irq_state);
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getSoftIrqRaiseHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){
            private StateStrings.Events eventType = StateStrings.Events.LTT_EVENT_SOFT_IRQ_RAISE;

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long softirq = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_SOFT_IRQ_ID);
                if (softirq == null) {
                    TraceDebug.debug("Soft_irq_id not found in " + this.eventType.getInName() + " time: " + trcEvent.getTimestamp());
                    return true;
                }
                LttngSoftIRQState irqState = traceSt.getSoft_irq_states().get(softirq);
                if (irqState != null) {
                    irqState.setPending(1L);
                } else {
                    TraceDebug.debug("unexpected soft irq id value: " + softirq);
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getSoftIrqEntryHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                Long softirq = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_SOFT_IRQ_ID);
                if (softirq == null) {
                    TraceDebug.debug("Soft IRQ ID not found, eventTime: " + trcEvent.getTimestamp());
                    return true;
                }
                Map<Long, String> softIrqNames = traceSt.getSoft_irq_names();
                String submode = softIrqNames.get(softirq);
                if (submode == null) {
                    submode = "softirq " + softirq;
                    softIrqNames.put(softirq, submode);
                }
                int submodeId = softirq.intValue() | 0x30000000;
                LttngSoftIRQState irqState = traceSt.getSoft_irq_states().get(softirq);
                if (irqState != null) {
                    irqState.decrementPending();
                    irqState.incrementRunning();
                } else {
                    TraceDebug.debug("unexpected soft irq id value: " + softirq);
                }
                LTTngCPUState cpu_state = traceSt.getCpu_states().get(cpu);
                cpu_state.pushToSoftIrqStack(softirq);
                this.cpu_push_mode(cpu_state, StateStrings.CpuMode.LTTV_CPU_SOFT_IRQ);
                this.push_state(cpu, StateStrings.ExecutionMode.LTTV_STATE_SOFT_IRQ, submode, submodeId, trcEvent.getTimestamp(), traceSt);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getEnumInterruptHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){
            private StateStrings.Events eventType = StateStrings.Events.LTT_EVENT_LIST_INTERRUPT;

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                String action = this.getAFieldString(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_ACTION);
                Long irq = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_IRQ_ID);
                if (action == null) {
                    TraceDebug.debug("Field Action not found in event " + this.eventType.getInName() + " time: " + trcEvent.getTimestamp());
                    return true;
                }
                if (irq == null) {
                    TraceDebug.debug("Field irq_id not found in event " + this.eventType.getInName() + " time: " + trcEvent.getTimestamp());
                    return true;
                }
                Map<Long, String> irq_names = traceSt.getIrq_names();
                irq_names.put(irq, action);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getBdevRequestIssueHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long major = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_MAJOR);
                Long minor = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_MINOR);
                Long operation = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_OPERATION);
                Long devcode = this.mkdev(major, minor);
                if (devcode == null) {
                    TraceDebug.debug("incorrect calcualtion of bdevcode input( major: " + major + " minor: " + minor + " operation: " + operation);
                    return true;
                }
                Map<Long, LttngBdevState> bdev_states = traceSt.getBdev_states();
                LttngBdevState bdevState = bdev_states.get(devcode);
                if (bdevState == null) {
                    bdevState = new LttngBdevState();
                }
                if (operation == 0L) {
                    bdevState.pushToBdevStack(StateStrings.BdevMode.LTTV_BDEV_BUSY_READING);
                } else {
                    bdevState.pushToBdevStack(StateStrings.BdevMode.LTTV_BDEV_BUSY_WRITING);
                }
                bdev_states.put(devcode, bdevState);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getBdevRequestCompleteHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long major = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_MAJOR);
                Long minor = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_MINOR);
                Long operation = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_OPERATION);
                Long devcode = this.mkdev(major, minor);
                if (devcode == null) {
                    TraceDebug.debug("incorrect calcualtion of bdevcode input( major: " + major + " minor: " + minor + " operation: " + operation);
                    return true;
                }
                Map<Long, LttngBdevState> bdev_states = traceSt.getBdev_states();
                LttngBdevState bdevState = bdev_states.get(devcode);
                if (bdevState == null) {
                    bdevState = new LttngBdevState();
                }
                this.bdev_pop_mode(bdevState);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getFunctionEntryHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                Long funcptr = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_THIS_FN);
                this.push_function(traceSt, funcptr, cpu);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getFunctionExitHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long funcptr = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_THIS_FN);
                this.pop_function(traceSt, trcEvent, funcptr);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getDumpSyscallHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long id = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_ID);
                String symbol = this.getAFieldString(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_SYMBOL);
                traceSt.getSyscall_names().put(id, symbol);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getDumpKprobeHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long ip = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_IP);
                String symbol = this.getAFieldString(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_SYMBOL);
                traceSt.getKprobe_table().put(ip, symbol);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getDumpSoftIrqHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long id = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_ID);
                String symbol = this.getAFieldString(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_SYMBOL);
                traceSt.getSoft_irq_names().put(id, symbol);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getSchedChangeHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                ITmfTimestamp eventTime = trcEvent.getTimestamp();
                LttngProcessState process = traceSt.getRunning_process().get(cpu);
                Long pid_out = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PREV_PID);
                Long pid_in = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_NEXT_PID);
                Long state_out = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PREV_STATE);
                if (process != null) {
                    if (process.getPid() == 0L && process.getState().getExec_mode() == StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN) {
                        if (pid_out != null && pid_out == 0L) {
                            process.getState().setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_SYSCALL);
                            process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_WAIT);
                            process.getState().setChange_Time(trcEvent.getTimestamp().getValue());
                            process.getState().setEntry_Time(trcEvent.getTimestamp().getValue());
                        }
                    } else {
                        if (process.getState().getProc_status() == StateStrings.ProcessStatus.LTTV_STATE_EXIT) {
                            process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_ZOMBIE);
                            process.getState().setChange_Time(trcEvent.getTimestamp().getValue());
                        } else {
                            if (state_out != null && state_out == 0L) {
                                process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_WAIT_CPU);
                            } else {
                                process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_WAIT);
                            }
                            process.getState().setChange_Time(trcEvent.getTimestamp().getValue());
                        }
                        if (!(state_out == null || state_out != 32L && state_out != 64L || this.exit_process(traceSt, process))) {
                            process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_DEAD);
                            process.getState().setChange_Time(trcEvent.getTimestamp().getValue());
                        }
                    }
                }
                process = this.lttv_state_find_process_or_create(traceSt, cpu, pid_in, eventTime);
                traceSt.getRunning_process().put(cpu, process);
                process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_RUN);
                process.getState().setChange_Time(eventTime.getValue());
                process.setCpu(cpu);
                LTTngCPUState cpu_state = traceSt.getCpu_states().get(cpu);
                if (pid_in != null && pid_in == 0L) {
                    this.cpu_set_base_mode(cpu_state, StateStrings.CpuMode.LTTV_CPU_IDLE);
                } else {
                    this.cpu_set_base_mode(cpu_state, StateStrings.CpuMode.LTTV_CPU_BUSY);
                    if (process.getState().getExec_mode() == StateStrings.ExecutionMode.LTTV_STATE_TRAP) {
                        this.cpu_push_mode(cpu_state, StateStrings.CpuMode.LTTV_CPU_TRAP);
                    }
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessForkHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState child_process;
                Long cpu = trcEvent.getCpuId();
                LttngProcessState process = traceSt.getRunning_process().get(cpu);
                ITmfTimestamp timeStamp = trcEvent.getTimestamp();
                Long child_pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_CHILD_PID);
                Long child_tgid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_CHILD_TGID);
                if (child_tgid == null) {
                    child_tgid = 0L;
                }
                if (process.getPid().equals(child_pid)) {
                    TraceDebug.debug("Unexpected, process pid equal to child pid: " + child_pid + " Event Time: " + trcEvent.getTimestamp());
                }
                if ((child_process = this.lttv_state_find_process(traceSt, ANY_CPU, child_pid)) == null) {
                    child_process = this.create_process(traceSt, cpu, child_pid, child_tgid, timeStamp);
                    child_process.setPpid(process.getPid(), timeStamp.getValue());
                } else {
                    StringBuilder sb = new StringBuilder("Process " + child_pid);
                    sb.append(" has been created at [" + child_process.getCreation_time() + "] ");
                    sb.append("and inserted at [" + child_process.getInsertion_time() + "] ");
                    sb.append("before \nfork on cpu " + cpu + " Event time: [" + (Object)((Object)trcEvent) + "]\n.");
                    sb.append("Probably an unsynchronized TSD problem on the traced machine.");
                    TraceDebug.debug(sb.toString());
                    child_process.setPpid(process.getPid());
                    child_process.setTgid(child_tgid);
                }
                if (!child_process.getName().equals(StateStrings.ProcessStatus.LTTV_STATE_UNNAMED.getInName())) {
                    TraceDebug.debug("Unexpected child process status: " + child_process.getName());
                }
                child_process.setName(process.getName());
                child_process.setBrand(process.getBrand());
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessKernelThreadHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PID);
                LttngProcessState process = this.lttv_state_find_process_or_create(traceSt, ANY_CPU, pid, (ITmfTimestamp)new TmfTimestamp());
                if (!process.getState().getProc_status().equals((Object)StateStrings.ProcessStatus.LTTV_STATE_DEAD)) {
                    LttngExecutionState exState = process.getFirstElementFromExecutionStack();
                    exState.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_SYSCALL);
                    process.clearExecutionStack();
                    process.pushToExecutionStack(exState);
                }
                process.setType(StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessExitHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PID);
                LttngProcessState process = this.lttv_state_find_process(traceSt, ANY_CPU, pid);
                if (process != null) {
                    process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_EXIT);
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessFreeHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState process;
                Long release_pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PID);
                if (release_pid != null && release_pid == 0L) {
                    TraceDebug.debug("Unexpected release_pid: 0, Event time: " + trcEvent.getTimestamp());
                }
                if ((process = this.lttv_state_find_process(traceSt, ANY_CPU, release_pid)) != null) {
                    this.exit_process(traceSt, process);
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessExecHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                LttngProcessState process = traceSt.getRunning_process().get(cpu);
                process.setName(this.getAFieldString(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_FILENAME));
                process.setBrand("");
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor GetThreadBrandHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                LttngProcessState process = traceSt.getRunning_process().get(cpu);
                String name = this.getAFieldString(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_NAME);
                process.setBrand(name);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getStateDumpEndHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState[] processes = traceSt.getProcesses();
                ITmfTimestamp time = trcEvent.getTimestamp();
                int pos = 0;
                while (pos < processes.length) {
                    this.fix_process(processes[pos], time);
                    ++pos;
                }
                LttngProcessState process = traceSt.getRunning_process().get(trcEvent.getCpuId());
                process.getState().setProc_status(StateStrings.ProcessStatus.LTTV_STATE_RUN);
                return false;
            }

            private void fix_process(LttngProcessState process, ITmfTimestamp timestamp) {
                if (process.getType() == StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD) {
                    LttngExecutionState es = process.getFirstElementFromExecutionStack();
                    if (es.getExec_mode() == StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN) {
                        es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_SYSCALL);
                        es.setExec_submode(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.getInName());
                        es.setExec_submode_id(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.ordinal() | 0x10000000);
                        es.setEntry_Time(timestamp.getValue());
                        es.setChange_Time(timestamp.getValue());
                        es.setCum_cpu_time(0L);
                        if (es.getProc_status() == StateStrings.ProcessStatus.LTTV_STATE_UNNAMED) {
                            es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_WAIT);
                        }
                    }
                } else {
                    LttngExecutionState es = process.getFirstElementFromExecutionStack();
                    if (es.getExec_mode() == StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN) {
                        es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_USER_MODE);
                        es.setExec_submode(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.getInName());
                        es.setExec_submode_id(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.ordinal() | 0x10000000);
                        es.setEntry_Time(timestamp.getValue());
                        es.setChange_Time(timestamp.getValue());
                        es.setCum_cpu_time(0L);
                        if (es.getProc_status() == StateStrings.ProcessStatus.LTTV_STATE_UNNAMED) {
                            es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_RUN);
                        }
                        if (process.getFirstElementFromExecutionStack() == process.peekFromExecutionStack()) {
                            es = new LttngExecutionState();
                            es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_SYSCALL);
                            es.setExec_submode(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.getInName());
                            es.setExec_submode_id(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.ordinal() | 0x10000000);
                            es.setEntry_Time(timestamp.getValue());
                            es.setChange_Time(timestamp.getValue());
                            es.setCum_cpu_time(0L);
                            es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_WAIT);
                            process.pushToExecutionStack(es);
                        }
                    }
                }
            }
        };
        return handler;
    }

    final ILttngEventProcessor getEnumProcessStateHandler() {
        AbsStateUpdate handler = new AbsStateUpdate(){

            @Override
            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long tgid;
                Long cpu = trcEvent.getCpuId();
                LttngProcessState process = traceSt.getRunning_process().get(cpu);
                Long pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PID);
                Long parent_pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PARENT_PID);
                String command = this.getAFieldString(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_NAME);
                Long typeVal = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_TYPE);
                String type = StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD.getInName();
                if (typeVal != null && typeVal == 0L) {
                    type = StateStrings.ProcessType.LTTV_STATE_USER_THREAD.getInName();
                }
                if ((tgid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_TGID)) == null) {
                    tgid = 0L;
                }
                if (pid != null && pid == 0L) {
                    for (Long acpu : traceSt.getCpu_states().keySet()) {
                        process = this.lttv_state_find_process(traceSt, acpu, pid);
                        if (process != null) {
                            process.setPpid(parent_pid);
                            process.setTgid(tgid);
                            process.setName(command);
                            process.setType(StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD);
                            continue;
                        }
                        StringBuilder sb = new StringBuilder("Unexpected, null process read from the TraceState list of processes, event time: " + trcEvent.getTimestamp());
                        TraceDebug.debug(sb.toString());
                    }
                } else {
                    process = this.lttv_state_find_process(traceSt, ANY_CPU, pid);
                    if (process == null) {
                        LttngProcessState parent_process = this.lttv_state_find_process(traceSt, ANY_CPU, parent_pid);
                        ITmfTimestamp eventTime = trcEvent.getTimestamp();
                        process = this.create_process(traceSt, cpu, pid, tgid, command, eventTime);
                        if (parent_process != null) {
                            process.setPpid(parent_process.getPid(), eventTime.getValue());
                        }
                        if (type.equals(StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD.getInName())) {
                            process.setType(StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD);
                        }
                        process.popFromExecutionStack();
                        LttngExecutionState es = process.getState();
                        es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN);
                        es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_UNNAMED);
                        es.setExec_submode(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.getInName());
                        es.setExec_submode_id(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_UNKNOWN.ordinal() | 0x10000000);
                    } else {
                        process.setPpid(parent_pid);
                        process.setTgid(tgid);
                        process.setName(command);
                        if (type.equals(StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD.getInName())) {
                            process.setType(StateStrings.ProcessType.LTTV_STATE_KERNEL_THREAD);
                        } else {
                            process.setType(StateStrings.ProcessType.LTTV_STATE_USER_THREAD);
                        }
                    }
                }
                return false;
            }
        };
        return handler;
    }
}

