/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.util.TCFTask;

public class TraceResource
extends AbstractResource
implements Comparable<TraceResource> {
    public static final String Ltt_Trace_Property_TracePath = "trace_path";
    public static final String Ltt_Trace_Property_TraceNumberOfChannels = "num_threads";
    public static final String Ltt_Trace_Property_FlightRecorderMode = "flight_only";
    public static final String Ltt_Trace_Property_NormalMode = "normal_only";
    public static final String Ltt_Trace_Property_NetworkTrace = "isNetwork";
    public static final String Ltt_Trace_Property_TraceTransport = "transport";
    public static final int DEFAULT_TCF_TASK_TIMEOUT = 10;
    private static final Map<String, PropertyInfo> fPropertyInfo = new HashMap<String, PropertyInfo>();
    private String fName;
    private String fId;
    private TargetResource fParent;
    private TraceState fTraceState;
    private TraceConfig fTraceConfig;
    private ILttControllerService fService;

    static {
        fPropertyInfo.put(Ltt_Trace_Property_TracePath, new PropertyInfo(Messages.Ltt_Trace_Property_TracePathName, Messages.Ltt_Trace_Property_TracePathDescription));
        fPropertyInfo.put(Ltt_Trace_Property_TraceNumberOfChannels, new PropertyInfo(Messages.Ltt_Trace_Property_NumberOfChannelsName, Messages.Ltt_Trace_Property_NumberOfChannelsDescr));
        fPropertyInfo.put(Ltt_Trace_Property_FlightRecorderMode, new PropertyInfo(Messages.Ltt_Trace_Property_FlighRecorderModeName, Messages.Ltt_Trace_Property_FlighRecorderModeDesc));
        fPropertyInfo.put(Ltt_Trace_Property_NormalMode, new PropertyInfo(Messages.Ltt_Trace_Property_NormalModeName, Messages.Ltt_Trace_Property_NormalModeDesc));
        fPropertyInfo.put(Ltt_Trace_Property_NetworkTrace, new PropertyInfo(Messages.Ltt_Trace_Property_NetworkTraceName, Messages.Ltt_Trace_Property_NetWorkTraceDescr));
        fPropertyInfo.put(Ltt_Trace_Property_TraceTransport, new PropertyInfo(Messages.Ltt_Trace_Property_TraceTransportName, Messages.Ltt_Trace_Property_TraceTransportDesc));
    }

    public TraceResource(ISubSystem parentSubSystem, ILttControllerService service) {
        super(parentSubSystem);
        this.fService = service;
    }

    public TraceState getTraceState() {
        return this.fTraceState;
    }

    public void setTraceState(TraceState traceState) {
        this.fTraceState = traceState;
    }

    public TraceConfig getTraceConfig() {
        return this.fTraceConfig;
    }

    public void setTraceConfig(TraceConfig traceConfig) {
        this.fTraceConfig = traceConfig;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getId() {
        return this.fId;
    }

    public void setId(String id) {
        this.fId = id;
    }

    public TargetResource getParent() {
        return this.fParent;
    }

    public void setParent(TargetResource target) {
        this.fParent = target;
    }

    public Map<String, PropertyInfo> getPropertyInfo() {
        return fPropertyInfo;
    }

    public String getProperty(String property) {
        if (this.fTraceConfig != null && fPropertyInfo.containsKey(property)) {
            if (Ltt_Trace_Property_TracePath.equals(property)) {
                return this.fTraceConfig.getTracePath();
            }
            if (Ltt_Trace_Property_TraceNumberOfChannels.equals(property)) {
                return String.valueOf(this.fTraceConfig.getNumChannel());
            }
            if (Ltt_Trace_Property_FlightRecorderMode.equals(property)) {
                return String.valueOf(this.fTraceConfig.getMode() == 1);
            }
            if (Ltt_Trace_Property_NormalMode.equals(property)) {
                return String.valueOf(this.fTraceConfig.getMode() == 0);
            }
            if (Ltt_Trace_Property_NetworkTrace.equals(property)) {
                return String.valueOf(this.fTraceConfig.isNetworkTrace());
            }
            if (Ltt_Trace_Property_TraceTransport.equals(property)) {
                return String.valueOf(this.fTraceConfig.getTraceTransport());
            }
        }
        return "";
    }

    public boolean isNetworkTraceAndStarted() {
        return this.fTraceConfig != null && this.fTraceConfig.isNetworkTrace() && !"network".equals(this.fTraceConfig.getTracePath()) && this.fTraceState == TraceState.STARTED;
    }

    public boolean isUst() {
        return this.fParent.isUst();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TraceResource) {
            TraceResource otherTrace = (TraceResource)other;
            if (this.fName != null) {
                return this.fName.equals(otherTrace.fName);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    @Override
    public int compareTo(TraceResource o) {
        return this.fName.toLowerCase().compareTo(o.fName.toLowerCase());
    }

    public String toString() {
        return "[TraceResource (" + this.fName + ")]";
    }

    public void setupTrace() throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                TraceResource.this.fService.setupTrace(TraceResource.this.fParent.getParent().getName(), TraceResource.this.fParent.getName(), TraceResource.this.fName, new ILttControllerService.DoneSetupTrace(){

                    @Override
                    public void doneSetupTrace(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    public void setChannelEnable(final String channelName, final boolean enabled) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                TraceResource.this.fService.setChannelEnable(TraceResource.this.fParent.getParent().getName(), TraceResource.this.fParent.getName(), TraceResource.this.fName, channelName, enabled, new ILttControllerService.DoneSetChannelEnable(){

                    @Override
                    public void doneSetChannelEnable(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    public void setChannelOverwrite(final String channelName, final boolean overwrite) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                TraceResource.this.fService.setChannelOverwrite(TraceResource.this.fParent.getParent().getName(), TraceResource.this.fParent.getName(), TraceResource.this.fName, channelName, overwrite, new ILttControllerService.DoneSetChannelOverwrite(){

                    @Override
                    public void doneSetChannelOverwrite(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    public void setChannelTimer(final String channelName, final long timer) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                TraceResource.this.fService.setChannelTimer(TraceResource.this.fParent.getParent().getName(), TraceResource.this.fParent.getName(), TraceResource.this.fName, channelName, timer, new ILttControllerService.DoneSetChannelTimer(){

                    @Override
                    public void doneSetChannelTimer(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    public void setChannelSubbufNum(final String channelName, final long subbufNum) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                TraceResource.this.fService.setChannelSubbufNum(TraceResource.this.fParent.getParent().getName(), TraceResource.this.fParent.getName(), TraceResource.this.fName, channelName, subbufNum, new ILttControllerService.DoneSetChannelSubbufNum(){

                    @Override
                    public void doneSetChannelSubbufNum(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    public void setChannelSubbufSize(final String channelName, final long subbufSize) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                TraceResource.this.fService.setChannelSubbufSize(TraceResource.this.fParent.getParent().getName(), TraceResource.this.fParent.getName(), TraceResource.this.fName, channelName, subbufSize, new ILttControllerService.DoneSetChannelSubbufSize(){

                    @Override
                    public void doneSetChannelSubbufSize(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    public static class PropertyInfo {
        private final String name;
        private final String description;

        PropertyInfo(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum TraceState {
        CREATED,
        CONFIGURED,
        STARTED,
        PAUSED,
        STOPPED;

    }
}

