/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.Messages;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecfileSource
extends SpecfileElement {
    int number;
    int lineNumber = -1;
    String fileName;
    SourceType sourceType;
    List<Integer> linesUsed;

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public SpecfileSource(int number, String fileName) {
        super("source");
        this.number = number;
        this.fileName = fileName;
        this.linesUsed = new ArrayList<Integer>();
    }

    public String getFileName() {
        return this.resolve(this.fileName);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void addLineUsed(int lineNumber) {
        this.linesUsed.add(lineNumber);
    }

    public void removeLineUsed(int lineNumber) {
        this.linesUsed.remove((Object)lineNumber);
    }

    public List<Integer> getLinesUsed() {
        return this.linesUsed;
    }

    @Override
    public String toString() {
        if (this.sourceType == SourceType.SOURCE) {
            return MessageFormat.format("Source #{0} (line #{1}, used on lines {2}) -> {3}", this.number, this.lineNumber, this.getLinesUsed(), this.fileName);
        }
        return MessageFormat.format("Patch #{0} (line #{1}, used on lines {2}) -> {3}", this.number, this.lineNumber, this.getLinesUsed(), this.fileName);
    }

    public void changeReferences(int oldPatchNumber) {
        Specfile specfile = this.getSpecfile();
        Pattern patchPattern = oldPatchNumber == 0 ? Pattern.compile("%patch" + oldPatchNumber + "|%patch") : Pattern.compile("%patch" + oldPatchNumber);
        for (int lineNumber : this.getLinesUsed()) {
            try {
                String line = specfile.getLine(lineNumber);
                Matcher patchMatcher = patchPattern.matcher(line);
                if (!patchMatcher.find()) {
                    System.out.println(String.valueOf(Messages.getString("SpecfileSource.0")) + patchPattern.pattern());
                }
                specfile.changeLine(lineNumber, line.replaceAll(patchPattern.pattern(), String.valueOf(Messages.getString("SpecfileSource.1")) + this.number));
            }
            catch (BadLocationException e) {
                SpecfileLog.logError(e);
            }
        }
    }

    public void changeDeclaration(int oldPatchNumber) {
        Specfile specfile = this.getSpecfile();
        Pattern patchPattern = oldPatchNumber == 0 ? Pattern.compile("Patch" + oldPatchNumber + "|Patch") : Pattern.compile("Patch" + oldPatchNumber);
        try {
            String line = specfile.getLine(this.lineNumber);
            Matcher patchMatcher = patchPattern.matcher(line);
            if (!patchMatcher.find()) {
                System.out.println(String.valueOf(Messages.getString("SpecfileSource.2")) + patchPattern.pattern());
            }
            specfile.changeLine(this.lineNumber, line.replaceAll(patchPattern.pattern(), "Patch" + this.number));
        }
        catch (BadLocationException e) {
            SpecfileLog.logError(e);
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        SOURCE,
        PATCH;

    }
}

