/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class DropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (target instanceof TmfTraceFolder) {
            this.getCommonDropAdapter().overrideOperation(1);
            return Status.OK_STATUS;
        }
        if (target instanceof TmfExperimentElement) {
            this.getCommonDropAdapter().overrideOperation(4);
            return Status.OK_STATUS;
        }
        if (target instanceof TmfTraceElement) {
            ITmfProjectModelElement parent = ((TmfTraceElement)target).getParent();
            if (parent instanceof TmfTraceFolder) {
                this.getCommonDropAdapter().overrideOperation(1);
                return Status.OK_STATUS;
            }
            if (parent instanceof TmfExperimentElement) {
                this.getCommonDropAdapter().overrideOperation(4);
                return Status.OK_STATUS;
            }
        }
        if (target instanceof IProject) {
            this.getCommonDropAdapter().overrideOperation(1);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        boolean ok;
        block21: {
            String[] sources;
            Object targetToUse;
            block20: {
                TmfProjectElement projectElement;
                ok = false;
                targetToUse = aTarget;
                if (targetToUse instanceof TmfTraceElement) {
                    targetToUse = ((TmfTraceElement)targetToUse).getParent();
                }
                if (targetToUse instanceof IProject && (projectElement = TmfProjectRegistry.getProject((IProject)targetToUse)) != null) {
                    targetToUse = projectElement.getTracesFolder();
                }
                if (!(aDropTargetEvent.data instanceof IStructuredSelection)) break block20;
                IStructuredSelection selection = (IStructuredSelection)aDropTargetEvent.data;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TmfTraceFolder traceFolder;
                    TmfExperimentElement targetExperiment;
                    IResource sourceResource;
                    TmfProjectElement projectElement2;
                    Object source = objectArray[n2];
                    if (source instanceof IResource && (projectElement2 = TmfProjectRegistry.getProject((sourceResource = (IResource)source).getProject())) != null && projectElement2.getTracesFolder() != null) {
                        for (TmfTraceElement trace : projectElement2.getTracesFolder().getTraces()) {
                            if (!trace.getResource().equals((Object)sourceResource)) continue;
                            source = trace;
                            break;
                        }
                    }
                    if (source instanceof TmfTraceElement) {
                        TmfTraceElement sourceTrace = (TmfTraceElement)source;
                        if (sourceTrace.getParent() instanceof TmfExperimentElement) {
                            for (TmfTraceElement trace : sourceTrace.getProject().getTracesFolder().getTraces()) {
                                if (!trace.getName().equals(sourceTrace.getName())) continue;
                                sourceTrace = trace;
                                break;
                            }
                        }
                        if (targetToUse instanceof TmfExperimentElement) {
                            targetExperiment = (TmfExperimentElement)targetToUse;
                            ok |= this.drop(sourceTrace, targetExperiment);
                        } else if (targetToUse instanceof TmfTraceFolder) {
                            traceFolder = (TmfTraceFolder)targetToUse;
                            ok |= this.drop(sourceTrace, traceFolder);
                        }
                    } else if (source instanceof IResource && ((sourceResource = (IResource)source).getType() == 1 || sourceResource.getType() == 2)) {
                        if (targetToUse instanceof TmfExperimentElement) {
                            targetExperiment = (TmfExperimentElement)targetToUse;
                            ok |= this.drop(sourceResource, targetExperiment);
                        } else if (targetToUse instanceof TmfTraceFolder) {
                            traceFolder = (TmfTraceFolder)targetToUse;
                            ok |= this.drop(sourceResource, traceFolder);
                        }
                    }
                    ++n2;
                }
                break block21;
            }
            if (!(aDropTargetEvent.data instanceof String[])) break block21;
            String[] stringArray = sources = (String[])aDropTargetEvent.data;
            int n = sources.length;
            int n3 = 0;
            while (n3 < n) {
                String source = stringArray[n3];
                Path path = new Path(source);
                if (targetToUse instanceof TmfExperimentElement) {
                    TmfExperimentElement targetExperiment = (TmfExperimentElement)targetToUse;
                    ok |= this.drop(path, targetExperiment);
                } else if (targetToUse instanceof TmfTraceFolder) {
                    TmfTraceFolder traceFolder = (TmfTraceFolder)targetToUse;
                    ok |= this.drop(path, traceFolder);
                }
                ++n3;
            }
        }
        return ok ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private boolean drop(TmfTraceElement sourceTrace, TmfExperimentElement targetExperiment) {
        IResource sourceResource = sourceTrace.getResource();
        if (this.drop(sourceResource, targetExperiment)) {
            IFolder destinationSupplementaryFolder = targetExperiment.getTraceSupplementaryFolder(sourceResource.getName());
            sourceTrace.copySupplementaryFolder(destinationSupplementaryFolder);
            return true;
        }
        return false;
    }

    private boolean drop(IResource sourceResource, TmfExperimentElement targetExperiment) {
        boolean doit = true;
        IResource sourceResourceToUse = sourceResource;
        TmfProjectElement projectElement = TmfProjectRegistry.getProject(sourceResourceToUse.getProject());
        for (TmfTraceElement trace : targetExperiment.getTraces()) {
            if (!trace.getName().equals(sourceResourceToUse.getName())) continue;
            doit = false;
            break;
        }
        if (doit && !targetExperiment.getProject().equals(projectElement)) {
            for (TmfTraceElement trace : targetExperiment.getProject().getTracesFolder().getTraces()) {
                if (!trace.getName().equals(sourceResourceToUse.getName())) continue;
                doit = false;
                break;
            }
            if (doit) {
                try {
                    IPath destination = targetExperiment.getProject().getTracesFolder().getResource().getFullPath().addTrailingSeparator().append(sourceResourceToUse.getName());
                    sourceResourceToUse.copy(destination, false, null);
                    this.cleanupBookmarks(destination);
                    if (sourceResourceToUse.getType() == 1) {
                        sourceResourceToUse = targetExperiment.getProject().getTracesFolder().getResource().getFile(sourceResourceToUse.getName());
                    } else if (sourceResourceToUse.getType() == 2) {
                        sourceResourceToUse = targetExperiment.getProject().getTracesFolder().getResource().getFolder(sourceResourceToUse.getName());
                    }
                }
                catch (CoreException e) {
                    doit = false;
                    this.displayException((Exception)((Object)e));
                }
            }
        }
        if (doit && sourceResourceToUse != null && sourceResourceToUse.exists()) {
            this.createLink(targetExperiment.getResource(), sourceResourceToUse);
            return true;
        }
        return false;
    }

    private boolean drop(TmfTraceElement sourceTrace, TmfTraceFolder traceFolder) {
        IResource sourceResource = sourceTrace.getResource();
        if (this.drop(sourceResource, traceFolder)) {
            IFolder destinationSupplementaryFolder = traceFolder.getTraceSupplementaryFolder(sourceResource.getName());
            sourceTrace.copySupplementaryFolder(destinationSupplementaryFolder);
            return true;
        }
        return false;
    }

    private boolean drop(IResource sourceResource, TmfTraceFolder traceFolder) {
        boolean doit = true;
        for (TmfTraceElement trace : traceFolder.getTraces()) {
            if (!trace.getName().equals(sourceResource.getName())) continue;
            doit = false;
            break;
        }
        if (doit) {
            try {
                IPath destination = traceFolder.getResource().getFullPath().addTrailingSeparator().append(sourceResource.getName());
                sourceResource.copy(destination, false, null);
                this.cleanupBookmarks(destination);
                return true;
            }
            catch (CoreException e) {
                this.displayException((Exception)((Object)e));
            }
        }
        return false;
    }

    private boolean drop(Path path, TmfExperimentElement targetExperiment) {
        boolean doit = true;
        Path pathToUse = path;
        for (TmfTraceElement trace : targetExperiment.getTraces()) {
            if (!trace.getName().equals(pathToUse.lastSegment())) continue;
            doit = false;
            break;
        }
        if (doit && !pathToUse.toString().startsWith(targetExperiment.getProject().getResource().getLocation().toString())) {
            for (TmfTraceElement trace : targetExperiment.getProject().getTracesFolder().getTraces()) {
                if (!trace.getName().equals(pathToUse.lastSegment())) continue;
                doit = false;
                break;
            }
            if (doit) {
                this.importTrace(targetExperiment.getProject().getTracesFolder().getResource(), pathToUse);
                pathToUse = new Path(targetExperiment.getProject().getTracesFolder().getResource().getFile(pathToUse.lastSegment()).getLocation().toString());
            }
        }
        if (doit) {
            IFile resource = null;
            File file = new File(pathToUse.toString());
            if (file.exists() && file.isFile()) {
                resource = targetExperiment.getProject().getTracesFolder().getResource().getFile(pathToUse.lastSegment());
            } else if (file.exists() && file.isDirectory()) {
                resource = targetExperiment.getProject().getTracesFolder().getResource().getFolder(pathToUse.lastSegment());
            }
            if (resource != null && resource.exists()) {
                this.createLink(targetExperiment.getResource(), (IResource)resource);
                return true;
            }
        }
        return false;
    }

    private boolean drop(Path path, TmfTraceFolder traceFolder) {
        boolean doit = true;
        for (TmfTraceElement trace : traceFolder.getTraces()) {
            if (!trace.getName().equals(path.lastSegment())) continue;
            doit = false;
            break;
        }
        if (doit) {
            this.importTrace(traceFolder.getResource(), path);
            return true;
        }
        return false;
    }

    private void importTrace(IFolder resource, Path path) {
        IPath containerPath = resource.getFullPath();
        File file = new File(path.toString());
        File source = file.getParentFile();
        IOverwriteQuery overwriteImplementor = new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                return "NOALL";
            }
        };
        LinkedList<File> filesToImport = new LinkedList<File>();
        filesToImport.add(file);
        ImportOperation operation = new ImportOperation(containerPath, (Object)source, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overwriteImplementor, filesToImport);
        operation.setCreateContainerStructure(false);
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            this.displayException(e);
        }
        catch (InterruptedException e) {
            this.displayException(e);
        }
    }

    private void createLink(IFolder parentFolder, IResource resource) {
        IPath location = resource.getLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            Map properties = resource.getPersistentProperties();
            String bundleName = (String)properties.get(TmfCommonConstants.TRACEBUNDLE);
            String traceType = (String)properties.get(TmfCommonConstants.TRACETYPE);
            String iconUrl = (String)properties.get(TmfCommonConstants.TRACEICON);
            String supplFolder = (String)properties.get(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
            if (resource instanceof IFolder) {
                IFolder folder = parentFolder.getFolder(resource.getName());
                if (workspace.validateLinkLocation((IResource)folder, location).isOK()) {
                    folder.createLink(location, 256, null);
                    this.setProperties((IResource)folder, bundleName, traceType, iconUrl, supplFolder);
                } else {
                    TmfUiPlugin.getDefault().logError("Invalid Trace Location");
                }
            } else {
                IFile file = parentFolder.getFile(resource.getName());
                if (workspace.validateLinkLocation((IResource)file, location).isOK()) {
                    file.createLink(location, 256, null);
                    this.setProperties((IResource)file, bundleName, traceType, iconUrl, supplFolder);
                } else {
                    TmfUiPlugin.getDefault().logError("Invalid Trace Location");
                }
            }
        }
        catch (CoreException e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void cleanupBookmarks(IPath path) {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (folder.exists()) {
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (TmfTrace.class.getCanonicalName().equals(member.getPersistentProperty(TmfCommonConstants.TRACETYPE))) {
                        member.delete(true, null);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.displayException((Exception)((Object)e));
            }
        }
    }

    private void setProperties(IResource resource, String bundleName, String traceType, String iconUrl, String supplFolder) throws CoreException {
        resource.setPersistentProperty(TmfCommonConstants.TRACEBUNDLE, bundleName);
        resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceType);
        resource.setPersistentProperty(TmfCommonConstants.TRACEICON, iconUrl);
        resource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder);
    }

    private void displayException(Exception e) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(e.getClass().getName());
        mb.setMessage(e.getMessage());
        mb.open();
    }
}

