/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;

public class PagesDialog
extends Dialog {
    protected ISDAdvancedPagingProvider fProvider = null;
    protected TextArea fCurrentPage;
    protected Label fTotalPageComment;

    public PagesDialog(IViewPart view, ISDAdvancedPagingProvider provider) {
        super(view.getSite().getShell());
        this.fProvider = provider;
        this.setShellStyle(67680);
    }

    public Control createDialogArea(Composite parent) {
        Group ret = new Group(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        ret.setLayoutData((Object)data);
        ret.setText(SDMessages._67);
        FillLayout fillLayout = new FillLayout(512);
        ret.setLayout((Layout)fillLayout);
        Label label = new Label((Composite)ret, 0);
        label.setText(SDMessages._75);
        this.fCurrentPage = new TextArea((Composite)ret);
        this.fCurrentPage.setBounds(1, this.fProvider.pagesCount());
        this.fCurrentPage.setValue(this.fProvider.currentPage() + 1);
        this.fTotalPageComment = new Label((Composite)ret, 0);
        this.fTotalPageComment.setAlignment(131072);
        this.updateComments();
        this.getShell().setText(SDMessages._68);
        return ret;
    }

    public void okPressed() {
        int currentPageValue = this.fCurrentPage.getValue() - 1;
        super.close();
        this.fProvider.pageNumberChanged(currentPageValue);
    }

    protected void updateComments() {
        int pages = Math.max(0, this.fProvider.pagesCount());
        StringBuffer totalPageCommentText = new StringBuffer();
        totalPageCommentText.append(SDMessages._70);
        totalPageCommentText.append(pages);
        totalPageCommentText.append(" ");
        if (pages == 0) {
            totalPageCommentText.append(SDMessages._71);
        } else if (pages == 1) {
            totalPageCommentText.append(SDMessages._72);
        } else {
            totalPageCommentText.append(SDMessages._73);
        }
        this.fTotalPageComment.setText(totalPageCommentText.toString());
    }

    protected static class TextArea {
        protected Text fText;
        int fMin;
        int fMax;

        public TextArea(Composite parent) {
            this.fText = new Text(parent, 133124);
            this.fText.setTextLimit(10);
        }

        public void setValue(int page) {
            int value = Math.max(this.fMin, Math.min(this.fMax, page));
            this.fText.setText(Integer.toString(value));
        }

        public int getValue() {
            int res;
            try {
                res = Integer.parseInt(this.fText.getText());
            }
            catch (Exception exception) {
                res = 0;
            }
            return Math.max(this.fMin, Math.min(this.fMax, res));
        }

        public void setBounds(int min, int max) {
            this.fMin = Math.max(0, min);
            this.fMax = Math.max(this.fMin, max);
            Object[] tab = new Integer[]{this.fMin, this.fMax};
            this.fText.setToolTipText(MessageFormat.format(SDMessages._69, tab));
        }
    }
}

