/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.hidden;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.FunctionBrowserView;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.KernelBrowserView;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.ProbeAliasBrowserView;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeExpandCollapseAction
extends Action
implements ISelectionListener,
ActionFactory.IWorkbenchAction {
    private final IWorkbenchWindow fWindow;
    private IStructuredSelection selection;
    private final Class<?> cl;

    public TreeExpandCollapseAction(Class<?> cls) {
        LogManager.logDebug((String)("Start TreeExpandCollapseAction: cls-" + cls), (Object)((Object)this));
        this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.fWindow.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.cl = cls;
        LogManager.logDebug((String)"End TreeExpandCollapseAction:", (Object)((Object)this));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        LogManager.logDebug((String)("Start selectionChanged: part-" + part + ", incoming-" + incoming), (Object)((Object)this));
        if (incoming instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            this.setEnabled(false);
        }
        LogManager.logDebug((String)"End selectionChanged:", (Object)((Object)this));
    }

    public void dispose() {
        LogManager.logDebug((String)"Start dispose:", (Object)((Object)this));
        this.fWindow.getSelectionService().removeSelectionListener((ISelectionListener)this);
        LogManager.logDebug((String)"End dispose:", (Object)((Object)this));
    }

    public void run() {
        LogManager.logDebug((String)"Start run:", (Object)((Object)this));
        if (!(this.cl.equals(FunctionBrowserView.class) || this.cl.equals(ProbeAliasBrowserView.class) || this.cl.equals(KernelBrowserView.class))) {
            LogManager.logDebug((String)"End run:", (Object)((Object)this));
            return;
        }
        IViewReference[] references = this.fWindow.getActivePage().getViewReferences();
        IViewPart part = null;
        boolean found = false;
        int i = 0;
        while (i < references.length) {
            part = references[i].getView(false);
            if (part != null && part.getClass().equals(this.cl)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            LogManager.logDebug((String)"End run:", (Object)((Object)this));
            return;
        }
        if (part == null) {
            LogManager.logDebug((String)"End run:", (Object)((Object)this));
            return;
        }
        BrowserView viewer = (BrowserView)part;
        ISelection incoming = viewer.getViewer().getSelection();
        IStructuredSelection selection = (IStructuredSelection)incoming;
        Object o = selection.getFirstElement();
        if (o == null) {
            LogManager.logDebug((String)"End run:", (Object)((Object)this));
            return;
        }
        Object[] objs = viewer.getViewer().getVisibleExpandedElements();
        boolean doExpand = true;
        int i2 = 0;
        while (i2 < objs.length) {
            if (objs[i2] == o) {
                doExpand = false;
            }
            ++i2;
        }
        if (doExpand) {
            viewer.getViewer().expandToLevel(o, 1);
        } else {
            viewer.getViewer().collapseToLevel(o, 1);
        }
        LogManager.logDebug((String)"End run:", (Object)((Object)this));
    }
}

