/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.actions;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.uistructures.StapSettingsDialog;
import org.eclipse.linuxtools.systemtap.ui.ide.actions.RunScriptAction;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunScriptOptionsAction
extends RunScriptAction
implements IWorkbenchWindowActionDelegate {
    public RunScriptOptionsAction() {
        LogManager.logDebug((String)"initialized", (Object)((Object)this));
    }

    @Override
    protected String[] buildScript() {
        return this.buildOptionsScript();
    }

    protected String[] buildOptionsScript() {
        ArrayList<String> cmdList = new ArrayList<String>();
        this.getImportedTapsets(cmdList);
        if (this.isGuru()) {
            cmdList.add("-g");
        }
        this.getCommandLineOptions(cmdList);
        String[] script = this.finalizeScript(cmdList);
        return script;
    }

    protected void getCommandLineOptions(ArrayList<String> cmdList) {
        StapSettingsDialog ssd = new StapSettingsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        ssd.open();
        boolean[] cmdOpts = ssd.getStapOpts();
        String[] cmdOptVals = ssd.getStapOptVals();
        if (cmdOpts != null && cmdOptVals != null) {
            int i = 0;
            while (i < cmdOpts.length) {
                if (cmdOpts[i]) {
                    cmdList.add(IDEPreferenceConstants.P_STAP[i][0]);
                }
                ++i;
            }
            i = 0;
            while (i < cmdOptVals.length) {
                if (cmdOptVals[i] != null && cmdOptVals[i].trim().length() > 0) {
                    if ("-v".equals(IDEPreferenceConstants.P_STAP[i + cmdOpts.length][0])) {
                        cmdList.add("-" + cmdOptVals[i]);
                    } else if ("-p NUM".equals(IDEPreferenceConstants.P_STAP[i + cmdOpts.length][0])) {
                        cmdList.add("-p" + cmdOptVals[i]);
                    } else {
                        cmdList.add(IDEPreferenceConstants.P_STAP[i + cmdOpts.length][0].substring(0, 2));
                        cmdList.add(cmdOptVals[i - cmdOpts.length]);
                    }
                }
                ++i;
            }
        } else {
            this.continueRun = false;
        }
    }
}

