/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTraceReader;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketReader;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInputReader {
    private final StreamInput streamInput;
    private final StreamInputPacketReader packetReader;
    private int packetIndex;
    private EventDefinition currentEvent = null;
    private int name;
    private CTFTraceReader parent;
    private final long prevIndex;

    public StreamInputReader(StreamInput streamInput) {
        this.streamInput = streamInput;
        this.packetReader = new StreamInputPacketReader(this);
        this.packetIndex = 0;
        this.prevIndex = 0L;
        this.goToNextPacket();
    }

    public EventDefinition getCurrentEvent() {
        return this.currentEvent;
    }

    public StructDefinition getCurrentPacketContext() {
        return this.packetReader.getStreamPacketContextDef();
    }

    public ByteOrder getByteOrder() {
        return this.streamInput.getStream().getTrace().getByteOrder();
    }

    public int getName() {
        return this.name;
    }

    public void setName(int name) {
        this.name = name;
    }

    public int getCPU() {
        return this.packetReader.getCPU();
    }

    public String getFilename() {
        return this.streamInput.getFilename();
    }

    StreamInput getStreamInput() {
        return this.streamInput;
    }

    public boolean readNextEvent() {
        StreamInputPacketIndexEntry prevPacket;
        if (!this.packetReader.hasMoreEvents() && (prevPacket = this.packetReader.getCurrentPacket()) != null) {
            this.goToNextPacket();
            this.packetReader.getCurrentPacket();
        }
        if (this.packetReader.hasMoreEvents()) {
            try {
                this.setCurrentEvent(this.packetReader.readNextEvent());
            }
            catch (CTFReaderException cTFReaderException) {
                return false;
            }
            return true;
        }
        this.setCurrentEvent(null);
        return false;
    }

    private void goToNextPacket() {
        ++this.packetIndex;
        if (this.getPacketSize() >= this.packetIndex + 1) {
            this.packetReader.setCurrentPacket(this.getPacket());
        } else {
            try {
                if (this.streamInput.addPacketHeaderIndex()) {
                    this.packetIndex = this.getPacketSize() - 1;
                    this.packetReader.setCurrentPacket(this.getPacket());
                } else {
                    this.packetReader.setCurrentPacket(null);
                }
            }
            catch (CTFReaderException cTFReaderException) {
                this.packetReader.setCurrentPacket(null);
            }
        }
    }

    private int getPacketSize() {
        return this.streamInput.getIndex().getEntries().size();
    }

    public long seek(long timestamp) {
        long offset = 0L;
        this.packetIndex = this.streamInput.getIndex().search(timestamp).previousIndex();
        this.goToNextPacket();
        while (this.packetReader.getCurrentPacket() != null && this.packetReader.getCurrentPacket().getTimestampEnd() < timestamp) {
            try {
                this.streamInput.addPacketHeaderIndex();
                this.goToNextPacket();
            }
            catch (CTFReaderException cTFReaderException) {}
        }
        this.readNextEvent();
        boolean done = this.getCurrentEvent() == null;
        while (!done && this.getCurrentEvent().getTimestamp() < timestamp) {
            this.readNextEvent();
            done = this.getCurrentEvent() == null;
            ++offset;
        }
        return offset;
    }

    public void goToLastEvent() {
        int len = this.streamInput.getIndex().getEntries().size();
        this.seek(0L);
        if (len == 0 || !this.packetReader.hasMoreEvents()) {
            return;
        }
        int pos = len - 1;
        while (pos > 0) {
            this.packetIndex = pos--;
            this.packetReader.setCurrentPacket(this.getPacket());
            if (this.packetReader.hasMoreEvents()) break;
        }
        EventDefinition prevEvent = null;
        while (this.currentEvent != null) {
            prevEvent = this.currentEvent;
            this.readNextEvent();
        }
        this.setCurrentEvent(prevEvent);
    }

    public CTFTraceReader getParent() {
        return this.parent;
    }

    public void setParent(CTFTraceReader parent) {
        this.parent = parent;
    }

    public void setCurrentEvent(EventDefinition currentEvent) {
        this.currentEvent = currentEvent;
    }

    private int getPacketIndex() {
        return this.packetIndex;
    }

    private StreamInputPacketIndexEntry getPacket() {
        return this.streamInput.getIndex().getEntries().get(this.getPacketIndex());
    }

    public StreamInputPacketReader getPacketReader() {
        return this.packetReader;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name;
        result = 31 * result + (this.streamInput == null ? 0 : this.streamInput.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInputReader)) {
            return false;
        }
        StreamInputReader other = (StreamInputReader)obj;
        if (this.name != other.name) {
            return false;
        }
        return !(this.streamInput == null ? other.streamInput != null : !this.streamInput.equals(other.streamInput));
    }
}

