/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.CommandResult;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandResult;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.IRemoteSystemProxy;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public class CommandShell
implements ICommandShell {
    public static final String DONE_MARKUP_STRING = "--RSE:donedonedone:--";
    public static final String CMD_DELIMITER = "\n";
    public static final String SHELL_ECHO_CMD = " echo ";
    private static final int DEFAULT_TIMEOUT_VALUE = 15000;
    private IRemoteSystemProxy fProxy = null;
    private IHostShell fHostShell = null;
    private BufferedReader fBufferReader = null;
    private ExecutorService fExecutor = Executors.newFixedThreadPool(1);
    private boolean fIsConnected = false;

    public CommandShell(IRemoteSystemProxy proxy) {
        this.fProxy = proxy;
    }

    @Override
    public void connect() throws ExecutionException {
        IShellService shellService = this.fProxy.getShellService();
        HostShellProcessAdapter p = null;
        try {
            this.fHostShell = shellService.launchShell("", new String[0], (IProgressMonitor)new NullProgressMonitor());
            p = new HostShellProcessAdapter(this.fHostShell);
        }
        catch (Exception e) {
            throw new ExecutionException(Messages.TraceControl_CommandShellError, (Throwable)e);
        }
        this.fBufferReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        this.fIsConnected = true;
        this.executeCommand(" ", (IProgressMonitor)new NullProgressMonitor(), false);
    }

    @Override
    public void disconnect() {
        this.fIsConnected = false;
        try {
            this.fBufferReader.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public ICommandResult executeCommand(String command, IProgressMonitor monitor) throws ExecutionException {
        return this.executeCommand(command, monitor, true);
    }

    @Override
    public ICommandResult executeCommand(final String command, final IProgressMonitor monitor, final boolean checkReturnValue) throws ExecutionException {
        if (this.fIsConnected) {
            FutureTask<CommandResult> future = new FutureTask<CommandResult>(new Callable<CommandResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public CommandResult call() throws IOException, CancellationException {
                    ArrayList<String> result = new ArrayList<String>();
                    int returnValue = 0;
                    IHostShell iHostShell = CommandShell.this.fHostShell;
                    synchronized (iHostShell) {
                        String nextLine;
                        CommandShell.this.fHostShell.writeToShell(CommandShell.this.formatShellCommand(command));
                        while ((nextLine = CommandShell.this.fBufferReader.readLine()) != null) {
                            if (monitor.isCanceled()) {
                                CommandShell.this.flushInput();
                                throw new CancellationException();
                            }
                            if (nextLine.contains(CommandShell.DONE_MARKUP_STRING) && nextLine.contains(CommandShell.SHELL_ECHO_CMD)) break;
                        }
                        while ((nextLine = CommandShell.this.fBufferReader.readLine()) != null) {
                            if (monitor.isCanceled()) {
                                CommandShell.this.flushInput();
                                throw new CancellationException();
                            }
                            if (!nextLine.contains(CommandShell.DONE_MARKUP_STRING)) {
                                result.add(nextLine);
                                continue;
                            }
                            if (!checkReturnValue) break;
                            returnValue = Integer.valueOf(nextLine.substring(CommandShell.DONE_MARKUP_STRING.length() + 1));
                            break;
                        }
                        CommandShell.this.flushInput();
                    }
                    return new CommandResult(returnValue, result.toArray(new String[result.size()]));
                }
            });
            this.fExecutor.execute(future);
            try {
                return future.get(15000L, TimeUnit.MILLISECONDS);
            }
            catch (java.util.concurrent.ExecutionException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionFailure, (Throwable)ex);
            }
            catch (InterruptedException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionCancelled, (Throwable)ex);
            }
            catch (TimeoutException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionTimeout, (Throwable)ex);
            }
        }
        throw new ExecutionException(Messages.TraceControl_ShellNotConnected, null);
    }

    private void flushInput() throws IOException {
        char[] cbuf = new char[1];
        while (this.fBufferReader.ready()) {
            if (this.fBufferReader.read(cbuf, 0, 1) == -1) break;
        }
    }

    private String formatShellCommand(String cmd) {
        if (cmd == null || cmd.equals("")) {
            return cmd;
        }
        StringBuffer formattedCommand = new StringBuffer();
        formattedCommand.append(cmd).append("\\\r;");
        formattedCommand.append(SHELL_ECHO_CMD).append(DONE_MARKUP_STRING);
        formattedCommand.append(" $?");
        formattedCommand.append(CMD_DELIMITER);
        return formattedCommand.toString();
    }
}

