/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.dialog;

import java.io.File;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OpenGCDialog
extends Dialog {
    private Text binText;
    private String binValue;
    private Button openThisFileOnlyButton;
    private Button openCoverageSummaryButton;
    private boolean openCoverageSummary = true;
    private Button binBrowseWorkspaceButton;
    private Button binBrowseFileSystemButton;
    private Label errorLabel;
    private boolean binaryValid;
    private final BinaryModifyListener binModifyListener = new BinaryModifyListener();
    private final String defaultValue;
    private final IPath gcFile;

    public OpenGCDialog(Shell parentShell, String binPath, IPath gcFile) {
        super(parentShell);
        this.gcFile = gcFile;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.defaultValue = binPath;
    }

    public String getBinaryFile() {
        return this.binValue;
    }

    public boolean isCompleteCoverageResultWanted() {
        return this.openCoverageSummary;
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        this.validateBinary();
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Gcov - Open coverage results...");
        Composite composite = (Composite)super.createDialogArea(parent);
        Group c = new Group(composite, 0);
        c.setText("Binary File");
        c.setToolTipText("Please enter here the binary file which produced the coverage data.");
        GridLayout layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        c.setLayoutData((Object)data);
        Label binLabel = new Label((Composite)c, 0);
        binLabel.setText("Please enter here the binary file which produced the coverage data.");
        data = new GridData();
        data.horizontalSpan = 2;
        binLabel.setLayoutData((Object)data);
        this.binText = new Text((Composite)c, 2048);
        this.binText.setText(this.defaultValue);
        data = new GridData(768);
        data.widthHint = 200;
        this.binText.setLayoutData((Object)data);
        this.binText.addModifyListener((ModifyListener)this.binModifyListener);
        Composite cbBin = new Composite((Composite)c, 0);
        data = new GridData(128);
        cbBin.setLayoutData((Object)data);
        cbBin.setLayout((Layout)new GridLayout(2, true));
        this.binBrowseWorkspaceButton = new Button(cbBin, 8);
        this.binBrowseWorkspaceButton.setText("&Workspace...");
        this.binBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGCDialog.this.handleBrowseWorkspace("Open Binary file...", OpenGCDialog.this.binText);
            }
        });
        this.binBrowseFileSystemButton = new Button(cbBin, 8);
        this.binBrowseFileSystemButton.setText("&File System...");
        this.binBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGCDialog.this.handleBrowse("Open Binary file...", OpenGCDialog.this.binText);
            }
        });
        Group covMode = new Group(composite, 0);
        covMode.setText("Coverage result");
        covMode.setToolTipText("Please choose the result scope.");
        GridData covModeData = new GridData(1808);
        covMode.setLayoutData((Object)covModeData);
        covMode.setLayout((Layout)new GridLayout());
        this.openThisFileOnlyButton = new Button((Composite)covMode, 16);
        this.openThisFileOnlyButton.setLayoutData((Object)new GridData());
        this.openCoverageSummaryButton = new Button((Composite)covMode, 16);
        this.openCoverageSummaryButton.setLayoutData((Object)new GridData());
        String cFile = String.valueOf(this.gcFile.removeFileExtension().lastSegment()) + ".c";
        this.openThisFileOnlyButton.setText("Show coverage details for \"" + cFile + "\" only.");
        this.openCoverageSummaryButton.setText("Show coverage for the whole selected binary file");
        this.openCoverageSummaryButton.setSelection(true);
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGCDialog.this.openCoverageSummary = OpenGCDialog.this.openCoverageSummaryButton.getSelection();
            }
        };
        this.openCoverageSummaryButton.addSelectionListener((SelectionListener)sa);
        this.openThisFileOnlyButton.addSelectionListener((SelectionListener)sa);
        this.errorLabel = new Label(composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.errorLabel.setLayoutData((Object)data);
        this.errorLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        c.layout();
        return composite;
    }

    private void validateBinary() {
        this.binValue = this.binText.getText();
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            this.binValue = mgr.performStringSubstitution(this.binValue, false);
        }
        catch (CoreException coreException) {}
        File f = new File(this.binValue);
        if (f.exists()) {
            IBinaryParser.IBinaryObject binary = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(this.binValue));
            if (binary == null) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Invalid binary file", (String)(String.valueOf(this.binText.getText()) + " is not a valid binary file."));
                return;
            }
        } else {
            this.binaryValid = false;
            this.getButton(0).setEnabled(false);
            if (!this.binValue.equals("")) {
                this.errorLabel.setText("\"" + this.binText.getText() + "\" doesn't exist");
            } else {
                this.errorLabel.setText("Please enter a binary file");
            }
            return;
        }
        this.binaryValid = true;
        this.getButton(0).setEnabled(this.binaryValid);
        this.errorLabel.setText("");
    }

    protected void handleBrowseWorkspace(String msg, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(msg);
        dialog.setMessage(msg);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(false);
        IContainer c = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.gcFile);
        if (c != null) {
            dialog.setInitialSelection((Object)c.getProject());
        }
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1) {
                    return new Status(4, "org.eclipse.linuxtools.gcov.core", 0, "", null);
                }
                if (!(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.linuxtools.gcov.core", 0, "", null);
                }
                return new Status(0, "org.eclipse.linuxtools.gcov.core", 0, "", null);
            }
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            text.setText("${resource_loc:" + resource.getFullPath() + "}");
        }
    }

    protected void handleBrowse(String msg, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(msg);
        String t = text.getText();
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            t = mgr.performStringSubstitution(t, false);
        }
        catch (CoreException coreException) {}
        File f = new File(t);
        t = f.getParent();
        if (t == null || t.length() == 0) {
            t = this.gcFile.removeLastSegments(1).toOSString();
        }
        dialog.setFilterPath(t);
        String s = dialog.open();
        if (s != null) {
            text.setText(s);
        }
    }

    private class BinaryModifyListener
    implements ModifyListener {
        private BinaryModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            OpenGCDialog.this.validateBinary();
        }
    }
}

