/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis;

import java.util.Map;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TraceColorScheme;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class TmfTimeAnalysisProvider {
    public static final int IMG_THREAD_RUNNING = 0;
    public static final int IMG_THREAD_SUSPENDED = 1;
    public static final int IMG_THREAD_STOPPED = 2;
    public static final int IMG_METHOD_RUNNING = 3;
    public static final int IMG_METHOD = 4;
    public static final int IMG_NUM = 5;

    public void drawState(TraceColorScheme colors, ITimeEvent event, Rectangle rect, GC gc, boolean selected, boolean rectBound, boolean timeSelected) {
        int colorIdx = this.getEventColorVal(event);
        this.drawState(colors, colorIdx, rect, gc, selected, rectBound, timeSelected);
    }

    public void drawState(TraceColorScheme colors, int colorIdx, Rectangle rect, GC gc, boolean selected, boolean rectBound, boolean timeSelected) {
        boolean visible = rect.width != 0;
        int colorIdx1 = colorIdx;
        boolean bl = timeSelected = timeSelected && selected;
        if (timeSelected) {
            colorIdx1 = colorIdx + 16 - 0;
        }
        if (visible) {
            if (rect.isEmpty()) {
                return;
            }
            gc.setBackground(colors.getColor(colorIdx1));
            gc.fillRectangle(rect);
            colorIdx1 = colorIdx + 45 - 0;
            gc.setForeground(colors.getColor(colorIdx1));
            if (!timeSelected) {
                if (rectBound && rect.width >= 3) {
                    gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
                } else {
                    gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                }
            }
        } else {
            int width;
            rect.width = width = 2;
            if (rect.isEmpty()) {
                return;
            }
            gc.setForeground(colors.getColor(colorIdx));
            int s = gc.getLineStyle();
            int w = gc.getLineWidth();
            gc.setLineStyle(3);
            gc.setLineWidth(width);
            gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
            gc.setLineStyle(s);
            gc.setLineWidth(w);
        }
    }

    public int getEventColorVal(ITimeEvent event) {
        StateColor colors = this.getEventColor(event);
        if (colors == StateColor.GREEN) {
            return 1;
        }
        if (colors == StateColor.DARK_BLUE) {
            return 2;
        }
        if (colors == StateColor.RED) {
            return 5;
        }
        if (colors == StateColor.GOLD) {
            return 4;
        }
        if (colors == StateColor.ORANGE) {
            return 3;
        }
        if (colors == StateColor.GRAY) {
            return 6;
        }
        if (colors == StateColor.DARK_GREEN) {
            return 7;
        }
        if (colors == StateColor.DARK_YELLOW) {
            return 8;
        }
        if (colors == StateColor.MAGENTA3) {
            return 9;
        }
        if (colors == StateColor.PURPLE1) {
            return 10;
        }
        if (colors == StateColor.PINK1) {
            return 11;
        }
        if (colors == StateColor.AQUAMARINE) {
            return 12;
        }
        if (colors == StateColor.LIGHT_BLUE) {
            return 13;
        }
        if (colors == StateColor.CADET_BLUE) {
            return 30;
        }
        if (colors == StateColor.OLIVE) {
            return 15;
        }
        return 0;
    }

    public abstract StateColor getEventColor(ITimeEvent var1);

    public abstract String getTraceClassName(ITmfTimeAnalysisEntry var1);

    public String getEventName(ITimeEvent event) {
        return this.getEventName(event, true, false);
    }

    public abstract String getEventName(ITimeEvent var1, boolean var2, boolean var3);

    public String composeTraceName(ITmfTimeAnalysisEntry trace, boolean inclState) {
        String name = trace.getName();
        String threadClass = this.getTraceClassName(trace);
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        return name;
    }

    public String composeEventName(ITimeEvent event) {
        String name = event.getEntry().getName();
        String threadClass = this.getTraceClassName(event.getEntry());
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        name = String.valueOf(name) + " (" + this.getEventName(event, false, true) + ")";
        return name;
    }

    public abstract Map<String, String> getEventHoverToolTipInfo(ITimeEvent var1);

    public Image getItemImage(Object obj) {
        return null;
    }

    public abstract String getStateName(StateColor var1);

    public static enum StateColor {
        GREEN,
        DARK_BLUE,
        RED,
        GOLD,
        ORANGE,
        GRAY,
        BLACK,
        DARK_GREEN,
        DARK_YELLOW,
        MAGENTA3,
        PURPLE1,
        PINK1,
        AQUAMARINE,
        LIGHT_BLUE,
        CADET_BLUE,
        OLIVE;

        private String stateName;

        private StateColor() {
            String undef;
            this.stateName = undef = "Undefined";
        }

        public String getStateName() {
            return this.stateName;
        }

        public void setStateName(String stateName) {
            this.stateName = stateName;
        }
    }
}

