/*******************************************************************************
 * Copyright (c) 2005-2008 Polarion Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Alexander Gurov - Initial API and implementation
 *******************************************************************************/

package org.eclipse.team.svn.ui.verifier;

import java.util.StringTokenizer;

import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.ui.SVNUIMessages;

/**
 * Allows only absolute paths
 * 
 * @author Alexander Gurov
 */
public class AbsolutePathVerifier extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE;
        
    public AbsolutePathVerifier(String fieldName) {
        super(fieldName);
        AbsolutePathVerifier.ERROR_MESSAGE = SVNUIMessages.format(SVNUIMessages.Verifier_AbsolutePath, new String[] {AbstractFormattedVerifier.FIELD_NAME});
    }
    
    protected String getErrorMessageImpl(Control input) {
        String text = this.getText(input);
        if (this.isRealtive(text)) {
            return AbsolutePathVerifier.ERROR_MESSAGE;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    protected boolean isRealtive(String path) {
    	StringTokenizer tok = new StringTokenizer(path, "/\\", false); //$NON-NLS-1$
    	while (tok.hasMoreTokens()) {
    		String token = tok.nextToken();
    		if (token.matches("(\\.)+")) { //$NON-NLS-1$
    			return true;
    		}
    	}
    	return false;
    }
}
