/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.pde.build;

import java.util.Properties;

public interface IMapFileParser {
    public static final IMapFileParser DEFAULT = new IMapFileParser(){

        public FetchData parse(String rawEntry, String[] arguments, Properties overrideTags) {
            String overrideTag;
            FetchData data = new FetchData();
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                int idx = argument.indexOf("=");
                if (idx != -1) {
                    String key = argument.substring(0, idx);
                    String value = argument.substring(idx + 1);
                    if ("url".equals(key)) {
                        data.url = value;
                    } else if ("tag".equals(key)) {
                        data.tag = value;
                    } else if ("path".equals(key)) {
                        data.path = value;
                    } else if ("revision".equals(key)) {
                        data.revision = value;
                    } else if ("peg".equals(key)) {
                        data.peg = value;
                    } else if ("username".equals(key)) {
                        data.username = value;
                    } else if ("password".equals(key)) {
                        data.password = value;
                    } else if ("force".equals(key)) {
                        data.force = value;
                    }
                }
                ++n2;
            }
            if (overrideTags != null && (overrideTag = overrideTags.getProperty("SVN")) != null && overrideTag.length() > 0) {
                data.tag = overrideTag;
            }
            return data;
        }
    };
    public static final IMapFileParser SOURCE_FORGE_PARSER = new IMapFileParser(){
        public static final String HEAD = "HEAD";
        public static final String TRUNK = "trunk";

        public FetchData parse(String rawEntry, String[] arguments, Properties overrideTags) {
            String preTagPath;
            FetchData data = new FetchData();
            if (arguments.length < 2) {
                throw new RuntimeException("Incorrect map file entry format, arguments munber should be more than 2. Entry: " + rawEntry);
            }
            data.url = arguments[1];
            String string = preTagPath = arguments.length > 2 && !arguments[2].equals("") ? arguments[2] : null;
            if (preTagPath != null) {
                data.url = String.valueOf(data.url) + "/" + preTagPath;
            }
            data.path = arguments.length > 3 && !arguments[3].equals("") ? arguments[3] : null;
            String tagText = this.getTagText(overrideTags, arguments);
            data.tag = this.getSvnTag(tagText);
            data.peg = data.revision = this.getRevision(tagText);
            data.username = "";
            data.password = "";
            data.force = "true";
            return data;
        }

        protected String getSvnTag(String tagText) {
            String string;
            int index = tagText.indexOf(":");
            String string2 = string = index > 0 ? tagText.substring(0, index) : tagText;
            if (HEAD.equals(string) || TRUNK.equals(string)) {
                return TRUNK;
            }
            return string;
        }

        protected String getRevision(String tagText) {
            int index = tagText.indexOf(":");
            return index > 0 ? tagText.substring(index + 1) : HEAD;
        }

        protected String getTagText(Properties overrideTags, String[] arguments) {
            String overrideTag = overrideTags.getProperty("SVN");
            return overrideTag != null && overrideTag.length() != 0 ? overrideTag : arguments[0];
        }
    };

    public FetchData parse(String var1, String[] var2, Properties var3);

    public static class FetchData {
        public String url;
        public String tag;
        public String path;
        public String revision;
        public String peg;
        public String username;
        public String password;
        public String force;
    }
}

