/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text.pattern.internal.naming;

import java.util.Arrays;

public class Path {
    private final String[] components;
    private final int offset;

    public Path(String ... components) {
        this.components = components;
        this.offset = 0;
    }

    private Path(String[] components, int offset) {
        this.components = components;
        this.offset = offset;
    }

    public int size() {
        return this.components.length - this.offset;
    }

    public String component(int i) {
        return this.components[this.offset + i];
    }

    public String head() {
        return this.component(0);
    }

    public Path tail() {
        return new Path(this.components, this.offset + 1);
    }

    public int hashCode() {
        return this.offset ^ Arrays.hashCode(this.components);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.component(i).equals(other.component(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String component : this.components) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(component);
        }
        return builder.toString();
    }

    public static Path parse(String pathAsString) {
        return new Path(pathAsString.split("\\."));
    }
}

