/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class SingleListSelectionRule
extends GenerationRule {
    private List list;
    private String newSelectionText = null;

    public boolean appliesTo(Event event) {
        return event.widget instanceof List && event.type == 13 && (((List)event.widget).getStyle() & 4) != 0;
    }

    public void initializeForEvent(Event event) {
        this.list = (List)event.widget;
        if (this.list.getSelectionCount() > 0) {
            this.newSelectionText = this.list.getSelection()[0];
        }
    }

    protected String getWidgetAccessor() {
        int index = WidgetUtils.getIndex((Control)this.list);
        if (index != 0) {
            return "bot.list(" + index + ")";
        }
        return "bot.list()";
    }

    protected String getActon() {
        StringBuilder res = new StringBuilder();
        if (this.newSelectionText != null) {
            res.append(".select(\"");
            res.append(this.newSelectionText);
            res.append("\")");
        } else {
            res.append(".unselect()");
        }
        return res.toString();
    }
}

