/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.jdt.editor.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swtbot.generator.framework.AnnotationRule;
import org.eclipse.swtbot.generator.jdt.editor.document.ClassDocument;
import org.eclipse.swtbot.generator.jdt.editor.listener.AbstractAnnotationSelectionListener;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAnnotationSelectionListener
extends AbstractAnnotationSelectionListener {
    public ClassAnnotationSelectionListener(ToolItem dropdown, BotGeneratorEventDispatcher recorder, Map<CTabItem, SourceViewer> tabViewer, CTabFolder classTabFolder) {
        super(dropdown, recorder, tabViewer, classTabFolder);
    }

    @Override
    protected List<AnnotationRule> filterRules(List<AnnotationRule> items) {
        ArrayList<AnnotationRule> classAnnotations = new ArrayList<AnnotationRule>();
        for (AnnotationRule item : items) {
            if (!item.isClassAnnotation()) continue;
            classAnnotations.add(item);
        }
        return classAnnotations;
    }

    @Override
    protected SelectionAdapter getSelectionAdapter(final MenuItem menuItem) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem selected = (MenuItem)event.widget;
                SourceViewer viewer = (SourceViewer)ClassAnnotationSelectionListener.this.tabViewer.get(ClassAnnotationSelectionListener.this.classTabFolder.getSelection());
                ClassDocument doc = (ClassDocument)viewer.getDocument();
                if (selected.getSelection()) {
                    doc.addClassAnnotation((AnnotationRule)menuItem.getData());
                } else {
                    doc.removeClassAnnotation((AnnotationRule)menuItem.getData());
                }
                ClassAnnotationSelectionListener.this.update();
            }
        };
    }

    @Override
    protected boolean checkDocAnnotation(ClassDocument doc, MenuItem i) {
        return doc.getClassAnnotations().contains(i.getData());
    }
}

