/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.nebula.nattable.finder.widgets;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.nebula.nattable.finder.finders.NatTableContextMenuFinder;
import org.eclipse.swtbot.swt.finder.ReferenceBy;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.hamcrest.SelfDescribing;

@SWTBotWidget(clasz=NatTable.class, preferredName="NatTable", referenceBy={ReferenceBy.LABEL})
public class SWTBotNatTable
extends AbstractSWTBot<NatTable> {
    public SWTBotNatTable(NatTable natTable) throws WidgetNotFoundException {
        this(natTable, null);
    }

    public SWTBotNatTable(NatTable natTable, SelfDescribing description) throws WidgetNotFoundException {
        super((Widget)natTable, description);
    }

    public int rowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getRowCount();
            }
        });
    }

    public int preferredRowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getPreferredRowCount();
            }
        });
    }

    public int columnCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getColumnCount();
            }
        });
    }

    public int preferredColumnCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getPreferredColumnCount();
            }
        });
    }

    public SWTBotNatTable click(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.waitForEnabled();
        this.setFocus();
        this.syncExec(new VoidResult(){

            public void run() {
                Rectangle cellBounds = ((NatTable)SWTBotNatTable.this.widget).getBoundsByPosition(column, row);
                SWTBotNatTable.this.clickXY(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
            }
        });
        return this;
    }

    public SWTBotNatTable doubleclick(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.setFocus();
        this.syncExec(new VoidResult(){

            public void run() {
                Rectangle cellBounds = ((NatTable)SWTBotNatTable.this.widget).getBoundsByPosition(column, row);
                SWTBotNatTable.this.doubleClickXY(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
            }
        });
        return this;
    }

    public SWTBotNatTable rightClick(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.setFocus();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Rectangle cellBounds = ((NatTable)SWTBotNatTable.this.widget).getBoundsByPosition(column, row);
                SWTBotNatTable.this.rightClick(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2, false);
            }
        });
        return this;
    }

    public SWTBotNatTable rightClick() {
        this.setFocus();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Rectangle widgetBounds = ((NatTable)SWTBotNatTable.this.widget).getBounds();
                SWTBotNatTable.this.rightClick(widgetBounds.width / 2, widgetBounds.height / 2, false);
            }
        });
        return this;
    }

    protected Rectangle widgetBounds() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((NatTable)SWTBotNatTable.this.widget).getBounds();
            }
        });
    }

    protected SWTBotRootMenu contextMenu(Control control) throws WidgetNotFoundException {
        this.waitForEnabled();
        Rectangle location = this.widgetBounds();
        return NatTableContextMenuFinder.contextMenu((Control)this.widget, location.width / 2, location.height / 2);
    }

    public SWTBotRootMenu contextMenu(int row, int column) throws WidgetNotFoundException {
        this.assertIsLegalCell(row, column);
        this.waitForEnabled();
        Rectangle location = ((NatTable)this.widget).getBoundsByPosition(column, row);
        return NatTableContextMenuFinder.contextMenu((Control)this.widget, location.x + location.width / 2, location.y + location.height / 2);
    }

    protected void assertIsLegalCell(int row, int column) {
        int rowCount = this.rowCount();
        int columnCount = this.columnCount();
        Assert.isLegal((row >= 0 ? 1 : 0) != 0);
        Assert.isLegal((column >= 0 ? 1 : 0) != 0);
        Assert.isLegal((row < rowCount ? 1 : 0) != 0, (Object)("The row number (" + row + ") is more than the number of visible rows (" + rowCount + ") in the table."));
        Assert.isLegal((column < columnCount || columnCount == 0 && column == 0 ? 1 : 0) != 0, (Object)("The column number (" + column + ") is more than the number of visible columns (" + columnCount + ") in the table."));
    }

    public String getCellDataValueByPosition(int row, int column) {
        this.assertIsLegalCell(row, column);
        Object obj = ((NatTable)this.widget).getDataValueByPosition(column, row);
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public void setCellDataValueByPosition(final int row, final int column, final String text) {
        this.assertIsLegalCell(row, column);
        Assert.isNotNull((Object)text);
        this.waitForEnabled();
        Assert.isTrue((!this.hasStyle(this.widget, 8) ? 1 : 0) != 0);
        this.asyncExec(new VoidResult(){

            public void run() {
                SWTBotNatTable.this.click(row, column);
                ICellEditor editor = ((NatTable)SWTBotNatTable.this.widget).getActiveCellEditor();
                editor.setEditorValue((Object)text);
            }
        });
        this.notify(24);
    }
}

