"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BreadcrumbsRendererFactory = exports.BreadcrumbsRenderer = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const widgets_1 = require("../widgets");
const breadcrumbs_service_1 = require("./breadcrumbs-service");
const breadcrumb_renderer_1 = require("./breadcrumb-renderer");
const perfect_scrollbar_1 = require("perfect-scrollbar");
const common_1 = require("../../common");
const disposable_1 = require("../../common/disposable");
const core_preferences_1 = require("../core-preferences");
const breadcrumbs_constants_1 = require("./breadcrumbs-constants");
const label_provider_1 = require("../label-provider");
let BreadcrumbsRenderer = class BreadcrumbsRenderer extends widgets_1.ReactRenderer {
    constructor() {
        super(...arguments);
        this.onDidChangeActiveStateEmitter = new common_1.Emitter();
        this.breadcrumbs = [];
        this.toDispose = new disposable_1.DisposableCollection();
        this.refreshCancellationMarker = { canceled: true };
        this.togglePopup = (breadcrumb, event) => {
            var _a;
            event.stopPropagation();
            event.preventDefault();
            let openPopup = true;
            if ((_a = this.popup) === null || _a === void 0 ? void 0 : _a.isOpen) {
                this.popup.dispose();
                // There is a popup open. If the popup is the popup that belongs to the currently clicked breadcrumb
                // just close the popup. If another breadcrumb was clicked, open the new popup immediately.
                openPopup = this.popup.breadcrumbId !== breadcrumb.id;
            }
            else {
                this.popup = undefined;
            }
            if (openPopup) {
                const { currentTarget } = event;
                const breadcrumbElement = currentTarget.closest(`.${breadcrumbs_constants_1.Styles.BREADCRUMB_ITEM}`);
                if (breadcrumbElement) {
                    const { left: x, bottom: y } = breadcrumbElement.getBoundingClientRect();
                    this.breadcrumbsService.openPopup(breadcrumb, { x, y }).then(popup => { this.popup = popup; });
                }
            }
        };
    }
    get onDidChangeActiveState() {
        return this.onDidChangeActiveStateEmitter.event;
    }
    get active() {
        return !!this.breadcrumbs.length;
    }
    get breadCrumbsContainer() {
        var _a;
        return (_a = this.host.firstElementChild) !== null && _a !== void 0 ? _a : undefined;
    }
    init() {
        this.toDispose.push(this.onDidChangeActiveStateEmitter);
        this.toDispose.push(this.breadcrumbsService.onDidChangeBreadcrumbs(uri => {
            var _a;
            if ((_a = this.uri) === null || _a === void 0 ? void 0 : _a.isEqual(uri)) {
                this.refresh(this.uri);
            }
        }));
        this.toDispose.push(this.corePreferences.onPreferenceChanged(change => {
            if (change.preferenceName === 'breadcrumbs.enabled') {
                this.refresh(this.uri);
            }
        }));
        this.toDispose.push(this.labelProvider.onDidChange(() => this.refresh(this.uri)));
    }
    dispose() {
        super.dispose();
        this.toDispose.dispose();
        if (this.popup) {
            this.popup.dispose();
        }
        if (this.scrollbar) {
            this.scrollbar.destroy();
            this.scrollbar = undefined;
        }
    }
    async refresh(uri) {
        this.uri = uri;
        this.refreshCancellationMarker.canceled = true;
        const currentCallCanceled = { canceled: false };
        this.refreshCancellationMarker = currentCallCanceled;
        let breadcrumbs;
        if (uri && this.corePreferences['breadcrumbs.enabled']) {
            breadcrumbs = await this.breadcrumbsService.getBreadcrumbs(uri);
        }
        else {
            breadcrumbs = [];
        }
        if (currentCallCanceled.canceled) {
            return;
        }
        const wasActive = this.active;
        this.breadcrumbs = breadcrumbs;
        const isActive = this.active;
        if (wasActive !== isActive) {
            this.onDidChangeActiveStateEmitter.fire(isActive);
        }
        this.update();
    }
    update() {
        this.render();
        if (!this.scrollbar) {
            this.createScrollbar();
        }
        else {
            this.scrollbar.update();
        }
        this.scrollToEnd();
    }
    createScrollbar() {
        const { breadCrumbsContainer } = this;
        if (breadCrumbsContainer) {
            this.scrollbar = new perfect_scrollbar_1.default(breadCrumbsContainer, {
                handlers: ['drag-thumb', 'keyboard', 'wheel', 'touch'],
                useBothWheelAxes: true,
                scrollXMarginOffset: 4,
                suppressScrollY: true
            });
        }
    }
    scrollToEnd() {
        const { breadCrumbsContainer } = this;
        if (breadCrumbsContainer) {
            breadCrumbsContainer.scrollLeft = breadCrumbsContainer.scrollWidth;
        }
    }
    doRender() {
        return React.createElement("ul", { className: breadcrumbs_constants_1.Styles.BREADCRUMBS }, this.renderBreadcrumbs());
    }
    renderBreadcrumbs() {
        return this.breadcrumbs.map(breadcrumb => this.breadcrumbRenderer.render(breadcrumb, this.togglePopup));
    }
};
__decorate([
    inversify_1.inject(breadcrumbs_service_1.BreadcrumbsService),
    __metadata("design:type", breadcrumbs_service_1.BreadcrumbsService)
], BreadcrumbsRenderer.prototype, "breadcrumbsService", void 0);
__decorate([
    inversify_1.inject(breadcrumb_renderer_1.BreadcrumbRenderer),
    __metadata("design:type", Object)
], BreadcrumbsRenderer.prototype, "breadcrumbRenderer", void 0);
__decorate([
    inversify_1.inject(core_preferences_1.CorePreferences),
    __metadata("design:type", Object)
], BreadcrumbsRenderer.prototype, "corePreferences", void 0);
__decorate([
    inversify_1.inject(label_provider_1.LabelProvider),
    __metadata("design:type", label_provider_1.LabelProvider)
], BreadcrumbsRenderer.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BreadcrumbsRenderer.prototype, "init", null);
BreadcrumbsRenderer = __decorate([
    inversify_1.injectable()
], BreadcrumbsRenderer);
exports.BreadcrumbsRenderer = BreadcrumbsRenderer;
exports.BreadcrumbsRendererFactory = Symbol('BreadcrumbsRendererFactory');
//# sourceMappingURL=breadcrumbs-renderer.js.map