/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { ArrayNavigator } from './navigator';
var HistoryNavigator = /** @class */ (function () {
    function HistoryNavigator(history, limit) {
        if (history === void 0) { history = []; }
        if (limit === void 0) { limit = 10; }
        this._initialize(history);
        this._limit = limit;
        this._onChange();
    }
    HistoryNavigator.prototype.getHistory = function () {
        return this._elements;
    };
    HistoryNavigator.prototype.add = function (t) {
        this._history.delete(t);
        this._history.add(t);
        this._onChange();
    };
    HistoryNavigator.prototype.next = function () {
        if (this._currentPosition() !== this._elements.length - 1) {
            return this._navigator.next();
        }
        return null;
    };
    HistoryNavigator.prototype.previous = function () {
        if (this._currentPosition() !== 0) {
            return this._navigator.previous();
        }
        return null;
    };
    HistoryNavigator.prototype.current = function () {
        return this._navigator.current();
    };
    HistoryNavigator.prototype.first = function () {
        return this._navigator.first();
    };
    HistoryNavigator.prototype.last = function () {
        return this._navigator.last();
    };
    HistoryNavigator.prototype.has = function (t) {
        return this._history.has(t);
    };
    HistoryNavigator.prototype.clear = function () {
        this._initialize([]);
        this._onChange();
    };
    HistoryNavigator.prototype._onChange = function () {
        this._reduceToLimit();
        var elements = this._elements;
        this._navigator = new ArrayNavigator(elements, 0, elements.length, elements.length);
    };
    HistoryNavigator.prototype._reduceToLimit = function () {
        var data = this._elements;
        if (data.length > this._limit) {
            this._initialize(data.slice(data.length - this._limit));
        }
    };
    HistoryNavigator.prototype._currentPosition = function () {
        var currentElement = this._navigator.current();
        if (!currentElement) {
            return -1;
        }
        return this._elements.indexOf(currentElement);
    };
    HistoryNavigator.prototype._initialize = function (history) {
        var e_1, _a;
        this._history = new Set();
        try {
            for (var history_1 = __values(history), history_1_1 = history_1.next(); !history_1_1.done; history_1_1 = history_1.next()) {
                var entry = history_1_1.value;
                this._history.add(entry);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (history_1_1 && !history_1_1.done && (_a = history_1.return)) _a.call(history_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    Object.defineProperty(HistoryNavigator.prototype, "_elements", {
        get: function () {
            var elements = [];
            this._history.forEach(function (e) { return elements.push(e); });
            return elements;
        },
        enumerable: false,
        configurable: true
    });
    return HistoryNavigator;
}());
export { HistoryNavigator };
var HistoryNavigator2 = /** @class */ (function () {
    function HistoryNavigator2(history, capacity) {
        if (capacity === void 0) { capacity = 10; }
        this.capacity = capacity;
        if (history.length < 1) {
            throw new Error('not supported');
        }
        this.size = 1;
        this.head = this.tail = this.cursor = {
            value: history[0],
            previous: undefined,
            next: undefined
        };
        for (var i = 1; i < history.length; i++) {
            this.add(history[i]);
        }
    }
    HistoryNavigator2.prototype.add = function (value) {
        var node = {
            value: value,
            previous: this.tail,
            next: undefined
        };
        this.tail.next = node;
        this.tail = node;
        this.cursor = this.tail;
        this.size++;
        while (this.size > this.capacity) {
            this.head = this.head.next;
            this.head.previous = undefined;
            this.size--;
        }
    };
    HistoryNavigator2.prototype.replaceLast = function (value) {
        this.tail.value = value;
    };
    HistoryNavigator2.prototype.isAtEnd = function () {
        return this.cursor === this.tail;
    };
    HistoryNavigator2.prototype.current = function () {
        return this.cursor.value;
    };
    HistoryNavigator2.prototype.previous = function () {
        if (this.cursor.previous) {
            this.cursor = this.cursor.previous;
        }
        return this.cursor.value;
    };
    HistoryNavigator2.prototype.next = function () {
        if (this.cursor.next) {
            this.cursor = this.cursor.next;
        }
        return this.cursor.value;
    };
    HistoryNavigator2.prototype.has = function (t) {
        var temp = this.head;
        while (temp) {
            if (temp.value === t) {
                return true;
            }
            temp = temp.next;
        }
        return false;
    };
    HistoryNavigator2.prototype.resetCursor = function () {
        this.cursor = this.tail;
        return this.cursor.value;
    };
    HistoryNavigator2.prototype[Symbol.iterator] = function () {
        var node;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    node = this.head;
                    _a.label = 1;
                case 1:
                    if (!node) return [3 /*break*/, 3];
                    return [4 /*yield*/, node.value];
                case 2:
                    _a.sent();
                    node = node.next;
                    return [3 /*break*/, 1];
                case 3: return [2 /*return*/];
            }
        });
    };
    return HistoryNavigator2;
}());
export { HistoryNavigator2 };
