/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { mergeSort } from '../../../base/common/arrays';
import { stringDiff } from '../../../base/common/diff/diff';
import { globals } from '../../../base/common/platform';
import { URI } from '../../../base/common/uri';
import { Position } from '../core/position';
import { Range } from '../core/range';
import { DiffComputer } from '../diff/diffComputer';
import { MirrorTextModel as BaseMirrorModel } from '../model/mirrorTextModel';
import { ensureValidWordDefinition, getWordAtText } from '../model/wordHelper';
import { computeLinks } from '../modes/linkComputer';
import { BasicInplaceReplace } from '../modes/supports/inplaceReplaceSupport';
import { createMonacoBaseAPI } from '../standalone/standaloneBase';
import * as types from '../../../base/common/types';
import { StopWatch } from '../../../base/common/stopwatch';
/**
 * @internal
 */
var MirrorModel = /** @class */ (function (_super) {
    __extends(MirrorModel, _super);
    function MirrorModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(MirrorModel.prototype, "uri", {
        get: function () {
            return this._uri;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MirrorModel.prototype, "version", {
        get: function () {
            return this._versionId;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MirrorModel.prototype, "eol", {
        get: function () {
            return this._eol;
        },
        enumerable: false,
        configurable: true
    });
    MirrorModel.prototype.getValue = function () {
        return this.getText();
    };
    MirrorModel.prototype.getLinesContent = function () {
        return this._lines.slice(0);
    };
    MirrorModel.prototype.getLineCount = function () {
        return this._lines.length;
    };
    MirrorModel.prototype.getLineContent = function (lineNumber) {
        return this._lines[lineNumber - 1];
    };
    MirrorModel.prototype.getWordAtPosition = function (position, wordDefinition) {
        var wordAtText = getWordAtText(position.column, ensureValidWordDefinition(wordDefinition), this._lines[position.lineNumber - 1], 0);
        if (wordAtText) {
            return new Range(position.lineNumber, wordAtText.startColumn, position.lineNumber, wordAtText.endColumn);
        }
        return null;
    };
    MirrorModel.prototype.getWordUntilPosition = function (position, wordDefinition) {
        var wordAtPosition = this.getWordAtPosition(position, wordDefinition);
        if (!wordAtPosition) {
            return {
                word: '',
                startColumn: position.column,
                endColumn: position.column
            };
        }
        return {
            word: this._lines[position.lineNumber - 1].substring(wordAtPosition.startColumn - 1, position.column - 1),
            startColumn: wordAtPosition.startColumn,
            endColumn: position.column
        };
    };
    MirrorModel.prototype.words = function (wordDefinition) {
        var _a;
        var lines = this._lines;
        var wordenize = this._wordenize.bind(this);
        var lineNumber = 0;
        var lineText = '';
        var wordRangesIdx = 0;
        var wordRanges = [];
        return _a = {},
            _a[Symbol.iterator] = function () {
                var value;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!true) return [3 /*break*/, 4];
                            if (!(wordRangesIdx < wordRanges.length)) return [3 /*break*/, 2];
                            value = lineText.substring(wordRanges[wordRangesIdx].start, wordRanges[wordRangesIdx].end);
                            wordRangesIdx += 1;
                            return [4 /*yield*/, value];
                        case 1:
                            _a.sent();
                            return [3 /*break*/, 3];
                        case 2:
                            if (lineNumber < lines.length) {
                                lineText = lines[lineNumber];
                                wordRanges = wordenize(lineText, wordDefinition);
                                wordRangesIdx = 0;
                                lineNumber += 1;
                            }
                            else {
                                return [3 /*break*/, 4];
                            }
                            _a.label = 3;
                        case 3: return [3 /*break*/, 0];
                        case 4: return [2 /*return*/];
                    }
                });
            },
            _a;
    };
    MirrorModel.prototype.getLineWords = function (lineNumber, wordDefinition) {
        var e_1, _a;
        var content = this._lines[lineNumber - 1];
        var ranges = this._wordenize(content, wordDefinition);
        var words = [];
        try {
            for (var ranges_1 = __values(ranges), ranges_1_1 = ranges_1.next(); !ranges_1_1.done; ranges_1_1 = ranges_1.next()) {
                var range = ranges_1_1.value;
                words.push({
                    word: content.substring(range.start, range.end),
                    startColumn: range.start + 1,
                    endColumn: range.end + 1
                });
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (ranges_1_1 && !ranges_1_1.done && (_a = ranges_1.return)) _a.call(ranges_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return words;
    };
    MirrorModel.prototype._wordenize = function (content, wordDefinition) {
        var result = [];
        var match;
        wordDefinition.lastIndex = 0; // reset lastIndex just to be sure
        while (match = wordDefinition.exec(content)) {
            if (match[0].length === 0) {
                // it did match the empty string
                break;
            }
            result.push({ start: match.index, end: match.index + match[0].length });
        }
        return result;
    };
    MirrorModel.prototype.getValueInRange = function (range) {
        range = this._validateRange(range);
        if (range.startLineNumber === range.endLineNumber) {
            return this._lines[range.startLineNumber - 1].substring(range.startColumn - 1, range.endColumn - 1);
        }
        var lineEnding = this._eol;
        var startLineIndex = range.startLineNumber - 1;
        var endLineIndex = range.endLineNumber - 1;
        var resultLines = [];
        resultLines.push(this._lines[startLineIndex].substring(range.startColumn - 1));
        for (var i = startLineIndex + 1; i < endLineIndex; i++) {
            resultLines.push(this._lines[i]);
        }
        resultLines.push(this._lines[endLineIndex].substring(0, range.endColumn - 1));
        return resultLines.join(lineEnding);
    };
    MirrorModel.prototype.offsetAt = function (position) {
        position = this._validatePosition(position);
        this._ensureLineStarts();
        return this._lineStarts.getAccumulatedValue(position.lineNumber - 2) + (position.column - 1);
    };
    MirrorModel.prototype.positionAt = function (offset) {
        offset = Math.floor(offset);
        offset = Math.max(0, offset);
        this._ensureLineStarts();
        var out = this._lineStarts.getIndexOf(offset);
        var lineLength = this._lines[out.index].length;
        // Ensure we return a valid position
        return {
            lineNumber: 1 + out.index,
            column: 1 + Math.min(out.remainder, lineLength)
        };
    };
    MirrorModel.prototype._validateRange = function (range) {
        var start = this._validatePosition({ lineNumber: range.startLineNumber, column: range.startColumn });
        var end = this._validatePosition({ lineNumber: range.endLineNumber, column: range.endColumn });
        if (start.lineNumber !== range.startLineNumber
            || start.column !== range.startColumn
            || end.lineNumber !== range.endLineNumber
            || end.column !== range.endColumn) {
            return {
                startLineNumber: start.lineNumber,
                startColumn: start.column,
                endLineNumber: end.lineNumber,
                endColumn: end.column
            };
        }
        return range;
    };
    MirrorModel.prototype._validatePosition = function (position) {
        if (!Position.isIPosition(position)) {
            throw new Error('bad position');
        }
        var lineNumber = position.lineNumber, column = position.column;
        var hasChanged = false;
        if (lineNumber < 1) {
            lineNumber = 1;
            column = 1;
            hasChanged = true;
        }
        else if (lineNumber > this._lines.length) {
            lineNumber = this._lines.length;
            column = this._lines[lineNumber - 1].length + 1;
            hasChanged = true;
        }
        else {
            var maxCharacter = this._lines[lineNumber - 1].length + 1;
            if (column < 1) {
                column = 1;
                hasChanged = true;
            }
            else if (column > maxCharacter) {
                column = maxCharacter;
                hasChanged = true;
            }
        }
        if (!hasChanged) {
            return position;
        }
        else {
            return { lineNumber: lineNumber, column: column };
        }
    };
    return MirrorModel;
}(BaseMirrorModel));
/**
 * @internal
 */
var EditorSimpleWorker = /** @class */ (function () {
    function EditorSimpleWorker(host, foreignModuleFactory) {
        this._host = host;
        this._models = Object.create(null);
        this._foreignModuleFactory = foreignModuleFactory;
        this._foreignModule = null;
    }
    EditorSimpleWorker.prototype.dispose = function () {
        this._models = Object.create(null);
    };
    EditorSimpleWorker.prototype._getModel = function (uri) {
        return this._models[uri];
    };
    EditorSimpleWorker.prototype._getModels = function () {
        var _this = this;
        var all = [];
        Object.keys(this._models).forEach(function (key) { return all.push(_this._models[key]); });
        return all;
    };
    EditorSimpleWorker.prototype.acceptNewModel = function (data) {
        this._models[data.url] = new MirrorModel(URI.parse(data.url), data.lines, data.EOL, data.versionId);
    };
    EditorSimpleWorker.prototype.acceptModelChanged = function (strURL, e) {
        if (!this._models[strURL]) {
            return;
        }
        var model = this._models[strURL];
        model.onEvents(e);
    };
    EditorSimpleWorker.prototype.acceptRemovedModel = function (strURL) {
        if (!this._models[strURL]) {
            return;
        }
        delete this._models[strURL];
    };
    // ---- BEGIN diff --------------------------------------------------------------------------
    EditorSimpleWorker.prototype.computeDiff = function (originalUrl, modifiedUrl, ignoreTrimWhitespace, maxComputationTime) {
        return __awaiter(this, void 0, void 0, function () {
            var original, modified, originalLines, modifiedLines, diffComputer, diffResult, identical;
            return __generator(this, function (_a) {
                original = this._getModel(originalUrl);
                modified = this._getModel(modifiedUrl);
                if (!original || !modified) {
                    return [2 /*return*/, null];
                }
                originalLines = original.getLinesContent();
                modifiedLines = modified.getLinesContent();
                diffComputer = new DiffComputer(originalLines, modifiedLines, {
                    shouldComputeCharChanges: true,
                    shouldPostProcessCharChanges: true,
                    shouldIgnoreTrimWhitespace: ignoreTrimWhitespace,
                    shouldMakePrettyDiff: true,
                    maxComputationTime: maxComputationTime
                });
                diffResult = diffComputer.computeDiff();
                identical = (diffResult.changes.length > 0 ? false : this._modelsAreIdentical(original, modified));
                return [2 /*return*/, {
                        quitEarly: diffResult.quitEarly,
                        identical: identical,
                        changes: diffResult.changes
                    }];
            });
        });
    };
    EditorSimpleWorker.prototype._modelsAreIdentical = function (original, modified) {
        var originalLineCount = original.getLineCount();
        var modifiedLineCount = modified.getLineCount();
        if (originalLineCount !== modifiedLineCount) {
            return false;
        }
        for (var line = 1; line <= originalLineCount; line++) {
            var originalLine = original.getLineContent(line);
            var modifiedLine = modified.getLineContent(line);
            if (originalLine !== modifiedLine) {
                return false;
            }
        }
        return true;
    };
    EditorSimpleWorker.prototype.computeDirtyDiff = function (originalUrl, modifiedUrl, ignoreTrimWhitespace) {
        return __awaiter(this, void 0, void 0, function () {
            var original, modified, originalLines, modifiedLines, diffComputer;
            return __generator(this, function (_a) {
                original = this._getModel(originalUrl);
                modified = this._getModel(modifiedUrl);
                if (!original || !modified) {
                    return [2 /*return*/, null];
                }
                originalLines = original.getLinesContent();
                modifiedLines = modified.getLinesContent();
                diffComputer = new DiffComputer(originalLines, modifiedLines, {
                    shouldComputeCharChanges: false,
                    shouldPostProcessCharChanges: false,
                    shouldIgnoreTrimWhitespace: ignoreTrimWhitespace,
                    shouldMakePrettyDiff: true,
                    maxComputationTime: 1000
                });
                return [2 /*return*/, diffComputer.computeDiff().changes];
            });
        });
    };
    EditorSimpleWorker.prototype.computeMoreMinimalEdits = function (modelUrl, edits) {
        return __awaiter(this, void 0, void 0, function () {
            var model, result, lastEol, edits_1, edits_1_1, _a, range, text, eol, original, changes, editOffset, changes_1, changes_1_1, change, start, end, newEdit;
            var e_2, _b, e_3, _c;
            return __generator(this, function (_d) {
                model = this._getModel(modelUrl);
                if (!model) {
                    return [2 /*return*/, edits];
                }
                result = [];
                lastEol = undefined;
                edits = mergeSort(edits, function (a, b) {
                    if (a.range && b.range) {
                        return Range.compareRangesUsingStarts(a.range, b.range);
                    }
                    // eol only changes should go to the end
                    var aRng = a.range ? 0 : 1;
                    var bRng = b.range ? 0 : 1;
                    return aRng - bRng;
                });
                try {
                    for (edits_1 = __values(edits), edits_1_1 = edits_1.next(); !edits_1_1.done; edits_1_1 = edits_1.next()) {
                        _a = edits_1_1.value, range = _a.range, text = _a.text, eol = _a.eol;
                        if (typeof eol === 'number') {
                            lastEol = eol;
                        }
                        if (Range.isEmpty(range) && !text) {
                            // empty change
                            continue;
                        }
                        original = model.getValueInRange(range);
                        text = text.replace(/\r\n|\n|\r/g, model.eol);
                        if (original === text) {
                            // noop
                            continue;
                        }
                        // make sure diff won't take too long
                        if (Math.max(text.length, original.length) > EditorSimpleWorker._diffLimit) {
                            result.push({ range: range, text: text });
                            continue;
                        }
                        changes = stringDiff(original, text, false);
                        editOffset = model.offsetAt(Range.lift(range).getStartPosition());
                        try {
                            for (changes_1 = (e_3 = void 0, __values(changes)), changes_1_1 = changes_1.next(); !changes_1_1.done; changes_1_1 = changes_1.next()) {
                                change = changes_1_1.value;
                                start = model.positionAt(editOffset + change.originalStart);
                                end = model.positionAt(editOffset + change.originalStart + change.originalLength);
                                newEdit = {
                                    text: text.substr(change.modifiedStart, change.modifiedLength),
                                    range: { startLineNumber: start.lineNumber, startColumn: start.column, endLineNumber: end.lineNumber, endColumn: end.column }
                                };
                                if (model.getValueInRange(newEdit.range) !== newEdit.text) {
                                    result.push(newEdit);
                                }
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (changes_1_1 && !changes_1_1.done && (_c = changes_1.return)) _c.call(changes_1);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (edits_1_1 && !edits_1_1.done && (_b = edits_1.return)) _b.call(edits_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                if (typeof lastEol === 'number') {
                    result.push({ eol: lastEol, text: '', range: { startLineNumber: 0, startColumn: 0, endLineNumber: 0, endColumn: 0 } });
                }
                return [2 /*return*/, result];
            });
        });
    };
    // ---- END minimal edits ---------------------------------------------------------------
    EditorSimpleWorker.prototype.computeLinks = function (modelUrl) {
        return __awaiter(this, void 0, void 0, function () {
            var model;
            return __generator(this, function (_a) {
                model = this._getModel(modelUrl);
                if (!model) {
                    return [2 /*return*/, null];
                }
                return [2 /*return*/, computeLinks(model)];
            });
        });
    };
    EditorSimpleWorker.prototype.textualSuggest = function (modelUrls, leadingWord, wordDef, wordDefFlags) {
        return __awaiter(this, void 0, void 0, function () {
            var sw, wordDefRegExp, seen, modelUrls_1, modelUrls_1_1, url, model, _a, _b, word;
            var e_4, _c, e_5, _d;
            return __generator(this, function (_e) {
                sw = new StopWatch(true);
                wordDefRegExp = new RegExp(wordDef, wordDefFlags);
                seen = new Set();
                try {
                    outer: for (modelUrls_1 = __values(modelUrls), modelUrls_1_1 = modelUrls_1.next(); !modelUrls_1_1.done; modelUrls_1_1 = modelUrls_1.next()) {
                        url = modelUrls_1_1.value;
                        model = this._getModel(url);
                        if (!model) {
                            continue;
                        }
                        try {
                            for (_a = (e_5 = void 0, __values(model.words(wordDefRegExp))), _b = _a.next(); !_b.done; _b = _a.next()) {
                                word = _b.value;
                                if (word === leadingWord || !isNaN(Number(word))) {
                                    continue;
                                }
                                seen.add(word);
                                if (seen.size > EditorSimpleWorker._suggestionsLimit) {
                                    break outer;
                                }
                            }
                        }
                        catch (e_5_1) { e_5 = { error: e_5_1 }; }
                        finally {
                            try {
                                if (_b && !_b.done && (_d = _a.return)) _d.call(_a);
                            }
                            finally { if (e_5) throw e_5.error; }
                        }
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (modelUrls_1_1 && !modelUrls_1_1.done && (_c = modelUrls_1.return)) _c.call(modelUrls_1);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
                return [2 /*return*/, { words: Array.from(seen), duration: sw.elapsed() }];
            });
        });
    };
    // ---- END suggest --------------------------------------------------------------------------
    //#region -- word ranges --
    EditorSimpleWorker.prototype.computeWordRanges = function (modelUrl, range, wordDef, wordDefFlags) {
        return __awaiter(this, void 0, void 0, function () {
            var model, wordDefRegExp, result, line, words, words_1, words_1_1, word, array;
            var e_6, _a;
            return __generator(this, function (_b) {
                model = this._getModel(modelUrl);
                if (!model) {
                    return [2 /*return*/, Object.create(null)];
                }
                wordDefRegExp = new RegExp(wordDef, wordDefFlags);
                result = Object.create(null);
                for (line = range.startLineNumber; line < range.endLineNumber; line++) {
                    words = model.getLineWords(line, wordDefRegExp);
                    try {
                        for (words_1 = (e_6 = void 0, __values(words)), words_1_1 = words_1.next(); !words_1_1.done; words_1_1 = words_1.next()) {
                            word = words_1_1.value;
                            if (!isNaN(Number(word.word))) {
                                continue;
                            }
                            array = result[word.word];
                            if (!array) {
                                array = [];
                                result[word.word] = array;
                            }
                            array.push({
                                startLineNumber: line,
                                startColumn: word.startColumn,
                                endLineNumber: line,
                                endColumn: word.endColumn
                            });
                        }
                    }
                    catch (e_6_1) { e_6 = { error: e_6_1 }; }
                    finally {
                        try {
                            if (words_1_1 && !words_1_1.done && (_a = words_1.return)) _a.call(words_1);
                        }
                        finally { if (e_6) throw e_6.error; }
                    }
                }
                return [2 /*return*/, result];
            });
        });
    };
    //#endregion
    EditorSimpleWorker.prototype.navigateValueSet = function (modelUrl, range, up, wordDef, wordDefFlags) {
        return __awaiter(this, void 0, void 0, function () {
            var model, wordDefRegExp, selectionText, wordRange, word, result;
            return __generator(this, function (_a) {
                model = this._getModel(modelUrl);
                if (!model) {
                    return [2 /*return*/, null];
                }
                wordDefRegExp = new RegExp(wordDef, wordDefFlags);
                if (range.startColumn === range.endColumn) {
                    range = {
                        startLineNumber: range.startLineNumber,
                        startColumn: range.startColumn,
                        endLineNumber: range.endLineNumber,
                        endColumn: range.endColumn + 1
                    };
                }
                selectionText = model.getValueInRange(range);
                wordRange = model.getWordAtPosition({ lineNumber: range.startLineNumber, column: range.startColumn }, wordDefRegExp);
                if (!wordRange) {
                    return [2 /*return*/, null];
                }
                word = model.getValueInRange(wordRange);
                result = BasicInplaceReplace.INSTANCE.navigateValueSet(range, selectionText, wordRange, word, up);
                return [2 /*return*/, result];
            });
        });
    };
    // ---- BEGIN foreign module support --------------------------------------------------------------------------
    EditorSimpleWorker.prototype.loadForeignModule = function (moduleId, createData, foreignHostMethods) {
        var _this = this;
        var proxyMethodRequest = function (method, args) {
            return _this._host.fhr(method, args);
        };
        var foreignHost = types.createProxyObject(foreignHostMethods, proxyMethodRequest);
        var ctx = {
            host: foreignHost,
            getMirrorModels: function () {
                return _this._getModels();
            }
        };
        if (this._foreignModuleFactory) {
            this._foreignModule = this._foreignModuleFactory(ctx, createData);
            // static foreing module
            return Promise.resolve(types.getAllMethodNames(this._foreignModule));
        }
        // ESM-comment-begin
        // 		return new Promise<any>((resolve, reject) => {
        // 			require([moduleId], (foreignModule: { create: IForeignModuleFactory }) => {
        // 				this._foreignModule = foreignModule.create(ctx, createData);
        // 
        // 				resolve(types.getAllMethodNames(this._foreignModule));
        // 
        // 			}, reject);
        // 		});
        // ESM-comment-end
        // ESM-uncomment-begin
        return Promise.reject(new Error("Unexpected usage"));
        // ESM-uncomment-end
    };
    // foreign method request
    EditorSimpleWorker.prototype.fmr = function (method, args) {
        if (!this._foreignModule || typeof this._foreignModule[method] !== 'function') {
            return Promise.reject(new Error('Missing requestHandler or method: ' + method));
        }
        try {
            return Promise.resolve(this._foreignModule[method].apply(this._foreignModule, args));
        }
        catch (e) {
            return Promise.reject(e);
        }
    };
    // ---- END diff --------------------------------------------------------------------------
    // ---- BEGIN minimal edits ---------------------------------------------------------------
    EditorSimpleWorker._diffLimit = 100000;
    // ---- BEGIN suggest --------------------------------------------------------------------------
    EditorSimpleWorker._suggestionsLimit = 10000;
    return EditorSimpleWorker;
}());
export { EditorSimpleWorker };
/**
 * Called on the worker side
 * @internal
 */
export function create(host) {
    return new EditorSimpleWorker(host, null);
}
if (typeof importScripts === 'function') {
    // Running in a web worker
    globals.monaco = createMonacoBaseAPI();
}
