/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var EditorTheme = /** @class */ (function () {
    function EditorTheme(theme) {
        this._theme = theme;
    }
    Object.defineProperty(EditorTheme.prototype, "type", {
        get: function () {
            return this._theme.type;
        },
        enumerable: false,
        configurable: true
    });
    EditorTheme.prototype.update = function (theme) {
        this._theme = theme;
    };
    EditorTheme.prototype.getColor = function (color) {
        return this._theme.getColor(color);
    };
    return EditorTheme;
}());
export { EditorTheme };
var ViewContext = /** @class */ (function () {
    function ViewContext(configuration, theme, model) {
        this.configuration = configuration;
        this.theme = new EditorTheme(theme);
        this.model = model;
        this.viewLayout = model.viewLayout;
    }
    ViewContext.prototype.addEventHandler = function (eventHandler) {
        this.model.addViewEventHandler(eventHandler);
    };
    ViewContext.prototype.removeEventHandler = function (eventHandler) {
        this.model.removeViewEventHandler(eventHandler);
    };
    return ViewContext;
}());
export { ViewContext };
