/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { Emitter } from '../../../base/common/event';
import { Disposable } from '../../../base/common/lifecycle';
var ViewModelEventDispatcher = /** @class */ (function (_super) {
    __extends(ViewModelEventDispatcher, _super);
    function ViewModelEventDispatcher() {
        var _this = _super.call(this) || this;
        _this._onEvent = _this._register(new Emitter());
        _this.onEvent = _this._onEvent.event;
        _this._eventHandlers = [];
        _this._viewEventQueue = null;
        _this._isConsumingViewEventQueue = false;
        _this._collector = null;
        _this._collectorCnt = 0;
        _this._outgoingEvents = [];
        return _this;
    }
    ViewModelEventDispatcher.prototype.emitOutgoingEvent = function (e) {
        this._addOutgoingEvent(e);
        this._emitOugoingEvents();
    };
    ViewModelEventDispatcher.prototype._addOutgoingEvent = function (e) {
        for (var i = 0, len = this._outgoingEvents.length; i < len; i++) {
            if (this._outgoingEvents[i].kind === e.kind) {
                this._outgoingEvents[i] = this._outgoingEvents[i].merge(e);
                return;
            }
        }
        // not merged
        this._outgoingEvents.push(e);
    };
    ViewModelEventDispatcher.prototype._emitOugoingEvents = function () {
        while (this._outgoingEvents.length > 0) {
            if (this._collector || this._isConsumingViewEventQueue) {
                // right now collecting or emitting view events, so let's postpone emitting
                return;
            }
            var event_1 = this._outgoingEvents.shift();
            if (event_1.isNoOp()) {
                continue;
            }
            this._onEvent.fire(event_1);
        }
    };
    ViewModelEventDispatcher.prototype.addViewEventHandler = function (eventHandler) {
        for (var i = 0, len = this._eventHandlers.length; i < len; i++) {
            if (this._eventHandlers[i] === eventHandler) {
                console.warn('Detected duplicate listener in ViewEventDispatcher', eventHandler);
            }
        }
        this._eventHandlers.push(eventHandler);
    };
    ViewModelEventDispatcher.prototype.removeViewEventHandler = function (eventHandler) {
        for (var i = 0; i < this._eventHandlers.length; i++) {
            if (this._eventHandlers[i] === eventHandler) {
                this._eventHandlers.splice(i, 1);
                break;
            }
        }
    };
    ViewModelEventDispatcher.prototype.beginEmitViewEvents = function () {
        this._collectorCnt++;
        if (this._collectorCnt === 1) {
            this._collector = new ViewModelEventsCollector();
        }
        return this._collector;
    };
    ViewModelEventDispatcher.prototype.endEmitViewEvents = function () {
        var e_1, _a;
        this._collectorCnt--;
        if (this._collectorCnt === 0) {
            var outgoingEvents = this._collector.outgoingEvents;
            var viewEvents = this._collector.viewEvents;
            this._collector = null;
            try {
                for (var outgoingEvents_1 = __values(outgoingEvents), outgoingEvents_1_1 = outgoingEvents_1.next(); !outgoingEvents_1_1.done; outgoingEvents_1_1 = outgoingEvents_1.next()) {
                    var outgoingEvent = outgoingEvents_1_1.value;
                    this._addOutgoingEvent(outgoingEvent);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (outgoingEvents_1_1 && !outgoingEvents_1_1.done && (_a = outgoingEvents_1.return)) _a.call(outgoingEvents_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (viewEvents.length > 0) {
                this._emitMany(viewEvents);
            }
        }
        this._emitOugoingEvents();
    };
    ViewModelEventDispatcher.prototype.emitSingleViewEvent = function (event) {
        try {
            var eventsCollector = this.beginEmitViewEvents();
            eventsCollector.emitViewEvent(event);
        }
        finally {
            this.endEmitViewEvents();
        }
    };
    ViewModelEventDispatcher.prototype._emitMany = function (events) {
        if (this._viewEventQueue) {
            this._viewEventQueue = this._viewEventQueue.concat(events);
        }
        else {
            this._viewEventQueue = events;
        }
        if (!this._isConsumingViewEventQueue) {
            this._consumeViewEventQueue();
        }
    };
    ViewModelEventDispatcher.prototype._consumeViewEventQueue = function () {
        try {
            this._isConsumingViewEventQueue = true;
            this._doConsumeQueue();
        }
        finally {
            this._isConsumingViewEventQueue = false;
        }
    };
    ViewModelEventDispatcher.prototype._doConsumeQueue = function () {
        var e_2, _a;
        while (this._viewEventQueue) {
            // Empty event queue, as events might come in while sending these off
            var events = this._viewEventQueue;
            this._viewEventQueue = null;
            // Use a clone of the event handlers list, as they might remove themselves
            var eventHandlers = this._eventHandlers.slice(0);
            try {
                for (var eventHandlers_1 = (e_2 = void 0, __values(eventHandlers)), eventHandlers_1_1 = eventHandlers_1.next(); !eventHandlers_1_1.done; eventHandlers_1_1 = eventHandlers_1.next()) {
                    var eventHandler = eventHandlers_1_1.value;
                    eventHandler.handleEvents(events);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (eventHandlers_1_1 && !eventHandlers_1_1.done && (_a = eventHandlers_1.return)) _a.call(eventHandlers_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    };
    return ViewModelEventDispatcher;
}(Disposable));
export { ViewModelEventDispatcher };
var ViewModelEventsCollector = /** @class */ (function () {
    function ViewModelEventsCollector() {
        this.viewEvents = [];
        this.outgoingEvents = [];
    }
    ViewModelEventsCollector.prototype.emitViewEvent = function (event) {
        this.viewEvents.push(event);
    };
    ViewModelEventsCollector.prototype.emitOutgoingEvent = function (e) {
        this.outgoingEvents.push(e);
    };
    return ViewModelEventsCollector;
}());
export { ViewModelEventsCollector };
var ContentSizeChangedEvent = /** @class */ (function () {
    function ContentSizeChangedEvent(oldContentWidth, oldContentHeight, contentWidth, contentHeight) {
        this.kind = 0 /* ContentSizeChanged */;
        this._oldContentWidth = oldContentWidth;
        this._oldContentHeight = oldContentHeight;
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
        this.contentWidthChanged = (this._oldContentWidth !== this.contentWidth);
        this.contentHeightChanged = (this._oldContentHeight !== this.contentHeight);
    }
    ContentSizeChangedEvent.prototype.isNoOp = function () {
        return (!this.contentWidthChanged && !this.contentHeightChanged);
    };
    ContentSizeChangedEvent.prototype.merge = function (other) {
        if (other.kind !== 0 /* ContentSizeChanged */) {
            return this;
        }
        return new ContentSizeChangedEvent(this._oldContentWidth, this._oldContentHeight, other.contentWidth, other.contentHeight);
    };
    return ContentSizeChangedEvent;
}());
export { ContentSizeChangedEvent };
var FocusChangedEvent = /** @class */ (function () {
    function FocusChangedEvent(oldHasFocus, hasFocus) {
        this.kind = 1 /* FocusChanged */;
        this.oldHasFocus = oldHasFocus;
        this.hasFocus = hasFocus;
    }
    FocusChangedEvent.prototype.isNoOp = function () {
        return (this.oldHasFocus === this.hasFocus);
    };
    FocusChangedEvent.prototype.merge = function (other) {
        if (other.kind !== 1 /* FocusChanged */) {
            return this;
        }
        return new FocusChangedEvent(this.oldHasFocus, other.hasFocus);
    };
    return FocusChangedEvent;
}());
export { FocusChangedEvent };
var ScrollChangedEvent = /** @class */ (function () {
    function ScrollChangedEvent(oldScrollWidth, oldScrollLeft, oldScrollHeight, oldScrollTop, scrollWidth, scrollLeft, scrollHeight, scrollTop) {
        this.kind = 2 /* ScrollChanged */;
        this._oldScrollWidth = oldScrollWidth;
        this._oldScrollLeft = oldScrollLeft;
        this._oldScrollHeight = oldScrollHeight;
        this._oldScrollTop = oldScrollTop;
        this.scrollWidth = scrollWidth;
        this.scrollLeft = scrollLeft;
        this.scrollHeight = scrollHeight;
        this.scrollTop = scrollTop;
        this.scrollWidthChanged = (this._oldScrollWidth !== this.scrollWidth);
        this.scrollLeftChanged = (this._oldScrollLeft !== this.scrollLeft);
        this.scrollHeightChanged = (this._oldScrollHeight !== this.scrollHeight);
        this.scrollTopChanged = (this._oldScrollTop !== this.scrollTop);
    }
    ScrollChangedEvent.prototype.isNoOp = function () {
        return (!this.scrollWidthChanged && !this.scrollLeftChanged && !this.scrollHeightChanged && !this.scrollTopChanged);
    };
    ScrollChangedEvent.prototype.merge = function (other) {
        if (other.kind !== 2 /* ScrollChanged */) {
            return this;
        }
        return new ScrollChangedEvent(this._oldScrollWidth, this._oldScrollLeft, this._oldScrollHeight, this._oldScrollTop, other.scrollWidth, other.scrollLeft, other.scrollHeight, other.scrollTop);
    };
    return ScrollChangedEvent;
}());
export { ScrollChangedEvent };
var ViewZonesChangedEvent = /** @class */ (function () {
    function ViewZonesChangedEvent() {
        this.kind = 3 /* ViewZonesChanged */;
    }
    ViewZonesChangedEvent.prototype.isNoOp = function () {
        return false;
    };
    ViewZonesChangedEvent.prototype.merge = function (other) {
        return this;
    };
    return ViewZonesChangedEvent;
}());
export { ViewZonesChangedEvent };
var CursorStateChangedEvent = /** @class */ (function () {
    function CursorStateChangedEvent(oldSelections, selections, oldModelVersionId, modelVersionId, source, reason, reachedMaxCursorCount) {
        this.kind = 5 /* CursorStateChanged */;
        this.oldSelections = oldSelections;
        this.selections = selections;
        this.oldModelVersionId = oldModelVersionId;
        this.modelVersionId = modelVersionId;
        this.source = source;
        this.reason = reason;
        this.reachedMaxCursorCount = reachedMaxCursorCount;
    }
    CursorStateChangedEvent._selectionsAreEqual = function (a, b) {
        if (!a && !b) {
            return true;
        }
        if (!a || !b) {
            return false;
        }
        var aLen = a.length;
        var bLen = b.length;
        if (aLen !== bLen) {
            return false;
        }
        for (var i = 0; i < aLen; i++) {
            if (!a[i].equalsSelection(b[i])) {
                return false;
            }
        }
        return true;
    };
    CursorStateChangedEvent.prototype.isNoOp = function () {
        return (CursorStateChangedEvent._selectionsAreEqual(this.oldSelections, this.selections)
            && this.oldModelVersionId === this.modelVersionId);
    };
    CursorStateChangedEvent.prototype.merge = function (other) {
        if (other.kind !== 5 /* CursorStateChanged */) {
            return this;
        }
        return new CursorStateChangedEvent(this.oldSelections, other.selections, this.oldModelVersionId, other.modelVersionId, other.source, other.reason, this.reachedMaxCursorCount || other.reachedMaxCursorCount);
    };
    return CursorStateChangedEvent;
}());
export { CursorStateChangedEvent };
var ReadOnlyEditAttemptEvent = /** @class */ (function () {
    function ReadOnlyEditAttemptEvent() {
        this.kind = 4 /* ReadOnlyEditAttempt */;
    }
    ReadOnlyEditAttemptEvent.prototype.isNoOp = function () {
        return false;
    };
    ReadOnlyEditAttemptEvent.prototype.merge = function (other) {
        return this;
    };
    return ReadOnlyEditAttemptEvent;
}());
export { ReadOnlyEditAttemptEvent };
