/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { getDomNodePagePosition } from '../../../base/browser/dom';
import { Action, Separator } from '../../../base/common/actions';
import { canceled } from '../../../base/common/errors';
import { Lazy } from '../../../base/common/lazy';
import { Disposable, MutableDisposable } from '../../../base/common/lifecycle';
import { Position } from '../../common/core/position';
import { CodeActionProviderRegistry } from '../../common/modes';
import { codeActionCommandId, CodeActionItem, fixAllCommandId, organizeImportsCommandId, refactorCommandId, sourceActionCommandId } from './codeAction';
import { CodeActionCommandArgs, CodeActionKind } from './types';
import { IContextMenuService } from '../../../platform/contextview/browser/contextView';
import { IKeybindingService } from '../../../platform/keybinding/common/keybinding';
var CodeActionAction = /** @class */ (function (_super) {
    __extends(CodeActionAction, _super);
    function CodeActionAction(action, callback) {
        var _this = _super.call(this, action.command ? action.command.id : action.title, stripNewlines(action.title), undefined, !action.disabled, callback) || this;
        _this.action = action;
        return _this;
    }
    return CodeActionAction;
}(Action));
function stripNewlines(str) {
    return str.replace(/\r\n|\r|\n/g, ' ');
}
var CodeActionMenu = /** @class */ (function (_super) {
    __extends(CodeActionMenu, _super);
    function CodeActionMenu(_editor, _delegate, _contextMenuService, keybindingService) {
        var _this = _super.call(this) || this;
        _this._editor = _editor;
        _this._delegate = _delegate;
        _this._contextMenuService = _contextMenuService;
        _this._visible = false;
        _this._showingActions = _this._register(new MutableDisposable());
        _this._keybindingResolver = new CodeActionKeybindingResolver({
            getKeybindings: function () { return keybindingService.getKeybindings(); }
        });
        return _this;
    }
    Object.defineProperty(CodeActionMenu.prototype, "isVisible", {
        get: function () {
            return this._visible;
        },
        enumerable: false,
        configurable: true
    });
    CodeActionMenu.prototype.show = function (trigger, codeActions, at, options) {
        return __awaiter(this, void 0, void 0, function () {
            var actionsToShow, menuActions, anchor, resolver;
            var _this = this;
            return __generator(this, function (_a) {
                actionsToShow = options.includeDisabledActions ? codeActions.allActions : codeActions.validActions;
                if (!actionsToShow.length) {
                    this._visible = false;
                    return [2 /*return*/];
                }
                if (!this._editor.getDomNode()) {
                    // cancel when editor went off-dom
                    this._visible = false;
                    throw canceled();
                }
                this._visible = true;
                this._showingActions.value = codeActions;
                menuActions = this.getMenuActions(trigger, actionsToShow, codeActions.documentation);
                anchor = Position.isIPosition(at) ? this._toCoords(at) : at || { x: 0, y: 0 };
                resolver = this._keybindingResolver.getResolver();
                this._contextMenuService.showContextMenu({
                    domForShadowRoot: this._editor.getDomNode(),
                    getAnchor: function () { return anchor; },
                    getActions: function () { return menuActions; },
                    onHide: function () {
                        _this._visible = false;
                        _this._editor.focus();
                    },
                    autoSelectFirstItem: true,
                    getKeyBinding: function (action) { return action instanceof CodeActionAction ? resolver(action.action) : undefined; },
                });
                return [2 /*return*/];
            });
        });
    };
    CodeActionMenu.prototype.getMenuActions = function (trigger, actionsToShow, documentation) {
        var e_1, _a;
        var _this = this;
        var _b, _c;
        var toCodeActionAction = function (item) { return new CodeActionAction(item.action, function () { return _this._delegate.onSelectCodeAction(item); }); };
        var result = actionsToShow
            .map(toCodeActionAction);
        var allDocumentation = __spreadArray([], __read(documentation));
        var model = this._editor.getModel();
        if (model && result.length) {
            try {
                for (var _d = __values(CodeActionProviderRegistry.all(model)), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var provider = _e.value;
                    if (provider._getAdditionalMenuItems) {
                        allDocumentation.push.apply(allDocumentation, __spreadArray([], __read(provider._getAdditionalMenuItems({ trigger: trigger.type, only: (_c = (_b = trigger.filter) === null || _b === void 0 ? void 0 : _b.include) === null || _c === void 0 ? void 0 : _c.value }, actionsToShow.map(function (item) { return item.action; })))));
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        if (allDocumentation.length) {
            result.push.apply(result, __spreadArray([new Separator()], __read(allDocumentation.map(function (command) { return toCodeActionAction(new CodeActionItem({
                title: command.title,
                command: command,
            }, undefined)); }))));
        }
        return result;
    };
    CodeActionMenu.prototype._toCoords = function (position) {
        if (!this._editor.hasModel()) {
            return { x: 0, y: 0 };
        }
        this._editor.revealPosition(position, 1 /* Immediate */);
        this._editor.render();
        // Translate to absolute editor position
        var cursorCoords = this._editor.getScrolledVisiblePosition(position);
        var editorCoords = getDomNodePagePosition(this._editor.getDomNode());
        var x = editorCoords.left + cursorCoords.left;
        var y = editorCoords.top + cursorCoords.top + cursorCoords.height;
        return { x: x, y: y };
    };
    CodeActionMenu = __decorate([
        __param(2, IContextMenuService),
        __param(3, IKeybindingService)
    ], CodeActionMenu);
    return CodeActionMenu;
}(Disposable));
export { CodeActionMenu };
var CodeActionKeybindingResolver = /** @class */ (function () {
    function CodeActionKeybindingResolver(_keybindingProvider) {
        this._keybindingProvider = _keybindingProvider;
    }
    CodeActionKeybindingResolver.prototype.getResolver = function () {
        var _this = this;
        // Lazy since we may not actually ever read the value
        var allCodeActionBindings = new Lazy(function () {
            return _this._keybindingProvider.getKeybindings()
                .filter(function (item) { return CodeActionKeybindingResolver.codeActionCommands.indexOf(item.command) >= 0; })
                .filter(function (item) { return item.resolvedKeybinding; })
                .map(function (item) {
                // Special case these commands since they come built-in with VS Code and don't use 'commandArgs'
                var commandArgs = item.commandArgs;
                if (item.command === organizeImportsCommandId) {
                    commandArgs = { kind: CodeActionKind.SourceOrganizeImports.value };
                }
                else if (item.command === fixAllCommandId) {
                    commandArgs = { kind: CodeActionKind.SourceFixAll.value };
                }
                return __assign({ resolvedKeybinding: item.resolvedKeybinding }, CodeActionCommandArgs.fromUser(commandArgs, {
                    kind: CodeActionKind.None,
                    apply: "never" /* Never */
                }));
            });
        });
        return function (action) {
            if (action.kind) {
                var binding = _this.bestKeybindingForCodeAction(action, allCodeActionBindings.getValue());
                return binding === null || binding === void 0 ? void 0 : binding.resolvedKeybinding;
            }
            return undefined;
        };
    };
    CodeActionKeybindingResolver.prototype.bestKeybindingForCodeAction = function (action, candidates) {
        if (!action.kind) {
            return undefined;
        }
        var kind = new CodeActionKind(action.kind);
        return candidates
            .filter(function (candidate) { return candidate.kind.contains(kind); })
            .filter(function (candidate) {
            if (candidate.preferred) {
                // If the candidate keybinding only applies to preferred actions, the this action must also be preferred
                return action.isPreferred;
            }
            return true;
        })
            .reduceRight(function (currentBest, candidate) {
            if (!currentBest) {
                return candidate;
            }
            // Select the more specific binding
            return currentBest.kind.contains(candidate.kind) ? candidate : currentBest;
        }, undefined);
    };
    CodeActionKeybindingResolver.codeActionCommands = [
        refactorCommandId,
        codeActionCommandId,
        sourceActionCommandId,
        organizeImportsCommandId,
        fixAllCommandId
    ];
    return CodeActionKeybindingResolver;
}());
export { CodeActionKeybindingResolver };
