/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { mergeSort } from '../../../base/common/arrays';
import { CancellationToken } from '../../../base/common/cancellation';
import { illegalArgument, onUnexpectedExternalError } from '../../../base/common/errors';
import { URI } from '../../../base/common/uri';
import { CodeLensProviderRegistry } from '../../common/modes';
import { IModelService } from '../../common/services/modelService';
import { DisposableStore } from '../../../base/common/lifecycle';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { assertType } from '../../../base/common/types';
var CodeLensModel = /** @class */ (function () {
    function CodeLensModel() {
        this.lenses = [];
        this._disposables = new DisposableStore();
    }
    CodeLensModel.prototype.dispose = function () {
        this._disposables.dispose();
    };
    CodeLensModel.prototype.add = function (list, provider) {
        var e_1, _a;
        this._disposables.add(list);
        try {
            for (var _b = __values(list.lenses), _c = _b.next(); !_c.done; _c = _b.next()) {
                var symbol = _c.value;
                this.lenses.push({ symbol: symbol, provider: provider });
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    return CodeLensModel;
}());
export { CodeLensModel };
export function getCodeLensModel(model, token) {
    return __awaiter(this, void 0, void 0, function () {
        var provider, providerRanks, result, promises;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    provider = CodeLensProviderRegistry.ordered(model);
                    providerRanks = new Map();
                    result = new CodeLensModel();
                    promises = provider.map(function (provider, i) { return __awaiter(_this, void 0, void 0, function () {
                        var list, err_1;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    providerRanks.set(provider, i);
                                    _a.label = 1;
                                case 1:
                                    _a.trys.push([1, 3, , 4]);
                                    return [4 /*yield*/, Promise.resolve(provider.provideCodeLenses(model, token))];
                                case 2:
                                    list = _a.sent();
                                    if (list) {
                                        result.add(list, provider);
                                    }
                                    return [3 /*break*/, 4];
                                case 3:
                                    err_1 = _a.sent();
                                    onUnexpectedExternalError(err_1);
                                    return [3 /*break*/, 4];
                                case 4: return [2 /*return*/];
                            }
                        });
                    }); });
                    return [4 /*yield*/, Promise.all(promises)];
                case 1:
                    _a.sent();
                    result.lenses = mergeSort(result.lenses, function (a, b) {
                        // sort by lineNumber, provider-rank, and column
                        if (a.symbol.range.startLineNumber < b.symbol.range.startLineNumber) {
                            return -1;
                        }
                        else if (a.symbol.range.startLineNumber > b.symbol.range.startLineNumber) {
                            return 1;
                        }
                        else if ((providerRanks.get(a.provider)) < (providerRanks.get(b.provider))) {
                            return -1;
                        }
                        else if ((providerRanks.get(a.provider)) > (providerRanks.get(b.provider))) {
                            return 1;
                        }
                        else if (a.symbol.range.startColumn < b.symbol.range.startColumn) {
                            return -1;
                        }
                        else if (a.symbol.range.startColumn > b.symbol.range.startColumn) {
                            return 1;
                        }
                        else {
                            return 0;
                        }
                    });
                    return [2 /*return*/, result];
            }
        });
    });
}
CommandsRegistry.registerCommand('_executeCodeLensProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a = __read(args, 2), uri = _a[0], itemResolveCount = _a[1];
    assertType(URI.isUri(uri));
    assertType(typeof itemResolveCount === 'number' || !itemResolveCount);
    var model = accessor.get(IModelService).getModel(uri);
    if (!model) {
        throw illegalArgument();
    }
    var result = [];
    var disposables = new DisposableStore();
    return getCodeLensModel(model, CancellationToken.None).then(function (value) {
        var e_2, _a;
        disposables.add(value);
        var resolve = [];
        var _loop_1 = function (item) {
            if (itemResolveCount === undefined || itemResolveCount === null || Boolean(item.symbol.command)) {
                result.push(item.symbol);
            }
            else if (itemResolveCount-- > 0 && item.provider.resolveCodeLens) {
                resolve.push(Promise.resolve(item.provider.resolveCodeLens(model, item.symbol, CancellationToken.None)).then(function (symbol) { return result.push(symbol || item.symbol); }));
            }
        };
        try {
            for (var _b = __values(value.lenses), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                _loop_1(item);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return Promise.all(resolve);
    }).then(function () {
        return result;
    }).finally(function () {
        // make sure to return results, then (on next tick)
        // dispose the results
        setTimeout(function () { return disposables.dispose(); }, 100);
    });
});
