/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { localize } from '../../../nls';
import { DisposableStore, Disposable, toDisposable } from '../../../base/common/lifecycle';
import { AbstractEditorNavigationQuickAccessProvider } from './editorNavigationQuickAccess';
import { getCodeEditor } from '../../browser/editorBrowser';
var AbstractGotoLineQuickAccessProvider = /** @class */ (function (_super) {
    __extends(AbstractGotoLineQuickAccessProvider, _super);
    function AbstractGotoLineQuickAccessProvider() {
        return _super.call(this, { canAcceptInBackground: true }) || this;
    }
    AbstractGotoLineQuickAccessProvider.prototype.provideWithoutTextEditor = function (picker) {
        var label = localize('cannotRunGotoLine', "Open a text editor first to go to a line.");
        picker.items = [{ label: label }];
        picker.ariaLabel = label;
        return Disposable.None;
    };
    AbstractGotoLineQuickAccessProvider.prototype.provideWithTextEditor = function (context, picker, token) {
        var _this = this;
        var editor = context.editor;
        var disposables = new DisposableStore();
        // Goto line once picked
        disposables.add(picker.onDidAccept(function (event) {
            var _a = __read(picker.selectedItems, 1), item = _a[0];
            if (item) {
                if (!_this.isValidLineNumber(editor, item.lineNumber)) {
                    return;
                }
                _this.gotoLocation(context, { range: _this.toRange(item.lineNumber, item.column), keyMods: picker.keyMods, preserveFocus: event.inBackground });
                if (!event.inBackground) {
                    picker.hide();
                }
            }
        }));
        // React to picker changes
        var updatePickerAndEditor = function () {
            var position = _this.parsePosition(editor, picker.value.trim().substr(AbstractGotoLineQuickAccessProvider.PREFIX.length));
            var label = _this.getPickLabel(editor, position.lineNumber, position.column);
            // Picker
            picker.items = [{
                    lineNumber: position.lineNumber,
                    column: position.column,
                    label: label
                }];
            // ARIA Label
            picker.ariaLabel = label;
            // Clear decorations for invalid range
            if (!_this.isValidLineNumber(editor, position.lineNumber)) {
                _this.clearDecorations(editor);
                return;
            }
            // Reveal
            var range = _this.toRange(position.lineNumber, position.column);
            editor.revealRangeInCenter(range, 0 /* Smooth */);
            // Decorate
            _this.addDecorations(editor, range);
        };
        updatePickerAndEditor();
        disposables.add(picker.onDidChangeValue(function () { return updatePickerAndEditor(); }));
        // Adjust line number visibility as needed
        var codeEditor = getCodeEditor(editor);
        if (codeEditor) {
            var options = codeEditor.getOptions();
            var lineNumbers = options.get(54 /* lineNumbers */);
            if (lineNumbers.renderType === 2 /* Relative */) {
                codeEditor.updateOptions({ lineNumbers: 'on' });
                disposables.add(toDisposable(function () { return codeEditor.updateOptions({ lineNumbers: 'relative' }); }));
            }
        }
        return disposables;
    };
    AbstractGotoLineQuickAccessProvider.prototype.toRange = function (lineNumber, column) {
        if (lineNumber === void 0) { lineNumber = 1; }
        if (column === void 0) { column = 1; }
        return {
            startLineNumber: lineNumber,
            startColumn: column,
            endLineNumber: lineNumber,
            endColumn: column
        };
    };
    AbstractGotoLineQuickAccessProvider.prototype.parsePosition = function (editor, value) {
        // Support line-col formats of `line,col`, `line:col`, `line#col`
        var numbers = value.split(/,|:|#/).map(function (part) { return parseInt(part, 10); }).filter(function (part) { return !isNaN(part); });
        var endLine = this.lineCount(editor) + 1;
        return {
            lineNumber: numbers[0] > 0 ? numbers[0] : endLine + numbers[0],
            column: numbers[1]
        };
    };
    AbstractGotoLineQuickAccessProvider.prototype.getPickLabel = function (editor, lineNumber, column) {
        // Location valid: indicate this as picker label
        if (this.isValidLineNumber(editor, lineNumber)) {
            if (this.isValidColumn(editor, lineNumber, column)) {
                return localize('gotoLineColumnLabel', "Go to line {0} and column {1}.", lineNumber, column);
            }
            return localize('gotoLineLabel', "Go to line {0}.", lineNumber);
        }
        // Location invalid: show generic label
        var position = editor.getPosition() || { lineNumber: 1, column: 1 };
        var lineCount = this.lineCount(editor);
        if (lineCount > 1) {
            return localize('gotoLineLabelEmptyWithLimit', "Current Line: {0}, Character: {1}. Type a line number between 1 and {2} to navigate to.", position.lineNumber, position.column, lineCount);
        }
        return localize('gotoLineLabelEmpty', "Current Line: {0}, Character: {1}. Type a line number to navigate to.", position.lineNumber, position.column);
    };
    AbstractGotoLineQuickAccessProvider.prototype.isValidLineNumber = function (editor, lineNumber) {
        if (!lineNumber || typeof lineNumber !== 'number') {
            return false;
        }
        return lineNumber > 0 && lineNumber <= this.lineCount(editor);
    };
    AbstractGotoLineQuickAccessProvider.prototype.isValidColumn = function (editor, lineNumber, column) {
        if (!column || typeof column !== 'number') {
            return false;
        }
        var model = this.getModel(editor);
        if (!model) {
            return false;
        }
        var positionCandidate = { lineNumber: lineNumber, column: column };
        return model.validatePosition(positionCandidate).equals(positionCandidate);
    };
    AbstractGotoLineQuickAccessProvider.prototype.lineCount = function (editor) {
        var _a, _b;
        return (_b = (_a = this.getModel(editor)) === null || _a === void 0 ? void 0 : _a.getLineCount()) !== null && _b !== void 0 ? _b : 0;
    };
    AbstractGotoLineQuickAccessProvider.PREFIX = ':';
    return AbstractGotoLineQuickAccessProvider;
}(AbstractEditorNavigationQuickAccessProvider));
export { AbstractGotoLineQuickAccessProvider };
