/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { onUnexpectedExternalError, canceled, isPromiseCanceledError } from '../../../base/common/errors';
import * as modes from '../../common/modes';
import { Position } from '../../common/core/position';
import { RawContextKey } from '../../../platform/contextkey/common/contextkey';
import { CancellationToken } from '../../../base/common/cancellation';
import { Range } from '../../common/core/range';
import { FuzzyScore } from '../../../base/common/filters';
import { isDisposable, DisposableStore } from '../../../base/common/lifecycle';
import { MenuId } from '../../../platform/actions/common/actions';
import { SnippetParser } from '../snippet/snippetParser';
import { StopWatch } from '../../../base/common/stopwatch';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { assertType } from '../../../base/common/types';
import { URI } from '../../../base/common/uri';
import { ITextModelService } from '../../common/services/resolverService';
export var Context = {
    Visible: new RawContextKey('suggestWidgetVisible', false),
    DetailsVisible: new RawContextKey('suggestWidgetDetailsVisible', false),
    MultipleSuggestions: new RawContextKey('suggestWidgetMultipleSuggestions', false),
    MakesTextEdit: new RawContextKey('suggestionMakesTextEdit', true),
    AcceptSuggestionsOnEnter: new RawContextKey('acceptSuggestionOnEnter', true),
    HasInsertAndReplaceRange: new RawContextKey('suggestionHasInsertAndReplaceRange', false),
    InsertMode: new RawContextKey('suggestionInsertMode', undefined),
    CanResolve: new RawContextKey('suggestionCanResolve', false),
};
export var suggestWidgetStatusbarMenu = new MenuId('suggestWidgetStatusBar');
var CompletionItem = /** @class */ (function () {
    function CompletionItem(position, completion, container, provider) {
        this.position = position;
        this.completion = completion;
        this.container = container;
        this.provider = provider;
        // validation
        this.isInvalid = false;
        // sorting, filtering
        this.score = FuzzyScore.Default;
        this.distance = 0;
        this.textLabel = typeof completion.label === 'string'
            ? completion.label
            : completion.label.name;
        // ensure lower-variants (perf)
        this.labelLow = this.textLabel.toLowerCase();
        // validate label
        this.isInvalid = !this.textLabel;
        this.sortTextLow = completion.sortText && completion.sortText.toLowerCase();
        this.filterTextLow = completion.filterText && completion.filterText.toLowerCase();
        // normalize ranges
        if (Range.isIRange(completion.range)) {
            this.editStart = new Position(completion.range.startLineNumber, completion.range.startColumn);
            this.editInsertEnd = new Position(completion.range.endLineNumber, completion.range.endColumn);
            this.editReplaceEnd = new Position(completion.range.endLineNumber, completion.range.endColumn);
            // validate range
            this.isInvalid = this.isInvalid
                || Range.spansMultipleLines(completion.range) || completion.range.startLineNumber !== position.lineNumber;
        }
        else {
            this.editStart = new Position(completion.range.insert.startLineNumber, completion.range.insert.startColumn);
            this.editInsertEnd = new Position(completion.range.insert.endLineNumber, completion.range.insert.endColumn);
            this.editReplaceEnd = new Position(completion.range.replace.endLineNumber, completion.range.replace.endColumn);
            // validate ranges
            this.isInvalid = this.isInvalid
                || Range.spansMultipleLines(completion.range.insert) || Range.spansMultipleLines(completion.range.replace)
                || completion.range.insert.startLineNumber !== position.lineNumber || completion.range.replace.startLineNumber !== position.lineNumber
                || completion.range.insert.startColumn !== completion.range.replace.startColumn;
        }
        // create the suggestion resolver
        if (typeof provider.resolveCompletionItem !== 'function') {
            this._resolveCache = Promise.resolve();
            this._isResolved = true;
        }
    }
    Object.defineProperty(CompletionItem.prototype, "isResolved", {
        // ---- resolving
        get: function () {
            return !!this._isResolved;
        },
        enumerable: false,
        configurable: true
    });
    CompletionItem.prototype.resolve = function (token) {
        return __awaiter(this, void 0, void 0, function () {
            var sub_1;
            var _this = this;
            return __generator(this, function (_a) {
                if (!this._resolveCache) {
                    sub_1 = token.onCancellationRequested(function () {
                        _this._resolveCache = undefined;
                        _this._isResolved = false;
                    });
                    this._resolveCache = Promise.resolve(this.provider.resolveCompletionItem(this.completion, token)).then(function (value) {
                        Object.assign(_this.completion, value);
                        _this._isResolved = true;
                        sub_1.dispose();
                    }, function (err) {
                        if (isPromiseCanceledError(err)) {
                            // the IPC queue will reject the request with the
                            // cancellation error -> reset cached
                            _this._resolveCache = undefined;
                            _this._isResolved = false;
                        }
                    });
                }
                return [2 /*return*/, this._resolveCache];
            });
        });
    };
    return CompletionItem;
}());
export { CompletionItem };
var CompletionOptions = /** @class */ (function () {
    function CompletionOptions(snippetSortOrder, kindFilter, providerFilter) {
        if (snippetSortOrder === void 0) { snippetSortOrder = 2 /* Bottom */; }
        if (kindFilter === void 0) { kindFilter = new Set(); }
        if (providerFilter === void 0) { providerFilter = new Set(); }
        this.snippetSortOrder = snippetSortOrder;
        this.kindFilter = kindFilter;
        this.providerFilter = providerFilter;
    }
    CompletionOptions.default = new CompletionOptions();
    return CompletionOptions;
}());
export { CompletionOptions };
var _snippetSuggestSupport;
export function getSnippetSuggestSupport() {
    return _snippetSuggestSupport;
}
export function setSnippetSuggestSupport(support) {
    var old = _snippetSuggestSupport;
    _snippetSuggestSupport = support;
    return old;
}
var CompletionItemModel = /** @class */ (function () {
    function CompletionItemModel(items, needsClipboard, durations, disposable) {
        this.items = items;
        this.needsClipboard = needsClipboard;
        this.durations = durations;
        this.disposable = disposable;
    }
    return CompletionItemModel;
}());
export { CompletionItemModel };
export function provideSuggestionItems(model, position, options, context, token) {
    if (options === void 0) { options = CompletionOptions.default; }
    if (context === void 0) { context = { triggerKind: 0 /* Invoke */ }; }
    if (token === void 0) { token = CancellationToken.None; }
    return __awaiter(this, void 0, void 0, function () {
        var sw, word, defaultReplaceRange, defaultRange, result, disposables, durations, needsClipboard, onCompletionList, snippetCompletions, _a, _b, providerGroup, lenBefore, e_1_1;
        var e_1, _c;
        var _this = this;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    sw = new StopWatch(true);
                    position = position.clone();
                    word = model.getWordAtPosition(position);
                    defaultReplaceRange = word ? new Range(position.lineNumber, word.startColumn, position.lineNumber, word.endColumn) : Range.fromPositions(position);
                    defaultRange = { replace: defaultReplaceRange, insert: defaultReplaceRange.setEndPosition(position.lineNumber, position.column) };
                    result = [];
                    disposables = new DisposableStore();
                    durations = [];
                    needsClipboard = false;
                    onCompletionList = function (provider, container, sw) {
                        var e_2, _a;
                        var _b, _c;
                        if (!container) {
                            return;
                        }
                        try {
                            for (var _d = __values(container.suggestions), _e = _d.next(); !_e.done; _e = _d.next()) {
                                var suggestion = _e.value;
                                if (!options.kindFilter.has(suggestion.kind)) {
                                    // fill in default range when missing
                                    if (!suggestion.range) {
                                        suggestion.range = defaultRange;
                                    }
                                    // fill in default sortText when missing
                                    if (!suggestion.sortText) {
                                        suggestion.sortText = typeof suggestion.label === 'string' ? suggestion.label : suggestion.label.name;
                                    }
                                    if (!needsClipboard && suggestion.insertTextRules && suggestion.insertTextRules & 4 /* InsertAsSnippet */) {
                                        needsClipboard = SnippetParser.guessNeedsClipboard(suggestion.insertText);
                                    }
                                    result.push(new CompletionItem(position, suggestion, container, provider));
                                }
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                        if (isDisposable(container)) {
                            disposables.add(container);
                        }
                        durations.push({
                            providerName: (_b = provider._debugDisplayName) !== null && _b !== void 0 ? _b : 'unkown_provider', elapsedProvider: (_c = container.duration) !== null && _c !== void 0 ? _c : -1,
                            elapsedOverall: sw.elapsed()
                        });
                    };
                    snippetCompletions = (function () { return __awaiter(_this, void 0, void 0, function () {
                        var sw, list;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    if (!_snippetSuggestSupport || options.kindFilter.has(27 /* Snippet */)) {
                                        return [2 /*return*/];
                                    }
                                    if (options.providerFilter.size > 0 && !options.providerFilter.has(_snippetSuggestSupport)) {
                                        return [2 /*return*/];
                                    }
                                    sw = new StopWatch(true);
                                    return [4 /*yield*/, _snippetSuggestSupport.provideCompletionItems(model, position, context, token)];
                                case 1:
                                    list = _a.sent();
                                    onCompletionList(_snippetSuggestSupport, list, sw);
                                    return [2 /*return*/];
                            }
                        });
                    }); })();
                    _d.label = 1;
                case 1:
                    _d.trys.push([1, 6, 7, 8]);
                    _a = __values(modes.CompletionProviderRegistry.orderedGroups(model)), _b = _a.next();
                    _d.label = 2;
                case 2:
                    if (!!_b.done) return [3 /*break*/, 5];
                    providerGroup = _b.value;
                    lenBefore = result.length;
                    return [4 /*yield*/, Promise.all(providerGroup.map(function (provider) { return __awaiter(_this, void 0, void 0, function () {
                            var sw_1, list, err_1;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        if (options.providerFilter.size > 0 && !options.providerFilter.has(provider)) {
                                            return [2 /*return*/];
                                        }
                                        _a.label = 1;
                                    case 1:
                                        _a.trys.push([1, 3, , 4]);
                                        sw_1 = new StopWatch(true);
                                        return [4 /*yield*/, provider.provideCompletionItems(model, position, context, token)];
                                    case 2:
                                        list = _a.sent();
                                        onCompletionList(provider, list, sw_1);
                                        return [3 /*break*/, 4];
                                    case 3:
                                        err_1 = _a.sent();
                                        onUnexpectedExternalError(err_1);
                                        return [3 /*break*/, 4];
                                    case 4: return [2 /*return*/];
                                }
                            });
                        }); }))];
                case 3:
                    _d.sent();
                    if (lenBefore !== result.length || token.isCancellationRequested) {
                        return [3 /*break*/, 5];
                    }
                    _d.label = 4;
                case 4:
                    _b = _a.next();
                    return [3 /*break*/, 2];
                case 5: return [3 /*break*/, 8];
                case 6:
                    e_1_1 = _d.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 8];
                case 7:
                    try {
                        if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 8: return [4 /*yield*/, snippetCompletions];
                case 9:
                    _d.sent();
                    if (token.isCancellationRequested) {
                        disposables.dispose();
                        return [2 /*return*/, Promise.reject(canceled())];
                    }
                    return [2 /*return*/, new CompletionItemModel(result.sort(getSuggestionComparator(options.snippetSortOrder)), needsClipboard, { entries: durations, elapsed: sw.elapsed() }, disposables)];
            }
        });
    });
}
function defaultComparator(a, b) {
    // check with 'sortText'
    if (a.sortTextLow && b.sortTextLow) {
        if (a.sortTextLow < b.sortTextLow) {
            return -1;
        }
        else if (a.sortTextLow > b.sortTextLow) {
            return 1;
        }
    }
    // check with 'label'
    if (a.completion.label < b.completion.label) {
        return -1;
    }
    else if (a.completion.label > b.completion.label) {
        return 1;
    }
    // check with 'type'
    return a.completion.kind - b.completion.kind;
}
function snippetUpComparator(a, b) {
    if (a.completion.kind !== b.completion.kind) {
        if (a.completion.kind === 27 /* Snippet */) {
            return -1;
        }
        else if (b.completion.kind === 27 /* Snippet */) {
            return 1;
        }
    }
    return defaultComparator(a, b);
}
function snippetDownComparator(a, b) {
    if (a.completion.kind !== b.completion.kind) {
        if (a.completion.kind === 27 /* Snippet */) {
            return 1;
        }
        else if (b.completion.kind === 27 /* Snippet */) {
            return -1;
        }
    }
    return defaultComparator(a, b);
}
var _snippetComparators = new Map();
_snippetComparators.set(0 /* Top */, snippetUpComparator);
_snippetComparators.set(2 /* Bottom */, snippetDownComparator);
_snippetComparators.set(1 /* Inline */, defaultComparator);
export function getSuggestionComparator(snippetConfig) {
    return _snippetComparators.get(snippetConfig);
}
CommandsRegistry.registerCommand('_executeCompletionItemProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, position, triggerCharacter, maxItemsToResolve, ref, result, resolving, completions_1, _b, _c, item;
        var e_3, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    _a = __read(args, 4), uri = _a[0], position = _a[1], triggerCharacter = _a[2], maxItemsToResolve = _a[3];
                    assertType(URI.isUri(uri));
                    assertType(Position.isIPosition(position));
                    assertType(typeof triggerCharacter === 'string' || !triggerCharacter);
                    assertType(typeof maxItemsToResolve === 'number' || !maxItemsToResolve);
                    return [4 /*yield*/, accessor.get(ITextModelService).createModelReference(uri)];
                case 1:
                    ref = _e.sent();
                    _e.label = 2;
                case 2:
                    _e.trys.push([2, , 8, 9]);
                    result = {
                        incomplete: false,
                        suggestions: []
                    };
                    resolving = [];
                    return [4 /*yield*/, provideSuggestionItems(ref.object.textEditorModel, Position.lift(position), undefined, { triggerCharacter: triggerCharacter, triggerKind: triggerCharacter ? 1 /* TriggerCharacter */ : 0 /* Invoke */ })];
                case 3:
                    completions_1 = _e.sent();
                    try {
                        for (_b = __values(completions_1.items), _c = _b.next(); !_c.done; _c = _b.next()) {
                            item = _c.value;
                            if (resolving.length < (maxItemsToResolve !== null && maxItemsToResolve !== void 0 ? maxItemsToResolve : 0)) {
                                resolving.push(item.resolve(CancellationToken.None));
                            }
                            result.incomplete = result.incomplete || item.container.incomplete;
                            result.suggestions.push(item.completion);
                        }
                    }
                    catch (e_3_1) { e_3 = { error: e_3_1 }; }
                    finally {
                        try {
                            if (_c && !_c.done && (_d = _b.return)) _d.call(_b);
                        }
                        finally { if (e_3) throw e_3.error; }
                    }
                    _e.label = 4;
                case 4:
                    _e.trys.push([4, , 6, 7]);
                    return [4 /*yield*/, Promise.all(resolving)];
                case 5:
                    _e.sent();
                    return [2 /*return*/, result];
                case 6:
                    setTimeout(function () { return completions_1.disposable.dispose(); }, 100);
                    return [7 /*endfinally*/];
                case 7: return [3 /*break*/, 9];
                case 8:
                    ref.dispose();
                    return [7 /*endfinally*/];
                case 9: return [2 /*return*/];
            }
        });
    });
});
var _provider = new /** @class */ (function () {
    function class_1() {
        this.onlyOnceSuggestions = [];
    }
    class_1.prototype.provideCompletionItems = function () {
        var suggestions = this.onlyOnceSuggestions.slice(0);
        var result = { suggestions: suggestions };
        this.onlyOnceSuggestions.length = 0;
        return result;
    };
    return class_1;
}());
modes.CompletionProviderRegistry.register('*', _provider);
export function showSimpleSuggestions(editor, suggestions) {
    setTimeout(function () {
        var _a;
        (_a = _provider.onlyOnceSuggestions).push.apply(_a, __spreadArray([], __read(suggestions)));
        editor.getContribution('editor.contrib.suggestController').triggerSuggest(new Set().add(_provider));
    }, 0);
}
