/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { RunOnceScheduler } from '../../../base/common/async';
import { Emitter } from '../../../base/common/event';
import { DisposableStore } from '../../../base/common/lifecycle';
import { IMenuService, isIMenuItem, MenuItemAction, MenuRegistry, SubmenuItemAction } from './actions';
import { ICommandService } from '../../commands/common/commands';
import { IContextKeyService } from '../../contextkey/common/contextkey';
var MenuService = /** @class */ (function () {
    function MenuService(_commandService) {
        this._commandService = _commandService;
        //
    }
    /**
     * Create a new menu for the given menu identifier. A menu sends events when it's entries
     * have changed (placement, enablement, checked-state). By default it does send events for
     * sub menu entries. That is more expensive and must be explicitly enabled with the
     * `emitEventsForSubmenuChanges` flag.
     */
    MenuService.prototype.createMenu = function (id, contextKeyService, emitEventsForSubmenuChanges) {
        if (emitEventsForSubmenuChanges === void 0) { emitEventsForSubmenuChanges = false; }
        return new Menu(id, emitEventsForSubmenuChanges, this._commandService, contextKeyService, this);
    };
    MenuService = __decorate([
        __param(0, ICommandService)
    ], MenuService);
    return MenuService;
}());
export { MenuService };
var Menu = /** @class */ (function () {
    function Menu(_id, _fireEventsForSubmenuChanges, _commandService, _contextKeyService, _menuService) {
        var _this = this;
        this._id = _id;
        this._fireEventsForSubmenuChanges = _fireEventsForSubmenuChanges;
        this._commandService = _commandService;
        this._contextKeyService = _contextKeyService;
        this._menuService = _menuService;
        this._dispoables = new DisposableStore();
        this._onDidChange = new Emitter();
        this.onDidChange = this._onDidChange.event;
        this._menuGroups = [];
        this._contextKeys = new Set();
        this._build();
        // rebuild this menu whenever the menu registry reports an
        // event for this MenuId
        var rebuildMenuSoon = new RunOnceScheduler(function () { return _this._build(); }, 50);
        this._dispoables.add(rebuildMenuSoon);
        this._dispoables.add(MenuRegistry.onDidChangeMenu(function (e) {
            if (e.has(_id)) {
                rebuildMenuSoon.schedule();
            }
        }));
        // when context keys change we need to check if the menu also
        // has changed
        var fireChangeSoon = new RunOnceScheduler(function () { return _this._onDidChange.fire(_this); }, 50);
        this._dispoables.add(fireChangeSoon);
        this._dispoables.add(_contextKeyService.onDidChangeContext(function (e) {
            if (e.affectsSome(_this._contextKeys)) {
                fireChangeSoon.schedule();
            }
        }));
    }
    Menu.prototype.dispose = function () {
        this._dispoables.dispose();
        this._onDidChange.dispose();
    };
    Menu.prototype._build = function () {
        var e_1, _a;
        // reset
        this._menuGroups.length = 0;
        this._contextKeys.clear();
        var menuItems = MenuRegistry.getMenuItems(this._id);
        var group;
        menuItems.sort(Menu._compareMenuItems);
        try {
            for (var menuItems_1 = __values(menuItems), menuItems_1_1 = menuItems_1.next(); !menuItems_1_1.done; menuItems_1_1 = menuItems_1.next()) {
                var item = menuItems_1_1.value;
                // group by groupId
                var groupName = item.group || '';
                if (!group || group[0] !== groupName) {
                    group = [groupName, []];
                    this._menuGroups.push(group);
                }
                group[1].push(item);
                // keep keys for eventing
                this._collectContextKeys(item);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (menuItems_1_1 && !menuItems_1_1.done && (_a = menuItems_1.return)) _a.call(menuItems_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._onDidChange.fire(this);
    };
    Menu.prototype._collectContextKeys = function (item) {
        Menu._fillInKbExprKeys(item.when, this._contextKeys);
        if (isIMenuItem(item)) {
            // keep precondition keys for event if applicable
            if (item.command.precondition) {
                Menu._fillInKbExprKeys(item.command.precondition, this._contextKeys);
            }
            // keep toggled keys for event if applicable
            if (item.command.toggled) {
                var toggledExpression = item.command.toggled.condition || item.command.toggled;
                Menu._fillInKbExprKeys(toggledExpression, this._contextKeys);
            }
        }
        else if (this._fireEventsForSubmenuChanges) {
            // recursively collect context keys from submenus so that this
            // menu fires events when context key changes affect submenus
            MenuRegistry.getMenuItems(item.submenu).forEach(this._collectContextKeys, this);
        }
    };
    Menu.prototype.getActions = function (options) {
        var e_2, _a, e_3, _b;
        var result = [];
        try {
            for (var _c = __values(this._menuGroups), _d = _c.next(); !_d.done; _d = _c.next()) {
                var group = _d.value;
                var _e = __read(group, 2), id = _e[0], items = _e[1];
                var activeActions = [];
                try {
                    for (var items_1 = (e_3 = void 0, __values(items)), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                        var item = items_1_1.value;
                        if (this._contextKeyService.contextMatchesRules(item.when)) {
                            var action = isIMenuItem(item)
                                ? new MenuItemAction(item.command, item.alt, options, this._contextKeyService, this._commandService)
                                : new SubmenuItemAction(item, this._menuService, this._contextKeyService, options);
                            activeActions.push(action);
                        }
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (items_1_1 && !items_1_1.done && (_b = items_1.return)) _b.call(items_1);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                if (activeActions.length > 0) {
                    result.push([id, activeActions]);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return result;
    };
    Menu._fillInKbExprKeys = function (exp, set) {
        var e_4, _a;
        if (exp) {
            try {
                for (var _b = __values(exp.keys()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var key = _c.value;
                    set.add(key);
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_4) throw e_4.error; }
            }
        }
    };
    Menu._compareMenuItems = function (a, b) {
        var aGroup = a.group;
        var bGroup = b.group;
        if (aGroup !== bGroup) {
            // Falsy groups come last
            if (!aGroup) {
                return 1;
            }
            else if (!bGroup) {
                return -1;
            }
            // 'navigation' group comes first
            if (aGroup === 'navigation') {
                return -1;
            }
            else if (bGroup === 'navigation') {
                return 1;
            }
            // lexical sort for groups
            var value = aGroup.localeCompare(bGroup);
            if (value !== 0) {
                return value;
            }
        }
        // sort on priority - default is 0
        var aPrio = a.order || 0;
        var bPrio = b.order || 0;
        if (aPrio < bPrio) {
            return -1;
        }
        else if (aPrio > bPrio) {
            return 1;
        }
        // sort on titles
        return Menu._compareTitles(isIMenuItem(a) ? a.command.title : a.title, isIMenuItem(b) ? b.command.title : b.title);
    };
    Menu._compareTitles = function (a, b) {
        var aStr = typeof a === 'string' ? a : a.original;
        var bStr = typeof b === 'string' ? b : b.original;
        return aStr.localeCompare(bStr);
    };
    Menu = __decorate([
        __param(2, ICommandService),
        __param(3, IContextKeyService),
        __param(4, IMenuService)
    ], Menu);
    return Menu;
}());
