/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import * as nls from '../../../nls';
import * as arrays from '../../../base/common/arrays';
import { IntervalTimer, TimeoutTimer } from '../../../base/common/async';
import { Emitter, Event } from '../../../base/common/event';
import { Disposable } from '../../../base/common/lifecycle';
var AbstractKeybindingService = /** @class */ (function (_super) {
    __extends(AbstractKeybindingService, _super);
    function AbstractKeybindingService(_contextKeyService, _commandService, _telemetryService, _notificationService, _logService) {
        var _this = _super.call(this) || this;
        _this._contextKeyService = _contextKeyService;
        _this._commandService = _commandService;
        _this._telemetryService = _telemetryService;
        _this._notificationService = _notificationService;
        _this._logService = _logService;
        _this._onDidUpdateKeybindings = _this._register(new Emitter());
        _this._currentChord = null;
        _this._currentChordChecker = new IntervalTimer();
        _this._currentChordStatusMessage = null;
        _this._currentSingleModifier = null;
        _this._currentSingleModifierClearTimeout = new TimeoutTimer();
        _this._logging = false;
        return _this;
    }
    Object.defineProperty(AbstractKeybindingService.prototype, "onDidUpdateKeybindings", {
        get: function () {
            return this._onDidUpdateKeybindings ? this._onDidUpdateKeybindings.event : Event.None; // Sinon stubbing walks properties on prototype
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractKeybindingService.prototype, "inChordMode", {
        get: function () {
            return !!this._currentChord;
        },
        enumerable: false,
        configurable: true
    });
    AbstractKeybindingService.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
    };
    AbstractKeybindingService.prototype.getDefaultKeybindingsContent = function () {
        return '';
    };
    AbstractKeybindingService.prototype.toggleLogging = function () {
        this._logging = !this._logging;
        return this._logging;
    };
    AbstractKeybindingService.prototype._log = function (str) {
        if (this._logging) {
            this._logService.info("[KeybindingService]: " + str);
        }
    };
    AbstractKeybindingService.prototype.getDefaultKeybindings = function () {
        return this._getResolver().getDefaultKeybindings();
    };
    AbstractKeybindingService.prototype.getKeybindings = function () {
        return this._getResolver().getKeybindings();
    };
    AbstractKeybindingService.prototype.customKeybindingsCount = function () {
        return 0;
    };
    AbstractKeybindingService.prototype.lookupKeybindings = function (commandId) {
        return arrays.coalesce(this._getResolver().lookupKeybindings(commandId).map(function (item) { return item.resolvedKeybinding; }));
    };
    AbstractKeybindingService.prototype.lookupKeybinding = function (commandId) {
        var result = this._getResolver().lookupPrimaryKeybinding(commandId);
        if (!result) {
            return undefined;
        }
        return result.resolvedKeybinding;
    };
    AbstractKeybindingService.prototype.dispatchEvent = function (e, target) {
        return this._dispatch(e, target);
    };
    AbstractKeybindingService.prototype.softDispatch = function (e, target) {
        var keybinding = this.resolveKeyboardEvent(e);
        if (keybinding.isChord()) {
            console.warn('Unexpected keyboard event mapped to a chord');
            return null;
        }
        var _a = __read(keybinding.getDispatchParts(), 1), firstPart = _a[0];
        if (firstPart === null) {
            // cannot be dispatched, probably only modifier keys
            return null;
        }
        var contextValue = this._contextKeyService.getContext(target);
        var currentChord = this._currentChord ? this._currentChord.keypress : null;
        return this._getResolver().resolve(contextValue, currentChord, firstPart);
    };
    AbstractKeybindingService.prototype._enterChordMode = function (firstPart, keypressLabel) {
        var _this = this;
        this._currentChord = {
            keypress: firstPart,
            label: keypressLabel
        };
        this._currentChordStatusMessage = this._notificationService.status(nls.localize('first.chord', "({0}) was pressed. Waiting for second key of chord...", keypressLabel));
        var chordEnterTime = Date.now();
        this._currentChordChecker.cancelAndSet(function () {
            if (!_this._documentHasFocus()) {
                // Focus has been lost => leave chord mode
                _this._leaveChordMode();
                return;
            }
            if (Date.now() - chordEnterTime > 5000) {
                // 5 seconds elapsed => leave chord mode
                _this._leaveChordMode();
            }
        }, 500);
    };
    AbstractKeybindingService.prototype._leaveChordMode = function () {
        if (this._currentChordStatusMessage) {
            this._currentChordStatusMessage.dispose();
            this._currentChordStatusMessage = null;
        }
        this._currentChordChecker.cancel();
        this._currentChord = null;
    };
    AbstractKeybindingService.prototype.dispatchByUserSettingsLabel = function (userSettingsLabel, target) {
        var keybindings = this.resolveUserBinding(userSettingsLabel);
        if (keybindings.length >= 1) {
            this._doDispatch(keybindings[0], target, /*isSingleModiferChord*/ false);
        }
    };
    AbstractKeybindingService.prototype._dispatch = function (e, target) {
        return this._doDispatch(this.resolveKeyboardEvent(e), target, /*isSingleModiferChord*/ false);
    };
    AbstractKeybindingService.prototype._singleModifierDispatch = function (e, target) {
        var _this = this;
        var keybinding = this.resolveKeyboardEvent(e);
        var _a = __read(keybinding.getSingleModifierDispatchParts(), 1), singleModifier = _a[0];
        if (singleModifier !== null && this._currentSingleModifier === null) {
            // we have a valid `singleModifier`, store it for the next keyup, but clear it in 300ms
            this._log("+ Storing single modifier for possible chord " + singleModifier + ".");
            this._currentSingleModifier = singleModifier;
            this._currentSingleModifierClearTimeout.cancelAndSet(function () {
                _this._log("+ Clearing single modifier due to 300ms elapsed.");
                _this._currentSingleModifier = null;
            }, 300);
            return false;
        }
        if (singleModifier !== null && singleModifier === this._currentSingleModifier) {
            // bingo!
            this._log("/ Dispatching single modifier chord " + singleModifier + " " + singleModifier);
            this._currentSingleModifierClearTimeout.cancel();
            this._currentSingleModifier = null;
            return this._doDispatch(keybinding, target, /*isSingleModiferChord*/ true);
        }
        this._currentSingleModifierClearTimeout.cancel();
        this._currentSingleModifier = null;
        return false;
    };
    AbstractKeybindingService.prototype._doDispatch = function (keybinding, target, isSingleModiferChord) {
        var _a;
        var _this = this;
        if (isSingleModiferChord === void 0) { isSingleModiferChord = false; }
        var shouldPreventDefault = false;
        if (keybinding.isChord()) {
            console.warn('Unexpected keyboard event mapped to a chord');
            return false;
        }
        var firstPart = null; // the first keybinding i.e. Ctrl+K
        var currentChord = null; // the "second" keybinding i.e. Ctrl+K "Ctrl+D"
        if (isSingleModiferChord) {
            var _b = __read(keybinding.getSingleModifierDispatchParts(), 1), dispatchKeyname = _b[0];
            firstPart = dispatchKeyname;
            currentChord = dispatchKeyname;
        }
        else {
            _a = __read(keybinding.getDispatchParts(), 1), firstPart = _a[0];
            currentChord = this._currentChord ? this._currentChord.keypress : null;
        }
        if (firstPart === null) {
            this._log("\\ Keyboard event cannot be dispatched in keydown phase.");
            // cannot be dispatched, probably only modifier keys
            return shouldPreventDefault;
        }
        var contextValue = this._contextKeyService.getContext(target);
        var keypressLabel = keybinding.getLabel();
        var resolveResult = this._getResolver().resolve(contextValue, currentChord, firstPart);
        this._logService.trace('KeybindingService#dispatch', keypressLabel, resolveResult === null || resolveResult === void 0 ? void 0 : resolveResult.commandId);
        if (resolveResult && resolveResult.enterChord) {
            shouldPreventDefault = true;
            this._enterChordMode(firstPart, keypressLabel);
            return shouldPreventDefault;
        }
        if (this._currentChord) {
            if (!resolveResult || !resolveResult.commandId) {
                this._notificationService.status(nls.localize('missing.chord', "The key combination ({0}, {1}) is not a command.", this._currentChord.label, keypressLabel), { hideAfter: 10 * 1000 /* 10s */ });
                shouldPreventDefault = true;
            }
        }
        this._leaveChordMode();
        if (resolveResult && resolveResult.commandId) {
            if (!resolveResult.bubble) {
                shouldPreventDefault = true;
            }
            if (typeof resolveResult.commandArgs === 'undefined') {
                this._commandService.executeCommand(resolveResult.commandId).then(undefined, function (err) { return _this._notificationService.warn(err); });
            }
            else {
                this._commandService.executeCommand(resolveResult.commandId, resolveResult.commandArgs).then(undefined, function (err) { return _this._notificationService.warn(err); });
            }
            this._telemetryService.publicLog2('workbenchActionExecuted', { id: resolveResult.commandId, from: 'keybinding' });
        }
        return shouldPreventDefault;
    };
    AbstractKeybindingService.prototype.mightProducePrintableCharacter = function (event) {
        if (event.ctrlKey || event.metaKey) {
            // ignore ctrl/cmd-combination but not shift/alt-combinatios
            return false;
        }
        // weak check for certain ranges. this is properly implemented in a subclass
        // with access to the KeyboardMapperFactory.
        if ((event.keyCode >= 31 /* KEY_A */ && event.keyCode <= 56 /* KEY_Z */)
            || (event.keyCode >= 21 /* KEY_0 */ && event.keyCode <= 30 /* KEY_9 */)) {
            return true;
        }
        return false;
    };
    return AbstractKeybindingService;
}(Disposable));
export { AbstractKeybindingService };
