/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var _a;
import { createStyleSheet } from '../../../base/browser/dom';
import { PagedList } from '../../../base/browser/ui/list/listPaging';
import { DefaultStyleController, isSelectionRangeChangeEvent, isSelectionSingleChangeEvent, List } from '../../../base/browser/ui/list/listWidget';
import { Emitter, Event } from '../../../base/common/event';
import { Disposable, dispose, toDisposable, DisposableStore, combinedDisposable } from '../../../base/common/lifecycle';
import { localize } from '../../../nls';
import { IConfigurationService } from '../../configuration/common/configuration';
import { Extensions as ConfigurationExtensions } from '../../configuration/common/configurationRegistry';
import { ContextKeyExpr, IContextKeyService, RawContextKey } from '../../contextkey/common/contextkey';
import { createDecorator } from '../../instantiation/common/instantiation';
import { IKeybindingService } from '../../keybinding/common/keybinding';
import { Registry } from '../../registry/common/platform';
import { attachListStyler, computeStyles, defaultListStyles } from '../../theme/common/styler';
import { IThemeService } from '../../theme/common/themeService';
import { InputFocusedContextKey } from '../../contextkey/common/contextkeys';
import { ObjectTree, CompressibleObjectTree } from '../../../base/browser/ui/tree/objectTree';
import { AsyncDataTree, CompressibleAsyncDataTree } from '../../../base/browser/ui/tree/asyncDataTree';
import { DataTree } from '../../../base/browser/ui/tree/dataTree';
import { IAccessibilityService } from '../../accessibility/common/accessibility';
import { Table } from '../../../base/browser/ui/table/tableWidget';
export var IListService = createDecorator('listService');
var ListService = /** @class */ (function () {
    function ListService(_themeService) {
        this._themeService = _themeService;
        this.disposables = new DisposableStore();
        this.lists = [];
        this._lastFocusedWidget = undefined;
        this._hasCreatedStyleController = false;
    }
    Object.defineProperty(ListService.prototype, "lastFocusedList", {
        get: function () {
            return this._lastFocusedWidget;
        },
        enumerable: false,
        configurable: true
    });
    ListService.prototype.register = function (widget, extraContextKeys) {
        var _this = this;
        if (!this._hasCreatedStyleController) {
            this._hasCreatedStyleController = true;
            // create a shared default tree style sheet for performance reasons
            var styleController = new DefaultStyleController(createStyleSheet(), '');
            this.disposables.add(attachListStyler(styleController, this._themeService));
        }
        if (this.lists.some(function (l) { return l.widget === widget; })) {
            throw new Error('Cannot register the same widget multiple times');
        }
        // Keep in our lists list
        var registeredList = { widget: widget, extraContextKeys: extraContextKeys };
        this.lists.push(registeredList);
        // Check for currently being focused
        if (widget.getHTMLElement() === document.activeElement) {
            this._lastFocusedWidget = widget;
        }
        return combinedDisposable(widget.onDidFocus(function () { return _this._lastFocusedWidget = widget; }), toDisposable(function () { return _this.lists.splice(_this.lists.indexOf(registeredList), 1); }), widget.onDidDispose(function () {
            _this.lists = _this.lists.filter(function (l) { return l !== registeredList; });
            if (_this._lastFocusedWidget === widget) {
                _this._lastFocusedWidget = undefined;
            }
        }));
    };
    ListService.prototype.dispose = function () {
        this.disposables.dispose();
    };
    ListService = __decorate([
        __param(0, IThemeService)
    ], ListService);
    return ListService;
}());
export { ListService };
var RawWorkbenchListFocusContextKey = new RawContextKey('listFocus', true);
export var WorkbenchListSupportsMultiSelectContextKey = new RawContextKey('listSupportsMultiselect', true);
export var WorkbenchListFocusContextKey = ContextKeyExpr.and(RawWorkbenchListFocusContextKey, ContextKeyExpr.not(InputFocusedContextKey));
export var WorkbenchListHasSelectionOrFocus = new RawContextKey('listHasSelectionOrFocus', false);
export var WorkbenchListDoubleSelection = new RawContextKey('listDoubleSelection', false);
export var WorkbenchListMultiSelection = new RawContextKey('listMultiSelection', false);
export var WorkbenchListSupportsKeyboardNavigation = new RawContextKey('listSupportsKeyboardNavigation', true);
export var WorkbenchListAutomaticKeyboardNavigationKey = 'listAutomaticKeyboardNavigation';
export var WorkbenchListAutomaticKeyboardNavigation = new RawContextKey(WorkbenchListAutomaticKeyboardNavigationKey, true);
export var didBindWorkbenchListAutomaticKeyboardNavigation = false;
function createScopedContextKeyService(contextKeyService, widget) {
    var result = contextKeyService.createScoped(widget.getHTMLElement());
    RawWorkbenchListFocusContextKey.bindTo(result);
    return result;
}
var multiSelectModifierSettingKey = 'workbench.list.multiSelectModifier';
var openModeSettingKey = 'workbench.list.openMode';
var horizontalScrollingKey = 'workbench.list.horizontalScrolling';
var keyboardNavigationSettingKey = 'workbench.list.keyboardNavigation';
var automaticKeyboardNavigationSettingKey = 'workbench.list.automaticKeyboardNavigation';
var treeIndentKey = 'workbench.tree.indent';
var treeRenderIndentGuidesKey = 'workbench.tree.renderIndentGuides';
var listSmoothScrolling = 'workbench.list.smoothScrolling';
var treeExpandMode = 'workbench.tree.expandMode';
function useAltAsMultipleSelectionModifier(configurationService) {
    return configurationService.getValue(multiSelectModifierSettingKey) === 'alt';
}
var MultipleSelectionController = /** @class */ (function (_super) {
    __extends(MultipleSelectionController, _super);
    function MultipleSelectionController(configurationService) {
        var _this = _super.call(this) || this;
        _this.configurationService = configurationService;
        _this.useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
        _this.registerListeners();
        return _this;
    }
    MultipleSelectionController.prototype.registerListeners = function () {
        var _this = this;
        this._register(this.configurationService.onDidChangeConfiguration(function (e) {
            if (e.affectsConfiguration(multiSelectModifierSettingKey)) {
                _this.useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(_this.configurationService);
            }
        }));
    };
    MultipleSelectionController.prototype.isSelectionSingleChangeEvent = function (event) {
        if (this.useAltAsMultipleSelectionModifier) {
            return event.browserEvent.altKey;
        }
        return isSelectionSingleChangeEvent(event);
    };
    MultipleSelectionController.prototype.isSelectionRangeChangeEvent = function (event) {
        return isSelectionRangeChangeEvent(event);
    };
    return MultipleSelectionController;
}(Disposable));
function toWorkbenchListOptions(options, configurationService, keybindingService) {
    var disposables = new DisposableStore();
    var result = __assign({}, options);
    if (options.multipleSelectionSupport !== false && !options.multipleSelectionController) {
        var multipleSelectionController = new MultipleSelectionController(configurationService);
        result.multipleSelectionController = multipleSelectionController;
        disposables.add(multipleSelectionController);
    }
    result.keyboardNavigationDelegate = {
        mightProducePrintableCharacter: function (e) {
            return keybindingService.mightProducePrintableCharacter(e);
        }
    };
    result.smoothScrolling = configurationService.getValue(listSmoothScrolling);
    return [result, disposables];
}
var WorkbenchList = /** @class */ (function (_super) {
    __extends(WorkbenchList, _super);
    function WorkbenchList(user, container, delegate, renderers, options, contextKeyService, listService, themeService, configurationService, keybindingService) {
        var _this = this;
        var horizontalScrolling = typeof options.horizontalScrolling !== 'undefined' ? options.horizontalScrolling : configurationService.getValue(horizontalScrollingKey);
        var _a = __read(toWorkbenchListOptions(options, configurationService, keybindingService), 2), workbenchListOptions = _a[0], workbenchListOptionsDisposable = _a[1];
        _this = _super.call(this, user, container, delegate, renderers, __assign(__assign(__assign({ keyboardSupport: false }, computeStyles(themeService.getColorTheme(), defaultListStyles)), workbenchListOptions), { horizontalScrolling: horizontalScrolling })) || this;
        _this.disposables.add(workbenchListOptionsDisposable);
        _this.contextKeyService = createScopedContextKeyService(contextKeyService, _this);
        _this.themeService = themeService;
        var listSupportsMultiSelect = WorkbenchListSupportsMultiSelectContextKey.bindTo(_this.contextKeyService);
        listSupportsMultiSelect.set(!(options.multipleSelectionSupport === false));
        _this.listHasSelectionOrFocus = WorkbenchListHasSelectionOrFocus.bindTo(_this.contextKeyService);
        _this.listDoubleSelection = WorkbenchListDoubleSelection.bindTo(_this.contextKeyService);
        _this.listMultiSelection = WorkbenchListMultiSelection.bindTo(_this.contextKeyService);
        _this.horizontalScrolling = options.horizontalScrolling;
        _this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
        _this.disposables.add(_this.contextKeyService);
        _this.disposables.add(listService.register(_this));
        if (options.overrideStyles) {
            _this.updateStyles(options.overrideStyles);
        }
        _this.disposables.add(_this.onDidChangeSelection(function () {
            var selection = _this.getSelection();
            var focus = _this.getFocus();
            _this.contextKeyService.bufferChangeEvents(function () {
                _this.listHasSelectionOrFocus.set(selection.length > 0 || focus.length > 0);
                _this.listMultiSelection.set(selection.length > 1);
                _this.listDoubleSelection.set(selection.length === 2);
            });
        }));
        _this.disposables.add(_this.onDidChangeFocus(function () {
            var selection = _this.getSelection();
            var focus = _this.getFocus();
            _this.listHasSelectionOrFocus.set(selection.length > 0 || focus.length > 0);
        }));
        _this.disposables.add(configurationService.onDidChangeConfiguration(function (e) {
            if (e.affectsConfiguration(multiSelectModifierSettingKey)) {
                _this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
            }
            var options = {};
            if (e.affectsConfiguration(horizontalScrollingKey) && _this.horizontalScrolling === undefined) {
                var horizontalScrolling_1 = configurationService.getValue(horizontalScrollingKey);
                options = __assign(__assign({}, options), { horizontalScrolling: horizontalScrolling_1 });
            }
            if (e.affectsConfiguration(listSmoothScrolling)) {
                var smoothScrolling = configurationService.getValue(listSmoothScrolling);
                options = __assign(__assign({}, options), { smoothScrolling: smoothScrolling });
            }
            if (Object.keys(options).length > 0) {
                _this.updateOptions(options);
            }
        }));
        _this.navigator = new ListResourceNavigator(_this, __assign({ configurationService: configurationService }, options));
        _this.disposables.add(_this.navigator);
        return _this;
    }
    Object.defineProperty(WorkbenchList.prototype, "onDidOpen", {
        get: function () { return this.navigator.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchList.prototype.updateOptions = function (options) {
        _super.prototype.updateOptions.call(this, options);
        if (options.overrideStyles) {
            this.updateStyles(options.overrideStyles);
        }
    };
    WorkbenchList.prototype.updateStyles = function (styles) {
        var _a;
        (_a = this._styler) === null || _a === void 0 ? void 0 : _a.dispose();
        this._styler = attachListStyler(this, this.themeService, styles);
    };
    Object.defineProperty(WorkbenchList.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () {
            return this._useAltAsMultipleSelectionModifier;
        },
        enumerable: false,
        configurable: true
    });
    WorkbenchList.prototype.dispose = function () {
        var _a;
        (_a = this._styler) === null || _a === void 0 ? void 0 : _a.dispose();
        _super.prototype.dispose.call(this);
    };
    WorkbenchList = __decorate([
        __param(5, IContextKeyService),
        __param(6, IListService),
        __param(7, IThemeService),
        __param(8, IConfigurationService),
        __param(9, IKeybindingService)
    ], WorkbenchList);
    return WorkbenchList;
}(List));
export { WorkbenchList };
var WorkbenchPagedList = /** @class */ (function (_super) {
    __extends(WorkbenchPagedList, _super);
    function WorkbenchPagedList(user, container, delegate, renderers, options, contextKeyService, listService, themeService, configurationService, keybindingService) {
        var _this = this;
        var horizontalScrolling = typeof options.horizontalScrolling !== 'undefined' ? options.horizontalScrolling : configurationService.getValue(horizontalScrollingKey);
        var _a = __read(toWorkbenchListOptions(options, configurationService, keybindingService), 2), workbenchListOptions = _a[0], workbenchListOptionsDisposable = _a[1];
        _this = _super.call(this, user, container, delegate, renderers, __assign(__assign(__assign({ keyboardSupport: false }, computeStyles(themeService.getColorTheme(), defaultListStyles)), workbenchListOptions), { horizontalScrolling: horizontalScrolling })) || this;
        _this.disposables = new DisposableStore();
        _this.disposables.add(workbenchListOptionsDisposable);
        _this.contextKeyService = createScopedContextKeyService(contextKeyService, _this);
        _this.themeService = themeService;
        _this.horizontalScrolling = options.horizontalScrolling;
        var listSupportsMultiSelect = WorkbenchListSupportsMultiSelectContextKey.bindTo(_this.contextKeyService);
        listSupportsMultiSelect.set(!(options.multipleSelectionSupport === false));
        _this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
        _this.disposables.add(_this.contextKeyService);
        _this.disposables.add(listService.register(_this));
        if (options.overrideStyles) {
            _this.updateStyles(options.overrideStyles);
        }
        if (options.overrideStyles) {
            _this.disposables.add(attachListStyler(_this, themeService, options.overrideStyles));
        }
        _this.disposables.add(configurationService.onDidChangeConfiguration(function (e) {
            if (e.affectsConfiguration(multiSelectModifierSettingKey)) {
                _this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
            }
            var options = {};
            if (e.affectsConfiguration(horizontalScrollingKey) && _this.horizontalScrolling === undefined) {
                var horizontalScrolling_2 = configurationService.getValue(horizontalScrollingKey);
                options = __assign(__assign({}, options), { horizontalScrolling: horizontalScrolling_2 });
            }
            if (e.affectsConfiguration(listSmoothScrolling)) {
                var smoothScrolling = configurationService.getValue(listSmoothScrolling);
                options = __assign(__assign({}, options), { smoothScrolling: smoothScrolling });
            }
            if (Object.keys(options).length > 0) {
                _this.updateOptions(options);
            }
        }));
        _this.navigator = new ListResourceNavigator(_this, __assign({ configurationService: configurationService }, options));
        _this.disposables.add(_this.navigator);
        return _this;
    }
    Object.defineProperty(WorkbenchPagedList.prototype, "onDidOpen", {
        get: function () { return this.navigator.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchPagedList.prototype.updateOptions = function (options) {
        _super.prototype.updateOptions.call(this, options);
        if (options.overrideStyles) {
            this.updateStyles(options.overrideStyles);
        }
    };
    WorkbenchPagedList.prototype.updateStyles = function (styles) {
        var _a;
        (_a = this._styler) === null || _a === void 0 ? void 0 : _a.dispose();
        this._styler = attachListStyler(this, this.themeService, styles);
    };
    Object.defineProperty(WorkbenchPagedList.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () {
            return this._useAltAsMultipleSelectionModifier;
        },
        enumerable: false,
        configurable: true
    });
    WorkbenchPagedList.prototype.dispose = function () {
        var _a;
        (_a = this._styler) === null || _a === void 0 ? void 0 : _a.dispose();
        this.disposables.dispose();
        _super.prototype.dispose.call(this);
    };
    WorkbenchPagedList = __decorate([
        __param(5, IContextKeyService),
        __param(6, IListService),
        __param(7, IThemeService),
        __param(8, IConfigurationService),
        __param(9, IKeybindingService)
    ], WorkbenchPagedList);
    return WorkbenchPagedList;
}(PagedList));
export { WorkbenchPagedList };
var WorkbenchTable = /** @class */ (function (_super) {
    __extends(WorkbenchTable, _super);
    function WorkbenchTable(user, container, delegate, columns, renderers, options, contextKeyService, listService, themeService, configurationService, keybindingService) {
        var _this = this;
        var horizontalScrolling = typeof options.horizontalScrolling !== 'undefined' ? options.horizontalScrolling : configurationService.getValue(horizontalScrollingKey);
        var _a = __read(toWorkbenchListOptions(options, configurationService, keybindingService), 2), workbenchListOptions = _a[0], workbenchListOptionsDisposable = _a[1];
        _this = _super.call(this, user, container, delegate, columns, renderers, __assign(__assign(__assign({ keyboardSupport: false }, computeStyles(themeService.getColorTheme(), defaultListStyles)), workbenchListOptions), { horizontalScrolling: horizontalScrolling })) || this;
        _this.disposables = new DisposableStore();
        _this.disposables.add(workbenchListOptionsDisposable);
        _this.contextKeyService = createScopedContextKeyService(contextKeyService, _this);
        _this.themeService = themeService;
        var listSupportsMultiSelect = WorkbenchListSupportsMultiSelectContextKey.bindTo(_this.contextKeyService);
        listSupportsMultiSelect.set(!(options.multipleSelectionSupport === false));
        _this.listHasSelectionOrFocus = WorkbenchListHasSelectionOrFocus.bindTo(_this.contextKeyService);
        _this.listDoubleSelection = WorkbenchListDoubleSelection.bindTo(_this.contextKeyService);
        _this.listMultiSelection = WorkbenchListMultiSelection.bindTo(_this.contextKeyService);
        _this.horizontalScrolling = options.horizontalScrolling;
        _this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
        _this.disposables.add(_this.contextKeyService);
        _this.disposables.add(listService.register(_this));
        if (options.overrideStyles) {
            _this.updateStyles(options.overrideStyles);
        }
        _this.disposables.add(_this.onDidChangeSelection(function () {
            var selection = _this.getSelection();
            var focus = _this.getFocus();
            _this.contextKeyService.bufferChangeEvents(function () {
                _this.listHasSelectionOrFocus.set(selection.length > 0 || focus.length > 0);
                _this.listMultiSelection.set(selection.length > 1);
                _this.listDoubleSelection.set(selection.length === 2);
            });
        }));
        _this.disposables.add(_this.onDidChangeFocus(function () {
            var selection = _this.getSelection();
            var focus = _this.getFocus();
            _this.listHasSelectionOrFocus.set(selection.length > 0 || focus.length > 0);
        }));
        _this.disposables.add(configurationService.onDidChangeConfiguration(function (e) {
            if (e.affectsConfiguration(multiSelectModifierSettingKey)) {
                _this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
            }
            var options = {};
            if (e.affectsConfiguration(horizontalScrollingKey) && _this.horizontalScrolling === undefined) {
                var horizontalScrolling_3 = configurationService.getValue(horizontalScrollingKey);
                options = __assign(__assign({}, options), { horizontalScrolling: horizontalScrolling_3 });
            }
            if (e.affectsConfiguration(listSmoothScrolling)) {
                var smoothScrolling = configurationService.getValue(listSmoothScrolling);
                options = __assign(__assign({}, options), { smoothScrolling: smoothScrolling });
            }
            if (Object.keys(options).length > 0) {
                _this.updateOptions(options);
            }
        }));
        _this.navigator = new TableResourceNavigator(_this, __assign({ configurationService: configurationService }, options));
        _this.disposables.add(_this.navigator);
        return _this;
    }
    Object.defineProperty(WorkbenchTable.prototype, "onDidOpen", {
        get: function () { return this.navigator.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchTable.prototype.updateOptions = function (options) {
        _super.prototype.updateOptions.call(this, options);
        if (options.overrideStyles) {
            this.updateStyles(options.overrideStyles);
        }
    };
    WorkbenchTable.prototype.updateStyles = function (styles) {
        var _a;
        (_a = this._styler) === null || _a === void 0 ? void 0 : _a.dispose();
        this._styler = attachListStyler(this, this.themeService, styles);
    };
    Object.defineProperty(WorkbenchTable.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () {
            return this._useAltAsMultipleSelectionModifier;
        },
        enumerable: false,
        configurable: true
    });
    WorkbenchTable.prototype.dispose = function () {
        var _a;
        (_a = this._styler) === null || _a === void 0 ? void 0 : _a.dispose();
        this.disposables.dispose();
        _super.prototype.dispose.call(this);
    };
    WorkbenchTable = __decorate([
        __param(6, IContextKeyService),
        __param(7, IListService),
        __param(8, IThemeService),
        __param(9, IConfigurationService),
        __param(10, IKeybindingService)
    ], WorkbenchTable);
    return WorkbenchTable;
}(Table));
export { WorkbenchTable };
export function getSelectionKeyboardEvent(typeArg, preserveFocus, pinned) {
    if (typeArg === void 0) { typeArg = 'keydown'; }
    var e = new KeyboardEvent(typeArg);
    e.preserveFocus = preserveFocus;
    e.pinned = pinned;
    e.__forceEvent = true;
    return e;
}
var ResourceNavigator = /** @class */ (function (_super) {
    __extends(ResourceNavigator, _super);
    function ResourceNavigator(widget, options) {
        var _a, _b;
        var _this = _super.call(this) || this;
        _this.widget = widget;
        _this._onDidOpen = _this._register(new Emitter());
        _this.onDidOpen = _this._onDidOpen.event;
        _this.openOnFocus = (_a = options === null || options === void 0 ? void 0 : options.openOnFocus) !== null && _a !== void 0 ? _a : false;
        _this._register(Event.filter(_this.widget.onDidChangeSelection, function (e) { return e.browserEvent instanceof KeyboardEvent; })(function (e) { return _this.onSelectionFromKeyboard(e); }));
        _this._register(_this.widget.onPointer(function (e) { return _this.onPointer(e.element, e.browserEvent); }));
        _this._register(_this.widget.onMouseDblClick(function (e) { return _this.onMouseDblClick(e.element, e.browserEvent); }));
        if (_this.openOnFocus) {
            _this._register(Event.filter(_this.widget.onDidChangeFocus, function (e) { return e.browserEvent instanceof KeyboardEvent; })(function (e) { return _this.onFocusFromKeyboard(e); }));
        }
        if (typeof (options === null || options === void 0 ? void 0 : options.openOnSingleClick) !== 'boolean' && (options === null || options === void 0 ? void 0 : options.configurationService)) {
            _this.openOnSingleClick = (options === null || options === void 0 ? void 0 : options.configurationService.getValue(openModeSettingKey)) !== 'doubleClick';
            _this._register(options === null || options === void 0 ? void 0 : options.configurationService.onDidChangeConfiguration(function () {
                _this.openOnSingleClick = (options === null || options === void 0 ? void 0 : options.configurationService.getValue(openModeSettingKey)) !== 'doubleClick';
            }));
        }
        else {
            _this.openOnSingleClick = (_b = options === null || options === void 0 ? void 0 : options.openOnSingleClick) !== null && _b !== void 0 ? _b : true;
        }
        return _this;
    }
    ResourceNavigator.prototype.onFocusFromKeyboard = function (event) {
        var focus = this.widget.getFocus();
        this.widget.setSelection(focus, event.browserEvent);
        var selectionKeyboardEvent = event.browserEvent;
        var preserveFocus = typeof selectionKeyboardEvent.preserveFocus === 'boolean' ? selectionKeyboardEvent.preserveFocus : true;
        var pinned = typeof selectionKeyboardEvent.pinned === 'boolean' ? selectionKeyboardEvent.pinned : !preserveFocus;
        var sideBySide = false;
        this._open(this.getSelectedElement(), preserveFocus, pinned, sideBySide, event.browserEvent);
    };
    ResourceNavigator.prototype.onSelectionFromKeyboard = function (event) {
        if (event.elements.length !== 1) {
            return;
        }
        var selectionKeyboardEvent = event.browserEvent;
        var preserveFocus = typeof selectionKeyboardEvent.preserveFocus === 'boolean' ? selectionKeyboardEvent.preserveFocus : true;
        var pinned = typeof selectionKeyboardEvent.pinned === 'boolean' ? selectionKeyboardEvent.pinned : !preserveFocus;
        var sideBySide = false;
        this._open(this.getSelectedElement(), preserveFocus, pinned, sideBySide, event.browserEvent);
    };
    ResourceNavigator.prototype.onPointer = function (element, browserEvent) {
        if (!this.openOnSingleClick) {
            return;
        }
        var isDoubleClick = browserEvent.detail === 2;
        if (isDoubleClick) {
            return;
        }
        var isMiddleClick = browserEvent.button === 1;
        var preserveFocus = true;
        var pinned = isMiddleClick;
        var sideBySide = browserEvent.ctrlKey || browserEvent.metaKey || browserEvent.altKey;
        this._open(element, preserveFocus, pinned, sideBySide, browserEvent);
    };
    ResourceNavigator.prototype.onMouseDblClick = function (element, browserEvent) {
        if (!browserEvent) {
            return;
        }
        var preserveFocus = false;
        var pinned = true;
        var sideBySide = (browserEvent.ctrlKey || browserEvent.metaKey || browserEvent.altKey);
        this._open(element, preserveFocus, pinned, sideBySide, browserEvent);
    };
    ResourceNavigator.prototype._open = function (element, preserveFocus, pinned, sideBySide, browserEvent) {
        if (!element) {
            return;
        }
        this._onDidOpen.fire({
            editorOptions: {
                preserveFocus: preserveFocus,
                pinned: pinned,
                revealIfVisible: true
            },
            sideBySide: sideBySide,
            element: element,
            browserEvent: browserEvent
        });
    };
    return ResourceNavigator;
}(Disposable));
var ListResourceNavigator = /** @class */ (function (_super) {
    __extends(ListResourceNavigator, _super);
    function ListResourceNavigator(widget, options) {
        var _this = _super.call(this, widget, options) || this;
        _this.widget = widget;
        return _this;
    }
    ListResourceNavigator.prototype.getSelectedElement = function () {
        return this.widget.getSelectedElements()[0];
    };
    return ListResourceNavigator;
}(ResourceNavigator));
var TableResourceNavigator = /** @class */ (function (_super) {
    __extends(TableResourceNavigator, _super);
    function TableResourceNavigator(widget, options) {
        var _this = _super.call(this, widget, options) || this;
        _this.widget = widget;
        return _this;
    }
    TableResourceNavigator.prototype.getSelectedElement = function () {
        return this.widget.getSelectedElements()[0];
    };
    return TableResourceNavigator;
}(ResourceNavigator));
var TreeResourceNavigator = /** @class */ (function (_super) {
    __extends(TreeResourceNavigator, _super);
    function TreeResourceNavigator(widget, options) {
        var _this = _super.call(this, widget, options) || this;
        _this.widget = widget;
        return _this;
    }
    TreeResourceNavigator.prototype.getSelectedElement = function () {
        var _a;
        return (_a = this.widget.getSelection()[0]) !== null && _a !== void 0 ? _a : undefined;
    };
    return TreeResourceNavigator;
}(ResourceNavigator));
function createKeyboardNavigationEventFilter(container, keybindingService) {
    var inChord = false;
    return function (event) {
        if (inChord) {
            inChord = false;
            return false;
        }
        var result = keybindingService.softDispatch(event, container);
        if (result && result.enterChord) {
            inChord = true;
            return false;
        }
        inChord = false;
        return true;
    };
}
var WorkbenchObjectTree = /** @class */ (function (_super) {
    __extends(WorkbenchObjectTree, _super);
    function WorkbenchObjectTree(user, container, delegate, renderers, options, contextKeyService, listService, themeService, configurationService, keybindingService, accessibilityService) {
        var _this = this;
        var _a = workbenchTreeDataPreamble(container, options, contextKeyService, configurationService, keybindingService, accessibilityService), treeOptions = _a.options, getAutomaticKeyboardNavigation = _a.getAutomaticKeyboardNavigation, disposable = _a.disposable;
        _this = _super.call(this, user, container, delegate, renderers, treeOptions) || this;
        _this.disposables.add(disposable);
        _this.internals = new WorkbenchTreeInternals(_this, options, getAutomaticKeyboardNavigation, options.overrideStyles, contextKeyService, listService, themeService, configurationService, accessibilityService);
        _this.disposables.add(_this.internals);
        return _this;
    }
    Object.defineProperty(WorkbenchObjectTree.prototype, "contextKeyService", {
        get: function () { return this.internals.contextKeyService; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchObjectTree.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () { return this.internals.useAltAsMultipleSelectionModifier; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchObjectTree.prototype, "onDidOpen", {
        get: function () { return this.internals.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchObjectTree = __decorate([
        __param(5, IContextKeyService),
        __param(6, IListService),
        __param(7, IThemeService),
        __param(8, IConfigurationService),
        __param(9, IKeybindingService),
        __param(10, IAccessibilityService)
    ], WorkbenchObjectTree);
    return WorkbenchObjectTree;
}(ObjectTree));
export { WorkbenchObjectTree };
var WorkbenchCompressibleObjectTree = /** @class */ (function (_super) {
    __extends(WorkbenchCompressibleObjectTree, _super);
    function WorkbenchCompressibleObjectTree(user, container, delegate, renderers, options, contextKeyService, listService, themeService, configurationService, keybindingService, accessibilityService) {
        var _this = this;
        var _a = workbenchTreeDataPreamble(container, options, contextKeyService, configurationService, keybindingService, accessibilityService), treeOptions = _a.options, getAutomaticKeyboardNavigation = _a.getAutomaticKeyboardNavigation, disposable = _a.disposable;
        _this = _super.call(this, user, container, delegate, renderers, treeOptions) || this;
        _this.disposables.add(disposable);
        _this.internals = new WorkbenchTreeInternals(_this, options, getAutomaticKeyboardNavigation, options.overrideStyles, contextKeyService, listService, themeService, configurationService, accessibilityService);
        _this.disposables.add(_this.internals);
        return _this;
    }
    Object.defineProperty(WorkbenchCompressibleObjectTree.prototype, "contextKeyService", {
        get: function () { return this.internals.contextKeyService; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchCompressibleObjectTree.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () { return this.internals.useAltAsMultipleSelectionModifier; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchCompressibleObjectTree.prototype, "onDidOpen", {
        get: function () { return this.internals.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchCompressibleObjectTree.prototype.updateOptions = function (options) {
        if (options === void 0) { options = {}; }
        _super.prototype.updateOptions.call(this, options);
        if (options.overrideStyles) {
            this.internals.updateStyleOverrides(options.overrideStyles);
        }
    };
    WorkbenchCompressibleObjectTree = __decorate([
        __param(5, IContextKeyService),
        __param(6, IListService),
        __param(7, IThemeService),
        __param(8, IConfigurationService),
        __param(9, IKeybindingService),
        __param(10, IAccessibilityService)
    ], WorkbenchCompressibleObjectTree);
    return WorkbenchCompressibleObjectTree;
}(CompressibleObjectTree));
export { WorkbenchCompressibleObjectTree };
var WorkbenchDataTree = /** @class */ (function (_super) {
    __extends(WorkbenchDataTree, _super);
    function WorkbenchDataTree(user, container, delegate, renderers, dataSource, options, contextKeyService, listService, themeService, configurationService, keybindingService, accessibilityService) {
        var _this = this;
        var _a = workbenchTreeDataPreamble(container, options, contextKeyService, configurationService, keybindingService, accessibilityService), treeOptions = _a.options, getAutomaticKeyboardNavigation = _a.getAutomaticKeyboardNavigation, disposable = _a.disposable;
        _this = _super.call(this, user, container, delegate, renderers, dataSource, treeOptions) || this;
        _this.disposables.add(disposable);
        _this.internals = new WorkbenchTreeInternals(_this, options, getAutomaticKeyboardNavigation, options.overrideStyles, contextKeyService, listService, themeService, configurationService, accessibilityService);
        _this.disposables.add(_this.internals);
        return _this;
    }
    Object.defineProperty(WorkbenchDataTree.prototype, "contextKeyService", {
        get: function () { return this.internals.contextKeyService; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchDataTree.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () { return this.internals.useAltAsMultipleSelectionModifier; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchDataTree.prototype, "onDidOpen", {
        get: function () { return this.internals.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchDataTree.prototype.updateOptions = function (options) {
        if (options === void 0) { options = {}; }
        _super.prototype.updateOptions.call(this, options);
        if (options.overrideStyles) {
            this.internals.updateStyleOverrides(options.overrideStyles);
        }
    };
    WorkbenchDataTree = __decorate([
        __param(6, IContextKeyService),
        __param(7, IListService),
        __param(8, IThemeService),
        __param(9, IConfigurationService),
        __param(10, IKeybindingService),
        __param(11, IAccessibilityService)
    ], WorkbenchDataTree);
    return WorkbenchDataTree;
}(DataTree));
export { WorkbenchDataTree };
var WorkbenchAsyncDataTree = /** @class */ (function (_super) {
    __extends(WorkbenchAsyncDataTree, _super);
    function WorkbenchAsyncDataTree(user, container, delegate, renderers, dataSource, options, contextKeyService, listService, themeService, configurationService, keybindingService, accessibilityService) {
        var _this = this;
        var _a = workbenchTreeDataPreamble(container, options, contextKeyService, configurationService, keybindingService, accessibilityService), treeOptions = _a.options, getAutomaticKeyboardNavigation = _a.getAutomaticKeyboardNavigation, disposable = _a.disposable;
        _this = _super.call(this, user, container, delegate, renderers, dataSource, treeOptions) || this;
        _this.disposables.add(disposable);
        _this.internals = new WorkbenchTreeInternals(_this, options, getAutomaticKeyboardNavigation, options.overrideStyles, contextKeyService, listService, themeService, configurationService, accessibilityService);
        _this.disposables.add(_this.internals);
        return _this;
    }
    Object.defineProperty(WorkbenchAsyncDataTree.prototype, "contextKeyService", {
        get: function () { return this.internals.contextKeyService; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchAsyncDataTree.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () { return this.internals.useAltAsMultipleSelectionModifier; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchAsyncDataTree.prototype, "onDidOpen", {
        get: function () { return this.internals.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchAsyncDataTree.prototype.updateOptions = function (options) {
        if (options === void 0) { options = {}; }
        _super.prototype.updateOptions.call(this, options);
        if (options.overrideStyles) {
            this.internals.updateStyleOverrides(options.overrideStyles);
        }
    };
    WorkbenchAsyncDataTree = __decorate([
        __param(6, IContextKeyService),
        __param(7, IListService),
        __param(8, IThemeService),
        __param(9, IConfigurationService),
        __param(10, IKeybindingService),
        __param(11, IAccessibilityService)
    ], WorkbenchAsyncDataTree);
    return WorkbenchAsyncDataTree;
}(AsyncDataTree));
export { WorkbenchAsyncDataTree };
var WorkbenchCompressibleAsyncDataTree = /** @class */ (function (_super) {
    __extends(WorkbenchCompressibleAsyncDataTree, _super);
    function WorkbenchCompressibleAsyncDataTree(user, container, virtualDelegate, compressionDelegate, renderers, dataSource, options, contextKeyService, listService, themeService, configurationService, keybindingService, accessibilityService) {
        var _this = this;
        var _a = workbenchTreeDataPreamble(container, options, contextKeyService, configurationService, keybindingService, accessibilityService), treeOptions = _a.options, getAutomaticKeyboardNavigation = _a.getAutomaticKeyboardNavigation, disposable = _a.disposable;
        _this = _super.call(this, user, container, virtualDelegate, compressionDelegate, renderers, dataSource, treeOptions) || this;
        _this.disposables.add(disposable);
        _this.internals = new WorkbenchTreeInternals(_this, options, getAutomaticKeyboardNavigation, options.overrideStyles, contextKeyService, listService, themeService, configurationService, accessibilityService);
        _this.disposables.add(_this.internals);
        return _this;
    }
    Object.defineProperty(WorkbenchCompressibleAsyncDataTree.prototype, "contextKeyService", {
        get: function () { return this.internals.contextKeyService; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchCompressibleAsyncDataTree.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () { return this.internals.useAltAsMultipleSelectionModifier; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchCompressibleAsyncDataTree.prototype, "onDidOpen", {
        get: function () { return this.internals.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    WorkbenchCompressibleAsyncDataTree = __decorate([
        __param(7, IContextKeyService),
        __param(8, IListService),
        __param(9, IThemeService),
        __param(10, IConfigurationService),
        __param(11, IKeybindingService),
        __param(12, IAccessibilityService)
    ], WorkbenchCompressibleAsyncDataTree);
    return WorkbenchCompressibleAsyncDataTree;
}(CompressibleAsyncDataTree));
export { WorkbenchCompressibleAsyncDataTree };
function workbenchTreeDataPreamble(container, options, contextKeyService, configurationService, keybindingService, accessibilityService) {
    var _a;
    WorkbenchListSupportsKeyboardNavigation.bindTo(contextKeyService);
    if (!didBindWorkbenchListAutomaticKeyboardNavigation) {
        WorkbenchListAutomaticKeyboardNavigation.bindTo(contextKeyService);
        didBindWorkbenchListAutomaticKeyboardNavigation = true;
    }
    var getAutomaticKeyboardNavigation = function () {
        // give priority to the context key value to disable this completely
        var automaticKeyboardNavigation = contextKeyService.getContextKeyValue(WorkbenchListAutomaticKeyboardNavigationKey);
        if (automaticKeyboardNavigation) {
            automaticKeyboardNavigation = configurationService.getValue(automaticKeyboardNavigationSettingKey);
        }
        return automaticKeyboardNavigation;
    };
    var accessibilityOn = accessibilityService.isScreenReaderOptimized();
    var keyboardNavigation = options.simpleKeyboardNavigation || accessibilityOn ? 'simple' : configurationService.getValue(keyboardNavigationSettingKey);
    var horizontalScrolling = options.horizontalScrolling !== undefined ? options.horizontalScrolling : configurationService.getValue(horizontalScrollingKey);
    var _b = __read(toWorkbenchListOptions(options, configurationService, keybindingService), 2), workbenchListOptions = _b[0], disposable = _b[1];
    var additionalScrollHeight = options.additionalScrollHeight;
    return {
        getAutomaticKeyboardNavigation: getAutomaticKeyboardNavigation,
        disposable: disposable,
        options: __assign(__assign({ 
            // ...options, // TODO@Joao why is this not splatted here?
            keyboardSupport: false }, workbenchListOptions), { indent: configurationService.getValue(treeIndentKey), renderIndentGuides: configurationService.getValue(treeRenderIndentGuidesKey), smoothScrolling: configurationService.getValue(listSmoothScrolling), automaticKeyboardNavigation: getAutomaticKeyboardNavigation(), simpleKeyboardNavigation: keyboardNavigation === 'simple', filterOnType: keyboardNavigation === 'filter', horizontalScrolling: horizontalScrolling, keyboardNavigationEventFilter: createKeyboardNavigationEventFilter(container, keybindingService), additionalScrollHeight: additionalScrollHeight, hideTwistiesOfChildlessElements: options.hideTwistiesOfChildlessElements, expandOnlyOnTwistieClick: (_a = options.expandOnlyOnTwistieClick) !== null && _a !== void 0 ? _a : (configurationService.getValue(treeExpandMode) === 'doubleClick') })
    };
}
var WorkbenchTreeInternals = /** @class */ (function () {
    function WorkbenchTreeInternals(tree, options, getAutomaticKeyboardNavigation, overrideStyles, contextKeyService, listService, themeService, configurationService, accessibilityService) {
        var _this = this;
        this.tree = tree;
        this.themeService = themeService;
        this.disposables = [];
        this.contextKeyService = createScopedContextKeyService(contextKeyService, tree);
        var listSupportsMultiSelect = WorkbenchListSupportsMultiSelectContextKey.bindTo(this.contextKeyService);
        listSupportsMultiSelect.set(!(options.multipleSelectionSupport === false));
        this.hasSelectionOrFocus = WorkbenchListHasSelectionOrFocus.bindTo(this.contextKeyService);
        this.hasDoubleSelection = WorkbenchListDoubleSelection.bindTo(this.contextKeyService);
        this.hasMultiSelection = WorkbenchListMultiSelection.bindTo(this.contextKeyService);
        this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
        var interestingContextKeys = new Set();
        interestingContextKeys.add(WorkbenchListAutomaticKeyboardNavigationKey);
        var updateKeyboardNavigation = function () {
            var accessibilityOn = accessibilityService.isScreenReaderOptimized();
            var keyboardNavigation = accessibilityOn ? 'simple' : configurationService.getValue(keyboardNavigationSettingKey);
            tree.updateOptions({
                simpleKeyboardNavigation: keyboardNavigation === 'simple',
                filterOnType: keyboardNavigation === 'filter'
            });
        };
        this.updateStyleOverrides(overrideStyles);
        this.disposables.push(this.contextKeyService, listService.register(tree), tree.onDidChangeSelection(function () {
            var selection = tree.getSelection();
            var focus = tree.getFocus();
            _this.contextKeyService.bufferChangeEvents(function () {
                _this.hasSelectionOrFocus.set(selection.length > 0 || focus.length > 0);
                _this.hasMultiSelection.set(selection.length > 1);
                _this.hasDoubleSelection.set(selection.length === 2);
            });
        }), tree.onDidChangeFocus(function () {
            var selection = tree.getSelection();
            var focus = tree.getFocus();
            _this.hasSelectionOrFocus.set(selection.length > 0 || focus.length > 0);
        }), configurationService.onDidChangeConfiguration(function (e) {
            var newOptions = {};
            if (e.affectsConfiguration(multiSelectModifierSettingKey)) {
                _this._useAltAsMultipleSelectionModifier = useAltAsMultipleSelectionModifier(configurationService);
            }
            if (e.affectsConfiguration(treeIndentKey)) {
                var indent = configurationService.getValue(treeIndentKey);
                newOptions = __assign(__assign({}, newOptions), { indent: indent });
            }
            if (e.affectsConfiguration(treeRenderIndentGuidesKey)) {
                var renderIndentGuides = configurationService.getValue(treeRenderIndentGuidesKey);
                newOptions = __assign(__assign({}, newOptions), { renderIndentGuides: renderIndentGuides });
            }
            if (e.affectsConfiguration(listSmoothScrolling)) {
                var smoothScrolling = configurationService.getValue(listSmoothScrolling);
                newOptions = __assign(__assign({}, newOptions), { smoothScrolling: smoothScrolling });
            }
            if (e.affectsConfiguration(keyboardNavigationSettingKey)) {
                updateKeyboardNavigation();
            }
            if (e.affectsConfiguration(automaticKeyboardNavigationSettingKey)) {
                newOptions = __assign(__assign({}, newOptions), { automaticKeyboardNavigation: getAutomaticKeyboardNavigation() });
            }
            if (e.affectsConfiguration(horizontalScrollingKey) && options.horizontalScrolling === undefined) {
                var horizontalScrolling = configurationService.getValue(horizontalScrollingKey);
                newOptions = __assign(__assign({}, newOptions), { horizontalScrolling: horizontalScrolling });
            }
            if (e.affectsConfiguration(treeExpandMode) && options.expandOnlyOnTwistieClick === undefined) {
                newOptions = __assign(__assign({}, newOptions), { expandOnlyOnTwistieClick: configurationService.getValue(treeExpandMode) === 'doubleClick' });
            }
            if (Object.keys(newOptions).length > 0) {
                tree.updateOptions(newOptions);
            }
        }), this.contextKeyService.onDidChangeContext(function (e) {
            if (e.affectsSome(interestingContextKeys)) {
                tree.updateOptions({ automaticKeyboardNavigation: getAutomaticKeyboardNavigation() });
            }
        }), accessibilityService.onDidChangeScreenReaderOptimized(function () { return updateKeyboardNavigation(); }));
        this.navigator = new TreeResourceNavigator(tree, __assign({ configurationService: configurationService }, options));
        this.disposables.push(this.navigator);
    }
    Object.defineProperty(WorkbenchTreeInternals.prototype, "onDidOpen", {
        get: function () { return this.navigator.onDidOpen; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkbenchTreeInternals.prototype, "useAltAsMultipleSelectionModifier", {
        get: function () {
            return this._useAltAsMultipleSelectionModifier;
        },
        enumerable: false,
        configurable: true
    });
    WorkbenchTreeInternals.prototype.updateStyleOverrides = function (overrideStyles) {
        dispose(this.styler);
        this.styler = overrideStyles ? attachListStyler(this.tree, this.themeService, overrideStyles) : Disposable.None;
    };
    WorkbenchTreeInternals.prototype.dispose = function () {
        this.disposables = dispose(this.disposables);
        dispose(this.styler);
        this.styler = undefined;
    };
    WorkbenchTreeInternals = __decorate([
        __param(4, IContextKeyService),
        __param(5, IListService),
        __param(6, IThemeService),
        __param(7, IConfigurationService),
        __param(8, IAccessibilityService)
    ], WorkbenchTreeInternals);
    return WorkbenchTreeInternals;
}());
var configurationRegistry = Registry.as(ConfigurationExtensions.Configuration);
configurationRegistry.registerConfiguration({
    'id': 'workbench',
    'order': 7,
    'title': localize('workbenchConfigurationTitle', "Workbench"),
    'type': 'object',
    'properties': (_a = {},
        _a[multiSelectModifierSettingKey] = {
            'type': 'string',
            'enum': ['ctrlCmd', 'alt'],
            'enumDescriptions': [
                localize('multiSelectModifier.ctrlCmd', "Maps to `Control` on Windows and Linux and to `Command` on macOS."),
                localize('multiSelectModifier.alt', "Maps to `Alt` on Windows and Linux and to `Option` on macOS.")
            ],
            'default': 'ctrlCmd',
            'description': localize({
                key: 'multiSelectModifier',
                comment: [
                    '- `ctrlCmd` refers to a value the setting can take and should not be localized.',
                    '- `Control` and `Command` refer to the modifier keys Ctrl or Cmd on the keyboard and can be localized.'
                ]
            }, "The modifier to be used to add an item in trees and lists to a multi-selection with the mouse (for example in the explorer, open editors and scm view). The 'Open to Side' mouse gestures - if supported - will adapt such that they do not conflict with the multiselect modifier.")
        },
        _a[openModeSettingKey] = {
            'type': 'string',
            'enum': ['singleClick', 'doubleClick'],
            'default': 'singleClick',
            'description': localize({
                key: 'openModeModifier',
                comment: ['`singleClick` and `doubleClick` refers to a value the setting can take and should not be localized.']
            }, "Controls how to open items in trees and lists using the mouse (if supported). Note that some trees and lists might choose to ignore this setting if it is not applicable.")
        },
        _a[horizontalScrollingKey] = {
            'type': 'boolean',
            'default': false,
            'description': localize('horizontalScrolling setting', "Controls whether lists and trees support horizontal scrolling in the workbench. Warning: turning on this setting has a performance implication.")
        },
        _a[treeIndentKey] = {
            'type': 'number',
            'default': 8,
            minimum: 0,
            maximum: 40,
            'description': localize('tree indent setting', "Controls tree indentation in pixels.")
        },
        _a[treeRenderIndentGuidesKey] = {
            type: 'string',
            enum: ['none', 'onHover', 'always'],
            default: 'onHover',
            description: localize('render tree indent guides', "Controls whether the tree should render indent guides.")
        },
        _a[listSmoothScrolling] = {
            type: 'boolean',
            default: false,
            description: localize('list smoothScrolling setting', "Controls whether lists and trees have smooth scrolling."),
        },
        _a[keyboardNavigationSettingKey] = {
            'type': 'string',
            'enum': ['simple', 'highlight', 'filter'],
            'enumDescriptions': [
                localize('keyboardNavigationSettingKey.simple', "Simple keyboard navigation focuses elements which match the keyboard input. Matching is done only on prefixes."),
                localize('keyboardNavigationSettingKey.highlight', "Highlight keyboard navigation highlights elements which match the keyboard input. Further up and down navigation will traverse only the highlighted elements."),
                localize('keyboardNavigationSettingKey.filter', "Filter keyboard navigation will filter out and hide all the elements which do not match the keyboard input.")
            ],
            'default': 'highlight',
            'description': localize('keyboardNavigationSettingKey', "Controls the keyboard navigation style for lists and trees in the workbench. Can be simple, highlight and filter.")
        },
        _a[automaticKeyboardNavigationSettingKey] = {
            'type': 'boolean',
            'default': true,
            markdownDescription: localize('automatic keyboard navigation setting', "Controls whether keyboard navigation in lists and trees is automatically triggered simply by typing. If set to `false`, keyboard navigation is only triggered when executing the `list.toggleKeyboardNavigation` command, for which you can assign a keyboard shortcut.")
        },
        _a[treeExpandMode] = {
            type: 'string',
            enum: ['singleClick', 'doubleClick'],
            default: 'singleClick',
            description: localize('expand mode', "Controls how tree folders are expanded when clicking the folder names. Note that some trees and lists might choose to ignore this setting if it is not applicable."),
        },
        _a)
});
