/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.ls.core.internal.IProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public abstract class AbstractProjectImporter
implements IProjectImporter {
    protected File rootFolder;
    protected Collection<Path> directories;

    @Override
    public void initialize(File rootFolder) {
        if (!Objects.equals(this.rootFolder, rootFolder)) {
            this.reset();
        }
        this.rootFolder = rootFolder;
    }

    @Override
    public abstract boolean applies(IProgressMonitor var1) throws OperationCanceledException, CoreException;

    @Override
    public boolean isResolved(File folder) throws OperationCanceledException, CoreException {
        return this.directories != null && this.directories.contains(folder.toPath());
    }

    @Override
    public abstract void importToWorkspace(IProgressMonitor var1) throws OperationCanceledException, CoreException;

    @Override
    public abstract void reset();

    protected static Preferences getPreferences() {
        return JavaLanguageServerPlugin.getPreferencesManager() == null || JavaLanguageServerPlugin.getPreferencesManager().getPreferences() == null ? new Preferences() : JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
    }
}

