/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import './sash.css';
import { dispose, Disposable, DisposableStore, toDisposable } from '../../../common/lifecycle';
import { isMacintosh } from '../../../common/platform';
import * as types from '../../../common/types';
import { EventType, Gesture } from '../../touch';
import { StandardMouseEvent } from '../../mouseEvent';
import { Emitter } from '../../../common/event';
import { getElementsByTagName, EventHelper, createStyleSheet, addDisposableListener, append, $ } from '../../dom';
import { domEvent } from '../../event';
import { Delayer } from '../../../common/async';
var DEBUG = false;
export var OrthogonalEdge;
(function (OrthogonalEdge) {
    OrthogonalEdge["North"] = "north";
    OrthogonalEdge["South"] = "south";
    OrthogonalEdge["East"] = "east";
    OrthogonalEdge["West"] = "west";
})(OrthogonalEdge || (OrthogonalEdge = {}));
var globalSize = 4;
var onDidChangeGlobalSize = new Emitter();
export function setGlobalSashSize(size) {
    globalSize = size;
    onDidChangeGlobalSize.fire(size);
}
var Sash = /** @class */ (function (_super) {
    __extends(Sash, _super);
    function Sash(container, layoutProvider, options) {
        var _this = _super.call(this) || this;
        _this.hoverDelayer = _this._register(new Delayer(300));
        _this._state = 3 /* Enabled */;
        _this._onDidEnablementChange = _this._register(new Emitter());
        _this.onDidEnablementChange = _this._onDidEnablementChange.event;
        _this._onDidStart = _this._register(new Emitter());
        _this.onDidStart = _this._onDidStart.event;
        _this._onDidChange = _this._register(new Emitter());
        _this.onDidChange = _this._onDidChange.event;
        _this._onDidReset = _this._register(new Emitter());
        _this.onDidReset = _this._onDidReset.event;
        _this._onDidEnd = _this._register(new Emitter());
        _this.onDidEnd = _this._onDidEnd.event;
        _this.linkedSash = undefined;
        _this.orthogonalStartSashDisposables = _this._register(new DisposableStore());
        _this.orthogonalStartDragHandleDisposables = _this._register(new DisposableStore());
        _this.orthogonalEndSashDisposables = _this._register(new DisposableStore());
        _this.orthogonalEndDragHandleDisposables = _this._register(new DisposableStore());
        _this.el = append(container, $('.monaco-sash'));
        if (options.orthogonalEdge) {
            _this.el.classList.add("orthogonal-edge-" + options.orthogonalEdge);
        }
        if (isMacintosh) {
            _this.el.classList.add('mac');
        }
        _this._register(domEvent(_this.el, 'mousedown')(_this.onMouseDown, _this));
        _this._register(domEvent(_this.el, 'dblclick')(_this.onMouseDoubleClick, _this));
        _this._register(domEvent(_this.el, 'mouseenter')(function () { return Sash.onMouseEnter(_this); }));
        _this._register(domEvent(_this.el, 'mouseleave')(function () { return Sash.onMouseLeave(_this); }));
        _this._register(Gesture.addTarget(_this.el));
        _this._register(domEvent(_this.el, EventType.Start)(_this.onTouchStart, _this));
        if (typeof options.size === 'number') {
            _this.size = options.size;
            if (options.orientation === 0 /* VERTICAL */) {
                _this.el.style.width = _this.size + "px";
            }
            else {
                _this.el.style.height = _this.size + "px";
            }
        }
        else {
            _this.size = globalSize;
            _this._register(onDidChangeGlobalSize.event(function (size) {
                _this.size = size;
                _this.layout();
            }));
        }
        _this.hidden = false;
        _this.layoutProvider = layoutProvider;
        _this.orthogonalStartSash = options.orthogonalStartSash;
        _this.orthogonalEndSash = options.orthogonalEndSash;
        _this.orientation = options.orientation || 0 /* VERTICAL */;
        if (_this.orientation === 1 /* HORIZONTAL */) {
            _this.el.classList.add('horizontal');
            _this.el.classList.remove('vertical');
        }
        else {
            _this.el.classList.remove('horizontal');
            _this.el.classList.add('vertical');
        }
        _this.el.classList.toggle('debug', DEBUG);
        _this.layout();
        return _this;
    }
    Object.defineProperty(Sash.prototype, "state", {
        get: function () { return this._state; },
        set: function (state) {
            if (this._state === state) {
                return;
            }
            this.el.classList.toggle('disabled', state === 0 /* Disabled */);
            this.el.classList.toggle('minimum', state === 1 /* Minimum */);
            this.el.classList.toggle('maximum', state === 2 /* Maximum */);
            this._state = state;
            this._onDidEnablementChange.fire(state);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Sash.prototype, "orthogonalStartSash", {
        get: function () { return this._orthogonalStartSash; },
        set: function (sash) {
            var _this = this;
            this.orthogonalStartDragHandleDisposables.clear();
            this.orthogonalStartSashDisposables.clear();
            if (sash) {
                var onChange = function (state) {
                    _this.orthogonalStartDragHandleDisposables.clear();
                    if (state !== 0 /* Disabled */) {
                        _this._orthogonalStartDragHandle = append(_this.el, $('.orthogonal-drag-handle.start'));
                        _this.orthogonalStartDragHandleDisposables.add(toDisposable(function () { return _this._orthogonalStartDragHandle.remove(); }));
                        domEvent(_this._orthogonalStartDragHandle, 'mouseenter')(function () { return Sash.onMouseEnter(sash); }, undefined, _this.orthogonalStartDragHandleDisposables);
                        domEvent(_this._orthogonalStartDragHandle, 'mouseleave')(function () { return Sash.onMouseLeave(sash); }, undefined, _this.orthogonalStartDragHandleDisposables);
                    }
                };
                this.orthogonalStartSashDisposables.add(sash.onDidEnablementChange(onChange, this));
                onChange(sash.state);
            }
            this._orthogonalStartSash = sash;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Sash.prototype, "orthogonalEndSash", {
        get: function () { return this._orthogonalEndSash; },
        set: function (sash) {
            var _this = this;
            this.orthogonalEndDragHandleDisposables.clear();
            this.orthogonalEndSashDisposables.clear();
            if (sash) {
                var onChange = function (state) {
                    _this.orthogonalEndDragHandleDisposables.clear();
                    if (state !== 0 /* Disabled */) {
                        _this._orthogonalEndDragHandle = append(_this.el, $('.orthogonal-drag-handle.end'));
                        _this.orthogonalEndDragHandleDisposables.add(toDisposable(function () { return _this._orthogonalEndDragHandle.remove(); }));
                        domEvent(_this._orthogonalEndDragHandle, 'mouseenter')(function () { return Sash.onMouseEnter(sash); }, undefined, _this.orthogonalEndDragHandleDisposables);
                        domEvent(_this._orthogonalEndDragHandle, 'mouseleave')(function () { return Sash.onMouseLeave(sash); }, undefined, _this.orthogonalEndDragHandleDisposables);
                    }
                };
                this.orthogonalEndSashDisposables.add(sash.onDidEnablementChange(onChange, this));
                onChange(sash.state);
            }
            this._orthogonalEndSash = sash;
        },
        enumerable: false,
        configurable: true
    });
    Sash.prototype.onMouseDown = function (e) {
        var e_1, _a;
        var _this = this;
        EventHelper.stop(e, false);
        var isMultisashResize = false;
        if (!e.__orthogonalSashEvent) {
            var orthogonalSash = this.getOrthogonalSash(e);
            if (orthogonalSash) {
                isMultisashResize = true;
                e.__orthogonalSashEvent = true;
                orthogonalSash.onMouseDown(e);
            }
        }
        if (this.linkedSash && !e.__linkedSashEvent) {
            e.__linkedSashEvent = true;
            this.linkedSash.onMouseDown(e);
        }
        if (!this.state) {
            return;
        }
        // Select both iframes and webviews; internally Electron nests an iframe
        // in its <webview> component, but this isn't queryable.
        var iframes = __spreadArray(__spreadArray([], __read(getElementsByTagName('iframe'))), __read(getElementsByTagName('webview')));
        try {
            for (var iframes_1 = __values(iframes), iframes_1_1 = iframes_1.next(); !iframes_1_1.done; iframes_1_1 = iframes_1.next()) {
                var iframe = iframes_1_1.value;
                iframe.style.pointerEvents = 'none'; // disable mouse events on iframes as long as we drag the sash
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iframes_1_1 && !iframes_1_1.done && (_a = iframes_1.return)) _a.call(iframes_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var mouseDownEvent = new StandardMouseEvent(e);
        var startX = mouseDownEvent.posx;
        var startY = mouseDownEvent.posy;
        var altKey = mouseDownEvent.altKey;
        var startEvent = { startX: startX, currentX: startX, startY: startY, currentY: startY, altKey: altKey };
        this.el.classList.add('active');
        this._onDidStart.fire(startEvent);
        // fix https://github.com/microsoft/vscode/issues/21675
        var style = createStyleSheet(this.el);
        var updateStyle = function () {
            var cursor = '';
            if (isMultisashResize) {
                cursor = 'all-scroll';
            }
            else if (_this.orientation === 1 /* HORIZONTAL */) {
                if (_this.state === 1 /* Minimum */) {
                    cursor = 's-resize';
                }
                else if (_this.state === 2 /* Maximum */) {
                    cursor = 'n-resize';
                }
                else {
                    cursor = isMacintosh ? 'row-resize' : 'ns-resize';
                }
            }
            else {
                if (_this.state === 1 /* Minimum */) {
                    cursor = 'e-resize';
                }
                else if (_this.state === 2 /* Maximum */) {
                    cursor = 'w-resize';
                }
                else {
                    cursor = isMacintosh ? 'col-resize' : 'ew-resize';
                }
            }
            style.textContent = "* { cursor: " + cursor + " !important; }";
        };
        var disposables = new DisposableStore();
        updateStyle();
        if (!isMultisashResize) {
            this.onDidEnablementChange(updateStyle, null, disposables);
        }
        var onMouseMove = function (e) {
            EventHelper.stop(e, false);
            var mouseMoveEvent = new StandardMouseEvent(e);
            var event = { startX: startX, currentX: mouseMoveEvent.posx, startY: startY, currentY: mouseMoveEvent.posy, altKey: altKey };
            _this._onDidChange.fire(event);
        };
        var onMouseUp = function (e) {
            var e_2, _a;
            EventHelper.stop(e, false);
            _this.el.removeChild(style);
            _this.el.classList.remove('active');
            _this._onDidEnd.fire();
            disposables.dispose();
            try {
                for (var iframes_2 = __values(iframes), iframes_2_1 = iframes_2.next(); !iframes_2_1.done; iframes_2_1 = iframes_2.next()) {
                    var iframe = iframes_2_1.value;
                    iframe.style.pointerEvents = 'auto';
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (iframes_2_1 && !iframes_2_1.done && (_a = iframes_2.return)) _a.call(iframes_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
        };
        domEvent(window, 'mousemove')(onMouseMove, null, disposables);
        domEvent(window, 'mouseup')(onMouseUp, null, disposables);
    };
    Sash.prototype.onMouseDoubleClick = function (e) {
        var orthogonalSash = this.getOrthogonalSash(e);
        if (orthogonalSash) {
            orthogonalSash._onDidReset.fire();
        }
        if (this.linkedSash) {
            this.linkedSash._onDidReset.fire();
        }
        this._onDidReset.fire();
    };
    Sash.prototype.onTouchStart = function (event) {
        var _this = this;
        EventHelper.stop(event);
        var listeners = [];
        var startX = event.pageX;
        var startY = event.pageY;
        var altKey = event.altKey;
        this._onDidStart.fire({
            startX: startX,
            currentX: startX,
            startY: startY,
            currentY: startY,
            altKey: altKey
        });
        listeners.push(addDisposableListener(this.el, EventType.Change, function (event) {
            if (types.isNumber(event.pageX) && types.isNumber(event.pageY)) {
                _this._onDidChange.fire({
                    startX: startX,
                    currentX: event.pageX,
                    startY: startY,
                    currentY: event.pageY,
                    altKey: altKey
                });
            }
        }));
        listeners.push(addDisposableListener(this.el, EventType.End, function () {
            _this._onDidEnd.fire();
            dispose(listeners);
        }));
    };
    Sash.onMouseEnter = function (sash, fromLinkedSash) {
        if (fromLinkedSash === void 0) { fromLinkedSash = false; }
        if (sash.el.classList.contains('active')) {
            sash.hoverDelayer.cancel();
            sash.el.classList.add('hover');
        }
        else {
            sash.hoverDelayer.trigger(function () { return sash.el.classList.add('hover'); });
        }
        if (!fromLinkedSash && sash.linkedSash) {
            Sash.onMouseEnter(sash.linkedSash, true);
        }
    };
    Sash.onMouseLeave = function (sash, fromLinkedSash) {
        if (fromLinkedSash === void 0) { fromLinkedSash = false; }
        sash.hoverDelayer.cancel();
        sash.el.classList.remove('hover');
        if (!fromLinkedSash && sash.linkedSash) {
            Sash.onMouseLeave(sash.linkedSash, true);
        }
    };
    Sash.prototype.layout = function () {
        if (this.orientation === 0 /* VERTICAL */) {
            var verticalProvider = this.layoutProvider;
            this.el.style.left = verticalProvider.getVerticalSashLeft(this) - (this.size / 2) + 'px';
            if (verticalProvider.getVerticalSashTop) {
                this.el.style.top = verticalProvider.getVerticalSashTop(this) + 'px';
            }
            if (verticalProvider.getVerticalSashHeight) {
                this.el.style.height = verticalProvider.getVerticalSashHeight(this) + 'px';
            }
        }
        else {
            var horizontalProvider = this.layoutProvider;
            this.el.style.top = horizontalProvider.getHorizontalSashTop(this) - (this.size / 2) + 'px';
            if (horizontalProvider.getHorizontalSashLeft) {
                this.el.style.left = horizontalProvider.getHorizontalSashLeft(this) + 'px';
            }
            if (horizontalProvider.getHorizontalSashWidth) {
                this.el.style.width = horizontalProvider.getHorizontalSashWidth(this) + 'px';
            }
        }
    };
    Sash.prototype.show = function () {
        this.hidden = false;
        this.el.style.removeProperty('display');
        this.el.setAttribute('aria-hidden', 'false');
    };
    Sash.prototype.hide = function () {
        this.hidden = true;
        this.el.style.display = 'none';
        this.el.setAttribute('aria-hidden', 'true');
    };
    Sash.prototype.isHidden = function () {
        return this.hidden;
    };
    Sash.prototype.getOrthogonalSash = function (e) {
        if (!e.target || !(e.target instanceof HTMLElement)) {
            return undefined;
        }
        if (e.target.classList.contains('orthogonal-drag-handle')) {
            return e.target.classList.contains('start') ? this.orthogonalStartSash : this.orthogonalEndSash;
        }
        return undefined;
    };
    Sash.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.el.remove();
    };
    return Sash;
}(Disposable));
export { Sash };
