/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { renderMarkdown } from '../../../base/browser/markdownRenderer';
import { IOpenerService } from '../../../platform/opener/common/opener';
import { IModeService } from '../../common/services/modeService';
import { onUnexpectedError } from '../../../base/common/errors';
import { tokenizeToString } from '../../common/modes/textToHtmlTokenizer';
import { Emitter } from '../../../base/common/event';
import { DisposableStore } from '../../../base/common/lifecycle';
import { TokenizationRegistry } from '../../common/modes';
/**
 * Markdown renderer that can render codeblocks with the editor mechanics. This
 * renderer should always be preferred.
 */
var MarkdownRenderer = /** @class */ (function () {
    function MarkdownRenderer(_options, _modeService, _openerService) {
        this._options = _options;
        this._modeService = _modeService;
        this._openerService = _openerService;
        this._onDidRenderAsync = new Emitter();
        this.onDidRenderAsync = this._onDidRenderAsync.event;
    }
    MarkdownRenderer.prototype.dispose = function () {
        this._onDidRenderAsync.dispose();
    };
    MarkdownRenderer.prototype.render = function (markdown, options, markedOptions) {
        var disposeables = new DisposableStore();
        var element;
        if (!markdown) {
            element = document.createElement('span');
        }
        else {
            element = renderMarkdown(markdown, __assign(__assign({}, this._getRenderOptions(disposeables)), options), markedOptions);
        }
        return {
            element: element,
            dispose: function () { return disposeables.dispose(); }
        };
    };
    MarkdownRenderer.prototype._getRenderOptions = function (disposeables) {
        var _this = this;
        return {
            baseUrl: this._options.baseUrl,
            codeBlockRenderer: function (languageAlias, value) { return __awaiter(_this, void 0, void 0, function () {
                var modeId, tokenization, element, fontFamily;
                var _a, _b, _c, _d;
                return __generator(this, function (_e) {
                    switch (_e.label) {
                        case 0:
                            if (languageAlias) {
                                modeId = this._modeService.getModeIdForLanguageName(languageAlias);
                            }
                            else if (this._options.editor) {
                                modeId = (_a = this._options.editor.getModel()) === null || _a === void 0 ? void 0 : _a.getLanguageIdentifier().language;
                            }
                            if (!modeId) {
                                modeId = 'plaintext';
                            }
                            this._modeService.triggerMode(modeId);
                            return [4 /*yield*/, TokenizationRegistry.getPromise(modeId)];
                        case 1:
                            tokenization = (_b = _e.sent()) !== null && _b !== void 0 ? _b : undefined;
                            element = document.createElement('span');
                            element.innerHTML = ((_d = (_c = MarkdownRenderer._ttpTokenizer) === null || _c === void 0 ? void 0 : _c.createHTML(value, tokenization)) !== null && _d !== void 0 ? _d : tokenizeToString(value, tokenization));
                            fontFamily = this._options.codeBlockFontFamily;
                            if (this._options.editor) {
                                fontFamily = this._options.editor.getOption(38 /* fontInfo */).fontFamily;
                            }
                            if (fontFamily) {
                                element.style.fontFamily = fontFamily;
                            }
                            return [2 /*return*/, element];
                    }
                });
            }); },
            asyncRenderCallback: function () { return _this._onDidRenderAsync.fire(); },
            actionHandler: {
                callback: function (content) { return _this._openerService.open(content, { fromUserGesture: true, allowContributedOpeners: true }).catch(onUnexpectedError); },
                disposeables: disposeables
            }
        };
    };
    var _a;
    MarkdownRenderer._ttpTokenizer = (_a = window.trustedTypes) === null || _a === void 0 ? void 0 : _a.createPolicy('tokenizeToString', {
        createHTML: function (value, tokenizer) {
            return tokenizeToString(value, tokenizer);
        }
    });
    MarkdownRenderer = __decorate([
        __param(1, IModeService),
        __param(2, IOpenerService)
    ], MarkdownRenderer);
    return MarkdownRenderer;
}());
export { MarkdownRenderer };
