/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as nls from '../../../nls';
import { EditorAction, registerEditorAction } from '../../browser/editorExtensions';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { MoveCaretCommand } from './moveCaretCommand';
var MoveCaretAction = /** @class */ (function (_super) {
    __extends(MoveCaretAction, _super);
    function MoveCaretAction(left, opts) {
        var _this = _super.call(this, opts) || this;
        _this.left = left;
        return _this;
    }
    MoveCaretAction.prototype.run = function (accessor, editor) {
        var e_1, _a;
        if (!editor.hasModel()) {
            return;
        }
        var commands = [];
        var selections = editor.getSelections();
        try {
            for (var selections_1 = __values(selections), selections_1_1 = selections_1.next(); !selections_1_1.done; selections_1_1 = selections_1.next()) {
                var selection = selections_1_1.value;
                commands.push(new MoveCaretCommand(selection, this.left));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (selections_1_1 && !selections_1_1.done && (_a = selections_1.return)) _a.call(selections_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        editor.pushUndoStop();
        editor.executeCommands(this.id, commands);
        editor.pushUndoStop();
    };
    return MoveCaretAction;
}(EditorAction));
var MoveCaretLeftAction = /** @class */ (function (_super) {
    __extends(MoveCaretLeftAction, _super);
    function MoveCaretLeftAction() {
        return _super.call(this, true, {
            id: 'editor.action.moveCarretLeftAction',
            label: nls.localize('caret.moveLeft', "Move Selected Text Left"),
            alias: 'Move Selected Text Left',
            precondition: EditorContextKeys.writable
        }) || this;
    }
    return MoveCaretLeftAction;
}(MoveCaretAction));
var MoveCaretRightAction = /** @class */ (function (_super) {
    __extends(MoveCaretRightAction, _super);
    function MoveCaretRightAction() {
        return _super.call(this, false, {
            id: 'editor.action.moveCarretRightAction',
            label: nls.localize('caret.moveRight', "Move Selected Text Right"),
            alias: 'Move Selected Text Right',
            precondition: EditorContextKeys.writable
        }) || this;
    }
    return MoveCaretRightAction;
}(MoveCaretAction));
registerEditorAction(MoveCaretLeftAction);
registerEditorAction(MoveCaretRightAction);
