/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { createDecorator as createServiceDecorator } from '../../instantiation/common/instantiation';
import { Disposable } from '../../../base/common/lifecycle';
import { isWindows } from '../../../base/common/platform';
import { Emitter } from '../../../base/common/event';
import { toErrorMessage } from '../../../base/common/errorMessage';
export var ILogService = createServiceDecorator('logService');
export var ILoggerService = createServiceDecorator('loggerService');
function now() {
    return new Date().toISOString();
}
export var LogLevel;
(function (LogLevel) {
    LogLevel[LogLevel["Trace"] = 0] = "Trace";
    LogLevel[LogLevel["Debug"] = 1] = "Debug";
    LogLevel[LogLevel["Info"] = 2] = "Info";
    LogLevel[LogLevel["Warning"] = 3] = "Warning";
    LogLevel[LogLevel["Error"] = 4] = "Error";
    LogLevel[LogLevel["Critical"] = 5] = "Critical";
    LogLevel[LogLevel["Off"] = 6] = "Off";
})(LogLevel || (LogLevel = {}));
export var DEFAULT_LOG_LEVEL = LogLevel.Info;
var AbstractLogger = /** @class */ (function (_super) {
    __extends(AbstractLogger, _super);
    function AbstractLogger() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.level = DEFAULT_LOG_LEVEL;
        _this._onDidChangeLogLevel = _this._register(new Emitter());
        _this.onDidChangeLogLevel = _this._onDidChangeLogLevel.event;
        return _this;
    }
    AbstractLogger.prototype.setLevel = function (level) {
        if (this.level !== level) {
            this.level = level;
            this._onDidChangeLogLevel.fire(this.level);
        }
    };
    AbstractLogger.prototype.getLevel = function () {
        return this.level;
    };
    return AbstractLogger;
}(Disposable));
export { AbstractLogger };
var AbstractMessageLogger = /** @class */ (function (_super) {
    __extends(AbstractMessageLogger, _super);
    function AbstractMessageLogger(logAlways) {
        var _this = _super.call(this) || this;
        _this.logAlways = logAlways;
        return _this;
    }
    AbstractMessageLogger.prototype.checkLogLevel = function (level) {
        return this.logAlways || this.getLevel() <= level;
    };
    AbstractMessageLogger.prototype.trace = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.checkLogLevel(LogLevel.Trace)) {
            this.log(LogLevel.Trace, this.format(__spreadArray([message], __read(args))));
        }
    };
    AbstractMessageLogger.prototype.debug = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.checkLogLevel(LogLevel.Debug)) {
            this.log(LogLevel.Debug, this.format(__spreadArray([message], __read(args))));
        }
    };
    AbstractMessageLogger.prototype.info = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.checkLogLevel(LogLevel.Info)) {
            this.log(LogLevel.Info, this.format(__spreadArray([message], __read(args))));
        }
    };
    AbstractMessageLogger.prototype.warn = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.checkLogLevel(LogLevel.Warning)) {
            this.log(LogLevel.Warning, this.format(__spreadArray([message], __read(args))));
        }
    };
    AbstractMessageLogger.prototype.error = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.checkLogLevel(LogLevel.Error)) {
            if (message instanceof Error) {
                var array = Array.prototype.slice.call(arguments);
                array[0] = message.stack;
                this.log(LogLevel.Error, this.format(array));
            }
            else {
                this.log(LogLevel.Error, this.format(__spreadArray([message], __read(args))));
            }
        }
    };
    AbstractMessageLogger.prototype.critical = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.checkLogLevel(LogLevel.Critical)) {
            this.log(LogLevel.Critical, this.format(__spreadArray([message], __read(args))));
        }
    };
    AbstractMessageLogger.prototype.flush = function () { };
    AbstractMessageLogger.prototype.format = function (args) {
        var result = '';
        for (var i = 0; i < args.length; i++) {
            var a = args[i];
            if (typeof a === 'object') {
                try {
                    a = JSON.stringify(a);
                }
                catch (e) { }
            }
            result += (i > 0 ? ' ' : '') + a;
        }
        return result;
    };
    return AbstractMessageLogger;
}(AbstractLogger));
export { AbstractMessageLogger };
var ConsoleMainLogger = /** @class */ (function (_super) {
    __extends(ConsoleMainLogger, _super);
    function ConsoleMainLogger(logLevel) {
        if (logLevel === void 0) { logLevel = DEFAULT_LOG_LEVEL; }
        var _this = _super.call(this) || this;
        _this.setLevel(logLevel);
        _this.useColors = !isWindows;
        return _this;
    }
    ConsoleMainLogger.prototype.trace = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Trace) {
            if (this.useColors) {
                console.log.apply(console, __spreadArray(["\u001B[90m[main " + now() + "]\u001B[0m", message], __read(args)));
            }
            else {
                console.log.apply(console, __spreadArray(["[main " + now() + "]", message], __read(args)));
            }
        }
    };
    ConsoleMainLogger.prototype.debug = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Debug) {
            if (this.useColors) {
                console.log.apply(console, __spreadArray(["\u001B[90m[main " + now() + "]\u001B[0m", message], __read(args)));
            }
            else {
                console.log.apply(console, __spreadArray(["[main " + now() + "]", message], __read(args)));
            }
        }
    };
    ConsoleMainLogger.prototype.info = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Info) {
            if (this.useColors) {
                console.log.apply(console, __spreadArray(["\u001B[90m[main " + now() + "]\u001B[0m", message], __read(args)));
            }
            else {
                console.log.apply(console, __spreadArray(["[main " + now() + "]", message], __read(args)));
            }
        }
    };
    ConsoleMainLogger.prototype.warn = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Warning) {
            if (this.useColors) {
                console.warn.apply(console, __spreadArray(["\u001B[93m[main " + now() + "]\u001B[0m", message], __read(args)));
            }
            else {
                console.warn.apply(console, __spreadArray(["[main " + now() + "]", message], __read(args)));
            }
        }
    };
    ConsoleMainLogger.prototype.error = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Error) {
            if (this.useColors) {
                console.error.apply(console, __spreadArray(["\u001B[91m[main " + now() + "]\u001B[0m", message], __read(args)));
            }
            else {
                console.error.apply(console, __spreadArray(["[main " + now() + "]", message], __read(args)));
            }
        }
    };
    ConsoleMainLogger.prototype.critical = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Critical) {
            if (this.useColors) {
                console.error.apply(console, __spreadArray(["\u001B[90m[main " + now() + "]\u001B[0m", message], __read(args)));
            }
            else {
                console.error.apply(console, __spreadArray(["[main " + now() + "]", message], __read(args)));
            }
        }
    };
    ConsoleMainLogger.prototype.dispose = function () {
        // noop
    };
    ConsoleMainLogger.prototype.flush = function () {
        // noop
    };
    return ConsoleMainLogger;
}(AbstractLogger));
export { ConsoleMainLogger };
var ConsoleLogger = /** @class */ (function (_super) {
    __extends(ConsoleLogger, _super);
    function ConsoleLogger(logLevel) {
        if (logLevel === void 0) { logLevel = DEFAULT_LOG_LEVEL; }
        var _this = _super.call(this) || this;
        _this.setLevel(logLevel);
        return _this;
    }
    ConsoleLogger.prototype.trace = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Trace) {
            console.log.apply(console, __spreadArray(['%cTRACE', 'color: #888', message], __read(args)));
        }
    };
    ConsoleLogger.prototype.debug = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Debug) {
            console.log.apply(console, __spreadArray(['%cDEBUG', 'background: #eee; color: #888', message], __read(args)));
        }
    };
    ConsoleLogger.prototype.info = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Info) {
            console.log.apply(console, __spreadArray(['%c INFO', 'color: #33f', message], __read(args)));
        }
    };
    ConsoleLogger.prototype.warn = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Warning) {
            console.log.apply(console, __spreadArray(['%c WARN', 'color: #993', message], __read(args)));
        }
    };
    ConsoleLogger.prototype.error = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Error) {
            console.log.apply(console, __spreadArray(['%c  ERR', 'color: #f33', message], __read(args)));
        }
    };
    ConsoleLogger.prototype.critical = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Critical) {
            console.log.apply(console, __spreadArray(['%cCRITI', 'background: #f33; color: white', message], __read(args)));
        }
    };
    ConsoleLogger.prototype.dispose = function () {
        // noop
    };
    ConsoleLogger.prototype.flush = function () {
        // noop
    };
    return ConsoleLogger;
}(AbstractLogger));
export { ConsoleLogger };
var AdapterLogger = /** @class */ (function (_super) {
    __extends(AdapterLogger, _super);
    function AdapterLogger(adapter, logLevel) {
        if (logLevel === void 0) { logLevel = DEFAULT_LOG_LEVEL; }
        var _this = _super.call(this) || this;
        _this.adapter = adapter;
        _this.setLevel(logLevel);
        return _this;
    }
    AdapterLogger.prototype.trace = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Trace) {
            this.adapter.log(LogLevel.Trace, __spreadArray([this.extractMessage(message)], __read(args)));
        }
    };
    AdapterLogger.prototype.debug = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Debug) {
            this.adapter.log(LogLevel.Debug, __spreadArray([this.extractMessage(message)], __read(args)));
        }
    };
    AdapterLogger.prototype.info = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Info) {
            this.adapter.log(LogLevel.Info, __spreadArray([this.extractMessage(message)], __read(args)));
        }
    };
    AdapterLogger.prototype.warn = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Warning) {
            this.adapter.log(LogLevel.Warning, __spreadArray([this.extractMessage(message)], __read(args)));
        }
    };
    AdapterLogger.prototype.error = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Error) {
            this.adapter.log(LogLevel.Error, __spreadArray([this.extractMessage(message)], __read(args)));
        }
    };
    AdapterLogger.prototype.critical = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.getLevel() <= LogLevel.Critical) {
            this.adapter.log(LogLevel.Critical, __spreadArray([this.extractMessage(message)], __read(args)));
        }
    };
    AdapterLogger.prototype.extractMessage = function (msg) {
        if (typeof msg === 'string') {
            return msg;
        }
        return toErrorMessage(msg, this.getLevel() <= LogLevel.Trace);
    };
    AdapterLogger.prototype.dispose = function () {
        // noop
    };
    AdapterLogger.prototype.flush = function () {
        // noop
    };
    return AdapterLogger;
}(AbstractLogger));
export { AdapterLogger };
var MultiplexLogService = /** @class */ (function (_super) {
    __extends(MultiplexLogService, _super);
    function MultiplexLogService(logServices) {
        var _this = _super.call(this) || this;
        _this.logServices = logServices;
        if (logServices.length) {
            _this.setLevel(logServices[0].getLevel());
        }
        return _this;
    }
    MultiplexLogService.prototype.setLevel = function (level) {
        var e_1, _a;
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.setLevel(level);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        _super.prototype.setLevel.call(this, level);
    };
    MultiplexLogService.prototype.trace = function (message) {
        var e_2, _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.trace.apply(logService, __spreadArray([message], __read(args)));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    MultiplexLogService.prototype.debug = function (message) {
        var e_3, _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.debug.apply(logService, __spreadArray([message], __read(args)));
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    MultiplexLogService.prototype.info = function (message) {
        var e_4, _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.info.apply(logService, __spreadArray([message], __read(args)));
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
    };
    MultiplexLogService.prototype.warn = function (message) {
        var e_5, _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.warn.apply(logService, __spreadArray([message], __read(args)));
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
    };
    MultiplexLogService.prototype.error = function (message) {
        var e_6, _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.error.apply(logService, __spreadArray([message], __read(args)));
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_6) throw e_6.error; }
        }
    };
    MultiplexLogService.prototype.critical = function (message) {
        var e_7, _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.critical.apply(logService, __spreadArray([message], __read(args)));
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_7) throw e_7.error; }
        }
    };
    MultiplexLogService.prototype.flush = function () {
        var e_8, _a;
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.flush();
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_8) throw e_8.error; }
        }
    };
    MultiplexLogService.prototype.dispose = function () {
        var e_9, _a;
        try {
            for (var _b = __values(this.logServices), _c = _b.next(); !_c.done; _c = _b.next()) {
                var logService = _c.value;
                logService.dispose();
            }
        }
        catch (e_9_1) { e_9 = { error: e_9_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_9) throw e_9.error; }
        }
    };
    return MultiplexLogService;
}(AbstractLogger));
export { MultiplexLogService };
var LogService = /** @class */ (function (_super) {
    __extends(LogService, _super);
    function LogService(logger) {
        var _this = _super.call(this) || this;
        _this.logger = logger;
        _this._register(logger);
        return _this;
    }
    Object.defineProperty(LogService.prototype, "onDidChangeLogLevel", {
        get: function () {
            return this.logger.onDidChangeLogLevel;
        },
        enumerable: false,
        configurable: true
    });
    LogService.prototype.setLevel = function (level) {
        this.logger.setLevel(level);
    };
    LogService.prototype.getLevel = function () {
        return this.logger.getLevel();
    };
    LogService.prototype.trace = function (message) {
        var _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        (_a = this.logger).trace.apply(_a, __spreadArray([message], __read(args)));
    };
    LogService.prototype.debug = function (message) {
        var _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        (_a = this.logger).debug.apply(_a, __spreadArray([message], __read(args)));
    };
    LogService.prototype.info = function (message) {
        var _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        (_a = this.logger).info.apply(_a, __spreadArray([message], __read(args)));
    };
    LogService.prototype.warn = function (message) {
        var _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        (_a = this.logger).warn.apply(_a, __spreadArray([message], __read(args)));
    };
    LogService.prototype.error = function (message) {
        var _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        (_a = this.logger).error.apply(_a, __spreadArray([message], __read(args)));
    };
    LogService.prototype.critical = function (message) {
        var _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        (_a = this.logger).critical.apply(_a, __spreadArray([message], __read(args)));
    };
    LogService.prototype.flush = function () {
        this.logger.flush();
    };
    return LogService;
}(Disposable));
export { LogService };
var NullLogService = /** @class */ (function () {
    function NullLogService() {
        this.onDidChangeLogLevel = new Emitter().event;
    }
    NullLogService.prototype.setLevel = function (level) { };
    NullLogService.prototype.getLevel = function () { return LogLevel.Info; };
    NullLogService.prototype.trace = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
    };
    NullLogService.prototype.debug = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
    };
    NullLogService.prototype.info = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
    };
    NullLogService.prototype.warn = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
    };
    NullLogService.prototype.error = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
    };
    NullLogService.prototype.critical = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
    };
    NullLogService.prototype.dispose = function () { };
    NullLogService.prototype.flush = function () { };
    return NullLogService;
}());
export { NullLogService };
export function getLogLevel(environmentService) {
    if (environmentService.verbose) {
        return LogLevel.Trace;
    }
    if (typeof environmentService.logLevel === 'string') {
        var logLevel = parseLogLevel(environmentService.logLevel.toLowerCase());
        if (logLevel !== undefined) {
            return logLevel;
        }
    }
    return DEFAULT_LOG_LEVEL;
}
export function parseLogLevel(logLevel) {
    switch (logLevel) {
        case 'trace':
            return LogLevel.Trace;
        case 'debug':
            return LogLevel.Debug;
        case 'info':
            return LogLevel.Info;
        case 'warn':
            return LogLevel.Warning;
        case 'error':
            return LogLevel.Error;
        case 'critical':
            return LogLevel.Critical;
        case 'off':
            return LogLevel.Off;
    }
    return undefined;
}
export function LogLevelToString(logLevel) {
    switch (logLevel) {
        case LogLevel.Trace: return 'trace';
        case LogLevel.Debug: return 'debug';
        case LogLevel.Info: return 'info';
        case LogLevel.Warning: return 'warn';
        case LogLevel.Error: return 'error';
        case LogLevel.Critical: return 'critical';
        case LogLevel.Off: return 'off';
    }
}
