/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import Severity from '../../../base/common/severity';
import { registerThemingParticipant } from '../../theme/common/themeService';
import { problemsErrorIconForeground, problemsInfoIconForeground, problemsWarningIconForeground } from '../../theme/common/colorRegistry';
import { Codicon } from '../../../base/common/codicons';
export var SeverityIcon;
(function (SeverityIcon) {
    function className(severity) {
        switch (severity) {
            case Severity.Ignore:
                return 'severity-ignore ' + Codicon.info.classNames;
            case Severity.Info:
                return Codicon.info.classNames;
            case Severity.Warning:
                return Codicon.warning.classNames;
            case Severity.Error:
                return Codicon.error.classNames;
            default:
                return '';
        }
    }
    SeverityIcon.className = className;
})(SeverityIcon || (SeverityIcon = {}));
registerThemingParticipant(function (theme, collector) {
    var errorIconForeground = theme.getColor(problemsErrorIconForeground);
    if (errorIconForeground) {
        var errorCodiconSelector = Codicon.error.cssSelector;
        collector.addRule("\n\t\t\t.monaco-editor .zone-widget " + errorCodiconSelector + ",\n\t\t\t.markers-panel .marker-icon" + errorCodiconSelector + ",\n\t\t\t.extensions-viewlet > .extensions " + errorCodiconSelector + " {\n\t\t\t\tcolor: " + errorIconForeground + ";\n\t\t\t}\n\t\t");
    }
    var warningIconForeground = theme.getColor(problemsWarningIconForeground);
    if (warningIconForeground) {
        var warningCodiconSelector = Codicon.warning.cssSelector;
        collector.addRule("\n\t\t\t.monaco-editor .zone-widget " + warningCodiconSelector + ",\n\t\t\t.markers-panel .marker-icon" + warningCodiconSelector + ",\n\t\t\t.extensions-viewlet > .extensions " + warningCodiconSelector + ",\n\t\t\t.extension-editor " + warningCodiconSelector + " {\n\t\t\t\tcolor: " + warningIconForeground + ";\n\t\t\t}\n\t\t");
    }
    var infoIconForeground = theme.getColor(problemsInfoIconForeground);
    if (infoIconForeground) {
        var infoCodiconSelector = Codicon.info.cssSelector;
        collector.addRule("\n\t\t\t.monaco-editor .zone-widget " + infoCodiconSelector + ",\n\t\t\t.markers-panel .marker-icon" + infoCodiconSelector + ",\n\t\t\t.extensions-viewlet > .extensions " + infoCodiconSelector + ",\n\t\t\t.extension-editor " + infoCodiconSelector + " {\n\t\t\t\tcolor: " + infoIconForeground + ";\n\t\t\t}\n\t\t");
    }
});
