/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { createDecorator } from '../../instantiation/common/instantiation';
import { toDisposable, Disposable } from '../../../base/common/lifecycle';
import * as platform from '../../registry/common/platform';
import { Emitter } from '../../../base/common/event';
import { ColorScheme } from './theme';
import { Codicon, CSSIcon } from '../../../base/common/codicons';
export var IThemeService = createDecorator('themeService');
export var ThemeColor;
(function (ThemeColor) {
    function isThemeColor(obj) {
        return obj && typeof obj === 'object' && typeof obj.id === 'string';
    }
    ThemeColor.isThemeColor = isThemeColor;
})(ThemeColor || (ThemeColor = {}));
export function themeColorFromId(id) {
    return { id: id };
}
export var ThemeIcon;
(function (ThemeIcon) {
    function isThemeIcon(obj) {
        return obj && typeof obj === 'object' && typeof obj.id === 'string' && (typeof obj.color === 'undefined' || ThemeColor.isThemeColor(obj.color));
    }
    ThemeIcon.isThemeIcon = isThemeIcon;
    var _regexFromString = new RegExp("^\\$\\((" + CSSIcon.iconNameExpression + "(?:" + CSSIcon.iconModifierExpression + ")?)\\)$");
    function fromString(str) {
        var match = _regexFromString.exec(str);
        if (!match) {
            return undefined;
        }
        var _a = __read(match, 2), name = _a[1];
        return { id: name };
    }
    ThemeIcon.fromString = fromString;
    function modify(icon, modifier) {
        var id = icon.id;
        var tildeIndex = id.lastIndexOf('~');
        if (tildeIndex !== -1) {
            id = id.substring(0, tildeIndex);
        }
        if (modifier) {
            id = id + "~" + modifier;
        }
        return { id: id };
    }
    ThemeIcon.modify = modify;
    function isEqual(ti1, ti2) {
        var _a, _b;
        return ti1.id === ti2.id && ((_a = ti1.color) === null || _a === void 0 ? void 0 : _a.id) === ((_b = ti2.color) === null || _b === void 0 ? void 0 : _b.id);
    }
    ThemeIcon.isEqual = isEqual;
    ThemeIcon.asClassNameArray = CSSIcon.asClassNameArray;
    ThemeIcon.asClassName = CSSIcon.asClassName;
    ThemeIcon.asCSSSelector = CSSIcon.asCSSSelector;
})(ThemeIcon || (ThemeIcon = {}));
export var FileThemeIcon = Codicon.file;
export var FolderThemeIcon = Codicon.folder;
export function getThemeTypeSelector(type) {
    switch (type) {
        case ColorScheme.DARK: return 'vs-dark';
        case ColorScheme.HIGH_CONTRAST: return 'hc-black';
        default: return 'vs';
    }
}
// static theming participant
export var Extensions = {
    ThemingContribution: 'base.contributions.theming'
};
var ThemingRegistry = /** @class */ (function () {
    function ThemingRegistry() {
        this.themingParticipants = [];
        this.themingParticipants = [];
        this.onThemingParticipantAddedEmitter = new Emitter();
    }
    ThemingRegistry.prototype.onColorThemeChange = function (participant) {
        var _this = this;
        this.themingParticipants.push(participant);
        this.onThemingParticipantAddedEmitter.fire(participant);
        return toDisposable(function () {
            var idx = _this.themingParticipants.indexOf(participant);
            _this.themingParticipants.splice(idx, 1);
        });
    };
    Object.defineProperty(ThemingRegistry.prototype, "onThemingParticipantAdded", {
        get: function () {
            return this.onThemingParticipantAddedEmitter.event;
        },
        enumerable: false,
        configurable: true
    });
    ThemingRegistry.prototype.getThemingParticipants = function () {
        return this.themingParticipants;
    };
    return ThemingRegistry;
}());
var themingRegistry = new ThemingRegistry();
platform.Registry.add(Extensions.ThemingContribution, themingRegistry);
export function registerThemingParticipant(participant) {
    return themingRegistry.onColorThemeChange(participant);
}
/**
 * Utility base class for all themable components.
 */
var Themable = /** @class */ (function (_super) {
    __extends(Themable, _super);
    function Themable(themeService) {
        var _this = _super.call(this) || this;
        _this.themeService = themeService;
        _this.theme = themeService.getColorTheme();
        // Hook up to theme changes
        _this._register(_this.themeService.onDidColorThemeChange(function (theme) { return _this.onThemeChange(theme); }));
        return _this;
    }
    Themable.prototype.onThemeChange = function (theme) {
        this.theme = theme;
        this.updateStyles();
    };
    Themable.prototype.updateStyles = function () {
        // Subclasses to override
    };
    Themable.prototype.getColor = function (id, modify) {
        var color = this.theme.getColor(id);
        if (color && modify) {
            color = modify(color, this.theme);
        }
        return color ? color.toString() : null;
    };
    return Themable;
}(Disposable));
export { Themable };
