/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import * as nls from '../../../nls';
import { IUndoRedoService, ResourceEditStackSnapshot, UndoRedoGroup, UndoRedoSource } from './undoRedo';
import { onUnexpectedError } from '../../../base/common/errors';
import { registerSingleton } from '../../instantiation/common/extensions';
import { IDialogService } from '../../dialogs/common/dialogs';
import Severity from '../../../base/common/severity';
import { Schemas } from '../../../base/common/network';
import { INotificationService } from '../../notification/common/notification';
import { Disposable, isDisposable } from '../../../base/common/lifecycle';
var DEBUG = false;
function getResourceLabel(resource) {
    return resource.scheme === Schemas.file ? resource.fsPath : resource.path;
}
var stackElementCounter = 0;
var ResourceStackElement = /** @class */ (function () {
    function ResourceStackElement(actual, resourceLabel, strResource, groupId, groupOrder, sourceId, sourceOrder) {
        this.id = (++stackElementCounter);
        this.type = 0 /* Resource */;
        this.actual = actual;
        this.label = actual.label;
        this.confirmBeforeUndo = actual.confirmBeforeUndo || false;
        this.resourceLabel = resourceLabel;
        this.strResource = strResource;
        this.resourceLabels = [this.resourceLabel];
        this.strResources = [this.strResource];
        this.groupId = groupId;
        this.groupOrder = groupOrder;
        this.sourceId = sourceId;
        this.sourceOrder = sourceOrder;
        this.isValid = true;
    }
    ResourceStackElement.prototype.setValid = function (isValid) {
        this.isValid = isValid;
    };
    ResourceStackElement.prototype.toString = function () {
        return "[id:" + this.id + "] [group:" + this.groupId + "] [" + (this.isValid ? '  VALID' : 'INVALID') + "] " + this.actual.constructor.name + " - " + this.actual;
    };
    return ResourceStackElement;
}());
var ResourceReasonPair = /** @class */ (function () {
    function ResourceReasonPair(resourceLabel, reason) {
        this.resourceLabel = resourceLabel;
        this.reason = reason;
    }
    return ResourceReasonPair;
}());
var RemovedResources = /** @class */ (function () {
    function RemovedResources() {
        this.elements = new Map();
    }
    RemovedResources.prototype.createMessage = function () {
        var e_1, _a;
        var externalRemoval = [];
        var noParallelUniverses = [];
        try {
            for (var _b = __values(this.elements), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), element = _d[1];
                var dest = (element.reason === 0 /* ExternalRemoval */
                    ? externalRemoval
                    : noParallelUniverses);
                dest.push(element.resourceLabel);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var messages = [];
        if (externalRemoval.length > 0) {
            messages.push(nls.localize({ key: 'externalRemoval', comment: ['{0} is a list of filenames'] }, "The following files have been closed and modified on disk: {0}.", externalRemoval.join(', ')));
        }
        if (noParallelUniverses.length > 0) {
            messages.push(nls.localize({ key: 'noParallelUniverses', comment: ['{0} is a list of filenames'] }, "The following files have been modified in an incompatible way: {0}.", noParallelUniverses.join(', ')));
        }
        return messages.join('\n');
    };
    Object.defineProperty(RemovedResources.prototype, "size", {
        get: function () {
            return this.elements.size;
        },
        enumerable: false,
        configurable: true
    });
    RemovedResources.prototype.has = function (strResource) {
        return this.elements.has(strResource);
    };
    RemovedResources.prototype.set = function (strResource, value) {
        this.elements.set(strResource, value);
    };
    RemovedResources.prototype.delete = function (strResource) {
        return this.elements.delete(strResource);
    };
    return RemovedResources;
}());
var WorkspaceStackElement = /** @class */ (function () {
    function WorkspaceStackElement(actual, resourceLabels, strResources, groupId, groupOrder, sourceId, sourceOrder) {
        this.id = (++stackElementCounter);
        this.type = 1 /* Workspace */;
        this.actual = actual;
        this.label = actual.label;
        this.confirmBeforeUndo = actual.confirmBeforeUndo || false;
        this.resourceLabels = resourceLabels;
        this.strResources = strResources;
        this.groupId = groupId;
        this.groupOrder = groupOrder;
        this.sourceId = sourceId;
        this.sourceOrder = sourceOrder;
        this.removedResources = null;
        this.invalidatedResources = null;
    }
    WorkspaceStackElement.prototype.canSplit = function () {
        return (typeof this.actual.split === 'function');
    };
    WorkspaceStackElement.prototype.removeResource = function (resourceLabel, strResource, reason) {
        if (!this.removedResources) {
            this.removedResources = new RemovedResources();
        }
        if (!this.removedResources.has(strResource)) {
            this.removedResources.set(strResource, new ResourceReasonPair(resourceLabel, reason));
        }
    };
    WorkspaceStackElement.prototype.setValid = function (resourceLabel, strResource, isValid) {
        if (isValid) {
            if (this.invalidatedResources) {
                this.invalidatedResources.delete(strResource);
                if (this.invalidatedResources.size === 0) {
                    this.invalidatedResources = null;
                }
            }
        }
        else {
            if (!this.invalidatedResources) {
                this.invalidatedResources = new RemovedResources();
            }
            if (!this.invalidatedResources.has(strResource)) {
                this.invalidatedResources.set(strResource, new ResourceReasonPair(resourceLabel, 0 /* ExternalRemoval */));
            }
        }
    };
    WorkspaceStackElement.prototype.toString = function () {
        return "[id:" + this.id + "] [group:" + this.groupId + "] [" + (this.invalidatedResources ? 'INVALID' : '  VALID') + "] " + this.actual.constructor.name + " - " + this.actual;
    };
    return WorkspaceStackElement;
}());
var ResourceEditStack = /** @class */ (function () {
    function ResourceEditStack(resourceLabel, strResource) {
        this.resourceLabel = resourceLabel;
        this.strResource = strResource;
        this._past = [];
        this._future = [];
        this.locked = false;
        this.versionId = 1;
    }
    ResourceEditStack.prototype.dispose = function () {
        var e_2, _a, e_3, _b;
        try {
            for (var _c = __values(this._past), _d = _c.next(); !_d.done; _d = _c.next()) {
                var element = _d.value;
                if (element.type === 1 /* Workspace */) {
                    element.removeResource(this.resourceLabel, this.strResource, 0 /* ExternalRemoval */);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        try {
            for (var _e = __values(this._future), _f = _e.next(); !_f.done; _f = _e.next()) {
                var element = _f.value;
                if (element.type === 1 /* Workspace */) {
                    element.removeResource(this.resourceLabel, this.strResource, 0 /* ExternalRemoval */);
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_3) throw e_3.error; }
        }
        this.versionId++;
    };
    ResourceEditStack.prototype.toString = function () {
        var result = [];
        result.push("* " + this.strResource + ":");
        for (var i = 0; i < this._past.length; i++) {
            result.push("   * [UNDO] " + this._past[i]);
        }
        for (var i = this._future.length - 1; i >= 0; i--) {
            result.push("   * [REDO] " + this._future[i]);
        }
        return result.join('\n');
    };
    ResourceEditStack.prototype.flushAllElements = function () {
        this._past = [];
        this._future = [];
        this.versionId++;
    };
    ResourceEditStack.prototype.setElementsIsValid = function (isValid) {
        var e_4, _a, e_5, _b;
        try {
            for (var _c = __values(this._past), _d = _c.next(); !_d.done; _d = _c.next()) {
                var element = _d.value;
                if (element.type === 1 /* Workspace */) {
                    element.setValid(this.resourceLabel, this.strResource, isValid);
                }
                else {
                    element.setValid(isValid);
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_4) throw e_4.error; }
        }
        try {
            for (var _e = __values(this._future), _f = _e.next(); !_f.done; _f = _e.next()) {
                var element = _f.value;
                if (element.type === 1 /* Workspace */) {
                    element.setValid(this.resourceLabel, this.strResource, isValid);
                }
                else {
                    element.setValid(isValid);
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_5) throw e_5.error; }
        }
    };
    ResourceEditStack.prototype._setElementValidFlag = function (element, isValid) {
        if (element.type === 1 /* Workspace */) {
            element.setValid(this.resourceLabel, this.strResource, isValid);
        }
        else {
            element.setValid(isValid);
        }
    };
    ResourceEditStack.prototype.setElementsValidFlag = function (isValid, filter) {
        var e_6, _a, e_7, _b;
        try {
            for (var _c = __values(this._past), _d = _c.next(); !_d.done; _d = _c.next()) {
                var element = _d.value;
                if (filter(element.actual)) {
                    this._setElementValidFlag(element, isValid);
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_6) throw e_6.error; }
        }
        try {
            for (var _e = __values(this._future), _f = _e.next(); !_f.done; _f = _e.next()) {
                var element = _f.value;
                if (filter(element.actual)) {
                    this._setElementValidFlag(element, isValid);
                }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_7) throw e_7.error; }
        }
    };
    ResourceEditStack.prototype.pushElement = function (element) {
        var e_8, _a;
        try {
            // remove the future
            for (var _b = __values(this._future), _c = _b.next(); !_c.done; _c = _b.next()) {
                var futureElement = _c.value;
                if (futureElement.type === 1 /* Workspace */) {
                    futureElement.removeResource(this.resourceLabel, this.strResource, 1 /* NoParallelUniverses */);
                }
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_8) throw e_8.error; }
        }
        this._future = [];
        this._past.push(element);
        this.versionId++;
    };
    ResourceEditStack.prototype.createSnapshot = function (resource) {
        var elements = [];
        for (var i = 0, len = this._past.length; i < len; i++) {
            elements.push(this._past[i].id);
        }
        for (var i = this._future.length - 1; i >= 0; i--) {
            elements.push(this._future[i].id);
        }
        return new ResourceEditStackSnapshot(resource, elements);
    };
    ResourceEditStack.prototype.restoreSnapshot = function (snapshot) {
        var snapshotLength = snapshot.elements.length;
        var isOK = true;
        var snapshotIndex = 0;
        var removePastAfter = -1;
        for (var i = 0, len = this._past.length; i < len; i++, snapshotIndex++) {
            var element = this._past[i];
            if (isOK && (snapshotIndex >= snapshotLength || element.id !== snapshot.elements[snapshotIndex])) {
                isOK = false;
                removePastAfter = 0;
            }
            if (!isOK && element.type === 1 /* Workspace */) {
                element.removeResource(this.resourceLabel, this.strResource, 0 /* ExternalRemoval */);
            }
        }
        var removeFutureBefore = -1;
        for (var i = this._future.length - 1; i >= 0; i--, snapshotIndex++) {
            var element = this._future[i];
            if (isOK && (snapshotIndex >= snapshotLength || element.id !== snapshot.elements[snapshotIndex])) {
                isOK = false;
                removeFutureBefore = i;
            }
            if (!isOK && element.type === 1 /* Workspace */) {
                element.removeResource(this.resourceLabel, this.strResource, 0 /* ExternalRemoval */);
            }
        }
        if (removePastAfter !== -1) {
            this._past = this._past.slice(0, removePastAfter);
        }
        if (removeFutureBefore !== -1) {
            this._future = this._future.slice(removeFutureBefore + 1);
        }
        this.versionId++;
    };
    ResourceEditStack.prototype.getElements = function () {
        var e_9, _a, e_10, _b;
        var past = [];
        var future = [];
        try {
            for (var _c = __values(this._past), _d = _c.next(); !_d.done; _d = _c.next()) {
                var element = _d.value;
                past.push(element.actual);
            }
        }
        catch (e_9_1) { e_9 = { error: e_9_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_9) throw e_9.error; }
        }
        try {
            for (var _e = __values(this._future), _f = _e.next(); !_f.done; _f = _e.next()) {
                var element = _f.value;
                future.push(element.actual);
            }
        }
        catch (e_10_1) { e_10 = { error: e_10_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_10) throw e_10.error; }
        }
        return { past: past, future: future };
    };
    ResourceEditStack.prototype.getClosestPastElement = function () {
        if (this._past.length === 0) {
            return null;
        }
        return this._past[this._past.length - 1];
    };
    ResourceEditStack.prototype.getSecondClosestPastElement = function () {
        if (this._past.length < 2) {
            return null;
        }
        return this._past[this._past.length - 2];
    };
    ResourceEditStack.prototype.getClosestFutureElement = function () {
        if (this._future.length === 0) {
            return null;
        }
        return this._future[this._future.length - 1];
    };
    ResourceEditStack.prototype.hasPastElements = function () {
        return (this._past.length > 0);
    };
    ResourceEditStack.prototype.hasFutureElements = function () {
        return (this._future.length > 0);
    };
    ResourceEditStack.prototype.splitPastWorkspaceElement = function (toRemove, individualMap) {
        for (var j = this._past.length - 1; j >= 0; j--) {
            if (this._past[j] === toRemove) {
                if (individualMap.has(this.strResource)) {
                    // gets replaced
                    this._past[j] = individualMap.get(this.strResource);
                }
                else {
                    // gets deleted
                    this._past.splice(j, 1);
                }
                break;
            }
        }
        this.versionId++;
    };
    ResourceEditStack.prototype.splitFutureWorkspaceElement = function (toRemove, individualMap) {
        for (var j = this._future.length - 1; j >= 0; j--) {
            if (this._future[j] === toRemove) {
                if (individualMap.has(this.strResource)) {
                    // gets replaced
                    this._future[j] = individualMap.get(this.strResource);
                }
                else {
                    // gets deleted
                    this._future.splice(j, 1);
                }
                break;
            }
        }
        this.versionId++;
    };
    ResourceEditStack.prototype.moveBackward = function (element) {
        this._past.pop();
        this._future.push(element);
        this.versionId++;
    };
    ResourceEditStack.prototype.moveForward = function (element) {
        this._future.pop();
        this._past.push(element);
        this.versionId++;
    };
    return ResourceEditStack;
}());
var EditStackSnapshot = /** @class */ (function () {
    function EditStackSnapshot(editStacks) {
        this.editStacks = editStacks;
        this._versionIds = [];
        for (var i = 0, len = this.editStacks.length; i < len; i++) {
            this._versionIds[i] = this.editStacks[i].versionId;
        }
    }
    EditStackSnapshot.prototype.isValid = function () {
        for (var i = 0, len = this.editStacks.length; i < len; i++) {
            if (this._versionIds[i] !== this.editStacks[i].versionId) {
                return false;
            }
        }
        return true;
    };
    return EditStackSnapshot;
}());
var missingEditStack = new ResourceEditStack('', '');
missingEditStack.locked = true;
var UndoRedoService = /** @class */ (function () {
    function UndoRedoService(_dialogService, _notificationService) {
        this._dialogService = _dialogService;
        this._notificationService = _notificationService;
        this._editStacks = new Map();
        this._uriComparisonKeyComputers = [];
    }
    UndoRedoService.prototype.registerUriComparisonKeyComputer = function (scheme, uriComparisonKeyComputer) {
        var _this = this;
        this._uriComparisonKeyComputers.push([scheme, uriComparisonKeyComputer]);
        return {
            dispose: function () {
                for (var i = 0, len = _this._uriComparisonKeyComputers.length; i < len; i++) {
                    if (_this._uriComparisonKeyComputers[i][1] === uriComparisonKeyComputer) {
                        _this._uriComparisonKeyComputers.splice(i, 1);
                        return;
                    }
                }
            }
        };
    };
    UndoRedoService.prototype.getUriComparisonKey = function (resource) {
        var e_11, _a;
        try {
            for (var _b = __values(this._uriComparisonKeyComputers), _c = _b.next(); !_c.done; _c = _b.next()) {
                var uriComparisonKeyComputer = _c.value;
                if (uriComparisonKeyComputer[0] === resource.scheme) {
                    return uriComparisonKeyComputer[1].getComparisonKey(resource);
                }
            }
        }
        catch (e_11_1) { e_11 = { error: e_11_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_11) throw e_11.error; }
        }
        return resource.toString();
    };
    UndoRedoService.prototype._print = function (label) {
        var e_12, _a;
        console.log("------------------------------------");
        console.log("AFTER " + label + ": ");
        var str = [];
        try {
            for (var _b = __values(this._editStacks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var element = _c.value;
                str.push(element[1].toString());
            }
        }
        catch (e_12_1) { e_12 = { error: e_12_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_12) throw e_12.error; }
        }
        console.log(str.join('\n'));
    };
    UndoRedoService.prototype.pushElement = function (element, group, source) {
        var e_13, _a;
        if (group === void 0) { group = UndoRedoGroup.None; }
        if (source === void 0) { source = UndoRedoSource.None; }
        if (element.type === 0 /* Resource */) {
            var resourceLabel = getResourceLabel(element.resource);
            var strResource = this.getUriComparisonKey(element.resource);
            this._pushElement(new ResourceStackElement(element, resourceLabel, strResource, group.id, group.nextOrder(), source.id, source.nextOrder()));
        }
        else {
            var seen = new Set();
            var resourceLabels = [];
            var strResources = [];
            try {
                for (var _b = __values(element.resources), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var resource = _c.value;
                    var resourceLabel = getResourceLabel(resource);
                    var strResource = this.getUriComparisonKey(resource);
                    if (seen.has(strResource)) {
                        continue;
                    }
                    seen.add(strResource);
                    resourceLabels.push(resourceLabel);
                    strResources.push(strResource);
                }
            }
            catch (e_13_1) { e_13 = { error: e_13_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_13) throw e_13.error; }
            }
            if (resourceLabels.length === 1) {
                this._pushElement(new ResourceStackElement(element, resourceLabels[0], strResources[0], group.id, group.nextOrder(), source.id, source.nextOrder()));
            }
            else {
                this._pushElement(new WorkspaceStackElement(element, resourceLabels, strResources, group.id, group.nextOrder(), source.id, source.nextOrder()));
            }
        }
        if (DEBUG) {
            this._print('pushElement');
        }
    };
    UndoRedoService.prototype._pushElement = function (element) {
        for (var i = 0, len = element.strResources.length; i < len; i++) {
            var resourceLabel = element.resourceLabels[i];
            var strResource = element.strResources[i];
            var editStack = void 0;
            if (this._editStacks.has(strResource)) {
                editStack = this._editStacks.get(strResource);
            }
            else {
                editStack = new ResourceEditStack(resourceLabel, strResource);
                this._editStacks.set(strResource, editStack);
            }
            editStack.pushElement(element);
        }
    };
    UndoRedoService.prototype.getLastElement = function (resource) {
        var strResource = this.getUriComparisonKey(resource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            if (editStack.hasFutureElements()) {
                return null;
            }
            var closestPastElement = editStack.getClosestPastElement();
            return closestPastElement ? closestPastElement.actual : null;
        }
        return null;
    };
    UndoRedoService.prototype._splitPastWorkspaceElement = function (toRemove, ignoreResources) {
        var e_14, _a, e_15, _b;
        var individualArr = toRemove.actual.split();
        var individualMap = new Map();
        try {
            for (var individualArr_1 = __values(individualArr), individualArr_1_1 = individualArr_1.next(); !individualArr_1_1.done; individualArr_1_1 = individualArr_1.next()) {
                var _element = individualArr_1_1.value;
                var resourceLabel = getResourceLabel(_element.resource);
                var strResource = this.getUriComparisonKey(_element.resource);
                var element = new ResourceStackElement(_element, resourceLabel, strResource, 0, 0, 0, 0);
                individualMap.set(element.strResource, element);
            }
        }
        catch (e_14_1) { e_14 = { error: e_14_1 }; }
        finally {
            try {
                if (individualArr_1_1 && !individualArr_1_1.done && (_a = individualArr_1.return)) _a.call(individualArr_1);
            }
            finally { if (e_14) throw e_14.error; }
        }
        try {
            for (var _c = __values(toRemove.strResources), _d = _c.next(); !_d.done; _d = _c.next()) {
                var strResource = _d.value;
                if (ignoreResources && ignoreResources.has(strResource)) {
                    continue;
                }
                var editStack = this._editStacks.get(strResource);
                editStack.splitPastWorkspaceElement(toRemove, individualMap);
            }
        }
        catch (e_15_1) { e_15 = { error: e_15_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
            }
            finally { if (e_15) throw e_15.error; }
        }
    };
    UndoRedoService.prototype._splitFutureWorkspaceElement = function (toRemove, ignoreResources) {
        var e_16, _a, e_17, _b;
        var individualArr = toRemove.actual.split();
        var individualMap = new Map();
        try {
            for (var individualArr_2 = __values(individualArr), individualArr_2_1 = individualArr_2.next(); !individualArr_2_1.done; individualArr_2_1 = individualArr_2.next()) {
                var _element = individualArr_2_1.value;
                var resourceLabel = getResourceLabel(_element.resource);
                var strResource = this.getUriComparisonKey(_element.resource);
                var element = new ResourceStackElement(_element, resourceLabel, strResource, 0, 0, 0, 0);
                individualMap.set(element.strResource, element);
            }
        }
        catch (e_16_1) { e_16 = { error: e_16_1 }; }
        finally {
            try {
                if (individualArr_2_1 && !individualArr_2_1.done && (_a = individualArr_2.return)) _a.call(individualArr_2);
            }
            finally { if (e_16) throw e_16.error; }
        }
        try {
            for (var _c = __values(toRemove.strResources), _d = _c.next(); !_d.done; _d = _c.next()) {
                var strResource = _d.value;
                if (ignoreResources && ignoreResources.has(strResource)) {
                    continue;
                }
                var editStack = this._editStacks.get(strResource);
                editStack.splitFutureWorkspaceElement(toRemove, individualMap);
            }
        }
        catch (e_17_1) { e_17 = { error: e_17_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
            }
            finally { if (e_17) throw e_17.error; }
        }
    };
    UndoRedoService.prototype.removeElements = function (resource) {
        var strResource = typeof resource === 'string' ? resource : this.getUriComparisonKey(resource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            editStack.dispose();
            this._editStacks.delete(strResource);
        }
        if (DEBUG) {
            this._print('removeElements');
        }
    };
    UndoRedoService.prototype.setElementsValidFlag = function (resource, isValid, filter) {
        var strResource = this.getUriComparisonKey(resource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            editStack.setElementsValidFlag(isValid, filter);
        }
        if (DEBUG) {
            this._print('setElementsValidFlag');
        }
    };
    UndoRedoService.prototype.hasElements = function (resource) {
        var strResource = this.getUriComparisonKey(resource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            return (editStack.hasPastElements() || editStack.hasFutureElements());
        }
        return false;
    };
    UndoRedoService.prototype.createSnapshot = function (resource) {
        var strResource = this.getUriComparisonKey(resource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            return editStack.createSnapshot(resource);
        }
        return new ResourceEditStackSnapshot(resource, []);
    };
    UndoRedoService.prototype.restoreSnapshot = function (snapshot) {
        var strResource = this.getUriComparisonKey(snapshot.resource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            editStack.restoreSnapshot(snapshot);
            if (!editStack.hasPastElements() && !editStack.hasFutureElements()) {
                // the edit stack is now empty, just remove it entirely
                editStack.dispose();
                this._editStacks.delete(strResource);
            }
        }
        if (DEBUG) {
            this._print('restoreSnapshot');
        }
    };
    UndoRedoService.prototype.getElements = function (resource) {
        var strResource = this.getUriComparisonKey(resource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            return editStack.getElements();
        }
        return { past: [], future: [] };
    };
    UndoRedoService.prototype._findClosestUndoElementWithSource = function (sourceId) {
        var e_18, _a;
        if (!sourceId) {
            return [null, null];
        }
        // find an element with the sourceId and with the highest sourceOrder ready to be undone
        var matchedElement = null;
        var matchedStrResource = null;
        try {
            for (var _b = __values(this._editStacks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), strResource = _d[0], editStack = _d[1];
                var candidate = editStack.getClosestPastElement();
                if (!candidate) {
                    continue;
                }
                if (candidate.sourceId === sourceId) {
                    if (!matchedElement || candidate.sourceOrder > matchedElement.sourceOrder) {
                        matchedElement = candidate;
                        matchedStrResource = strResource;
                    }
                }
            }
        }
        catch (e_18_1) { e_18 = { error: e_18_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_18) throw e_18.error; }
        }
        return [matchedElement, matchedStrResource];
    };
    UndoRedoService.prototype.canUndo = function (resourceOrSource) {
        if (resourceOrSource instanceof UndoRedoSource) {
            var _a = __read(this._findClosestUndoElementWithSource(resourceOrSource.id), 2), matchedStrResource = _a[1];
            return matchedStrResource ? true : false;
        }
        var strResource = this.getUriComparisonKey(resourceOrSource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            return editStack.hasPastElements();
        }
        return false;
    };
    UndoRedoService.prototype._onError = function (err, element) {
        var e_19, _a;
        onUnexpectedError(err);
        try {
            // An error occured while undoing or redoing => drop the undo/redo stack for all affected resources
            for (var _b = __values(element.strResources), _c = _b.next(); !_c.done; _c = _b.next()) {
                var strResource = _c.value;
                this.removeElements(strResource);
            }
        }
        catch (e_19_1) { e_19 = { error: e_19_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_19) throw e_19.error; }
        }
        this._notificationService.error(err);
    };
    UndoRedoService.prototype._acquireLocks = function (editStackSnapshot) {
        var e_20, _a, e_21, _b;
        try {
            // first, check if all locks can be acquired
            for (var _c = __values(editStackSnapshot.editStacks), _d = _c.next(); !_d.done; _d = _c.next()) {
                var editStack = _d.value;
                if (editStack.locked) {
                    throw new Error('Cannot acquire edit stack lock');
                }
            }
        }
        catch (e_20_1) { e_20 = { error: e_20_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_20) throw e_20.error; }
        }
        try {
            // can acquire all locks
            for (var _e = __values(editStackSnapshot.editStacks), _f = _e.next(); !_f.done; _f = _e.next()) {
                var editStack = _f.value;
                editStack.locked = true;
            }
        }
        catch (e_21_1) { e_21 = { error: e_21_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_21) throw e_21.error; }
        }
        return function () {
            var e_22, _a;
            try {
                // release all locks
                for (var _b = __values(editStackSnapshot.editStacks), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var editStack = _c.value;
                    editStack.locked = false;
                }
            }
            catch (e_22_1) { e_22 = { error: e_22_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_22) throw e_22.error; }
            }
        };
    };
    UndoRedoService.prototype._safeInvokeWithLocks = function (element, invoke, editStackSnapshot, cleanup, continuation) {
        var _this = this;
        var releaseLocks = this._acquireLocks(editStackSnapshot);
        var result;
        try {
            result = invoke();
        }
        catch (err) {
            releaseLocks();
            cleanup.dispose();
            return this._onError(err, element);
        }
        if (result) {
            // result is Promise<void>
            return result.then(function () {
                releaseLocks();
                cleanup.dispose();
                return continuation();
            }, function (err) {
                releaseLocks();
                cleanup.dispose();
                return _this._onError(err, element);
            });
        }
        else {
            // result is void
            releaseLocks();
            cleanup.dispose();
            return continuation();
        }
    };
    UndoRedoService.prototype._invokeWorkspacePrepare = function (element) {
        return __awaiter(this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                if (typeof element.actual.prepareUndoRedo === 'undefined') {
                    return [2 /*return*/, Disposable.None];
                }
                result = element.actual.prepareUndoRedo();
                if (typeof result === 'undefined') {
                    return [2 /*return*/, Disposable.None];
                }
                return [2 /*return*/, result];
            });
        });
    };
    UndoRedoService.prototype._invokeResourcePrepare = function (element, callback) {
        if (element.actual.type !== 1 /* Workspace */ || typeof element.actual.prepareUndoRedo === 'undefined') {
            // no preparation needed
            return callback(Disposable.None);
        }
        var r = element.actual.prepareUndoRedo();
        if (!r) {
            // nothing to clean up
            return callback(Disposable.None);
        }
        if (isDisposable(r)) {
            return callback(r);
        }
        return r.then(function (disposable) {
            return callback(disposable);
        });
    };
    UndoRedoService.prototype._getAffectedEditStacks = function (element) {
        var e_23, _a;
        var affectedEditStacks = [];
        try {
            for (var _b = __values(element.strResources), _c = _b.next(); !_c.done; _c = _b.next()) {
                var strResource = _c.value;
                affectedEditStacks.push(this._editStacks.get(strResource) || missingEditStack);
            }
        }
        catch (e_23_1) { e_23 = { error: e_23_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_23) throw e_23.error; }
        }
        return new EditStackSnapshot(affectedEditStacks);
    };
    UndoRedoService.prototype._tryToSplitAndUndo = function (strResource, element, ignoreResources, message) {
        var e_24, _a;
        if (element.canSplit()) {
            this._splitPastWorkspaceElement(element, ignoreResources);
            this._notificationService.info(message);
            return new WorkspaceVerificationError(this._undo(strResource, 0, true));
        }
        else {
            try {
                // Cannot safely split this workspace element => flush all undo/redo stacks
                for (var _b = __values(element.strResources), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var strResource_1 = _c.value;
                    this.removeElements(strResource_1);
                }
            }
            catch (e_24_1) { e_24 = { error: e_24_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_24) throw e_24.error; }
            }
            this._notificationService.info(message);
            return new WorkspaceVerificationError();
        }
    };
    UndoRedoService.prototype._checkWorkspaceUndo = function (strResource, element, editStackSnapshot, checkInvalidatedResources) {
        var e_25, _a, e_26, _b;
        if (element.removedResources) {
            return this._tryToSplitAndUndo(strResource, element, element.removedResources, nls.localize({ key: 'cannotWorkspaceUndo', comment: ['{0} is a label for an operation. {1} is another message.'] }, "Could not undo '{0}' across all files. {1}", element.label, element.removedResources.createMessage()));
        }
        if (checkInvalidatedResources && element.invalidatedResources) {
            return this._tryToSplitAndUndo(strResource, element, element.invalidatedResources, nls.localize({ key: 'cannotWorkspaceUndo', comment: ['{0} is a label for an operation. {1} is another message.'] }, "Could not undo '{0}' across all files. {1}", element.label, element.invalidatedResources.createMessage()));
        }
        // this must be the last past element in all the impacted resources!
        var cannotUndoDueToResources = [];
        try {
            for (var _c = __values(editStackSnapshot.editStacks), _d = _c.next(); !_d.done; _d = _c.next()) {
                var editStack = _d.value;
                if (editStack.getClosestPastElement() !== element) {
                    cannotUndoDueToResources.push(editStack.resourceLabel);
                }
            }
        }
        catch (e_25_1) { e_25 = { error: e_25_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_25) throw e_25.error; }
        }
        if (cannotUndoDueToResources.length > 0) {
            return this._tryToSplitAndUndo(strResource, element, null, nls.localize({ key: 'cannotWorkspaceUndoDueToChanges', comment: ['{0} is a label for an operation. {1} is a list of filenames.'] }, "Could not undo '{0}' across all files because changes were made to {1}", element.label, cannotUndoDueToResources.join(', ')));
        }
        var cannotLockDueToResources = [];
        try {
            for (var _e = __values(editStackSnapshot.editStacks), _f = _e.next(); !_f.done; _f = _e.next()) {
                var editStack = _f.value;
                if (editStack.locked) {
                    cannotLockDueToResources.push(editStack.resourceLabel);
                }
            }
        }
        catch (e_26_1) { e_26 = { error: e_26_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_26) throw e_26.error; }
        }
        if (cannotLockDueToResources.length > 0) {
            return this._tryToSplitAndUndo(strResource, element, null, nls.localize({ key: 'cannotWorkspaceUndoDueToInProgressUndoRedo', comment: ['{0} is a label for an operation. {1} is a list of filenames.'] }, "Could not undo '{0}' across all files because there is already an undo or redo operation running on {1}", element.label, cannotLockDueToResources.join(', ')));
        }
        // check if new stack elements were added in the meantime...
        if (!editStackSnapshot.isValid()) {
            return this._tryToSplitAndUndo(strResource, element, null, nls.localize({ key: 'cannotWorkspaceUndoDueToInMeantimeUndoRedo', comment: ['{0} is a label for an operation. {1} is a list of filenames.'] }, "Could not undo '{0}' across all files because an undo or redo operation occurred in the meantime", element.label));
        }
        return null;
    };
    UndoRedoService.prototype._workspaceUndo = function (strResource, element, undoConfirmed) {
        var affectedEditStacks = this._getAffectedEditStacks(element);
        var verificationError = this._checkWorkspaceUndo(strResource, element, affectedEditStacks, /*invalidated resources will be checked after the prepare call*/ false);
        if (verificationError) {
            return verificationError.returnValue;
        }
        return this._confirmAndExecuteWorkspaceUndo(strResource, element, affectedEditStacks, undoConfirmed);
    };
    UndoRedoService.prototype._isPartOfUndoGroup = function (element) {
        var e_27, _a;
        if (!element.groupId) {
            return false;
        }
        try {
            // check that there is at least another element with the same groupId ready to be undone
            for (var _b = __values(this._editStacks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), editStack = _d[1];
                var pastElement = editStack.getClosestPastElement();
                if (!pastElement) {
                    continue;
                }
                if (pastElement === element) {
                    var secondPastElement = editStack.getSecondClosestPastElement();
                    if (secondPastElement && secondPastElement.groupId === element.groupId) {
                        // there is another element with the same group id in the same stack!
                        return true;
                    }
                }
                if (pastElement.groupId === element.groupId) {
                    // there is another element with the same group id in another stack!
                    return true;
                }
            }
        }
        catch (e_27_1) { e_27 = { error: e_27_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_27) throw e_27.error; }
        }
        return false;
    };
    UndoRedoService.prototype._confirmAndExecuteWorkspaceUndo = function (strResource, element, editStackSnapshot, undoConfirmed) {
        return __awaiter(this, void 0, void 0, function () {
            var result, verificationError1, cleanup, err_1, verificationError2, _a, _b, editStack;
            var e_28, _c;
            var _this = this;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        if (!(element.canSplit() && !this._isPartOfUndoGroup(element))) return [3 /*break*/, 2];
                        return [4 /*yield*/, this._dialogService.show(Severity.Info, nls.localize('confirmWorkspace', "Would you like to undo '{0}' across all files?", element.label), [
                                nls.localize({ key: 'ok', comment: ['{0} denotes a number that is > 1'] }, "Undo in {0} Files", editStackSnapshot.editStacks.length),
                                nls.localize('nok', "Undo this File"),
                                nls.localize('cancel', "Cancel"),
                            ], {
                                cancelId: 2
                            })];
                    case 1:
                        result = _d.sent();
                        if (result.choice === 2) {
                            // choice: cancel
                            return [2 /*return*/];
                        }
                        if (result.choice === 1) {
                            // choice: undo this file
                            this._splitPastWorkspaceElement(element, null);
                            return [2 /*return*/, this._undo(strResource, 0, true)];
                        }
                        verificationError1 = this._checkWorkspaceUndo(strResource, element, editStackSnapshot, /*invalidated resources will be checked after the prepare call*/ false);
                        if (verificationError1) {
                            return [2 /*return*/, verificationError1.returnValue];
                        }
                        undoConfirmed = true;
                        _d.label = 2;
                    case 2:
                        _d.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, this._invokeWorkspacePrepare(element)];
                    case 3:
                        cleanup = _d.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        err_1 = _d.sent();
                        return [2 /*return*/, this._onError(err_1, element)];
                    case 5:
                        verificationError2 = this._checkWorkspaceUndo(strResource, element, editStackSnapshot, /*now also check that there are no more invalidated resources*/ true);
                        if (verificationError2) {
                            cleanup.dispose();
                            return [2 /*return*/, verificationError2.returnValue];
                        }
                        try {
                            for (_a = __values(editStackSnapshot.editStacks), _b = _a.next(); !_b.done; _b = _a.next()) {
                                editStack = _b.value;
                                editStack.moveBackward(element);
                            }
                        }
                        catch (e_28_1) { e_28 = { error: e_28_1 }; }
                        finally {
                            try {
                                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                            }
                            finally { if (e_28) throw e_28.error; }
                        }
                        return [2 /*return*/, this._safeInvokeWithLocks(element, function () { return element.actual.undo(); }, editStackSnapshot, cleanup, function () { return _this._continueUndoInGroup(element.groupId, undoConfirmed); })];
                }
            });
        });
    };
    UndoRedoService.prototype._resourceUndo = function (editStack, element, undoConfirmed) {
        var _this = this;
        if (!element.isValid) {
            // invalid element => immediately flush edit stack!
            editStack.flushAllElements();
            return;
        }
        if (editStack.locked) {
            var message = nls.localize({ key: 'cannotResourceUndoDueToInProgressUndoRedo', comment: ['{0} is a label for an operation.'] }, "Could not undo '{0}' because there is already an undo or redo operation running.", element.label);
            this._notificationService.info(message);
            return;
        }
        return this._invokeResourcePrepare(element, function (cleanup) {
            editStack.moveBackward(element);
            return _this._safeInvokeWithLocks(element, function () { return element.actual.undo(); }, new EditStackSnapshot([editStack]), cleanup, function () { return _this._continueUndoInGroup(element.groupId, undoConfirmed); });
        });
    };
    UndoRedoService.prototype._findClosestUndoElementInGroup = function (groupId) {
        var e_29, _a;
        if (!groupId) {
            return [null, null];
        }
        // find another element with the same groupId and with the highest groupOrder ready to be undone
        var matchedElement = null;
        var matchedStrResource = null;
        try {
            for (var _b = __values(this._editStacks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), strResource = _d[0], editStack = _d[1];
                var candidate = editStack.getClosestPastElement();
                if (!candidate) {
                    continue;
                }
                if (candidate.groupId === groupId) {
                    if (!matchedElement || candidate.groupOrder > matchedElement.groupOrder) {
                        matchedElement = candidate;
                        matchedStrResource = strResource;
                    }
                }
            }
        }
        catch (e_29_1) { e_29 = { error: e_29_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_29) throw e_29.error; }
        }
        return [matchedElement, matchedStrResource];
    };
    UndoRedoService.prototype._continueUndoInGroup = function (groupId, undoConfirmed) {
        if (!groupId) {
            return;
        }
        var _a = __read(this._findClosestUndoElementInGroup(groupId), 2), matchedStrResource = _a[1];
        if (matchedStrResource) {
            return this._undo(matchedStrResource, 0, undoConfirmed);
        }
    };
    UndoRedoService.prototype.undo = function (resourceOrSource) {
        if (resourceOrSource instanceof UndoRedoSource) {
            var _a = __read(this._findClosestUndoElementWithSource(resourceOrSource.id), 2), matchedStrResource = _a[1];
            return matchedStrResource ? this._undo(matchedStrResource, resourceOrSource.id, false) : undefined;
        }
        if (typeof resourceOrSource === 'string') {
            return this._undo(resourceOrSource, 0, false);
        }
        return this._undo(this.getUriComparisonKey(resourceOrSource), 0, false);
    };
    UndoRedoService.prototype._undo = function (strResource, sourceId, undoConfirmed) {
        if (sourceId === void 0) { sourceId = 0; }
        if (!this._editStacks.has(strResource)) {
            return;
        }
        var editStack = this._editStacks.get(strResource);
        var element = editStack.getClosestPastElement();
        if (!element) {
            return;
        }
        if (element.groupId) {
            // this element is a part of a group, we need to make sure undoing in a group is in order
            var _a = __read(this._findClosestUndoElementInGroup(element.groupId), 2), matchedElement = _a[0], matchedStrResource = _a[1];
            if (element !== matchedElement && matchedStrResource) {
                // there is an element in the same group that should be undone before this one
                return this._undo(matchedStrResource, sourceId, undoConfirmed);
            }
        }
        var shouldPromptForConfirmation = (element.sourceId !== sourceId || element.confirmBeforeUndo);
        if (shouldPromptForConfirmation && !undoConfirmed) {
            // Hit a different source or the element asks for prompt before undo, prompt for confirmation
            return this._confirmAndContinueUndo(strResource, sourceId, element);
        }
        try {
            if (element.type === 1 /* Workspace */) {
                return this._workspaceUndo(strResource, element, undoConfirmed);
            }
            else {
                return this._resourceUndo(editStack, element, undoConfirmed);
            }
        }
        finally {
            if (DEBUG) {
                this._print('undo');
            }
        }
    };
    UndoRedoService.prototype._confirmAndContinueUndo = function (strResource, sourceId, element) {
        return __awaiter(this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._dialogService.show(Severity.Info, nls.localize('confirmDifferentSource', "Would you like to undo '{0}'?", element.label), [
                            nls.localize('confirmDifferentSource.ok', "Undo"),
                            nls.localize('cancel', "Cancel"),
                        ], {
                            cancelId: 1
                        })];
                    case 1:
                        result = _a.sent();
                        if (result.choice === 1) {
                            // choice: cancel
                            return [2 /*return*/];
                        }
                        // choice: undo
                        return [2 /*return*/, this._undo(strResource, sourceId, true)];
                }
            });
        });
    };
    UndoRedoService.prototype._findClosestRedoElementWithSource = function (sourceId) {
        var e_30, _a;
        if (!sourceId) {
            return [null, null];
        }
        // find an element with sourceId and with the lowest sourceOrder ready to be redone
        var matchedElement = null;
        var matchedStrResource = null;
        try {
            for (var _b = __values(this._editStacks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), strResource = _d[0], editStack = _d[1];
                var candidate = editStack.getClosestFutureElement();
                if (!candidate) {
                    continue;
                }
                if (candidate.sourceId === sourceId) {
                    if (!matchedElement || candidate.sourceOrder < matchedElement.sourceOrder) {
                        matchedElement = candidate;
                        matchedStrResource = strResource;
                    }
                }
            }
        }
        catch (e_30_1) { e_30 = { error: e_30_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_30) throw e_30.error; }
        }
        return [matchedElement, matchedStrResource];
    };
    UndoRedoService.prototype.canRedo = function (resourceOrSource) {
        if (resourceOrSource instanceof UndoRedoSource) {
            var _a = __read(this._findClosestRedoElementWithSource(resourceOrSource.id), 2), matchedStrResource = _a[1];
            return matchedStrResource ? true : false;
        }
        var strResource = this.getUriComparisonKey(resourceOrSource);
        if (this._editStacks.has(strResource)) {
            var editStack = this._editStacks.get(strResource);
            return editStack.hasFutureElements();
        }
        return false;
    };
    UndoRedoService.prototype._tryToSplitAndRedo = function (strResource, element, ignoreResources, message) {
        var e_31, _a;
        if (element.canSplit()) {
            this._splitFutureWorkspaceElement(element, ignoreResources);
            this._notificationService.info(message);
            return new WorkspaceVerificationError(this._redo(strResource));
        }
        else {
            try {
                // Cannot safely split this workspace element => flush all undo/redo stacks
                for (var _b = __values(element.strResources), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var strResource_2 = _c.value;
                    this.removeElements(strResource_2);
                }
            }
            catch (e_31_1) { e_31 = { error: e_31_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_31) throw e_31.error; }
            }
            this._notificationService.info(message);
            return new WorkspaceVerificationError();
        }
    };
    UndoRedoService.prototype._checkWorkspaceRedo = function (strResource, element, editStackSnapshot, checkInvalidatedResources) {
        var e_32, _a, e_33, _b;
        if (element.removedResources) {
            return this._tryToSplitAndRedo(strResource, element, element.removedResources, nls.localize({ key: 'cannotWorkspaceRedo', comment: ['{0} is a label for an operation. {1} is another message.'] }, "Could not redo '{0}' across all files. {1}", element.label, element.removedResources.createMessage()));
        }
        if (checkInvalidatedResources && element.invalidatedResources) {
            return this._tryToSplitAndRedo(strResource, element, element.invalidatedResources, nls.localize({ key: 'cannotWorkspaceRedo', comment: ['{0} is a label for an operation. {1} is another message.'] }, "Could not redo '{0}' across all files. {1}", element.label, element.invalidatedResources.createMessage()));
        }
        // this must be the last future element in all the impacted resources!
        var cannotRedoDueToResources = [];
        try {
            for (var _c = __values(editStackSnapshot.editStacks), _d = _c.next(); !_d.done; _d = _c.next()) {
                var editStack = _d.value;
                if (editStack.getClosestFutureElement() !== element) {
                    cannotRedoDueToResources.push(editStack.resourceLabel);
                }
            }
        }
        catch (e_32_1) { e_32 = { error: e_32_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_32) throw e_32.error; }
        }
        if (cannotRedoDueToResources.length > 0) {
            return this._tryToSplitAndRedo(strResource, element, null, nls.localize({ key: 'cannotWorkspaceRedoDueToChanges', comment: ['{0} is a label for an operation. {1} is a list of filenames.'] }, "Could not redo '{0}' across all files because changes were made to {1}", element.label, cannotRedoDueToResources.join(', ')));
        }
        var cannotLockDueToResources = [];
        try {
            for (var _e = __values(editStackSnapshot.editStacks), _f = _e.next(); !_f.done; _f = _e.next()) {
                var editStack = _f.value;
                if (editStack.locked) {
                    cannotLockDueToResources.push(editStack.resourceLabel);
                }
            }
        }
        catch (e_33_1) { e_33 = { error: e_33_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_33) throw e_33.error; }
        }
        if (cannotLockDueToResources.length > 0) {
            return this._tryToSplitAndRedo(strResource, element, null, nls.localize({ key: 'cannotWorkspaceRedoDueToInProgressUndoRedo', comment: ['{0} is a label for an operation. {1} is a list of filenames.'] }, "Could not redo '{0}' across all files because there is already an undo or redo operation running on {1}", element.label, cannotLockDueToResources.join(', ')));
        }
        // check if new stack elements were added in the meantime...
        if (!editStackSnapshot.isValid()) {
            return this._tryToSplitAndRedo(strResource, element, null, nls.localize({ key: 'cannotWorkspaceRedoDueToInMeantimeUndoRedo', comment: ['{0} is a label for an operation. {1} is a list of filenames.'] }, "Could not redo '{0}' across all files because an undo or redo operation occurred in the meantime", element.label));
        }
        return null;
    };
    UndoRedoService.prototype._workspaceRedo = function (strResource, element) {
        var affectedEditStacks = this._getAffectedEditStacks(element);
        var verificationError = this._checkWorkspaceRedo(strResource, element, affectedEditStacks, /*invalidated resources will be checked after the prepare call*/ false);
        if (verificationError) {
            return verificationError.returnValue;
        }
        return this._executeWorkspaceRedo(strResource, element, affectedEditStacks);
    };
    UndoRedoService.prototype._executeWorkspaceRedo = function (strResource, element, editStackSnapshot) {
        return __awaiter(this, void 0, void 0, function () {
            var cleanup, err_2, verificationError, _a, _b, editStack;
            var e_34, _c;
            var _this = this;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this._invokeWorkspacePrepare(element)];
                    case 1:
                        cleanup = _d.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        err_2 = _d.sent();
                        return [2 /*return*/, this._onError(err_2, element)];
                    case 3:
                        verificationError = this._checkWorkspaceRedo(strResource, element, editStackSnapshot, /*now also check that there are no more invalidated resources*/ true);
                        if (verificationError) {
                            cleanup.dispose();
                            return [2 /*return*/, verificationError.returnValue];
                        }
                        try {
                            for (_a = __values(editStackSnapshot.editStacks), _b = _a.next(); !_b.done; _b = _a.next()) {
                                editStack = _b.value;
                                editStack.moveForward(element);
                            }
                        }
                        catch (e_34_1) { e_34 = { error: e_34_1 }; }
                        finally {
                            try {
                                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                            }
                            finally { if (e_34) throw e_34.error; }
                        }
                        return [2 /*return*/, this._safeInvokeWithLocks(element, function () { return element.actual.redo(); }, editStackSnapshot, cleanup, function () { return _this._continueRedoInGroup(element.groupId); })];
                }
            });
        });
    };
    UndoRedoService.prototype._resourceRedo = function (editStack, element) {
        var _this = this;
        if (!element.isValid) {
            // invalid element => immediately flush edit stack!
            editStack.flushAllElements();
            return;
        }
        if (editStack.locked) {
            var message = nls.localize({ key: 'cannotResourceRedoDueToInProgressUndoRedo', comment: ['{0} is a label for an operation.'] }, "Could not redo '{0}' because there is already an undo or redo operation running.", element.label);
            this._notificationService.info(message);
            return;
        }
        return this._invokeResourcePrepare(element, function (cleanup) {
            editStack.moveForward(element);
            return _this._safeInvokeWithLocks(element, function () { return element.actual.redo(); }, new EditStackSnapshot([editStack]), cleanup, function () { return _this._continueRedoInGroup(element.groupId); });
        });
    };
    UndoRedoService.prototype._findClosestRedoElementInGroup = function (groupId) {
        var e_35, _a;
        if (!groupId) {
            return [null, null];
        }
        // find another element with the same groupId and with the lowest groupOrder ready to be redone
        var matchedElement = null;
        var matchedStrResource = null;
        try {
            for (var _b = __values(this._editStacks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), strResource = _d[0], editStack = _d[1];
                var candidate = editStack.getClosestFutureElement();
                if (!candidate) {
                    continue;
                }
                if (candidate.groupId === groupId) {
                    if (!matchedElement || candidate.groupOrder < matchedElement.groupOrder) {
                        matchedElement = candidate;
                        matchedStrResource = strResource;
                    }
                }
            }
        }
        catch (e_35_1) { e_35 = { error: e_35_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_35) throw e_35.error; }
        }
        return [matchedElement, matchedStrResource];
    };
    UndoRedoService.prototype._continueRedoInGroup = function (groupId) {
        if (!groupId) {
            return;
        }
        var _a = __read(this._findClosestRedoElementInGroup(groupId), 2), matchedStrResource = _a[1];
        if (matchedStrResource) {
            return this._redo(matchedStrResource);
        }
    };
    UndoRedoService.prototype.redo = function (resourceOrSource) {
        if (resourceOrSource instanceof UndoRedoSource) {
            var _a = __read(this._findClosestRedoElementWithSource(resourceOrSource.id), 2), matchedStrResource = _a[1];
            return matchedStrResource ? this._redo(matchedStrResource) : undefined;
        }
        if (typeof resourceOrSource === 'string') {
            return this._redo(resourceOrSource);
        }
        return this._redo(this.getUriComparisonKey(resourceOrSource));
    };
    UndoRedoService.prototype._redo = function (strResource) {
        if (!this._editStacks.has(strResource)) {
            return;
        }
        var editStack = this._editStacks.get(strResource);
        var element = editStack.getClosestFutureElement();
        if (!element) {
            return;
        }
        if (element.groupId) {
            // this element is a part of a group, we need to make sure redoing in a group is in order
            var _a = __read(this._findClosestRedoElementInGroup(element.groupId), 2), matchedElement = _a[0], matchedStrResource = _a[1];
            if (element !== matchedElement && matchedStrResource) {
                // there is an element in the same group that should be redone before this one
                return this._redo(matchedStrResource);
            }
        }
        try {
            if (element.type === 1 /* Workspace */) {
                return this._workspaceRedo(strResource, element);
            }
            else {
                return this._resourceRedo(editStack, element);
            }
        }
        finally {
            if (DEBUG) {
                this._print('redo');
            }
        }
    };
    UndoRedoService = __decorate([
        __param(0, IDialogService),
        __param(1, INotificationService)
    ], UndoRedoService);
    return UndoRedoService;
}());
export { UndoRedoService };
var WorkspaceVerificationError = /** @class */ (function () {
    function WorkspaceVerificationError(returnValue) {
        this.returnValue = returnValue;
    }
    return WorkspaceVerificationError;
}());
registerSingleton(IUndoRedoService, UndoRedoService);
