"use strict";
// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var OpenEditorsWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenEditorsWidget = exports.OPEN_EDITORS_PROPS = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const navigator_open_editors_tree_model_1 = require("./navigator-open-editors-tree-model");
const browser_2 = require("@theia/filesystem/lib/browser");
const navigator_open_editors_decorator_service_1 = require("./navigator-open-editors-decorator-service");
const navigator_open_editors_menus_1 = require("./navigator-open-editors-menus");
const common_1 = require("@theia/core/lib/common");
const navigator_open_editors_commands_1 = require("./navigator-open-editors-commands");
const nls_1 = require("@theia/core/lib/common/nls");
const browser_3 = require("@theia/workspace/lib/browser");
exports.OPEN_EDITORS_PROPS = Object.assign(Object.assign({}, browser_1.defaultTreeProps), { virtualized: false, contextMenuPath: navigator_open_editors_menus_1.OPEN_EDITORS_CONTEXT_MENU });
let OpenEditorsWidget = OpenEditorsWidget_1 = class OpenEditorsWidget extends browser_2.FileTreeWidget {
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this.model = model;
        this.handleGroupActionIconClicked = async (e) => this.doHandleGroupActionIconClicked(e);
        this.closeEditor = async (e) => this.doCloseEditor(e);
    }
    static createContainer(parent) {
        const child = (0, browser_2.createFileTreeContainer)(parent);
        child.unbind(browser_2.FileTreeModel);
        child.bind(navigator_open_editors_tree_model_1.OpenEditorsModel).toSelf();
        child.rebind(browser_1.TreeModel).toService(navigator_open_editors_tree_model_1.OpenEditorsModel);
        child.unbind(browser_2.FileTreeWidget);
        child.bind(OpenEditorsWidget_1).toSelf();
        child.rebind(browser_1.TreeProps).toConstantValue(exports.OPEN_EDITORS_PROPS);
        child.bind(navigator_open_editors_decorator_service_1.OpenEditorsTreeDecoratorService).toSelf().inSingletonScope();
        child.rebind(browser_1.TreeDecoratorService).toService(navigator_open_editors_decorator_service_1.OpenEditorsTreeDecoratorService);
        return child;
    }
    static createWidget(parent) {
        return OpenEditorsWidget_1.createContainer(parent).get(OpenEditorsWidget_1);
    }
    init() {
        super.init();
        this.id = OpenEditorsWidget_1.ID;
        this.title.label = OpenEditorsWidget_1.LABEL;
        this.addClass(OpenEditorsWidget_1.ID);
        this.update();
    }
    get editorWidgets() {
        return this.model.editorWidgets;
    }
    renderNode(node, props) {
        if (!browser_1.TreeNode.isVisible(node)) {
            return undefined;
        }
        const attributes = this.createNodeAttributes(node, props);
        const isEditorNode = !(node.id.startsWith(navigator_open_editors_tree_model_1.OpenEditorsModel.GROUP_NODE_ID_PREFIX) || node.id.startsWith(navigator_open_editors_tree_model_1.OpenEditorsModel.AREA_NODE_ID_PREFIX));
        const content = React.createElement("div", { className: `${browser_1.TREE_NODE_CONTENT_CLASS}` },
            this.renderExpansionToggle(node, props),
            isEditorNode && this.renderPrefixIcon(node),
            this.decorateIcon(node, this.renderIcon(node, props)),
            this.renderCaptionAffixes(node, props, 'captionPrefixes'),
            this.renderCaption(node, props),
            this.renderCaptionAffixes(node, props, 'captionSuffixes'),
            this.renderTailDecorations(node, props),
            (this.isGroupNode(node) || this.isAreaNode(node)) && this.renderInteractables(node, props));
        return React.createElement('div', attributes, content);
    }
    getDecorationData(node, key) {
        const contributed = super.getDecorationData(node, key);
        if (key === 'captionSuffixes' && navigator_open_editors_tree_model_1.OpenEditorNode.is(node)) {
            contributed.push(this.getWorkspaceDecoration(node));
        }
        return contributed;
    }
    getWorkspaceDecoration(node) {
        var _a, _b;
        const color = (_a = this.getDecorationData(node, 'fontData').find(data => data.color)) === null || _a === void 0 ? void 0 : _a.color;
        const workspaceRoots = this.workspaceService.tryGetRoots();
        const parentWorkspace = this.workspaceService.getWorkspaceRootUri(node.fileStat.resource);
        let workspacePrefixString = '';
        let separator = '';
        let filePathString = '';
        const nodeURIDir = node.fileStat.resource.parent;
        if (parentWorkspace) {
            const relativeDirFromWorkspace = parentWorkspace.relative(nodeURIDir);
            workspacePrefixString = workspaceRoots.length > 1 ? this.labelProvider.getName(parentWorkspace) : '';
            filePathString = (_b = relativeDirFromWorkspace === null || relativeDirFromWorkspace === void 0 ? void 0 : relativeDirFromWorkspace.toString()) !== null && _b !== void 0 ? _b : '';
            separator = filePathString && workspacePrefixString ? ' \u2022 ' : ''; // add a bullet point between workspace and path
        }
        else {
            workspacePrefixString = nodeURIDir.path.toString();
        }
        return [{
                fontData: { color },
                data: `${workspacePrefixString}${separator}${filePathString}`,
            }];
    }
    isGroupNode(node) {
        return node.id.startsWith(navigator_open_editors_tree_model_1.OpenEditorsModel.GROUP_NODE_ID_PREFIX);
    }
    isAreaNode(node) {
        return node.id.startsWith(navigator_open_editors_tree_model_1.OpenEditorsModel.AREA_NODE_ID_PREFIX);
    }
    doRenderNodeRow({ node, depth }) {
        let groupClass = '';
        if (this.isGroupNode(node)) {
            groupClass = 'group-node';
        }
        else if (this.isAreaNode(node)) {
            groupClass = 'area-node';
        }
        return React.createElement("div", { className: `open-editors-node-row ${this.getPrefixIconClass(node)}${groupClass}` }, this.renderNode(node, { depth }));
    }
    renderInteractables(node, props) {
        return (React.createElement("div", { className: 'open-editors-inline-actions-container' },
            React.createElement("div", { className: 'open-editors-inline-action' },
                React.createElement("a", { className: 'codicon codicon-save-all', title: navigator_open_editors_commands_1.OpenEditorsCommands.SAVE_ALL_IN_GROUP_FROM_ICON.label, onClick: this.handleGroupActionIconClicked, "data-id": node.id, id: navigator_open_editors_commands_1.OpenEditorsCommands.SAVE_ALL_IN_GROUP_FROM_ICON.id })),
            React.createElement("div", { className: 'open-editors-inline-action' },
                React.createElement("a", { className: 'codicon codicon-close-all', title: navigator_open_editors_commands_1.OpenEditorsCommands.CLOSE_ALL_EDITORS_IN_GROUP_FROM_ICON.label, onClick: this.handleGroupActionIconClicked, "data-id": node.id, id: navigator_open_editors_commands_1.OpenEditorsCommands.CLOSE_ALL_EDITORS_IN_GROUP_FROM_ICON.id }))));
    }
    async doHandleGroupActionIconClicked(e) {
        e.stopPropagation();
        const groupName = e.currentTarget.getAttribute('data-id');
        const command = e.currentTarget.id;
        if (groupName && command) {
            const groupFromTarget = groupName.split(':').pop();
            const areaOrTabBar = this.sanitizeInputFromClickHandler(groupFromTarget);
            if (areaOrTabBar) {
                return this.commandService.executeCommand(command, areaOrTabBar);
            }
        }
    }
    sanitizeInputFromClickHandler(groupFromTarget) {
        let areaOrTabBar;
        if (groupFromTarget) {
            if (browser_1.ApplicationShell.isValidArea(groupFromTarget)) {
                areaOrTabBar = groupFromTarget;
            }
            else {
                const groupAsNum = parseInt(groupFromTarget);
                if (!isNaN(groupAsNum)) {
                    areaOrTabBar = this.model.getTabBarForGroup(groupAsNum);
                }
            }
        }
        return areaOrTabBar;
    }
    renderPrefixIcon(node) {
        return (React.createElement("div", { className: 'open-editors-prefix-icon-container' },
            React.createElement("div", { "data-id": node.id, className: 'open-editors-prefix-icon dirty codicon codicon-circle-filled' }),
            React.createElement("div", { "data-id": node.id, onClick: this.closeEditor, className: 'open-editors-prefix-icon close codicon codicon-close' })));
    }
    getPrefixIconClass(node) {
        const saveable = browser_1.Saveable.get(node.widget);
        if (saveable) {
            return saveable.dirty ? 'dirty' : '';
        }
        return '';
    }
    async doCloseEditor(e) {
        const widgetId = e.currentTarget.getAttribute('data-id');
        if (widgetId) {
            await this.applicationShell.closeWidget(widgetId);
        }
    }
    handleClickEvent(node, event) {
        if (navigator_open_editors_tree_model_1.OpenEditorNode.is(node)) {
            const { widget } = node;
            this.applicationShell.activateWidget(widget.id);
        }
        super.handleClickEvent(node, event);
    }
    handleContextMenuEvent(node, event) {
        super.handleContextMenuEvent(node, event);
        if (node) {
            // Since the CommonCommands used in the context menu act on the shell's activeWidget, this is necessary to ensure
            // that the EditorWidget is activated, not the Navigator itself
            this.applicationShell.activateWidget(node.widget.id);
        }
    }
};
OpenEditorsWidget.ID = 'theia-open-editors-widget';
OpenEditorsWidget.LABEL = nls_1.nls.localizeByDefault('Open Editors');
__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], OpenEditorsWidget.prototype, "applicationShell", void 0);
__decorate([
    (0, inversify_1.inject)(common_1.CommandService),
    __metadata("design:type", Object)
], OpenEditorsWidget.prototype, "commandService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_3.WorkspaceService),
    __metadata("design:type", browser_3.WorkspaceService)
], OpenEditorsWidget.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], OpenEditorsWidget.prototype, "init", null);
OpenEditorsWidget = OpenEditorsWidget_1 = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(browser_1.TreeProps)),
    __param(1, (0, inversify_1.inject)(navigator_open_editors_tree_model_1.OpenEditorsModel)),
    __param(2, (0, inversify_1.inject)(browser_1.ContextMenuRenderer)),
    __metadata("design:paramtypes", [Object, navigator_open_editors_tree_model_1.OpenEditorsModel,
        browser_1.ContextMenuRenderer])
], OpenEditorsWidget);
exports.OpenEditorsWidget = OpenEditorsWidget;
//# sourceMappingURL=navigator-open-editors-widget.js.map