/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.jdtls.ext.core.ExtUtils;
import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import com.microsoft.jdtls.ext.core.PackageParams;
import com.microsoft.jdtls.ext.core.model.NodeKind;
import com.microsoft.jdtls.ext.core.model.PackageNode;
import com.microsoft.jdtls.ext.core.model.PackageRootNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;

public class PackageCommand {
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();
    private static final Map<NodeKind, BiFunction<PackageParams, IProgressMonitor, List<PackageNode>>> commands = new HashMap<NodeKind, BiFunction<PackageParams, IProgressMonitor, List<PackageNode>>>();

    static {
        commands.put(NodeKind.PROJECT, PackageCommand::getContainers);
        commands.put(NodeKind.CONTAINER, PackageCommand::getPackageFragmentRoots);
        commands.put(NodeKind.PACKAGEROOT, PackageCommand::getPackages);
        commands.put(NodeKind.PACKAGE, PackageCommand::getRootTypes);
        commands.put(NodeKind.FOLDER, PackageCommand::getFolderChildren);
    }

    public static List<PackageNode> getChildren(List<Object> arguments, IProgressMonitor pm) throws CoreException {
        if (arguments == null || arguments.size() < 1) {
            throw new IllegalArgumentException("Should have at least one argument for getChildren");
        }
        PackageParams params = (PackageParams)gson.fromJson(gson.toJson(arguments.get(0)), PackageParams.class);
        BiFunction<PackageParams, IProgressMonitor, List<PackageNode>> loader = commands.get((Object)params.getKind());
        if (loader == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", String.format("Unknown classpath item type: %s", new Object[]{params.getKind()})));
        }
        List<PackageNode> result = loader.apply(params, pm);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<PackageNode> resolvePath(List<Object> arguments, IProgressMonitor pm) throws CoreException {
        IClassFile typeRoot;
        if (arguments == null || arguments.size() < 1) {
            throw new IllegalArgumentException("Should have one argument for resolvePath");
        }
        String typeRootUri = (String)arguments.get(0);
        ArrayList<PackageNode> result = new ArrayList<PackageNode>();
        URI uri = JDTUtils.toURI((String)typeRootUri);
        Object object = typeRoot = "jdt".equals(uri.getScheme()) ? JDTUtils.resolveClassFile((URI)uri) : JDTUtils.resolveCompilationUnit((URI)uri);
        if (typeRoot != null && typeRoot.findPrimaryType() != null) {
            PackageRootNode pkgRootNode;
            result.add(PackageNode.createNodeForProject((IJavaElement)typeRoot));
            IPackageFragment packageFragment = (IPackageFragment)typeRoot.getAncestor(4);
            IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)packageFragment.getAncestor(3);
            boolean isClassFile = typeRoot instanceof IClassFile;
            if (isClassFile) {
                result.add(PackageNode.createNodeForVirtualContainer(pkgRoot));
            }
            if (StringUtils.isNotBlank((CharSequence)(pkgRootNode = PackageNode.createNodeForPackageFragmentRoot(pkgRoot)).getName())) {
                result.add(pkgRootNode);
            }
            if (!packageFragment.isDefaultPackage()) {
                result.add(PackageNode.createNodeForPackageFragment(packageFragment));
            }
            result.add(PackageNode.createNodeForPrimaryType(typeRoot.findPrimaryType()));
            return result;
        } else if (ExtUtils.isJarResourceUri(uri)) {
            IJarEntryResource resource = ExtUtils.getJarEntryResource(uri);
            IPackageFragmentRoot pkgRoot = resource.getPackageFragmentRoot();
            result.add(PackageNode.createNodeForProject((IJavaElement)pkgRoot));
            result.add(PackageNode.createNodeForVirtualContainer(resource.getPackageFragmentRoot()));
            result.add(PackageNode.createNodeForPackageFragmentRoot(pkgRoot));
            if (resource.getParent() instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)resource.getParent();
                if (!packageFragment.isDefaultPackage()) {
                    result.add(PackageNode.createNodeForPackageFragment(packageFragment));
                }
            } else {
                int currentSize = result.size();
                Object currentNode = resource.getParent();
                while (currentNode instanceof JarEntryDirectory) {
                    JarEntryDirectory jarEntryDirectory = (JarEntryDirectory)currentNode;
                    PackageNode jarNode = PackageCommand.getJarEntryResource((JarEntryResource)jarEntryDirectory);
                    if (jarNode != null) {
                        result.add(currentSize, jarNode);
                    }
                    currentNode = jarEntryDirectory.getParent();
                }
            }
            PackageNode item = new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FILE);
            item.setUri(ExtUtils.toUri(resource));
            result.add(item);
            return result;
        } else {
            IResource resource = JDTUtils.findResource((URI)uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
            if (resource != null) {
                IContainer parent = resource.getParent();
                IJavaElement parentJavaElement = JavaCore.create((IResource)parent);
                if (!(parent instanceof IFolder) || !(parentJavaElement instanceof IPackageFragment)) return PackageCommand.getParentAncestorNodes(resource);
                IPackageFragment packageFragment = (IPackageFragment)parentJavaElement;
                result.add(PackageNode.createNodeForProject((IJavaElement)packageFragment));
                IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)packageFragment.getAncestor(3);
                PackageRootNode pkgRootNode = PackageNode.createNodeForPackageFragmentRoot(pkgRoot);
                if (StringUtils.isNotBlank((CharSequence)pkgRootNode.getName())) {
                    result.add(pkgRootNode);
                }
                if (!packageFragment.isDefaultPackage()) {
                    result.add(PackageNode.createNodeForPackageFragment(packageFragment));
                }
                PackageNode item = new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FILE);
                item.setUri(JDTUtils.getFileURI((IResource)resource));
                result.add(item);
                return result;
            } else {
                IContainer container = JDTUtils.findFolder((String)typeRootUri);
                IJavaElement element = JavaCore.create((IResource)container);
                result.add(PackageNode.createNodeForProject(element));
            }
        }
        return result;
    }

    private static List<PackageNode> getParentAncestorNodes(IResource element) throws JavaModelException {
        ArrayList<PackageNode> nodeList = new ArrayList<PackageNode>();
        while (element != null) {
            PackageNode entry;
            IJavaElement javaElement = JavaCore.create((IResource)element);
            if (javaElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)javaElement;
                nodeList.add(0, new PackageRootNode(pkgRoot, element.getProjectRelativePath().toPortableString(), NodeKind.PACKAGEROOT));
                nodeList.add(0, PackageNode.createNodeForProject(javaElement));
                return nodeList;
            }
            if (javaElement instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                if (packageFragment.containsJavaResources() || packageFragment.getNonJavaResources().length > 0) {
                    nodeList.add(0, PackageNode.createNodeForPackageFragment(packageFragment));
                }
            } else if (javaElement == null && (entry = PackageNode.createNodeForResource(element)) != null) {
                nodeList.add(0, entry);
            }
            element = element.getParent();
        }
        return nodeList;
    }

    private static List<PackageNode> getContainers(PackageParams query, IProgressMonitor pm) {
        IJavaProject javaProject = PackageCommand.getJavaProject(query.getProjectUri());
        if (javaProject != null) {
            try {
                IClasspathEntry[] references = javaProject.getRawClasspath();
                List<PackageNode> result = Arrays.stream(references).filter(entry -> entry.getEntryKind() != 1 && entry.getEntryKind() != 4).map(entry -> PackageNode.createNodeForClasspathEntry(entry, javaProject, NodeKind.CONTAINER)).filter(containerNode -> containerNode != null).collect(Collectors.toList());
                boolean isReferencedLibrariesExist = Arrays.stream(references).anyMatch(entry -> entry.getEntryKind() == 1 || entry.getEntryKind() == 4);
                if (!ProjectUtils.isVisibleProject((IProject)javaProject.getProject())) {
                    result.add(PackageNode.REFERENCED_LIBRARIES_CONTAINER);
                } else if (isReferencedLibrariesExist) {
                    result.add(PackageNode.IMMUTABLE_REFERENCED_LIBRARIES_CONTAINER);
                }
                return result;
            }
            catch (CoreException e) {
                JdtlsExtActivator.logException("Problem load project library ", e);
            }
        }
        return Collections.emptyList();
    }

    private static List<PackageNode> getPackageFragmentRoots(PackageParams query, IProgressMonitor pm) {
        ArrayList<PackageNode> children = new ArrayList<PackageNode>();
        IJavaProject javaProject = PackageCommand.getJavaProject(query.getProjectUri());
        if (javaProject != null) {
            try {
                IClasspathEntry[] references = javaProject.getRawClasspath();
                IClasspathEntry containerEntry = null;
                IClasspathEntry[] iClasspathEntryArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry reference = iClasspathEntryArray[n2];
                    if (reference.getPath().equals((Object)Path.fromPortableString((String)query.getPath()))) {
                        containerEntry = reference;
                        break;
                    }
                    ++n2;
                }
                if (containerEntry != null) {
                    IPackageFragmentRoot[] packageFragmentRoots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = javaProject.findPackageFragmentRoots(containerEntry);
                    int n3 = packageFragmentRoots.length;
                    n = 0;
                    while (n < n3) {
                        IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n];
                        PackageRootNode node = PackageNode.createNodeForPackageFragmentRoot(fragmentRoot);
                        if (StringUtils.isNotBlank((CharSequence)node.getName())) {
                            IClasspathEntry resolvedClasspathEntry;
                            node.setHandlerIdentifier(fragmentRoot.getHandleIdentifier());
                            if (fragmentRoot instanceof JrtPackageFragmentRoot) {
                                node.setModuleName(fragmentRoot.getModuleDescription().getElementName());
                            }
                            if ((resolvedClasspathEntry = fragmentRoot.getResolvedClasspathEntry()) != null) {
                                HashMap<String, String> attributes = new HashMap<String, String>();
                                IClasspathAttribute[] iClasspathAttributeArray = resolvedClasspathEntry.getExtraAttributes();
                                int n4 = iClasspathAttributeArray.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    IClasspathAttribute attribute = iClasspathAttributeArray[n5];
                                    attributes.put(attribute.getName(), attribute.getValue());
                                    ++n5;
                                }
                                node.setAttributes(attributes);
                            }
                            children.add(node);
                        } else {
                            PackageParams subQuery = new PackageParams(NodeKind.PACKAGEROOT, query.getProjectUri(), query.getPath(), fragmentRoot.getHandleIdentifier());
                            List<PackageNode> packageNodes = PackageCommand.getPackages(subQuery, pm);
                            children.addAll(packageNodes);
                        }
                        ++n;
                    }
                    return children;
                }
                if (query.getPath().equals("REFERENCED_LIBRARIES_PATH")) {
                    List referLibs = Arrays.stream(references).filter(entry -> entry.getEntryKind() == 1).map(classpath -> PackageNode.createNodeForClasspathEntry(classpath, javaProject, NodeKind.PACKAGEROOT)).filter(entry -> entry != null).collect(Collectors.toList());
                    List referVariables = Arrays.stream(references).filter(entry -> entry.getEntryKind() == 4).map(classpath -> PackageNode.createNodeForClasspathVariable(classpath)).filter(entry -> entry != null).collect(Collectors.toList());
                    children.addAll(referLibs);
                    children.addAll(referVariables);
                    return children;
                }
            }
            catch (CoreException e) {
                JdtlsExtActivator.logException("Problem load project JAR entries ", e);
            }
        }
        return Collections.emptyList();
    }

    private static List<PackageNode> getPackages(PackageParams query, IProgressMonitor pm) {
        try {
            IPackageFragmentRoot packageRoot = PackageCommand.getPackageFragmentRootFromQuery(query);
            if (packageRoot == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", String.format("No package root found for %s", query.getPath())));
            }
            Object[] result = PackageCommand.getPackageFragmentRootContent(packageRoot, pm);
            return PackageCommand.convertToPackageNode(result, packageRoot, pm);
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problem load project package ", e);
            return Collections.emptyList();
        }
    }

    private static IPackageFragmentRoot getPackageFragmentRootFromQuery(PackageParams query) {
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)JavaCore.create((String)query.getHandlerIdentifier());
        if (packageRoot != null) {
            return packageRoot;
        }
        IJavaProject javaProject = PackageCommand.getJavaProject(query.getProjectUri());
        if (javaProject != null) {
            try {
                packageRoot = javaProject.findPackageFragmentRoot(Path.fromPortableString((String)query.getRootPath()));
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return packageRoot;
    }

    private static List<PackageNode> getRootTypes(PackageParams query, IProgressMonitor pm) {
        try {
            IPackageFragment packageFragment = (IPackageFragment)JavaCore.create((String)query.getHandlerIdentifier());
            if (packageFragment != null) {
                ArrayList<IType> primaryTypes = new ArrayList<IType>();
                IJavaElement[] iJavaElementArray = packageFragment.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType primaryType;
                    IJavaElement element = iJavaElementArray[n2];
                    if (!(!(element instanceof ITypeRoot) || element instanceof IClassFile && element.getElementName().contains("$") || (primaryType = ((ITypeRoot)element).findPrimaryType()) == null)) {
                        primaryTypes.add(primaryType);
                    }
                    ++n2;
                }
                Object[] nonJavaResources = packageFragment.getNonJavaResources();
                List<PackageNode> rootTypeNodes = primaryTypes.stream().map(PackageNode::createNodeForPrimaryType).collect(Collectors.toList());
                if (nonJavaResources.length == 0) {
                    return rootTypeNodes;
                }
                rootTypeNodes.addAll(Arrays.stream(nonJavaResources).filter(resource -> resource instanceof IFile || resource instanceof JarEntryFile).map(resource -> {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        PackageNode item = new PackageNode(file.getName(), file.getFullPath().toPortableString(), NodeKind.FILE);
                        item.setUri(JDTUtils.getFileURI((IResource)file));
                        return item;
                    }
                    JarEntryFile file = (JarEntryFile)resource;
                    PackageNode entry = new PackageNode(file.getName(), file.getFullPath().toPortableString(), NodeKind.FILE);
                    entry.setUri(ExtUtils.toUri((IJarEntryResource)((JarEntryFile)resource)));
                    return entry;
                }).collect(Collectors.toList()));
                return rootTypeNodes;
            }
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problem load project classfile list ", e);
        }
        return Collections.emptyList();
    }

    private static List<PackageNode> getFolderChildren(PackageParams query, IProgressMonitor pm) {
        try {
            IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)JavaCore.create((String)query.getHandlerIdentifier());
            if (packageRoot == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", String.format("No package root found for %s", query.getPath())));
            }
            if (packageRoot.getKind() == 2) {
                Object[] resources;
                Object[] objectArray = resources = packageRoot.getNonJavaResources();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    JarEntryDirectory directory;
                    Object[] children;
                    Object resource = objectArray[n2];
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (resource instanceof JarEntryDirectory && (children = PackageCommand.findJarDirectoryChildren(directory = (JarEntryDirectory)resource, query.getPath())) != null) {
                        return PackageCommand.convertToPackageNode(children, null, pm);
                    }
                    ++n2;
                }
            } else {
                IJavaProject javaProject = packageRoot.getJavaProject();
                IFolder folder = javaProject.getProject().getFolder(new Path(query.getPath()).makeRelativeTo(javaProject.getProject().getFullPath()));
                if (folder != null && folder.exists()) {
                    Object[] children;
                    Object[] objectArray = children = JavaCore.create((IFolder)folder) != null ? Arrays.stream(folder.members()).filter(t -> t instanceof IFile).toArray() : folder.members();
                    if (children != null) {
                        return PackageCommand.convertToPackageNode(children, null, pm);
                    }
                }
            }
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problem load project classfile list ", e);
        }
        return Collections.emptyList();
    }

    private static Object[] getPackageFragmentRootContent(IPackageFragmentRoot root, IProgressMonitor pm) throws CoreException {
        IClassFile moduleInfo;
        ArrayList<Object> result = new ArrayList<Object>();
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            IPackageFragment fragment = (IPackageFragment)child;
            if (fragment.hasChildren()) {
                result.add(child);
            } else if (fragment.getNonJavaResources().length > 0) {
                result.add(fragment);
            } else if (!fragment.hasSubpackages()) {
                result.add(fragment);
            }
            ++n2;
        }
        Object[] nonJavaResources = root.getNonJavaResources();
        Collections.addAll(result, nonJavaResources);
        IModuleDescription moduleDescription = root.getModuleDescription();
        if (moduleDescription != null && (moduleInfo = moduleDescription.getClassFile()) != null) {
            result.add(moduleDescription.getClassFile());
        }
        return result.toArray();
    }

    private static List<PackageNode> convertToPackageNode(Object[] rootContent, IPackageFragmentRoot packageRoot, IProgressMonitor pm) throws JavaModelException {
        ArrayList<PackageNode> result = new ArrayList<PackageNode>();
        Object[] objectArray = rootContent;
        int n = rootContent.length;
        int n2 = 0;
        while (n2 < n) {
            PackageNode entry;
            Object root = objectArray[n2];
            if (root instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)root;
                if (fragment.isDefaultPackage()) {
                    PackageParams subQuery = new PackageParams(NodeKind.PACKAGE, packageRoot.getJavaProject().getProject().getLocationURI().toString(), fragment.getPath().toPortableString(), fragment.getHandleIdentifier());
                    List<PackageNode> packageNodes = PackageCommand.getRootTypes(subQuery, pm);
                    result.addAll(packageNodes);
                } else {
                    entry = PackageNode.createNodeForPackageFragment(fragment);
                    if (fragment.getResource() != null) {
                        entry.setUri(fragment.getResource().getLocationURI().toString());
                    } else {
                        entry.setUri(fragment.getPath().toFile().toURI().toString());
                    }
                    result.add(entry);
                }
            } else if (root instanceof IClassFile) {
                IClassFile classFile = (IClassFile)root;
                entry = new PackageNode(classFile.getElementName(), null, NodeKind.FILE);
                entry.setUri(JDTUtils.toUri((IClassFile)classFile));
                result.add(entry);
            } else if (root instanceof JarEntryResource) {
                PackageNode jarNode = PackageCommand.getJarEntryResource((JarEntryResource)root);
                if (jarNode != null) {
                    result.add(jarNode);
                }
            } else if (root instanceof IFile) {
                IFile file = (IFile)root;
                entry = new PackageNode(file.getName(), file.getFullPath().toPortableString(), NodeKind.FILE);
                entry.setUri(JDTUtils.getFileURI((IResource)file));
                result.add(entry);
            } else if (root instanceof IFolder) {
                IFolder folder = (IFolder)root;
                String displayName = folder.getName();
                if (packageRoot != null) {
                    IPath path = folder.getFullPath().makeRelativeTo(packageRoot.getPath());
                    displayName = StringUtils.replace((String)path.toPortableString(), (String)"/", (String)".");
                }
                PackageNode entry2 = new PackageNode(displayName, folder.getFullPath().toPortableString(), NodeKind.FOLDER);
                entry2.setUri(JDTUtils.getFileURI((IResource)folder));
                result.add(entry2);
            }
            ++n2;
        }
        return result;
    }

    private static PackageNode getJarEntryResource(JarEntryResource resource) {
        if (resource instanceof JarEntryDirectory) {
            return new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FOLDER);
        }
        if (resource instanceof JarEntryFile) {
            PackageNode entry = new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FILE);
            entry.setUri(ExtUtils.toUri((IJarEntryResource)resource));
            return entry;
        }
        return null;
    }

    private static Object[] findJarDirectoryChildren(JarEntryDirectory directory, String path) {
        String directoryPath = directory.getFullPath().toPortableString();
        if (directoryPath.equals(path)) {
            return directory.getChildren();
        }
        if (path.startsWith(directoryPath)) {
            IJarEntryResource[] iJarEntryResourceArray = directory.getChildren();
            int n = iJarEntryResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] result;
                IJarEntryResource resource = iJarEntryResourceArray[n2];
                String childrenPath = resource.getFullPath().toPortableString();
                if (childrenPath.equals(path)) {
                    return resource.getChildren();
                }
                if (path.startsWith(childrenPath) && resource instanceof JarEntryDirectory && (result = PackageCommand.findJarDirectoryChildren((JarEntryDirectory)resource, path)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IJavaProject getJavaProject(String projectUri) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] containers = root.findContainersForLocationURI(JDTUtils.toURI((String)projectUri));
        if (containers.length == 0) {
            return null;
        }
        IContainer[] iContainerArray = containers;
        if (containers.length != 0) {
            IContainer container = iContainerArray[0];
            IProject project = container.getProject();
            if (!project.exists()) {
                return null;
            }
            return JavaCore.create((IProject)project);
        }
        return null;
    }
}

