/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.jdtls.ext.core.PackageCommand;
import com.microsoft.jdtls.ext.core.model.PackageNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.jarpackager.JarPackageUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;

public final class ProjectCommand {
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();

    public static List<PackageNode> listProjects(List<Object> arguments, IProgressMonitor monitor) {
        String workspaceUri = (String)arguments.get(0);
        IPath workspaceFolderPath = ResourceUtils.canonicalFilePathFromURI((String)workspaceUri);
        String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName((IPath)workspaceFolderPath);
        IProject[] projects = ProjectCommand.getWorkspaceRoot().getProjects();
        ArrayList<PackageNode> children = new ArrayList<PackageNode>();
        List<IPath> paths = Collections.singletonList(workspaceFolderPath);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && ProjectUtils.isJavaProject((IProject)project) && (ResourceUtils.isContainedIn((IPath)project.getLocation(), paths) || Objects.equals(project.getName(), invisibleProjectName))) {
                PackageNode projectNode = PackageNode.createNodeForProject((IJavaElement)JavaCore.create((IProject)project));
                if (Objects.equals(project.getName(), invisibleProjectName)) {
                    projectNode.setDisplayName(FilenameUtils.getBaseName((String)workspaceFolderPath.toOSString()));
                }
                children.add(projectNode);
            }
            ++n2;
        }
        return children;
    }

    public static boolean refreshLibraries(List<Object> arguments, IProgressMonitor monitor) {
        String workspaceUri = (String)arguments.get(0);
        IPath workspacePath = ResourceUtils.canonicalFilePathFromURI((String)workspaceUri);
        String projectName = ProjectUtils.getWorkspaceInvisibleProjectName((IPath)workspacePath);
        IProject project = ProjectCommand.getWorkspaceRoot().getProject(projectName);
        try {
            Preferences.ReferencedLibraries libraries = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getReferencedLibraries();
            UpdateClasspathJob.getInstance().updateClasspath(JavaCore.create((IProject)project), libraries);
            return true;
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException((String)"Exception occurred during waiting for classpath to be updated", (Throwable)e);
            return false;
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static ExportResult exportJar(List<Object> arguments, IProgressMonitor monitor) {
        if (arguments.size() < 3) {
            return new ExportResult(false, "Invalid export Arguments");
        }
        String mainClass = (String)gson.fromJson(gson.toJson(arguments.get(0)), String.class);
        Classpath[] classpaths = (Classpath[])gson.fromJson(gson.toJson(arguments.get(1)), Classpath[].class);
        String destination = (String)gson.fromJson(gson.toJson(arguments.get(2)), String.class);
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (mainClass.length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(destination), manifest);){
                HashSet<String> directories = new HashSet<String>();
                Classpath[] classpathArray = classpaths;
                int n = classpaths.length;
                int n2 = 0;
                while (n2 < n) {
                    Classpath classpath = classpathArray[n2];
                    if (classpath.isArtifact) {
                        JarPackageUtil.writeArchive(new ZipFile(classpath.source), true, true, target, directories, monitor);
                    } else {
                        try {
                            JarPackageUtil.writeFile(new File(classpath.source), (IPath)new Path(classpath.destination), true, true, target, directories);
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return new ExportResult(false, e.getMessage());
        }
        return new ExportResult(true);
    }

    public static List<MainClassInfo> getMainClasses(List<Object> arguments, IProgressMonitor monitor) throws Exception {
        List<PackageNode> projectList = ProjectCommand.listProjects(arguments, monitor);
        final ArrayList<MainClassInfo> res = new ArrayList<MainClassInfo>();
        ArrayList<IPackageFragmentRoot> searchRoots = new ArrayList<IPackageFragmentRoot>();
        if (projectList.size() == 0) {
            return res;
        }
        for (PackageNode project : projectList) {
            IJavaProject javaProject = PackageCommand.getJavaProject(project.getUri());
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                if (!packageFragmentRoot.isExternal()) {
                    searchRoots.add(packageFragmentRoot);
                }
                ++n2;
            }
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])searchRoots.toArray(IJavaElement[]::new)));
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                Object element = match.getElement();
                if (!(element instanceof IMethod)) {
                    return;
                }
                IMethod method = (IMethod)element;
                try {
                    if (!method.isMainMethod() || method.getResource() == null || method.getJavaProject() == null) {
                        return;
                    }
                    String mainClass = method.getDeclaringType().getFullyQualifiedName();
                    String filePath = "";
                    if (match.getResource() instanceof IFile) {
                        filePath = match.getResource().getLocation().toOSString();
                    }
                    res.add(new MainClassInfo(mainClass, filePath));
                }
                catch (JavaModelException javaModelException) {}
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        return res;
    }

    public static String getModuleName(IJavaProject project) {
        if (project == null || !JavaRuntime.isModularProject((IJavaProject)project)) {
            return null;
        }
        try {
            IModuleDescription module = project.getModuleDescription();
            return module == null ? null : module.getElementName();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static class Classpath {
        public String source;
        public String destination;
        public boolean isArtifact;

        private Classpath() {
        }
    }

    private static class ExportResult {
        public boolean result;
        public String message;
        public String log;

        ExportResult(boolean result) {
            this.result = result;
            this.log = "";
        }

        ExportResult(boolean result, String message) {
            this.result = result;
            this.message = message;
            this.log = "";
        }
    }

    private static class MainClassInfo {
        public String name;
        public String path;

        public MainClassInfo(String name, String path) {
            this.name = name;
            this.path = path;
        }
    }
}

