/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.AssignToVariableAssistProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CodeActionParams;

public class QuickAssistProcessor {
    public static final String SPLIT_JOIN_VARIABLE_DECLARATION_ID = "org.eclipse.jdt.ls.correction.splitJoinVariableDeclaration.assist";
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ls.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignParamToField.assist";
    public static final String ASSIGN_ALL_PARAMS_TO_NEW_FIELDS_ID = "org.eclipse.jdt.ls.correction.assignAllParamsToNewFields.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ls.correction.addBlock.assist";
    public static final String EXTRACT_LOCAL_ID = "org.eclipse.jdt.ls.correction.extractLocal.assist";
    public static final String EXTRACT_LOCAL_NOT_REPLACE_ID = "org.eclipse.jdt.ls.correction.extractLocalNotReplaceOccurrences.assist";
    public static final String EXTRACT_CONSTANT_ID = "org.eclipse.jdt.ls.correction.extractConstant.assist";
    public static final String INLINE_LOCAL_ID = "org.eclipse.jdt.ls.correction.inlineLocal.assist";
    public static final String CONVERT_LOCAL_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.convertLocalToField.assist";
    public static final String CONVERT_ANONYMOUS_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.convertAnonymousToLocal.assist";
    public static final String CONVERT_TO_STRING_BUFFER_ID = "org.eclipse.jdt.ls.correction.convertToStringBuffer.assist";
    public static final String CONVERT_TO_MESSAGE_FORMAT_ID = "org.eclipse.jdt.ls.correction.convertToMessageFormat.assist";
    public static final String EXTRACT_METHOD_INPLACE_ID = "org.eclipse.jdt.ls.correction.extractMethodInplace.assist";
    private PreferenceManager preferenceManager;

    public QuickAssistProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<ChangeCorrectionProposal> getAssists(CodeActionParams params, IInvocationContext context, IProblemLocationCore[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ChangeCorrectionProposal> resultingCollections = new ArrayList<ChangeCorrectionProposal>();
            QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getAssignAllParamsToFieldsProposals(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getConvertMethodReferenceToLambdaProposal(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getConvertLambdaToMethodReferenceProposal(context, coveringNode, resultingCollections);
            return resultingCollections;
        }
        return Collections.emptyList();
    }

    private static boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)parent;
        IVariableBinding binding = paramDecl.resolveBinding();
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (binding == null || methodDecl.getBody() == null) {
            return false;
        }
        ITypeBinding typeBinding = binding.getType();
        if (typeBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType != null) {
            if (parentType.isInterface()) {
                return false;
            }
            CompilationUnit root = context.getASTRoot();
            IVariableBinding[] declaredFields = parentType.getDeclaredFields();
            boolean isStaticContext = ASTResolving.isInStaticContext((ASTNode)node);
            int i = 0;
            while (i < declaredFields.length) {
                VariableDeclarationFragment fragment;
                ASTNode fieldDeclFrag;
                IVariableBinding curr = declaredFields[i];
                if (isStaticContext == Modifier.isStatic((int)curr.getModifiers()) && typeBinding.isAssignmentCompatible(curr.getType()) && (fieldDeclFrag = root.findDeclaringNode((IBinding)curr)) instanceof VariableDeclarationFragment && (fragment = (VariableDeclarationFragment)fieldDeclFrag).getInitializer() == null) {
                    resultingCollections.add(new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, fragment, typeBinding, 1));
                }
                ++i;
            }
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, null, typeBinding, 3);
        resultingCollections.add(fieldProposal);
        return true;
    }

    private static boolean getAssignAllParamsToFieldsProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (methodDecl.getBody() == null) {
            return false;
        }
        List parameters = methodDecl.parameters();
        if (parameters.size() <= 1) {
            return false;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType == null || parentType.isInterface()) {
            return false;
        }
        for (SingleVariableDeclaration param : parameters) {
            IVariableBinding binding = param.resolveBinding();
            if (binding != null && binding.getType() != null) continue;
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), parameters, 2);
        resultingCollections.add(fieldProposal);
        return true;
    }

    public static ArrayList<ASTNode> getFullyCoveredNodes(IInvocationContext context, ASTNode coveringNode) {
        final ArrayList<ASTNode> coveredNodes = new ArrayList<ASTNode>();
        final int selectionBegin = context.getSelectionOffset();
        final int selectionEnd = selectionBegin + context.getSelectionLength();
        coveringNode.accept((ASTVisitor)new GenericVisitor(){

            protected boolean visitNode(ASTNode node) {
                ASTNode parent;
                int nodeStart = node.getStartPosition();
                int nodeEnd = nodeStart + node.getLength();
                if (nodeEnd < selectionBegin || selectionEnd < nodeStart) {
                    return false;
                }
                if (this.isCovered(node) && ((parent = node.getParent()) == null || !this.isCovered(parent))) {
                    coveredNodes.add(node);
                    return false;
                }
                return true;
            }

            private boolean isCovered(ASTNode node) {
                int begin = node.getStartPosition();
                int end = begin + node.getLength();
                return begin >= selectionBegin && end <= selectionEnd;
            }
        });
        return coveredNodes;
    }

    public static IMethodBinding getFunctionalMethodForMethodReference(MethodReference methodReference) {
        ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)methodReference);
        if (targetTypeBinding == null) {
            return null;
        }
        IMethodBinding functionalMethod = targetTypeBinding.getFunctionalInterfaceMethod();
        if (functionalMethod.isSynthetic()) {
            functionalMethod = Bindings.findOverriddenMethodInType((ITypeBinding)functionalMethod.getDeclaringClass(), (IMethodBinding)functionalMethod);
        }
        return functionalMethod;
    }

    public static LambdaExpression convertMethodRefernceToLambda(MethodReference methodReference, IMethodBinding functionalMethod, CompilationUnit astRoot, ASTRewrite rewrite, LinkedProposalModelCore linkedProposalModel, boolean createBlockBody) throws JavaModelException {
        MethodInvocation methodInvocation;
        AST ast = astRoot.getAST();
        LambdaExpression lambda = ast.newLambdaExpression();
        String[] lambdaParamNames = QuickAssistProcessor.getUniqueParameterNames(methodReference, functionalMethod);
        List lambdaParameters = lambda.parameters();
        int i = 0;
        while (i < lambdaParamNames.length) {
            String paramName = lambdaParamNames[i];
            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
            SimpleName name = ast.newSimpleName(paramName);
            lambdaParameter.setName(name);
            lambdaParameters.add(lambdaParameter);
            if (linkedProposalModel != null) {
                linkedProposalModel.getPositionGroup(name.getIdentifier(), true).addPosition(rewrite.track((ASTNode)name), i == 0);
            }
            ++i;
        }
        int noOfLambdaParameters = lambdaParamNames.length;
        lambda.setParentheses(noOfLambdaParameters != 1);
        ITypeBinding returnTypeBinding = functionalMethod.getReturnType();
        IMethodBinding referredMethodBinding = methodReference.resolveMethodBinding();
        if (methodReference instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)methodReference;
            Type type = creationRef.getType();
            if (type instanceof ArrayType) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)arrayCreation, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)arrayCreation);
                }
                ArrayType arrayType = (ArrayType)type;
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                arrayCreation.setType(ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                arrayCreation.dimensions().add(name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)cic, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)cic);
                }
                ITypeBinding typeBinding = type.resolveBinding();
                if (!(type instanceof ParameterizedType) && typeBinding != null && typeBinding.getTypeDeclaration().isGenericType()) {
                    cic.setType((Type)ast.newParameterizedType((Type)rewrite.createCopyTarget((ASTNode)type)));
                } else {
                    cic.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                }
                List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
                cic.arguments().addAll(invocationArgs);
                if (linkedProposalModel != null) {
                    for (SimpleName name : invocationArgs) {
                        linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                    }
                }
                cic.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
            }
        } else if (referredMethodBinding != null && Modifier.isStatic((int)referredMethodBinding.getModifiers())) {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            Expression expr = null;
            boolean hasConflict = QuickAssistProcessor.hasConflict(methodReference.getStartPosition(), referredMethodBinding, 17, astRoot);
            if (hasConflict || !Bindings.isSuperType((ITypeBinding)referredMethodBinding.getDeclaringClass(), (ITypeBinding)ASTNodes.getEnclosingType((ASTNode)methodReference)) || methodReference.typeArguments().size() != 0) {
                Type type;
                ITypeBinding typeBinding;
                if (methodReference instanceof ExpressionMethodReference) {
                    ExpressionMethodReference expressionMethodReference = (ExpressionMethodReference)methodReference;
                    expr = (Expression)rewrite.createCopyTarget((ASTNode)expressionMethodReference.getExpression());
                } else if (methodReference instanceof TypeMethodReference && (typeBinding = (type = ((TypeMethodReference)methodReference).getType()).resolveBinding()) != null) {
                    ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
                    expr = ast.newName(importRewrite.addImport(typeBinding));
                }
            }
            methodInvocation.setExpression(expr);
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)superMethodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)superMethodInvocation);
            }
            Name superQualifier = ((SuperMethodReference)methodReference).getQualifier();
            if (superQualifier != null) {
                superMethodInvocation.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            superMethodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            superMethodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            superMethodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            boolean isTypeReference = QuickAssistProcessor.isTypeReferenceToInstanceMethod(methodReference);
            if (isTypeReference) {
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                methodInvocation.setExpression((Expression)name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                Expression expr = ((ExpressionMethodReference)methodReference).getExpression();
                if (!(expr instanceof ThisExpression) || methodReference.typeArguments().size() != 0) {
                    methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expr));
                }
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, isTypeReference ? 1 : 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        }
        rewrite.replace((ASTNode)methodReference, (ASTNode)lambda, null);
        return lambda;
    }

    private static boolean hasConflict(int startPosition, IMethodBinding referredMethodBinding, int flags, CompilationUnit cu) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(cu);
        IBinding[] declarationsInScope = analyzer.getDeclarationsInScope(startPosition, flags);
        int i = 0;
        while (i < declarationsInScope.length) {
            IBinding decl = declarationsInScope[i];
            if (decl.getName().equals(referredMethodBinding.getName()) && !referredMethodBinding.getMethodDeclaration().isEqualTo(decl)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] getUniqueParameterNames(MethodReference methodReference, IMethodBinding functionalMethod) throws JavaModelException {
        String[] parameterNames = ((IMethod)functionalMethod.getJavaElement()).getParameterNames();
        ArrayList<String> oldNames = new ArrayList<String>(Arrays.asList(parameterNames));
        String[] newNames = new String[oldNames.size()];
        ArrayList<String> excludedNames = new ArrayList<String>(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodReference));
        int i = 0;
        while (i < oldNames.size()) {
            String paramName = (String)oldNames.get(i);
            ArrayList<String> allNamesToExclude = new ArrayList<String>(excludedNames);
            allNamesToExclude.addAll(oldNames.subList(0, i));
            allNamesToExclude.addAll(oldNames.subList(i + 1, oldNames.size()));
            if (allNamesToExclude.contains(paramName)) {
                String newParamName = QuickAssistProcessor.createName(paramName, allNamesToExclude);
                excludedNames.add(newParamName);
                newNames[i] = newParamName;
            } else {
                newNames[i] = paramName;
            }
            ++i;
        }
        return newNames;
    }

    private static String createName(String candidate, List<String> excludedNames) {
        int i = 1;
        String result = candidate;
        while (excludedNames.contains(result)) {
            result = String.valueOf(candidate) + i++;
        }
        return result;
    }

    private static boolean isTypeReferenceToInstanceMethod(MethodReference methodReference) {
        IBinding nameBinding;
        Expression expression;
        if (methodReference instanceof TypeMethodReference) {
            return true;
        }
        return methodReference instanceof ExpressionMethodReference && (expression = ((ExpressionMethodReference)methodReference).getExpression()) instanceof Name && (nameBinding = ((Name)expression).resolveBinding()) != null && nameBinding instanceof ITypeBinding;
    }

    private static List<SimpleName> getInvocationArguments(AST ast, int begIndex, int noOfLambdaParameters, String[] lambdaParamNames) {
        ArrayList<SimpleName> args = new ArrayList<SimpleName>();
        int i = begIndex;
        while (i < noOfLambdaParameters) {
            args.add(ast.newSimpleName(lambdaParamNames[i]));
            ++i;
        }
        return args;
    }

    private static List<Type> getCopiedTypeArguments(ASTRewrite rewrite, List<Type> typeArguments) {
        ArrayList<Type> copiedTypeArgs = new ArrayList<Type>();
        for (Type typeArg : typeArguments) {
            copiedTypeArgs.add((Type)rewrite.createCopyTarget((ASTNode)typeArg));
        }
        return copiedTypeArgs;
    }

    private static SimpleName getMethodInvocationName(MethodReference methodReference) {
        SimpleName name = null;
        if (methodReference instanceof ExpressionMethodReference) {
            name = ((ExpressionMethodReference)methodReference).getName();
        } else if (methodReference instanceof TypeMethodReference) {
            name = ((TypeMethodReference)methodReference).getName();
        } else if (methodReference instanceof SuperMethodReference) {
            name = ((SuperMethodReference)methodReference).getName();
        }
        return name;
    }

    public static void changeLambdaBodyToBlock(LambdaExpression lambda, AST ast, ASTRewrite rewrite) {
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        Block blockBody = QuickAssistProcessor.getBlockBodyForLambda(bodyExpr, lambda.resolveMethodBinding().getReturnType(), ast);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
    }

    private static Block getBlockBodyForLambda(Expression bodyExpr, ITypeBinding returnTypeBinding, AST ast) {
        ExpressionStatement statementInBlockBody;
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)returnTypeBinding)) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        return blockBody;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        String label;
        if (resultingCollections == null) {
            return true;
        }
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)node, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!(type.isSimpleType() || type.isUnionType() || type.isNameQualifiedType())) {
            return false;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer)) {
            return false;
        }
        AST ast = bodyDeclaration.getAST();
        SimpleType selectedMultiCatchType = null;
        if (type.isUnionType() && node instanceof Name) {
            Name topMostName = ASTNodes.getTopMostName((Name)((Name)node));
            ASTNode parent = topMostName.getParent();
            if (parent instanceof SimpleType) {
                selectedMultiCatchType = (SimpleType)parent;
            } else if (parent instanceof NameQualifiedType) {
                selectedMultiCatchType = (NameQualifiedType)parent;
            }
        }
        if (bodyDeclaration instanceof MethodDeclaration) {
            String label2;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            if (selectedMultiCatchType != null) {
                QuickAssistProcessor.removeException(rewrite, (UnionType)type, (Type)selectedMultiCatchType);
                QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, (Type)selectedMultiCatchType);
                label2 = CorrectionMessages.QuickAssistProcessor_exceptiontothrows_description;
                ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, "quickfix", context.getCompilationUnit(), rewrite, 6);
                resultingCollections.add(proposal2);
            } else {
                QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
                if (type.isUnionType()) {
                    UnionType unionType = (UnionType)type;
                    List types = unionType.types();
                    for (Type elementType : types) {
                        if (!(elementType instanceof SimpleType) && !(elementType instanceof NameQualifiedType)) {
                            return false;
                        }
                        QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, elementType);
                    }
                } else {
                    QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, type);
                }
                label2 = CorrectionMessages.QuickAssistProcessor_catchclausetothrows_description;
                ASTRewriteCorrectionProposal proposal3 = new ASTRewriteCorrectionProposal(label2, "quickfix", context.getCompilationUnit(), rewrite, 4);
                resultingCollections.add(proposal3);
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (selectedMultiCatchType != null) {
            QuickAssistProcessor.removeException(rewrite, (UnionType)type, selectedMultiCatchType);
            label = CorrectionMessages.QuickAssistProcessor_removeexception_description;
            proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
            resultingCollections.add(proposal);
        } else {
            QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
            label = CorrectionMessages.QuickAssistProcessor_removecatchclause_description;
            proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 5);
            resultingCollections.add(proposal);
        }
        return true;
    }

    private static void removeException(ASTRewrite rewrite, UnionType unionType, Type exception) {
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)unionType, UnionType.TYPES_PROPERTY);
        List types = unionType.types();
        for (Type type : types) {
            if (!type.equals((Object)exception)) continue;
            listRewrite.remove((ASTNode)type, null);
        }
    }

    private static void addExceptionToThrows(AST ast, MethodDeclaration methodDeclaration, ASTRewrite rewrite, Type type2) {
        ITypeBinding binding = type2.resolveBinding();
        if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptionTypes())) {
            Type newType = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type2);
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
            listRewriter.insertLast((ASTNode)newType, null);
        }
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null || !tryStatement.resources().isEmpty()) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List<Type> thrownExceptions) {
        for (Type thrownException : thrownExceptions) {
            ITypeBinding elem = thrownException.resolveBinding();
            if (elem == null || !Bindings.isSuperType((ITypeBinding)elem, (ITypeBinding)binding)) continue;
            return false;
        }
        return true;
    }

    private static boolean getConvertMethodReferenceToLambdaProposal(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) throws JavaModelException {
        MethodReference methodReference;
        if (covering instanceof MethodReference) {
            methodReference = (MethodReference)covering;
        } else if (covering.getParent() instanceof MethodReference) {
            methodReference = (MethodReference)covering.getParent();
        } else {
            return false;
        }
        IMethodBinding functionalMethod = QuickAssistProcessor.getFunctionalMethodForMethodReference(methodReference);
        if (functionalMethod == null || functionalMethod.isGenericMethod()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)methodReference.getAST());
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        LambdaExpression lambda = QuickAssistProcessor.convertMethodRefernceToLambda(methodReference, functionalMethod, context.getASTRoot(), rewrite, linkedProposalModel, false);
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_lambda_expression;
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
        proposal.setLinkedProposalModel(linkedProposalModel);
        proposal.setEndPosition(rewrite.track((ASTNode)lambda));
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertLambdaToMethodReferenceProposal(IInvocationContext context, ASTNode coveringNode, Collection<ChangeCorrectionProposal> resultingCollections) {
        IMethodBinding methodBinding;
        CreationReference replacement;
        CreationReference creationReference;
        IMethodBinding methodBinding2;
        LambdaExpression lambda;
        if (coveringNode instanceof LambdaExpression) {
            lambda = (LambdaExpression)coveringNode;
        } else if (coveringNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)coveringNode.getParent();
        } else {
            lambda = ASTResolving.findEnclosingLambdaExpression((ASTNode)coveringNode);
            if (lambda == null) {
                return false;
            }
        }
        ASTNode lambdaBody = lambda.getBody();
        Expression exprBody = lambdaBody instanceof Block ? QuickAssistProcessor.getSingleExpressionFromLambdaBody((Block)lambdaBody) : (Expression)lambdaBody;
        exprBody = ASTNodes.getUnparenthesedExpression((Expression)exprBody);
        if (exprBody == null || !QuickAssistProcessor.isValidLambdaReferenceToMethod(exprBody)) {
            return false;
        }
        if (!ASTNodes.isParent((ASTNode)exprBody, (ASTNode)coveringNode) && !QuickAssistProcessor.representsDefiningNode(coveringNode, (ASTNode)exprBody)) {
            return false;
        }
        ArrayList<Expression> lambdaParameters = new ArrayList<Expression>();
        for (VariableDeclaration param : lambda.parameters()) {
            lambdaParameters.add((Expression)param.getName());
        }
        if (exprBody instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)exprBody;
            if (cic.getExpression() != null || cic.getAnonymousClassDeclaration() != null) {
                return false;
            }
            if (!QuickAssistProcessor.matches(lambdaParameters, cic.arguments())) {
                return false;
            }
        } else if (exprBody instanceof ArrayCreation) {
            List dimensions = ((ArrayCreation)exprBody).dimensions();
            if (dimensions.size() != 1) {
                return false;
            }
            if (!QuickAssistProcessor.matches(lambdaParameters, dimensions)) {
                return false;
            }
        } else if (exprBody instanceof SuperMethodInvocation) {
            ITypeBinding invocationTypeBinding;
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)exprBody;
            methodBinding2 = superMethodInvocation.resolveMethodBinding();
            if (methodBinding2 == null) {
                return false;
            }
            if (Modifier.isStatic((int)methodBinding2.getModifiers()) && (invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, (IMethodBinding)methodBinding2, (Expression)superMethodInvocation.getQualifier())) == null) {
                return false;
            }
            if (!QuickAssistProcessor.matches(lambdaParameters, superMethodInvocation.arguments())) {
                return false;
            }
        } else {
            ITypeBinding invocationTypeBinding;
            MethodInvocation methodInvocation = (MethodInvocation)exprBody;
            methodBinding2 = methodInvocation.resolveMethodBinding();
            if (methodBinding2 == null) {
                return false;
            }
            Expression invocationExpr = methodInvocation.getExpression();
            if (Modifier.isStatic((int)methodBinding2.getModifiers())) {
                invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, (IMethodBinding)methodBinding2, (Expression)invocationExpr);
                if (invocationTypeBinding == null) {
                    return false;
                }
                if (!QuickAssistProcessor.matches(lambdaParameters, methodInvocation.arguments())) {
                    return false;
                }
            } else if (lambda.parameters().size() - methodInvocation.arguments().size() == 1) {
                if (invocationExpr == null) {
                    return false;
                }
                invocationTypeBinding = invocationExpr.resolveTypeBinding();
                if (invocationTypeBinding == null) {
                    return false;
                }
                IMethodBinding lambdaMethodBinding = lambda.resolveMethodBinding();
                if (lambdaMethodBinding == null) {
                    return false;
                }
                ITypeBinding firstParamType = lambdaMethodBinding.getParameterTypes()[0];
                if (!Bindings.equals((IBinding)invocationTypeBinding, (IBinding)firstParamType) && !Bindings.isSuperType((ITypeBinding)invocationTypeBinding, (ITypeBinding)firstParamType) || !JdtASTMatcher.doNodesMatch((ASTNode)((ASTNode)lambdaParameters.get(0)), (ASTNode)invocationExpr) || !QuickAssistProcessor.matches(lambdaParameters.subList(1, lambdaParameters.size()), methodInvocation.arguments())) {
                    return false;
                }
            } else if (!QuickAssistProcessor.matches(lambdaParameters, methodInvocation.arguments())) {
                return false;
            }
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = null;
        if (exprBody instanceof ClassInstanceCreation) {
            replacement = creationReference = ast.newCreationReference();
            ClassInstanceCreation cic = (ClassInstanceCreation)exprBody;
            Type type = cic.getType();
            if (type.isParameterizedType() && ((ParameterizedType)type).typeArguments().size() == 0) {
                type = ((ParameterizedType)type).getType();
            }
            creationReference.setType((Type)rewrite.createCopyTarget((ASTNode)type));
            creationReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, cic.typeArguments()));
        } else if (exprBody instanceof ArrayCreation) {
            replacement = creationReference = ast.newCreationReference();
            ArrayType arrayType = ((ArrayCreation)exprBody).getType();
            Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
            creationReference.setType((Type)ast.newArrayType(copiedElementType, arrayType.getDimensions()));
        } else if (exprBody instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)exprBody;
            methodBinding = superMethodInvocation.resolveMethodBinding();
            Name superQualifier = superMethodInvocation.getQualifier();
            if (Modifier.isStatic((int)methodBinding.getModifiers())) {
                TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                replacement = typeMethodReference;
                typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                importRewrite = StubUtility.createImportRewrite((CompilationUnit)context.getASTRoot(), (boolean)true);
                ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, (IMethodBinding)methodBinding, (Expression)superQualifier);
                typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding.getTypeDeclaration(), ast));
                typeMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
            } else {
                SuperMethodReference superMethodReference = ast.newSuperMethodReference();
                replacement = superMethodReference;
                if (superQualifier != null) {
                    superMethodReference.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
                }
                superMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                superMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
            }
        } else {
            boolean isTypeRefToInstanceMethod;
            MethodInvocation methodInvocation = (MethodInvocation)exprBody;
            methodBinding = methodInvocation.resolveMethodBinding();
            Expression invocationQualifier = methodInvocation.getExpression();
            boolean isStaticMethod = Modifier.isStatic((int)methodBinding.getModifiers());
            boolean bl = isTypeRefToInstanceMethod = methodInvocation.arguments().size() != lambda.parameters().size();
            if (isStaticMethod || isTypeRefToInstanceMethod) {
                TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                replacement = typeMethodReference;
                typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                importRewrite = StubUtility.createImportRewrite((CompilationUnit)context.getASTRoot(), (boolean)true);
                ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, (IMethodBinding)methodBinding, (Expression)invocationQualifier);
                invocationTypeBinding = StubUtility2Core.replaceWildcardsAndCaptures((ITypeBinding)invocationTypeBinding);
                ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)lambda, importRewrite);
                typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.OTHER));
                typeMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
            } else {
                ExpressionMethodReference exprMethodReference = ast.newExpressionMethodReference();
                replacement = exprMethodReference;
                exprMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                if (invocationQualifier != null) {
                    exprMethodReference.setExpression((Expression)rewrite.createCopyTarget((ASTNode)invocationQualifier));
                } else {
                    TypeDeclaration lambdaParentType = (TypeDeclaration)ASTResolving.findParentType((ASTNode)lambda);
                    ITypeBinding lambdaMethodInvokingClass = lambdaParentType.resolveBinding();
                    ITypeBinding lambdaMethodDeclaringClass = methodBinding.getDeclaringClass();
                    ThisExpression newThisExpression = ast.newThisExpression();
                    ITypeBinding nestedRootClass = QuickAssistProcessor.getNestedRootClass(lambdaMethodInvokingClass);
                    boolean isSuperClass = QuickAssistProcessor.isSuperClass(lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                    boolean isNestedClass = QuickAssistProcessor.isNestedClass(lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                    if (lambdaMethodDeclaringClass != lambdaMethodInvokingClass) {
                        if (Modifier.isDefault((int)methodBinding.getModifiers())) {
                            boolean nestedInterfaceClass = QuickAssistProcessor.isNestedInterfaceClass(ast, lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                            if (!(isNestedClass || nestedInterfaceClass && !isNestedClass && !isSuperClass || nestedInterfaceClass && nestedRootClass == lambdaMethodInvokingClass)) {
                                newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                            }
                        } else if (lambdaMethodDeclaringClass.isInterface()) {
                            if (!isSuperClass) {
                                newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                            }
                        } else if (!isSuperClass) {
                            newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                        }
                    }
                    exprMethodReference.setExpression((Expression)newThisExpression);
                }
                exprMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
            }
        }
        rewrite.replace((ASTNode)lambda, (ASTNode)replacement, null);
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_method_reference;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
        if (importRewrite != null) {
            proposal.setImportRewrite(importRewrite);
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression getSingleExpressionFromLambdaBody(Block lambdaBody) {
        Expression expression;
        if (lambdaBody.statements().size() != 1) {
            return null;
        }
        Statement singleStatement = (Statement)lambdaBody.statements().get(0);
        if (singleStatement instanceof ReturnStatement) {
            return ((ReturnStatement)singleStatement).getExpression();
        }
        if (singleStatement instanceof ExpressionStatement && QuickAssistProcessor.isValidLambdaExpressionBody(expression = ((ExpressionStatement)singleStatement).getExpression())) {
            return expression;
        }
        return null;
    }

    private static boolean isValidLambdaExpressionBody(Expression expression) {
        PrefixExpression.Operator operator;
        if (expression instanceof Assignment || expression instanceof ClassInstanceCreation || expression instanceof MethodInvocation || expression instanceof PostfixExpression || expression instanceof SuperMethodInvocation) {
            return true;
        }
        return expression instanceof PrefixExpression && ((operator = ((PrefixExpression)expression).getOperator()) == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT);
    }

    private static boolean isValidLambdaReferenceToMethod(Expression expression) {
        return expression instanceof ClassInstanceCreation || expression instanceof ArrayCreation || expression instanceof SuperMethodInvocation || expression instanceof MethodInvocation;
    }

    private static boolean matches(List<Expression> expected, List<Expression> toMatch) {
        if (toMatch.size() != expected.size()) {
            return false;
        }
        int i = 0;
        while (i < toMatch.size()) {
            if (!JdtASTMatcher.doNodesMatch((ASTNode)((ASTNode)expected.get(i)), (ASTNode)((ASTNode)toMatch.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean representsDefiningNode(ASTNode innerNode, ASTNode definingNode) {
        if (innerNode == definingNode) {
            return true;
        }
        switch (definingNode.getNodeType()) {
            case 14: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ClassInstanceCreation)definingNode).getType());
            }
            case 3: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ArrayCreation)definingNode).getType());
            }
            case 48: {
                return innerNode == ((SuperMethodInvocation)definingNode).getName();
            }
            case 32: {
                return innerNode == ((MethodInvocation)definingNode).getName();
            }
            case 88: {
                return innerNode == ((NameQualifiedType)definingNode).getName();
            }
            case 75: {
                return innerNode == ((QualifiedType)definingNode).getName();
            }
            case 43: {
                return innerNode == ((SimpleType)definingNode).getName();
            }
            case 5: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ArrayType)definingNode).getElementType());
            }
            case 74: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ParameterizedType)definingNode).getType());
            }
        }
        return false;
    }

    private static boolean isNestedInterfaceClass(AST ast, ITypeBinding lambdaMethodDeclaringClass, ITypeBinding lambdaMethodInvokingClass) {
        ITypeBinding[] methodNarrowingTypes = ASTResolving.getRelaxingTypes((AST)ast, (ITypeBinding)lambdaMethodDeclaringClass);
        ITypeBinding[] lambdaNarrowingTypes = ASTResolving.getRelaxingTypes((AST)ast, (ITypeBinding)lambdaMethodInvokingClass);
        if (methodNarrowingTypes.length != 1) {
            return false;
        }
        ITypeBinding methodNarrowingType = methodNarrowingTypes[0];
        ITypeBinding[] iTypeBindingArray = lambdaNarrowingTypes;
        int n = lambdaNarrowingTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding lambdaNarrowingType = iTypeBindingArray[n2];
            if (methodNarrowingType == lambdaNarrowingType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isNestedClass(ITypeBinding methodDeclarationType, ITypeBinding lambdaDeclarationType) {
        ITypeBinding parent = lambdaDeclarationType;
        while (parent.isNested()) {
            if ((parent = parent.getDeclaringClass()) != methodDeclarationType) continue;
            return true;
        }
        return false;
    }

    private static ITypeBinding getNestedRootClass(ITypeBinding lambdaDeclarationType) {
        ITypeBinding parent = lambdaDeclarationType;
        while (parent.isNested()) {
            parent = parent.getDeclaringClass();
        }
        return parent;
    }

    private static boolean isSuperClass(ITypeBinding methodDeclarationType, ITypeBinding lambdaDeclarationType) {
        ITypeBinding parent = lambdaDeclarationType.getSuperclass();
        while (parent != null) {
            if (parent == methodDeclarationType) {
                return true;
            }
            parent = parent.getSuperclass();
        }
        return false;
    }
}

