/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.internal.gradle.checksums;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class HashProvider {
    public static final String SHA256 = "SHA-256";
    private String alghorithm;

    public HashProvider() {
        this(SHA256);
    }

    public HashProvider(String alghorithm) {
        this.alghorithm = alghorithm;
    }

    public String getChecksum(File file) throws IOException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(this.alghorithm);
        }
        catch (NoSuchAlgorithmException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
        Throwable e = null;
        Object var4_6 = null;
        try (DigestInputStream dis = new DigestInputStream(new FileInputStream(file), messageDigest);){
            byte[] bytes = new byte[32768];
            while (dis.read(bytes) != -1) {
            }
            messageDigest = dis.getMessageDigest();
        }
        catch (Throwable throwable) {
            if (e == null) {
                e = throwable;
            } else if (e != throwable) {
                e.addSuppressed(throwable);
            }
            throw e;
        }
        StringBuilder result = new StringBuilder();
        byte[] byArray = messageDigest.digest();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            result.append(String.format("%02x", b));
            ++n2;
        }
        return result.toString();
    }
}

