/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class BuildPathCommand {
    public static final String UNSUPPORTED_ON_MAVEN = "Unsupported operation. Please use pom.xml file to manage the source directories of maven project.";
    public static final String UNSUPPORTED_ON_GRADLE = "Unsupported operation. Please use build.gradle file to manage the source directories of gradle project.";

    public static Result addToSourcePath(String sourceFolderUri) {
        IPath sourceFolderPath = ResourceUtils.filePathFromURI(sourceFolderUri);
        IProject targetProject = BuildPathCommand.findBelongedProject(sourceFolderPath);
        if (targetProject != null && !ProjectUtils.isGeneralJavaProject(targetProject)) {
            String message = ProjectUtils.isGradleProject(targetProject) ? UNSUPPORTED_ON_GRADLE : UNSUPPORTED_ON_MAVEN;
            return new Result(false, message);
        }
        IPath projectLocation = null;
        IProject projectRootResource = null;
        IPath[] exclusionPath = new IPath[]{};
        if (targetProject == null) {
            try {
                IPath workspaceRoot = ProjectUtils.findBelongedWorkspaceRoot(sourceFolderPath);
                if (workspaceRoot == null) {
                    return new Result(false, Messages.format("The folder ''{0}'' doesn''t belong to any workspace.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
                }
                targetProject = ProjectUtils.createInvisibleProjectIfNotExist(workspaceRoot);
                IFolder workspaceLink = targetProject.getFolder("_");
                projectLocation = workspaceRoot;
                projectRootResource = workspaceLink;
                List<IProject> subProjects = ProjectUtils.getVisibleProjects(workspaceRoot);
                exclusionPath = (IPath[])subProjects.stream().map(project -> {
                    IPath relativePath = project.getLocation().makeRelativeTo(workspaceRoot);
                    return workspaceLink.getFolder(relativePath).getFullPath();
                }).toArray(IPath[]::new);
            }
            catch (CoreException | OperationCanceledException e) {
                JavaLanguageServerPlugin.logException("Failed to create the invisible project.", e);
                return new Result(false, "Failed to add the folder to the workspace invisible project's source path. Reason: " + e.getMessage());
            }
        } else {
            projectLocation = targetProject.getLocation();
            projectRootResource = targetProject;
        }
        IPath relativeSourcePath = sourceFolderPath.makeRelativeTo(projectLocation);
        IPath sourcePath = relativeSourcePath.isEmpty() ? projectRootResource.getFullPath() : projectRootResource.getFolder(relativeSourcePath).getFullPath();
        IJavaProject javaProject = JavaCore.create((IProject)targetProject);
        try {
            if (ProjectUtils.addSourcePath(sourcePath, exclusionPath, javaProject)) {
                return new Result(true, Messages.format("Successfully added ''{0}'' to the project {1}''s source path.", new String[]{BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString(), targetProject.getName()}));
            }
            return new Result(true, Messages.format("No need to add it to source path again, because the folder ''{0}'' is already in the project {1}''s source path.", new String[]{BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString(), targetProject.getName()}));
        }
        catch (CoreException e) {
            return new Result(false, e.getMessage());
        }
    }

    public static Result removeFromSourcePath(String sourceFolderUri) {
        IPath sourceFolderPath = ResourceUtils.filePathFromURI(sourceFolderUri);
        IProject targetProject = BuildPathCommand.findBelongedProject(sourceFolderPath);
        if (targetProject != null && !ProjectUtils.isGeneralJavaProject(targetProject)) {
            String message = ProjectUtils.isGradleProject(targetProject) ? UNSUPPORTED_ON_GRADLE : UNSUPPORTED_ON_MAVEN;
            return new Result(false, message);
        }
        IPath projectLocation = null;
        IProject projectRootResource = null;
        if (targetProject == null) {
            IPath workspaceRoot = ProjectUtils.findBelongedWorkspaceRoot(sourceFolderPath);
            if (workspaceRoot == null) {
                return new Result(false, Messages.format("The folder ''{0}'' doesn''t belong to any workspace.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
            }
            String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(workspaceRoot);
            targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
            if (!targetProject.exists()) {
                return new Result(true, Messages.format("No need to remove it from source path, because the folder ''{0}'' isn''t on any project''s source path.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
            }
            projectLocation = workspaceRoot;
            projectRootResource = targetProject.getFolder("_");
        } else {
            projectLocation = targetProject.getLocation();
            projectRootResource = targetProject;
        }
        IPath relativeSourcePath = sourceFolderPath.makeRelativeTo(projectLocation);
        IPath sourcePath = relativeSourcePath.isEmpty() ? projectRootResource.getFullPath() : projectRootResource.getFolder(relativeSourcePath).getFullPath();
        IJavaProject javaProject = JavaCore.create((IProject)targetProject);
        try {
            if (ProjectUtils.removeSourcePath(sourcePath, javaProject)) {
                return new Result(true, Messages.format("Successfully removed ''{0}'' from the project {1}''s source path.", new String[]{BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString(), targetProject.getName()}));
            }
            return new Result(true, Messages.format("No need to remove it from source path, because the folder ''{0}'' isn''t on any project''s source path.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
        }
        catch (CoreException e) {
            return new Result(false, e.getMessage());
        }
    }

    public static Result listSourcePaths() {
        IProject[] projects;
        ArrayList<SourcePath> sourcePathList = new ArrayList<SourcePath>();
        IProject[] iProjectArray = projects = ProjectUtils.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IProject project = iProjectArray[n2];
                if ("jdt.ls-java-project".equals(project.getName()) || !ProjectUtils.isJavaProject(project)) break block9;
                try {
                    IPath[] paths;
                    IPath[] iPathArray = paths = ProjectUtils.listSourcePaths(JavaCore.create((IProject)project));
                    int n3 = paths.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block11: {
                            IProject projectRoot;
                            String projectType;
                            String projectName;
                            IPath entryPath;
                            block10: {
                                IPath path;
                                entryPath = path = iPathArray[n4];
                                projectName = project.getName();
                                projectType = "General";
                                if (ProjectUtils.isMavenProject(project)) {
                                    projectType = "Maven";
                                }
                                if (ProjectUtils.isGradleProject(project)) {
                                    projectType = "Gradle";
                                }
                                projectRoot = project;
                                if (ProjectUtils.isVisibleProject(project)) break block10;
                                projectType = "Workspace";
                                IFolder workspaceLinkFolder = project.getFolder("_");
                                if (!workspaceLinkFolder.isLinked()) break block11;
                                projectRoot = workspaceLinkFolder;
                            }
                            IPath relativePath = entryPath.makeRelativeTo(projectRoot.getFullPath());
                            IPath location = projectRoot.getRawLocation().append(relativePath);
                            IPath displayPath = BuildPathCommand.getWorkspacePath(location);
                            sourcePathList.add(new SourcePath(location != null ? location.toOSString() : "", displayPath != null ? displayPath.toOSString() : entryPath.toOSString(), entryPath.toOSString(), projectName, projectType));
                        }
                        ++n4;
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException("Failed to resolve the existing source paths in current workspace.", e);
                    return new ListCommandResult(false, e.getMessage());
                }
            }
            ++n2;
        }
        return new ListCommandResult(true, null, sourcePathList.toArray(new SourcePath[0]));
    }

    private static IProject findBelongedProject(IPath sourceFolder) {
        List projects = Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isJavaProject).sorted(new Comparator<IProject>(){

            @Override
            public int compare(IProject p1, IProject p2) {
                return p2.getLocation().toOSString().length() - p1.getLocation().toOSString().length();
            }
        }).collect(Collectors.toList());
        for (IProject project : projects) {
            if (!project.getLocation().isPrefixOf(sourceFolder)) continue;
            return project;
        }
        return null;
    }

    private static IPath getWorkspacePath(IPath path) {
        PreferenceManager manager = JavaLanguageServerPlugin.getPreferencesManager();
        Collection<IPath> rootPaths = manager.getPreferences().getRootPaths();
        if (rootPaths != null) {
            for (IPath rootPath : rootPaths) {
                if (!rootPath.isPrefixOf(path)) continue;
                return path.makeRelativeTo(rootPath.append(".."));
            }
        }
        return path;
    }

    public static class ListCommandResult
    extends Result {
        public SourcePath[] data;

        ListCommandResult(boolean status, String message) {
            super(status, message);
            this.data = new SourcePath[0];
        }

        ListCommandResult(boolean status, String message, SourcePath[] data) {
            super(status, message);
            this.data = data;
        }
    }

    public static class Result {
        public boolean status;
        public String message;

        Result(boolean status, String message) {
            this.status = status;
            this.message = message;
        }
    }

    public static class SourcePath {
        public String path;
        public String displayPath;
        public String classpathEntry;
        public String projectName;
        public String projectType;

        SourcePath(String path, String displayPath, String classpathEntry, String projectName, String projectType) {
            this.path = path;
            this.displayPath = displayPath;
            this.classpathEntry = classpathEntry;
            this.projectName = projectName;
            this.projectType = projectType;
        }
    }
}

