/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.event.Event;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.WorkbenchShutdownEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.GradlePreferenceChangeListener;
import org.eclipse.jdt.ls.core.internal.managers.GradleProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.JavaApplicationLaunchConfiguration;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class GradleBuildSupport
implements IBuildSupport {
    public static final String GRADLE_SUFFIX = ".gradle";
    public static final String GRADLE_PROPERTIES = "gradle.properties";
    public static final List<String> WATCH_FILE_PATTERNS = Arrays.asList("**/*.gradle", "**/gradle.properties");
    private static IPreferencesChangeListener listener = new GradlePreferenceChangeListener();

    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isGradleProject(project);
    }

    @Override
    public void update(IProject project, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        JavaLanguageServerPlugin.logInfo("Starting Gradle update for " + project.getName());
        Optional build = GradleCore.getWorkspace().getBuild(project);
        if (build.isPresent()) {
            boolean shouldUpdate;
            GradleBuild gradleBuild = (GradleBuild)build.get();
            boolean isRoot = this.isRoot(project, gradleBuild, monitor);
            if (force && isRoot) {
                String projectPath = project.getLocation().toFile().getAbsolutePath();
                BuildConfiguration buildConfiguration = GradleProjectImporter.getBuildConfiguration(Paths.get(projectPath, new String[0]));
                gradleBuild = GradleCore.getWorkspace().createBuild(buildConfiguration);
            }
            File buildFile = project.getFile("build.gradle").getLocation().toFile();
            File settingsFile = project.getFile("settings.gradle").getLocation().toFile();
            boolean bl = shouldUpdate = buildFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(buildFile.toPath()) || settingsFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsFile.toPath());
            if (isRoot || shouldUpdate) {
                gradleBuild.synchronize(monitor);
            }
        }
    }

    private boolean isRoot(IProject project, GradleBuild gradleBuild, IProgressMonitor monitor) {
        if (gradleBuild instanceof InternalGradleBuild) {
            CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
            Collection eclipseProjects = ((InternalGradleBuild)gradleBuild).getModelProvider().fetchModels(EclipseProject.class, FetchStrategy.LOAD_IF_NOT_CACHED, tokenSource, monitor);
            File projectDirectory = project.getLocation().toFile();
            for (EclipseProject eclipseProject : eclipseProjects) {
                File eclipseProjectDirectory = eclipseProject.getProjectDirectory();
                if (!eclipseProjectDirectory.equals(projectDirectory)) continue;
                return eclipseProject.getParent() == null;
            }
        }
        return false;
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        if (resource != null && resource.getType() == 1 && (resource.getName().endsWith(GRADLE_SUFFIX) || resource.getName().equals(GRADLE_PROPERTIES)) && ProjectUtils.isGradleProject(resource.getProject())) {
            block4: {
                if (ProjectUtils.isJavaProject(resource.getProject())) break block4;
                return true;
            }
            try {
                IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
                IPath outputLocation = javaProject.getOutputLocation();
                return outputLocation == null || !outputLocation.isPrefixOf(resource.getFullPath());
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return false;
    }

    @Override
    public boolean isBuildLikeFileName(String fileName) {
        return fileName.endsWith(GRADLE_SUFFIX) || fileName.equals(GRADLE_PROPERTIES);
    }

    public static void cleanGradleModels(IProgressMonitor monitor) {
        File projectPreferences = CorePlugin.getInstance().getStateLocation().append("project-preferences").toFile();
        if (projectPreferences.isDirectory()) {
            File[] projectFiles;
            File[] fileArray = projectFiles = projectPreferences.listFiles();
            int n = projectFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File projectFile = fileArray[n2];
                String projectName = projectFile.getName();
                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
                    FileUtils.deleteRecursively((File)projectFile);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        return IBuildSupport.super.fileChanged(resource, changeType, monitor) || this.isBuildFile(resource);
    }

    public static void saveModels() {
        CorePlugin.listenerRegistry().dispatch((Event)new WorkbenchShutdownEvent());
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(IJavaProject javaProject, String scope) throws CoreException {
        return new JavaApplicationLaunchConfiguration(javaProject.getProject(), scope, "org.eclipse.buildship.core.classpathprovider");
    }

    @Override
    public List<String> getWatchPatterns() {
        return WATCH_FILE_PATTERNS;
    }

    @Override
    public void registerPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.addPreferencesChangeListener(listener);
    }

    @Override
    public void unregisterPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.removePreferencesChangeListener(listener);
    }
}

