"use strict";
// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GettingStartedContribution = exports.GettingStartedCommand = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const getting_started_widget_1 = require("./getting-started-widget");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const browser_2 = require("@theia/workspace/lib/browser");
/**
 * Triggers opening the `GettingStartedWidget`.
 */
exports.GettingStartedCommand = {
    id: getting_started_widget_1.GettingStartedWidget.ID,
    label: getting_started_widget_1.GettingStartedWidget.LABEL
};
let GettingStartedContribution = class GettingStartedContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: getting_started_widget_1.GettingStartedWidget.ID,
            widgetName: getting_started_widget_1.GettingStartedWidget.LABEL,
            defaultWidgetOptions: {
                area: 'main',
            }
        });
    }
    async onStart(app) {
        if (!this.workspaceService.opened) {
            this.stateService.reachedState('ready').then(() => this.openView({ reveal: true, activate: true }));
        }
    }
    registerCommands(registry) {
        registry.registerCommand(exports.GettingStartedCommand, {
            execute: () => this.openView({ reveal: true, activate: true }),
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(browser_1.CommonMenus.HELP, {
            commandId: exports.GettingStartedCommand.id,
            label: exports.GettingStartedCommand.label,
            order: 'a10'
        });
    }
};
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], GettingStartedContribution.prototype, "stateService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    __metadata("design:type", browser_2.WorkspaceService)
], GettingStartedContribution.prototype, "workspaceService", void 0);
GettingStartedContribution = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], GettingStartedContribution);
exports.GettingStartedContribution = GettingStartedContribution;
//# sourceMappingURL=getting-started-contribution.js.map