"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.SequenceFromIntArray = exports.OffsetRange = exports.SequenceDiff = void 0;
class SequenceDiff {
    constructor(seq1Range, seq2Range) {
        this.seq1Range = seq1Range;
        this.seq2Range = seq2Range;
    }
}
exports.SequenceDiff = SequenceDiff;
/**
 * Todo move this class to some top level utils.
*/
class OffsetRange {
    constructor(start, endExclusive) {
        this.start = start;
        this.endExclusive = endExclusive;
    }
    get isEmpty() {
        return this.start === this.endExclusive;
    }
    delta(offset) {
        return new OffsetRange(this.start + offset, this.endExclusive + offset);
    }
    get length() {
        return this.endExclusive - this.start;
    }
}
exports.OffsetRange = OffsetRange;
class SequenceFromIntArray {
    constructor(arr) {
        this.arr = arr;
    }
    getElement(offset) {
        return this.arr[offset];
    }
    get length() {
        return this.arr.length;
    }
}
exports.SequenceFromIntArray = SequenceFromIntArray;
//# sourceMappingURL=diffAlgorithm.js.map