/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFixCore;
import org.eclipse.jdt.internal.corext.fix.ICleanUpCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LambdaExpressionsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.LambdaExpressionsCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InvertBooleanUtility;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteRemoveImportsCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.TypeChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactorProposalUtility;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactoringCorrectionCommandProposal;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RefactorProcessor {
    public static final String CONVERT_ANONYMOUS_CLASS_TO_NESTED_COMMAND = "convertAnonymousClassToNestedCommand";
    private PreferenceManager preferenceManager;

    public RefactorProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<ChangeCorrectionProposal> getProposals(CodeActionParams params, IInvocationContext context, IProblemLocationCore[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ChangeCorrectionProposal> proposals = new ArrayList<ChangeCorrectionProposal>();
            InvertBooleanUtility.getInverseConditionProposals(params, context, coveringNode, proposals);
            this.getInverseLocalVariableProposals(params, context, coveringNode, proposals);
            this.getMoveRefactoringProposals(params, context, coveringNode, proposals);
            boolean noErrorsAtLocation = RefactorProcessor.noErrorsAtLocation(locations, coveringNode);
            if (noErrorsAtLocation) {
                boolean problemsAtLocation = locations.length != 0;
                this.getExtractVariableProposal(params, context, problemsAtLocation, proposals);
                this.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, proposals);
                this.getExtractFieldProposal(params, context, problemsAtLocation, proposals);
                this.getInlineProposal(context, coveringNode, proposals);
                this.getConvertAnonymousToNestedProposals(params, context, coveringNode, proposals);
                RefactorProcessor.getConvertAnonymousClassCreationsToLambdaProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertLambdaToAnonymousClassCreationsProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertVarTypeToResolvedTypeProposal(context, coveringNode, proposals);
                RefactorProcessor.getConvertResolvedTypeToVarTypeProposal(context, coveringNode, proposals);
                RefactorProcessor.getAddStaticImportProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertForLoopProposal(context, coveringNode, proposals);
                this.getAssignToVariableProposals(context, coveringNode, locations, proposals, params);
                this.getIntroduceParameterProposals(params, context, coveringNode, locations, proposals);
                this.getExtractInterfaceProposal(params, context, proposals);
                this.getChangeSignatureProposal(params, context, proposals);
            }
            return proposals;
        }
        return Collections.emptyList();
    }

    private boolean getIntroduceParameterProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, IProblemLocationCore[] locations, ArrayList<ChangeCorrectionProposal> resultingCollections) throws CoreException {
        if (resultingCollections == null) {
            return false;
        }
        CUCorrectionProposal proposal = RefactorProposalUtility.getIntroduceParameterRefactoringProposals(params, context, coveringNode, this.preferenceManager.getClientPreferences().isAdvancedIntroduceParameterRefactoringSupported(), locations);
        if (proposal != null) {
            return resultingCollections.add(proposal);
        }
        return false;
    }

    private boolean getInverseLocalVariableProposals(CodeActionParams params, IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> proposals) {
        if (proposals == null) {
            return false;
        }
        ChangeCorrectionProposal proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? InvertBooleanUtility.getInvertVariableProposal(params, context, covering, true) : InvertBooleanUtility.getInvertVariableProposal(params, context, covering, false);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getMoveRefactoringProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, ArrayList<ChangeCorrectionProposal> resultingCollections) {
        List<CUCorrectionProposal> newProposals;
        if (resultingCollections == null) {
            return false;
        }
        if (this.preferenceManager.getClientPreferences().isMoveRefactoringSupported() && (newProposals = RefactorProposalUtility.getMoveRefactoringProposals(params, context)) != null && !newProposals.isEmpty()) {
            resultingCollections.addAll(newProposals);
            return true;
        }
        return false;
    }

    static boolean noErrorsAtLocation(IProblemLocationCore[] locations, ASTNode coveringNode) {
        if (locations != null) {
            int start = coveringNode.getStartPosition();
            int length = coveringNode.getLength();
            int i = 0;
            while (i < locations.length) {
                IProblemLocationCore location = locations[i];
                if (location.getOffset() <= start + length && location.getOffset() + location.getLength() >= start && location.isError() && (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)location.getProblemId()) == null)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        List<CUCorrectionProposal> newProposals = null;
        newProposals = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProposalUtility.getExtractVariableCommandProposals(params, context, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractVariableInferSelectionSupported()) : RefactorProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractVariableInferSelectionSupported());
        if (newProposals == null || newProposals.isEmpty()) {
            return false;
        }
        proposals.addAll(newProposals);
        return true;
    }

    private boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, IProblemLocationCore[] locations, Collection<ChangeCorrectionProposal> resultingCollections, CodeActionParams params) {
        try {
            Map formatterOptions = null;
            CUCorrectionProposal proposal = RefactorProposalUtility.getAssignVariableProposal(params, context, locations != null && locations.length != 0, formatterOptions, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), locations);
            if (proposal != null) {
                resultingCollections.add(proposal);
            }
            if ((proposal = RefactorProposalUtility.getAssignFieldProposal(params, context, locations != null && locations.length != 0, formatterOptions, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), locations)) != null) {
                resultingCollections.add(proposal);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e);
        }
        return true;
    }

    private boolean getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        CUCorrectionProposal proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProposalUtility.getExtractMethodCommandProposal(params, context, coveringNode, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractMethodInferSelectionSupported()) : RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractMethodInferSelectionSupported());
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        CUCorrectionProposal proposal = RefactorProposalUtility.getGenericExtractFieldProposal(params, context, problemsAtLocation, null, null, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), this.preferenceManager.getClientPreferences().isExtractFieldInferSelectionSupported());
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean getInlineProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        block17: {
            IBinding binding;
            block13: {
                boolean status;
                void localVar;
                ASTNode decl;
                block16: {
                    void varBinding;
                    block15: {
                        InlineConstantRefactoring refactoring;
                        block14: {
                            if (resultingCollections == null) {
                                return false;
                            }
                            if (!(node instanceof SimpleName)) {
                                return false;
                            }
                            SimpleName name = (SimpleName)node;
                            binding = name.resolveBinding();
                            IBinding iBinding = binding;
                            if (!(iBinding instanceof IVariableBinding)) break block13;
                            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                            IVariableBinding cfr_ignored_0 = (IVariableBinding)iBinding;
                            if (!varBinding.isParameter()) break block14;
                            return false;
                        }
                        if (!varBinding.isField()) break block15;
                        if (RefactoringAvailabilityTesterCore.isInlineConstantAvailable((IField)((IField)varBinding.getJavaElement())) && (refactoring = new InlineConstantRefactoring(context.getCompilationUnit(), context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength())) != null && refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK() && refactoring.getReferences((IProgressMonitor)new NullProgressMonitor(), new RefactoringStatus()).length > 0) {
                            refactoring.setRemoveDeclaration(refactoring.isDeclarationSelected());
                            refactoring.setReplaceAllReferences(refactoring.isDeclarationSelected());
                            CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 4);
                            CreateChangeOperation create = new CreateChangeOperation(check, 4);
                            create.run((IProgressMonitor)new NullProgressMonitor());
                            String label = ActionMessages.InlineConstantRefactoringAction_label;
                            int relevance = 5;
                            ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label, "refactor.inline", create.getChange(), relevance);
                            resultingCollections.add(proposal);
                            return true;
                        }
                        return false;
                    }
                    decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
                    if (decl instanceof VariableDeclarationFragment && decl.getLocationInParent() == VariableDeclarationStatement.FRAGMENTS_PROPERTY) break block16;
                    return false;
                }
                IJavaElement label = binding.getJavaElement();
                if (!(label instanceof ILocalVariable)) break block17;
                ILocalVariable check = (ILocalVariable)label;
                ILocalVariable cfr_ignored_1 = (ILocalVariable)label;
                if (!RefactoringAvailabilityTesterCore.isInlineTempAvailable((ILocalVariable)localVar)) break block17;
                InlineTempRefactoring refactoring = new InlineTempRefactoring((VariableDeclaration)decl);
                try {
                    status = refactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor()).isOK();
                }
                catch (Exception e) {
                    status = false;
                }
                if (status && refactoring.getReferences().length > 0) {
                    String label2 = CorrectionMessages.QuickAssistProcessor_inline_local_description;
                    int relevance = 5;
                    RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label2, "refactor.inline", context.getCompilationUnit(), (Refactoring)refactoring, relevance);
                    resultingCollections.add(proposal);
                    return true;
                }
            }
            try {
                InlineMethodRefactoring refactoring;
                if (binding instanceof IMethodBinding && RefactoringAvailabilityTesterCore.isInlineMethodAvailable((IMethod)((IMethod)binding.getJavaElement())) && (refactoring = InlineMethodRefactoring.create((ITypeRoot)context.getCompilationUnit(), (CompilationUnit)context.getASTRoot(), (int)context.getSelectionOffset(), (int)context.getSelectionLength())) != null && refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 4);
                    CreateChangeOperation create = new CreateChangeOperation(check, 4);
                    create.run((IProgressMonitor)new NullProgressMonitor());
                    String label = ActionMessages.InlineMethodRefactoringAction_label;
                    int relevance = 5;
                    ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label, "refactor.inline", create.getChange(), relevance);
                    resultingCollections.add(proposal);
                    return true;
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
            }
        }
        return false;
    }

    private boolean getConvertAnonymousToNestedProposals(CodeActionParams params, IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        RefactoringCorrectionProposal proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProcessor.getConvertAnonymousToNestedProposal(params, context, node, true) : RefactorProcessor.getConvertAnonymousToNestedProposal(params, context, node, false);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    public static RefactoringCorrectionProposal getConvertAnonymousToNestedProposal(CodeActionParams params, IInvocationContext context, ASTNode node, boolean returnAsCommand) throws CoreException {
        String label = CorrectionMessages.QuickAssistProcessor_convert_anonym_to_nested;
        ClassInstanceCreation cic = RefactorProcessor.getClassInstanceCreation(node);
        if (cic == null) {
            return null;
        }
        AnonymousClassDeclaration anonymTypeDecl = cic.getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return null;
        }
        ConvertAnonymousToNestedRefactoring refactoring = new ConvertAnonymousToNestedRefactoring(anonymTypeDecl);
        if (!refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            return null;
        }
        if (returnAsCommand) {
            return new RefactoringCorrectionCommandProposal(label, "refactor", context.getCompilationUnit(), 5, "java.action.applyRefactoringCommand", Arrays.asList(CONVERT_ANONYMOUS_CLASS_TO_NESTED_COMMAND, params));
        }
        String extTypeName = ASTNodes.getTypeName((Type)cic.getType());
        ITypeBinding anonymTypeBinding = anonymTypeDecl.resolveBinding();
        String className = anonymTypeBinding.getInterfaces().length == 0 ? Messages.format((String)CorrectionMessages.QuickAssistProcessor_name_extension_from_interface, (Object)extTypeName) : Messages.format((String)CorrectionMessages.QuickAssistProcessor_name_extension_from_class, (Object)extTypeName);
        String[][] existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(className);
        int i = 1;
        while (existingTypes != null) {
            existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(className + ++i);
        }
        refactoring.setClassName((String)(i == 1 ? className : className + i));
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        refactoring.setLinkedProposalModel(linkedProposalModel);
        ICompilationUnit cu = context.getCompilationUnit();
        RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor", cu, (Refactoring)refactoring, 5);
        proposal.setLinkedProposalModel(linkedProposalModel);
        return proposal;
    }

    /*
     * WARNING - void declaration
     */
    private static ClassInstanceCreation getClassInstanceCreation(ASTNode node) {
        while (node instanceof Name || node instanceof Type || node instanceof Dimension || node.getParent() instanceof MethodDeclaration || node.getLocationInParent() == AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY) {
            node = node.getParent();
        }
        ASTNode aSTNode = node;
        if (aSTNode instanceof ClassInstanceCreation) {
            void classInstanceCreation;
            ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode;
            ClassInstanceCreation cfr_ignored_0 = (ClassInstanceCreation)aSTNode;
            return classInstanceCreation;
        }
        if (node.getLocationInParent() == ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY) {
            return (ClassInstanceCreation)node.getParent();
        }
        return null;
    }

    private static boolean getConvertAnonymousClassCreationsToLambdaProposals(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) {
        ClassInstanceCreation cic = RefactorProcessor.getClassInstanceCreation(covering);
        if (cic == null) {
            return false;
        }
        LambdaExpressionsFixCore fix = LambdaExpressionsFixCore.createConvertToLambdaFix((ClassInstanceCreation)cic);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_lambda", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal((IProposableFix)fix, (ICleanUpCore)new LambdaExpressionsCleanUpCore(options), 6, context, "refactor");
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getConvertLambdaToAnonymousClassCreationsProposals(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) {
        LambdaExpression lambda;
        if (resultingCollections == null) {
            return true;
        }
        ASTNode aSTNode = covering;
        if (aSTNode instanceof LambdaExpression) {
            void lambdaExpression;
            LambdaExpression lambdaExpression2 = (LambdaExpression)aSTNode;
            LambdaExpression cfr_ignored_0 = (LambdaExpression)aSTNode;
            lambda = lambdaExpression;
        } else if (covering.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent();
        } else {
            return false;
        }
        IProposableFix fix = LambdaExpressionsFixCore.createConvertToAnonymousClassCreationsFix((LambdaExpression)lambda);
        if (fix == null) {
            return false;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_anonymous_class_creation", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, (ICleanUpCore)new LambdaExpressionsCleanUpCore(options), 2, context, "refactor");
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getConvertVarTypeToResolvedTypeProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        IJavaElement root = astRoot.getJavaElement();
        if (root == null) {
            return false;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        if (!JavaModelUtil.is10OrHigher((IJavaProject)javaProject)) {
            return false;
        }
        SimpleName name = RefactorProcessor.getSimpleNameForVariable(node);
        if (name == null) {
            return false;
        }
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode varDeclaration = astRoot.findDeclaringNode((IBinding)varBinding);
        if (varDeclaration == null) {
            return false;
        }
        ITypeBinding typeBinding = varBinding.getType();
        if (typeBinding == null || typeBinding.isAnonymous() || typeBinding.isIntersectionType() || typeBinding.isWildcardType()) {
            return false;
        }
        Type type = null;
        ASTNode aSTNode = varDeclaration;
        if (aSTNode instanceof SingleVariableDeclaration) {
            void singleVar;
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)aSTNode;
            SingleVariableDeclaration cfr_ignored_0 = (SingleVariableDeclaration)aSTNode;
            type = singleVar.getType();
        } else if (varDeclaration instanceof VariableDeclarationFragment) {
            ASTNode parent = varDeclaration.getParent();
            ASTNode aSTNode2 = parent;
            if (aSTNode2 instanceof VariableDeclarationStatement) {
                void variableDeclStatement;
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode2;
                VariableDeclarationStatement cfr_ignored_1 = (VariableDeclarationStatement)aSTNode2;
                type = variableDeclStatement.getType();
            } else {
                ASTNode aSTNode3 = parent;
                if (aSTNode3 instanceof VariableDeclarationExpression) {
                    void variableDeclExpression;
                    VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)aSTNode3;
                    VariableDeclarationExpression cfr_ignored_2 = (VariableDeclarationExpression)aSTNode3;
                    type = variableDeclExpression.getType();
                }
            }
        }
        if (type == null || !type.isVar()) {
            return false;
        }
        TypeChangeCorrectionProposal proposal = new TypeChangeCorrectionProposal(context.getCompilationUnit(), (IBinding)varBinding, astRoot, typeBinding, false, 8);
        proposal.setKind("refactor");
        proposals.add(proposal);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static SimpleName getSimpleNameForVariable(ASTNode node) {
        if (!(node instanceof SimpleName)) {
            return null;
        }
        SimpleName name = (SimpleName)node;
        if (!name.isDeclaration()) {
            while (node instanceof Name || node instanceof Type) {
                node = node.getParent();
            }
            ASTNode aSTNode = node;
            if (aSTNode instanceof VariableDeclarationStatement) {
                void variableDeclStatement;
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode;
                VariableDeclarationStatement cfr_ignored_0 = (VariableDeclarationStatement)aSTNode;
                List fragments = variableDeclStatement.fragments();
                if (fragments.size() > 0) {
                    name = ((VariableDeclarationFragment)fragments.get(0)).getName();
                }
            }
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getConvertResolvedTypeToVarTypeProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        IJavaElement root = astRoot.getJavaElement();
        if (root == null) {
            return false;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        if (!JavaModelUtil.is10OrHigher((IJavaProject)javaProject)) {
            return false;
        }
        SimpleName name = RefactorProcessor.getSimpleNameForVariable(node);
        if (name == null) {
            return false;
        }
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode varDeclaration = astRoot.findDeclaringNode((IBinding)varBinding);
        if (varDeclaration == null) {
            return false;
        }
        Type type = null;
        Expression expression = null;
        ITypeBinding typeBinding = varBinding.getType();
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding expressionTypeBinding = null;
        ASTNode aSTNode = varDeclaration;
        if (aSTNode instanceof SingleVariableDeclaration) {
            void svDecl;
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)aSTNode;
            SingleVariableDeclaration cfr_ignored_0 = (SingleVariableDeclaration)aSTNode;
            type = svDecl.getType();
            expression = svDecl.getInitializer();
            if (expression != null) {
                expressionTypeBinding = expression.resolveTypeBinding();
            } else {
                ASTNode parent = svDecl.getParent();
                ASTNode aSTNode2 = parent;
                if (aSTNode2 instanceof EnhancedForStatement) {
                    ITypeBinding expBinding;
                    void efStmt;
                    EnhancedForStatement enhancedForStatement = (EnhancedForStatement)aSTNode2;
                    EnhancedForStatement cfr_ignored_1 = (EnhancedForStatement)aSTNode2;
                    expression = efStmt.getExpression();
                    if (expression != null && (expBinding = expression.resolveTypeBinding()) != null) {
                        if (expBinding.isArray()) {
                            expressionTypeBinding = expBinding.getElementType();
                        } else {
                            ITypeBinding[] typeArguments;
                            ITypeBinding iterable = Bindings.findTypeInHierarchy((ITypeBinding)expBinding, (String)"java.lang.Iterable");
                            if (iterable != null && (typeArguments = iterable.getTypeArguments()).length == 1) {
                                expressionTypeBinding = typeArguments[0];
                                expressionTypeBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)expressionTypeBinding, (AST)context.getASTRoot().getAST());
                            }
                        }
                    }
                }
            }
        } else {
            ASTNode aSTNode3 = varDeclaration;
            if (aSTNode3 instanceof VariableDeclarationFragment) {
                ASTNode aSTNode4;
                void variableDeclarationFragment;
                VariableDeclarationFragment parent = (VariableDeclarationFragment)aSTNode3;
                VariableDeclarationFragment cfr_ignored_2 = (VariableDeclarationFragment)aSTNode3;
                ASTNode parent2 = varDeclaration.getParent();
                expression = variableDeclarationFragment.getInitializer();
                if (expression != null) {
                    expressionTypeBinding = expression.resolveTypeBinding();
                }
                if ((aSTNode4 = parent2) instanceof VariableDeclarationStatement) {
                    void variableDeclarationStatement;
                    VariableDeclarationStatement expBinding = (VariableDeclarationStatement)aSTNode4;
                    VariableDeclarationStatement cfr_ignored_3 = (VariableDeclarationStatement)aSTNode4;
                    type = variableDeclarationStatement.getType();
                } else {
                    ASTNode aSTNode5 = parent2;
                    if (aSTNode5 instanceof VariableDeclarationExpression) {
                        void varDecl;
                        VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)aSTNode5;
                        VariableDeclarationExpression cfr_ignored_4 = (VariableDeclarationExpression)aSTNode5;
                        if (varDecl.fragments().size() > 1) {
                            return false;
                        }
                        type = varDecl.getType();
                    }
                }
            }
        }
        if (type == null || type.isVar()) {
            return false;
        }
        if (expression == null || expression instanceof ArrayInitializer || expression instanceof LambdaExpression || expression instanceof MethodReference) {
            return false;
        }
        if (expressionTypeBinding == null || !expressionTypeBinding.isEqualTo((IBinding)typeBinding)) {
            return false;
        }
        TypeChangeCorrectionProposal proposal = new TypeChangeCorrectionProposal(context.getCompilationUnit(), (IBinding)varBinding, astRoot, typeBinding, 8);
        proposal.setKind("refactor");
        proposals.add(proposal);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getAddStaticImportProposals(IInvocationContext context, final ASTNode node, Collection<ChangeCorrectionProposal> proposals) {
        QualifiedName qn;
        MethodInvocation mi;
        ImportRemover removerAllOccurences;
        ImportRemover remover;
        ASTRewrite astRewriteReplaceAllOccurrences;
        ASTRewrite astRewrite;
        ImportRewrite importRewrite;
        boolean needImport;
        IMethodBinding binding;
        SimpleName name;
        block20: {
            ITypeBinding declaringClass;
            if (!(node instanceof SimpleName)) {
                return false;
            }
            name = (SimpleName)node;
            ASTNode aSTNode = name.getParent();
            if (aSTNode instanceof MethodInvocation) {
                void mi2;
                MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
                MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
                Expression expression = mi2.getExpression();
                if (expression == null || expression.equals((Object)name)) {
                    return false;
                }
                binding = mi2.resolveMethodBinding();
                if (binding == null) {
                    return false;
                }
                declaringClass = binding.getDeclaringClass();
            } else {
                ASTNode aSTNode2 = name.getParent();
                if (aSTNode2 instanceof QualifiedName) {
                    void qualifiedName;
                    QualifiedName expression = (QualifiedName)aSTNode2;
                    QualifiedName cfr_ignored_1 = (QualifiedName)aSTNode2;
                    if (name.equals((Object)qualifiedName.getQualifier()) || qualifiedName.getParent() instanceof ImportDeclaration) {
                        return false;
                    }
                    binding = qualifiedName.resolveBinding();
                    if (!(binding instanceof IVariableBinding)) {
                        return false;
                    }
                    declaringClass = ((IVariableBinding)binding).getDeclaringClass();
                } else {
                    return false;
                }
            }
            if (!Modifier.isStatic((int)binding.getModifiers())) {
                return false;
            }
            needImport = false;
            if (!RefactorProcessor.isDirectlyAccessible((ASTNode)name, declaringClass)) {
                if (Modifier.isPrivate((int)declaringClass.getModifiers())) {
                    return false;
                }
                needImport = true;
            }
            if (proposals == null) {
                return true;
            }
            importRewrite = StubUtility.createImportRewrite((ICompilationUnit)context.getCompilationUnit(), (boolean)true);
            astRewrite = ASTRewrite.create((AST)node.getAST());
            astRewriteReplaceAllOccurrences = ASTRewrite.create((AST)node.getAST());
            remover = new ImportRemover(context.getCompilationUnit().getJavaProject(), context.getASTRoot());
            removerAllOccurences = new ImportRemover(context.getCompilationUnit().getJavaProject(), context.getASTRoot());
            mi = null;
            qn = null;
            ASTNode aSTNode3 = name.getParent();
            if (aSTNode3 instanceof MethodInvocation) {
                void parentInvocation;
                MethodInvocation methodInvocation = (MethodInvocation)aSTNode3;
                MethodInvocation cfr_ignored_2 = (MethodInvocation)aSTNode3;
                mi = parentInvocation;
                astRewrite.remove((ASTNode)mi.getExpression(), null);
                remover.registerRemovedNode((ASTNode)mi.getExpression());
                removerAllOccurences.registerRemovedNode((ASTNode)mi.getExpression());
                mi.typeArguments().forEach(typeObject -> {
                    Type type = (Type)typeObject;
                    astRewrite.remove((ASTNode)type, null);
                    remover.registerRemovedNode((ASTNode)type);
                    removerAllOccurences.registerRemovedNode((ASTNode)type);
                });
                break block20;
            }
            ASTNode aSTNode4 = name.getParent();
            if (aSTNode4 instanceof QualifiedName) {
                void qname;
                QualifiedName qualifiedName = (QualifiedName)aSTNode4;
                QualifiedName cfr_ignored_3 = (QualifiedName)aSTNode4;
                qn = qname;
                astRewrite.replace(qn, (ASTNode)ASTNodeFactory.newName((AST)node.getAST(), (String)name.getFullyQualifiedName()), null);
                remover.registerRemovedNode(qn);
                removerAllOccurences.registerRemovedNode(qn);
                break block20;
            }
            return false;
        }
        try {
            final MethodInvocation miFinal = mi;
            name.getRoot().accept(new ASTVisitor(){

                /*
                 * WARNING - void declaration
                 */
                public boolean visit(MethodInvocation methodInvocation) {
                    Expression methodInvocationExpression = methodInvocation.getExpression();
                    if (methodInvocationExpression == null) {
                        return super.visit(methodInvocation);
                    }
                    Expression expression = methodInvocationExpression;
                    if (expression instanceof Name) {
                        Expression expression2;
                        void name;
                        Name name2 = (Name)expression;
                        Name cfr_ignored_0 = (Name)expression;
                        String fullyQualifiedName = name.getFullyQualifiedName();
                        if (miFinal != null && (expression2 = miFinal.getExpression()) instanceof Name) {
                            void exprName;
                            Name name3 = (Name)expression2;
                            Name cfr_ignored_1 = (Name)expression2;
                            if (exprName.getFullyQualifiedName().equals(fullyQualifiedName) && miFinal.getName().getIdentifier().equals(methodInvocation.getName().getIdentifier())) {
                                methodInvocation.typeArguments().forEach(type -> {
                                    astRewriteReplaceAllOccurrences.remove((ASTNode)((Type)type), null);
                                    removerAllOccurences.registerRemovedNode((ASTNode)((Type)type));
                                });
                                astRewriteReplaceAllOccurrences.remove((ASTNode)methodInvocationExpression, null);
                                removerAllOccurences.registerRemovedNode((ASTNode)methodInvocationExpression);
                            }
                        }
                    }
                    return super.visit(methodInvocation);
                }
            });
            final QualifiedName qnFinal = qn;
            name.getRoot().accept(new ASTVisitor(){

                public boolean visit(QualifiedName qualifiedName) {
                    if (qnFinal != null && qualifiedName.getFullyQualifiedName().equals(qnFinal.getFullyQualifiedName())) {
                        astRewriteReplaceAllOccurrences.replace((ASTNode)qualifiedName, (ASTNode)ASTNodeFactory.newName((AST)node.getAST(), (String)name.getFullyQualifiedName()), null);
                        removerAllOccurences.registerRemovedNode((ASTNode)qualifiedName);
                    }
                    return super.visit(qualifiedName);
                }
            });
            if (needImport) {
                importRewrite.addStaticImport((IBinding)binding);
            }
            ASTRewriteRemoveImportsCorrectionProposal proposal = new ASTRewriteRemoveImportsCorrectionProposal(CorrectionMessages.QuickAssistProcessor_convert_to_static_import, "refactor", context.getCompilationUnit(), astRewrite, 5);
            proposal.setImportRewrite(importRewrite);
            proposal.setImportRemover(remover);
            proposals.add(proposal);
            ASTRewriteRemoveImportsCorrectionProposal proposalReplaceAllOccurrences = new ASTRewriteRemoveImportsCorrectionProposal(CorrectionMessages.QuickAssistProcessor_convert_to_static_import_replace_all, "refactor", context.getCompilationUnit(), astRewriteReplaceAllOccurrences, 5);
            proposalReplaceAllOccurrences.setImportRewrite(importRewrite);
            proposalReplaceAllOccurrences.setImportRemover(removerAllOccurences);
            proposals.add(proposalReplaceAllOccurrences);
        }
        catch (IllegalArgumentException e) {
            JavaLanguageServerPlugin.logException("Failed to get static import proposal", e);
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isDirectlyAccessible(ASTNode nameNode, ITypeBinding declaringClass) {
        ASTNode node = nameNode.getParent();
        while (node != null) {
            ASTNode aSTNode = node;
            if (aSTNode instanceof AbstractTypeDeclaration) {
                void typeDecl;
                AbstractTypeDeclaration cfr_ignored_0 = (AbstractTypeDeclaration)aSTNode;
                AbstractTypeDeclaration cfr_ignored_1 = (AbstractTypeDeclaration)aSTNode;
                AnonymousClassDeclaration binding = typeDecl.resolveBinding();
                if (binding != null && binding.isSubTypeCompatible(declaringClass)) {
                    return true;
                }
            } else {
                ASTNode aSTNode2 = node;
                if (aSTNode2 instanceof AnonymousClassDeclaration) {
                    void anonymousClassDecl;
                    AnonymousClassDeclaration cfr_ignored_2 = (AnonymousClassDeclaration)aSTNode2;
                    AnonymousClassDeclaration cfr_ignored_3 = (AnonymousClassDeclaration)aSTNode2;
                    ITypeBinding binding = anonymousClassDecl.resolveBinding();
                    if (binding != null && binding.isSubTypeCompatible(declaringClass)) {
                        return true;
                    }
                }
            }
            node = node.getParent();
        }
        return false;
    }

    private static boolean getConvertForLoopProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ForStatement forStatement = RefactorProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ConvertLoopFixCore fix = ConvertLoopFixCore.createConvertForLoopToEnhancedFix((CompilationUnit)context.getASTRoot(), (ForStatement)forStatement);
        if (fix == null) {
            return false;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_to_enhanced_for_loop", "true");
        AbstractCleanUpCore cleanUp = new AbstractCleanUpCore(options){

            public CleanUpRequirementsCore getRequirementsCore() {
                return new CleanUpRequirementsCore(this.isEnabled("cleanup.convert_to_enhanced_for_loop"), false, false, null);
            }

            public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
                CompilationUnit compilationUnit = context.getAST();
                if (compilationUnit == null) {
                    return null;
                }
                boolean convertForLoops = this.isEnabled("cleanup.convert_to_enhanced_for_loop");
                boolean checkIfLoopVarUsed = this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used");
                return ConvertLoopFixCore.createCleanUp((CompilationUnit)compilationUnit, (boolean)convertForLoops, (boolean)convertForLoops, (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final") ? 1 : 0) != 0, (boolean)checkIfLoopVarUsed);
            }

            public String[] getStepDescriptions() {
                ArrayList<String> result = new ArrayList<String>();
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
                    result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
                    if (this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used")) {
                        result.add(MultiFixMessages.Java50CleanUp_ConvertLoopOnlyIfLoopVarUsed_description);
                    }
                }
                return result.toArray(new String[result.size()]);
            }

            public String getPreview() {
                StringBuilder buf = new StringBuilder();
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
                    buf.append("for (int element : ids) {\n");
                    buf.append("    double value= element / 2; \n");
                    buf.append("    System.out.println(value);\n");
                    buf.append("}\n");
                } else {
                    buf.append("for (int i = 0; i < ids.length; i++) {\n");
                    buf.append("    double value= ids[i] / 2; \n");
                    buf.append("    System.out.println(value);\n");
                    buf.append("}\n");
                }
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop") && !this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used")) {
                    buf.append("for (int id : ids) {\n");
                    buf.append("    System.out.println(\"here\");\n");
                    buf.append("}\n");
                } else {
                    buf.append("for (int i = 0; i < ids.length; i++) {\n");
                    buf.append("    System.out.println(\"here\");\n");
                    buf.append("}\n");
                }
                return buf.toString();
            }
        };
        FixCorrectionProposal proposal = new FixCorrectionProposal((IProposableFix)fix, (ICleanUpCore)cleanUp, 1, context, "refactor");
        resultingCollections.add(proposal);
        return true;
    }

    private static ForStatement getEnclosingForStatementHeader(ASTNode node) {
        return RefactorProcessor.getEnclosingHeader(node, ForStatement.class, new StructuralPropertyDescriptor[]{ForStatement.INITIALIZERS_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ForStatement.UPDATERS_PROPERTY});
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends ASTNode> T getEnclosingHeader(ASTNode node, Class<T> headerType, StructuralPropertyDescriptor ... headerProperties) {
        if (!headerType.isInstance(node)) ** GOTO lbl17
        return (T)((ASTNode)headerType.cast(node));
lbl-1000:
        // 1 sources

        {
            parent = node.getParent();
            if (headerType.isInstance(parent)) {
                locationInParent = node.getLocationInParent();
                var8_5 = headerProperties;
                var7_6 = headerProperties.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    property = var8_5[var6_7];
                    if (locationInParent == property) {
                        return (T)((ASTNode)headerType.cast(parent));
                    }
                    ++var6_7;
                }
                return null;
            }
            node = parent;
lbl17:
            // 2 sources

            ** while (node != null)
        }
lbl18:
        // 1 sources

        return null;
    }

    private boolean getExtractInterfaceProposal(CodeActionParams params, IInvocationContext context, Collection<ChangeCorrectionProposal> proposals) {
        if (proposals == null) {
            return false;
        }
        if (!this.preferenceManager.getClientPreferences().isExtractInterfaceSupport() || !this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported()) {
            return false;
        }
        ChangeCorrectionProposal proposal = RefactorProposalUtility.getExtractInterfaceProposal(params, context);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getChangeSignatureProposal(CodeActionParams params, IInvocationContext context, Collection<ChangeCorrectionProposal> proposals) {
        if (proposals == null) {
            return false;
        }
        ChangeCorrectionProposal proposal = RefactorProposalUtility.getChangeSignatureProposal(params, context);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }
}

